/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.beautiful_statistics_screen.client.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.boss.enderdragon.EndCrystal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.texboobcat.beautiful_statistics_screen.api.IconRenderer;

public class EntityIconRenderer
implements IconRenderer {
    private final EntityType<?> entityType;
    private final boolean isKilledBy;

    public EntityIconRenderer(EntityType<?> entityType) {
        this(entityType, false);
    }

    public EntityIconRenderer(EntityType<?> entityType, boolean isKilledBy) {
        this.entityType = entityType;
        this.isKilledBy = isKilledBy;
    }

    @Override
    public void render(GuiGraphics graphics, int x, int y, int size) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null) {
            return;
        }
        try {
            Entity entity = this.entityType.m_20615_((Level)mc.f_91073_);
            if (entity != null) {
                if (entity instanceof LightningBolt) {
                    this.renderItemIcon(graphics, new ItemStack((ItemLike)Items.f_151041_), x, y, size);
                    return;
                }
                if (entity instanceof EndCrystal) {
                    this.renderItemIcon(graphics, new ItemStack((ItemLike)Items.f_42729_), x, y, size);
                    return;
                }
                String entityTypeName = EntityType.m_20613_(this.entityType).m_135815_();
                if ("ender_dragon".equals(entityTypeName)) {
                    this.renderItemIcon(graphics, new ItemStack((ItemLike)Items.f_42683_), x, y, size);
                    return;
                }
                if ("wither".equals(entityTypeName)) {
                    this.renderItemIcon(graphics, new ItemStack((ItemLike)Items.f_42686_), x, y, size);
                    return;
                }
                this.renderEntity(graphics, entity, x, y, size);
            } else {
                this.renderSimpleIcon(graphics, x, y, size);
            }
        }
        catch (Exception e) {
            this.renderSimpleIcon(graphics, x, y, size);
        }
        if (this.isKilledBy) {
            this.renderDeathIndicator(graphics, x, y, size);
        }
    }

    private void renderDeathIndicator(GuiGraphics graphics, int x, int y, int size) {
        ItemStack skull = new ItemStack((ItemLike)Items.f_42678_);
        int skullSize = Math.max(8, size / 4);
        int skullX = x + size - skullSize - 2;
        int skullY = y + 2;
        PoseStack poseStack = graphics.m_280168_();
        poseStack.m_85836_();
        float scale = (float)skullSize / 16.0f;
        poseStack.m_252880_((float)skullX, (float)skullY, 200.0f);
        poseStack.m_85841_(scale, scale, scale);
        graphics.m_280480_(skull, 0, 0);
        poseStack.m_85849_();
    }

    private void renderEntity(GuiGraphics graphics, Entity entity, int x, int y, int size) {
        PoseStack poseStack = graphics.m_280168_();
        poseStack.m_85836_();
        float width = Math.max(0.001f, entity.m_20205_());
        float height = Math.max(0.001f, entity.m_20206_());
        float targetSize = (float)size * 0.7f;
        float scale = targetSize / Math.max(width, height);
        scale = Math.max(4.0f, Math.min(scale, 80.0f));
        if (height > width * 2.0f) {
            scale *= 0.75f;
        } else if (width > height * 2.0f) {
            scale *= 0.75f;
        }
        poseStack.m_252880_((float)x + (float)size / 2.0f, (float)y + (float)size * 0.75f, 100.0f);
        poseStack.m_85841_(scale, scale, -scale);
        poseStack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
        poseStack.m_252781_(Axis.f_252529_.m_252977_(10.0f));
        float prevYRot = entity.m_146908_();
        float prevXRot = entity.m_146909_();
        float prevBodyRot = 0.0f;
        float prevHeadRot = 0.0f;
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            prevBodyRot = living.f_20883_;
            prevHeadRot = living.f_20885_;
            living.f_20883_ = 180.0f;
            living.f_20885_ = 180.0f;
        }
        entity.m_146922_(180.0f);
        entity.m_146926_(0.0f);
        EntityRenderDispatcher dispatcher = Minecraft.m_91087_().m_91290_();
        MultiBufferSource.BufferSource buffer = Minecraft.m_91087_().m_91269_().m_110104_();
        RenderSystem.runAsFancy(() -> {
            dispatcher.m_114384_(entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, poseStack, (MultiBufferSource)buffer, 0xF000F0);
            buffer.m_109911_();
        });
        entity.m_146922_(prevYRot);
        entity.m_146926_(prevXRot);
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            living.f_20883_ = prevBodyRot;
            living.f_20885_ = prevHeadRot;
        }
        poseStack.m_85849_();
    }

    private void renderSimpleIcon(GuiGraphics graphics, int x, int y, int size) {
        graphics.m_280509_(x + 2, y + 2, x + size - 2, y + size - 2, -2139062144);
        String initial = this.entityType.m_20676_().getString().substring(0, 1).toUpperCase();
        int textX = x + size / 2 - 3;
        int textY = y + size / 2 - 4;
        graphics.m_280488_(Minecraft.m_91087_().f_91062_, initial, textX, textY, 0xFFFFFF);
    }

    private void renderItemIcon(GuiGraphics graphics, ItemStack stack, int x, int y, int size) {
        int ix = x + Math.max(0, (size - 16) / 2);
        int iy = y + Math.max(0, (size - 16) / 2);
        graphics.m_280480_(stack, ix, iy);
    }
}

