/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.beautiful_statistics_screen.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stat;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import org.texboobcat.beautiful_statistics_screen.Beautiful_statistics_screen;
import org.texboobcat.beautiful_statistics_screen.config.ModConfig;

public class StatsCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"statistics").requires(source -> !ModConfig.getServer().requireOpForCommands || source.m_6761_(2))).then(Commands.m_82127_((String)"view").then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).executes(ctx -> StatsCommand.viewStats((CommandContext<CommandSourceStack>)ctx, EntityArgument.m_91477_((CommandContext)ctx, (String)"targets")))))).then(Commands.m_82127_((String)"clear").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).executes(ctx -> StatsCommand.clearStats((CommandContext<CommandSourceStack>)ctx, EntityArgument.m_91477_((CommandContext)ctx, (String)"targets"), null))).then(Commands.m_82129_((String)"stat", (ArgumentType)StringArgumentType.string()).suggests(StatsCommand.statSuggestions()).executes(ctx -> StatsCommand.clearStats((CommandContext<CommandSourceStack>)ctx, EntityArgument.m_91477_((CommandContext)ctx, (String)"targets"), StringArgumentType.getString((CommandContext)ctx, (String)"stat"))))))).then(Commands.m_82127_((String)"set").then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82129_((String)"stat", (ArgumentType)StringArgumentType.string()).suggests(StatsCommand.statSuggestions()).then(Commands.m_82129_((String)"value", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(ctx -> StatsCommand.setStat((CommandContext<CommandSourceStack>)ctx, EntityArgument.m_91477_((CommandContext)ctx, (String)"targets"), StringArgumentType.getString((CommandContext)ctx, (String)"stat"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"value")))))))).then(Commands.m_82127_((String)"increase").then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82129_((String)"stat", (ArgumentType)StringArgumentType.string()).suggests(StatsCommand.statSuggestions()).then(Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> StatsCommand.increaseStat((CommandContext<CommandSourceStack>)ctx, EntityArgument.m_91477_((CommandContext)ctx, (String)"targets"), StringArgumentType.getString((CommandContext)ctx, (String)"stat"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"amount"))))))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"stats").requires(source -> !ModConfig.getServer().requireOpForCommands || source.m_6761_(2))).redirect(dispatcher.getRoot().getChild("statistics")));
    }

    private static SuggestionProvider<CommandSourceStack> statSuggestions() {
        return (context, builder) -> {
            SharedSuggestionProvider.m_82967_((String[])new String[]{"minecraft:custom/jump", "minecraft:custom/walk_one_cm", "minecraft:custom/run_one_cm", "minecraft:custom/damage_dealt", "minecraft:custom/damage_taken", "minecraft:custom/deaths", "minecraft:custom/play_time", "minecraft:used/diamond_pickaxe", "minecraft:crafted/diamond_sword", "minecraft:mined/stone", "minecraft:killed/zombie", "minecraft:killed_by/creeper"}, (SuggestionsBuilder)builder);
            return builder.buildFuture();
        };
    }

    private static int viewStats(CommandContext<CommandSourceStack> ctx, Collection<ServerPlayer> targets) {
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        for (ServerPlayer player : targets) {
            source.m_288197_(() -> Component.m_237113_((String)("Statistics for " + player.m_7755_().getString() + ":")), false);
            StatsCommand.showStat(source, player, Stats.f_12988_.m_12902_((Object)Stats.f_12935_), "Deaths");
            StatsCommand.showStat(source, player, Stats.f_12988_.m_12902_((Object)Stats.f_12928_), "Damage Dealt");
            StatsCommand.showStat(source, player, Stats.f_12988_.m_12902_((Object)Stats.f_12931_), "Damage Taken");
            StatsCommand.showStat(source, player, Stats.f_12988_.m_12902_((Object)Stats.f_144255_), "Play Time");
            StatsCommand.showStat(source, player, Stats.f_12988_.m_12902_((Object)Stats.f_12926_), "Jumps");
        }
        return targets.size();
    }

    private static void showStat(CommandSourceStack source, ServerPlayer player, Stat<?> stat, String name) {
        int value = player.m_8951_().m_13015_(stat);
        source.m_288197_(() -> Component.m_237113_((String)("  " + name + ": " + value)), false);
    }

    private static int clearStats(CommandContext<CommandSourceStack> ctx, Collection<ServerPlayer> targets, String statPath) {
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        for (ServerPlayer player : targets) {
            if (statPath == null) {
                player.m_7166_(Stats.f_12988_.m_12902_((Object)Stats.f_12935_));
                player.m_7166_(Stats.f_12988_.m_12902_((Object)Stats.f_12928_));
                player.m_7166_(Stats.f_12988_.m_12902_((Object)Stats.f_12931_));
                if (ModConfig.getServer().logStatChanges) {
                    Beautiful_statistics_screen.LOGGER.info("Cleared all stats for player: " + player.m_7755_().getString());
                }
                source.m_288197_(() -> Component.m_237113_((String)("Cleared all statistics for " + player.m_7755_().getString())), true);
                continue;
            }
            Stat<?> stat = StatsCommand.parseStat(statPath);
            if (stat != null) {
                player.m_7166_(stat);
                if (ModConfig.getServer().logStatChanges) {
                    Beautiful_statistics_screen.LOGGER.info("Cleared stat " + statPath + " for player: " + player.m_7755_().getString());
                }
                source.m_288197_(() -> Component.m_237113_((String)("Cleared statistic " + statPath + " for " + player.m_7755_().getString())), true);
                continue;
            }
            source.m_81352_((Component)Component.m_237113_((String)("Unknown statistic: " + statPath)));
            return 0;
        }
        return targets.size();
    }

    private static int setStat(CommandContext<CommandSourceStack> ctx, Collection<ServerPlayer> targets, String statPath, int value) {
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        Stat<?> stat = StatsCommand.parseStat(statPath);
        if (stat == null) {
            source.m_81352_((Component)Component.m_237113_((String)("Unknown statistic: " + statPath)));
            return 0;
        }
        for (ServerPlayer player : targets) {
            player.m_8951_().m_6085_((Player)player, stat, value);
            if (ModConfig.getServer().logStatChanges) {
                Beautiful_statistics_screen.LOGGER.info("Set stat " + statPath + " to " + value + " for player: " + player.m_7755_().getString());
            }
            source.m_288197_(() -> Component.m_237113_((String)("Set " + statPath + " to " + value + " for " + player.m_7755_().getString())), true);
        }
        return targets.size();
    }

    private static int increaseStat(CommandContext<CommandSourceStack> ctx, Collection<ServerPlayer> targets, String statPath, int amount) {
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        Stat<?> stat = StatsCommand.parseStat(statPath);
        if (stat == null) {
            source.m_81352_((Component)Component.m_237113_((String)("Unknown statistic: " + statPath)));
            return 0;
        }
        for (ServerPlayer player : targets) {
            int currentValue = player.m_8951_().m_13015_(stat);
            int newValue = currentValue + amount;
            player.m_8951_().m_6085_((Player)player, stat, newValue);
            if (ModConfig.getServer().logStatChanges) {
                Beautiful_statistics_screen.LOGGER.info("Increased stat " + statPath + " by " + amount + " for player: " + player.m_7755_().getString());
            }
            source.m_288197_(() -> Component.m_237113_((String)("Increased " + statPath + " by " + amount + " for " + player.m_7755_().getString() + " (new value: " + newValue + ")")), true);
        }
        return targets.size();
    }

    private static Stat<?> parseStat(String statPath) {
        try {
            ResourceLocation id = new ResourceLocation(statPath);
            String[] parts = id.m_135815_().split("/", 2);
            if (parts.length < 2) {
                return Stats.f_12988_.m_12902_((Object)StatsCommand.getCustomStat(id.m_135815_()));
            }
            String type = parts[0];
            String target = parts[1];
            ResourceLocation targetId = new ResourceLocation(id.m_135827_(), target);
            return switch (type) {
                case "used" -> {
                    Item item = (Item)BuiltInRegistries.f_257033_.m_7745_(targetId);
                    yield Stats.f_12982_.m_12902_((Object)item);
                }
                case "crafted" -> {
                    Item item = (Item)BuiltInRegistries.f_257033_.m_7745_(targetId);
                    yield Stats.f_12981_.m_12902_((Object)item);
                }
                case "broken" -> {
                    Item item = (Item)BuiltInRegistries.f_257033_.m_7745_(targetId);
                    yield Stats.f_12983_.m_12902_((Object)item);
                }
                case "mined" -> {
                    Block block = (Block)BuiltInRegistries.f_256975_.m_7745_(targetId);
                    yield Stats.f_12949_.m_12902_((Object)block);
                }
                case "killed" -> {
                    EntityType entityType = (EntityType)BuiltInRegistries.f_256780_.m_7745_(targetId);
                    yield Stats.f_12986_.m_12902_((Object)entityType);
                }
                case "killed_by" -> {
                    EntityType entityType = (EntityType)BuiltInRegistries.f_256780_.m_7745_(targetId);
                    yield Stats.f_12987_.m_12902_((Object)entityType);
                }
                default -> null;
            };
        }
        catch (Exception e) {
            return null;
        }
    }

    private static ResourceLocation getCustomStat(String name) {
        return switch (name.toLowerCase()) {
            case "jump" -> Stats.f_12926_;
            case "deaths" -> Stats.f_12935_;
            case "damage_dealt" -> Stats.f_12928_;
            case "damage_taken" -> Stats.f_12931_;
            case "play_time" -> Stats.f_144255_;
            default -> new ResourceLocation("minecraft", "custom/" + name);
        };
    }
}

