/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.beautiful_statistics_screen.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundClientCommandPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.stats.Stat;
import net.minecraft.stats.StatType;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import org.texboobcat.beautiful_statistics_screen.api.IconRenderer;
import org.texboobcat.beautiful_statistics_screen.api.StatCategory;
import org.texboobcat.beautiful_statistics_screen.api.StatEntry;
import org.texboobcat.beautiful_statistics_screen.client.hud.StatHudRenderer;
import org.texboobcat.beautiful_statistics_screen.client.render.EntityIconRenderer;
import org.texboobcat.beautiful_statistics_screen.config.ModConfig;
import org.texboobcat.beautiful_statistics_screen.core.StatCategoryRegistry;
import org.texboobcat.beautiful_statistics_screen.custom.CustomStatAdapter;

public class StatDataManager {
    private static final Map<ResourceLocation, StatEntry> STAT_CACHE = new ConcurrentHashMap<ResourceLocation, StatEntry>();
    private static final List<StatEntry> ALL_STATS = new ArrayList<StatEntry>();
    private static boolean initialized = false;
    private static long lastSyncRequestMs = 0L;
    private static final long SYNC_COOLDOWN_MS = 2000L;
    private static final long FAST_SYNC_COOLDOWN_MS = 250L;
    private static long lastDebugLogMs = 0L;
    private static final long DEBUG_LOG_INTERVAL_MS = 2000L;
    private static double lastPlayerX = 0.0;
    private static double lastPlayerY = 0.0;
    private static double lastPlayerZ = 0.0;
    private static boolean wasOnGround = false;
    private static boolean wasSprinting = false;
    private static boolean wasCrouching = false;
    private static boolean wasInWater = false;
    private static int ticksSinceLastSync = 0;

    public static synchronized void loadStats(LocalPlayer player) {
        STAT_CACHE.clear();
        ALL_STATS.clear();
        initialized = false;
        if (player == null) {
            return;
        }
        Registry customStatRegistry = BuiltInRegistries.f_256771_;
        for (ResourceLocation statId : customStatRegistry) {
            Stat stat = Stats.f_12988_.m_12902_((Object)statId);
            ResourceLocation id = new ResourceLocation("minecraft", "custom/" + statId.m_135815_());
            int value = player.m_108630_().m_13015_(stat);
            StatCategory category = StatCategoryRegistry.findCategory(id);
            MutableComponent displayName = Component.m_237115_((String)("stat.minecraft." + statId.m_135815_()));
            MutableComponent description = Component.m_237119_();
            IconRenderer iconRenderer = StatDataManager.getCustomStatIcon(statId.m_135815_());
            StatEntry entry = new StatEntry(id, category, value, (Component)displayName, (Component)description, iconRenderer);
            STAT_CACHE.put(id, entry);
            ALL_STATS.add(entry);
        }
        StatDataManager.loadItemStats(player, (StatType<Item>)Stats.f_12982_, "used");
        StatDataManager.loadItemStats(player, (StatType<Item>)Stats.f_12981_, "crafted");
        StatDataManager.loadItemStats(player, (StatType<Item>)Stats.f_12983_, "broken");
        StatDataManager.loadItemStats(player, (StatType<Item>)Stats.f_12984_, "picked_up");
        StatDataManager.loadItemStats(player, (StatType<Item>)Stats.f_12985_, "dropped");
        StatDataManager.loadEntityStats(player, Stats.f_12986_, "killed", false);
        StatDataManager.loadEntityStats(player, Stats.f_12987_, "killed_by", true);
        StatDataManager.loadBlockStats(player, (StatType<Block>)Stats.f_12949_, "mined");
        StatDataManager.loadCustomStats();
        lastPlayerX = 0.0;
        lastPlayerY = 0.0;
        lastPlayerZ = 0.0;
        wasOnGround = false;
        wasSprinting = false;
        wasCrouching = false;
        wasInWater = false;
        ticksSinceLastSync = 0;
        initialized = true;
    }

    private static void loadCustomStats() {
        List<StatEntry> customStatEntries = CustomStatAdapter.getCustomStatEntries();
        for (StatEntry entry : customStatEntries) {
            STAT_CACHE.put(entry.getStatId(), entry);
            ALL_STATS.add(entry);
        }
    }

    private static void loadItemStats(LocalPlayer player, StatType<Item> statType, String prefix) {
        for (Item item : BuiltInRegistries.f_257033_) {
            Stat stat = statType.m_12902_((Object)item);
            int value = player.m_108630_().m_13015_(stat);
            ResourceLocation itemId = BuiltInRegistries.f_257033_.m_7981_((Object)item);
            ResourceLocation id = new ResourceLocation(itemId.m_135827_(), prefix + "/" + itemId.m_135815_());
            StatCategory category = StatCategoryRegistry.findCategory(id);
            MutableComponent displayName = Component.m_237115_((String)("stat.beautiful_statistics_screen." + prefix)).m_130946_(" ").m_7220_(item.m_41466_());
            MutableComponent description = Component.m_237119_();
            IconRenderer iconRenderer = (graphics, x, y, size) -> {
                ItemStack stack = new ItemStack((ItemLike)item);
                int offsetX = Math.max(0, (size - 16) / 2);
                int offsetY = Math.max(0, (size - 16) / 2);
                graphics.m_280480_(stack, x + offsetX, y + offsetY);
            };
            StatEntry entry = new StatEntry(id, category, value, (Component)displayName, (Component)description, iconRenderer);
            STAT_CACHE.put(id, entry);
            ALL_STATS.add(entry);
        }
    }

    private static void loadEntityStats(LocalPlayer player, StatType<EntityType<?>> statType, String prefix, boolean isKilledBy) {
        for (EntityType entityType : BuiltInRegistries.f_256780_) {
            Stat stat = statType.m_12902_((Object)entityType);
            int value = player.m_108630_().m_13015_(stat);
            ResourceLocation entityId = BuiltInRegistries.f_256780_.m_7981_((Object)entityType);
            ResourceLocation id = new ResourceLocation(entityId.m_135827_(), prefix + "/" + entityId.m_135815_());
            StatCategory category = StatCategoryRegistry.findCategory(id);
            MutableComponent displayName = Component.m_237115_((String)("stat.beautiful_statistics_screen." + prefix)).m_130946_(" ").m_7220_(entityType.m_20676_());
            MutableComponent description = Component.m_237119_();
            EntityIconRenderer iconRenderer = new EntityIconRenderer(entityType, isKilledBy);
            StatEntry entry = new StatEntry(id, category, value, (Component)displayName, (Component)description, iconRenderer);
            STAT_CACHE.put(id, entry);
            ALL_STATS.add(entry);
        }
    }

    private static void loadBlockStats(LocalPlayer player, StatType<Block> statType, String prefix) {
        for (Block block : BuiltInRegistries.f_256975_) {
            Stat stat = statType.m_12902_((Object)block);
            int value = player.m_108630_().m_13015_(stat);
            ResourceLocation blockId = BuiltInRegistries.f_256975_.m_7981_((Object)block);
            ResourceLocation id = new ResourceLocation(blockId.m_135827_(), prefix + "/" + blockId.m_135815_());
            StatCategory category = StatCategoryRegistry.findCategory(id);
            MutableComponent displayName = Component.m_237115_((String)("stat.beautiful_statistics_screen." + prefix)).m_130946_(" ").m_7220_((Component)block.m_49954_());
            MutableComponent description = Component.m_237119_();
            IconRenderer iconRenderer = (graphics, x, y, size) -> {
                ItemStack stack = new ItemStack((ItemLike)block);
                int offsetX = Math.max(0, (size - 16) / 2);
                int offsetY = Math.max(0, (size - 16) / 2);
                graphics.m_280480_(stack, x + offsetX, y + offsetY);
            };
            StatEntry entry = new StatEntry(id, category, value, (Component)displayName, (Component)description, iconRenderer);
            STAT_CACHE.put(id, entry);
            ALL_STATS.add(entry);
        }
    }

    private static String getStatPath(Stat<?> stat) {
        String name = stat.m_83620_();
        if (name == null) {
            return "unknown";
        }
        return name.toLowerCase().replace(" ", "_").replace(".", "_");
    }

    public static List<StatEntry> getAllStats() {
        return Collections.unmodifiableList(ALL_STATS);
    }

    public static List<StatEntry> getStatsByCategory(StatCategory category) {
        return ALL_STATS.stream().filter(entry -> entry.getCategory().equals(category)).collect(Collectors.toList());
    }

    public static List<StatEntry> searchStats(String query) {
        if (query == null || query.isEmpty()) {
            return StatDataManager.getAllStats();
        }
        return ALL_STATS.stream().filter(entry -> entry.matchesSearch(query)).collect(Collectors.toList());
    }

    public static List<StatEntry> getFilteredStats(StatCategory category, String query, boolean hideZero) {
        return ALL_STATS.stream().filter(entry -> category == null || entry.getCategory().equals(category)).filter(entry -> entry.matchesSearch(query)).filter(entry -> !hideZero || !entry.isZero()).collect(Collectors.toList());
    }

    public static StatEntry getStatEntry(ResourceLocation id) {
        return STAT_CACHE.get(id);
    }

    public static void refresh() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null) {
            StatDataManager.requestServerSync();
            StatDataManager.loadStats(player);
            StatDataManager.resetClientTracking();
        }
    }

    public static void refreshPinned() {
        if (!initialized) {
            return;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        StatDataManager.requestServerSyncFast();
        List<ResourceLocation> pinnedStats = ModConfig.getPinnedStats();
        if (pinnedStats.isEmpty()) {
            return;
        }
        boolean anyChanged = false;
        boolean smoothing = ModConfig.getClient().enableSmoothStatUpdates || StatHudRenderer.isVisible();
        for (ResourceLocation statId : pinnedStats) {
            long existing;
            StatEntry entry = STAT_CACHE.get(statId);
            if (entry == null) continue;
            long current = StatDataManager.resolveCurrentValue(player, statId);
            long merged = smoothing ? Math.max(existing, current) : current;
            if (merged == (existing = entry.getValue())) continue;
            entry.setValue(merged);
            anyChanged = true;
        }
        if (anyChanged) {
            StatHudRenderer.invalidateLayoutCache();
        }
    }

    public static void updateClientSideStats() {
        if (!initialized) {
            return;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        ++ticksSinceLastSync;
        List<ResourceLocation> pinnedStats = ModConfig.getPinnedStats();
        if (pinnedStats.isEmpty()) {
            return;
        }
        double currentX = player.m_20185_();
        double currentY = player.m_20186_();
        double currentZ = player.m_20189_();
        boolean isOnGround = player.m_20096_();
        boolean isSprinting = player.m_20142_();
        boolean isCrouching = player.m_6047_();
        boolean isInWater = player.m_20069_();
        if (lastPlayerX == 0.0 && lastPlayerY == 0.0 && lastPlayerZ == 0.0) {
            lastPlayerX = currentX;
            lastPlayerY = currentY;
            lastPlayerZ = currentZ;
            wasOnGround = isOnGround;
            wasSprinting = isSprinting;
            wasCrouching = isCrouching;
            wasInWater = isInWater;
            return;
        }
        double dx = currentX - lastPlayerX;
        double dy = currentY - lastPlayerY;
        double dz = currentZ - lastPlayerZ;
        double horizontalDistance = Math.sqrt(dx * dx + dz * dz);
        long distanceCm = Math.round(horizontalDistance * 100.0);
        if (distanceCm > 0L) {
            if (isSprinting && isOnGround) {
                StatDataManager.incrementPinnedStat("minecraft:custom/sprint_one_cm", distanceCm, pinnedStats);
                StatDataManager.incrementPinnedStat("minecraft:custom/walk_one_cm", distanceCm, pinnedStats);
            } else if (isCrouching && isOnGround) {
                StatDataManager.incrementPinnedStat("minecraft:custom/crouch_one_cm", distanceCm, pinnedStats);
                StatDataManager.incrementPinnedStat("minecraft:custom/walk_one_cm", distanceCm, pinnedStats);
            } else if (isInWater) {
                if (player.m_5842_()) {
                    StatDataManager.incrementPinnedStat("minecraft:custom/walk_under_water_one_cm", distanceCm, pinnedStats);
                }
                StatDataManager.incrementPinnedStat("minecraft:custom/swim_one_cm", distanceCm, pinnedStats);
            } else if (player.m_6147_()) {
                StatDataManager.incrementPinnedStat("minecraft:custom/climb_one_cm", Math.round(Math.abs(dy) * 100.0), pinnedStats);
            } else if (!isOnGround && !wasOnGround) {
                if (dy < -0.1) {
                    StatDataManager.incrementPinnedStat("minecraft:custom/fall_one_cm", Math.round(Math.abs(dy) * 100.0), pinnedStats);
                } else if (player.m_150110_().f_35935_) {
                    StatDataManager.incrementPinnedStat("minecraft:custom/fly_one_cm", distanceCm, pinnedStats);
                }
            } else if (isOnGround) {
                StatDataManager.incrementPinnedStat("minecraft:custom/walk_one_cm", distanceCm, pinnedStats);
            }
        }
        StatDataManager.incrementPinnedStat("minecraft:custom/play_time", 1L, pinnedStats);
        StatDataManager.incrementPinnedStat("minecraft:custom/total_world_time", 1L, pinnedStats);
        StatDataManager.incrementPinnedStat("minecraft:custom/time_since_death", 1L, pinnedStats);
        StatDataManager.incrementPinnedStat("minecraft:custom/time_since_rest", 1L, pinnedStats);
        lastPlayerX = currentX;
        lastPlayerY = currentY;
        lastPlayerZ = currentZ;
        wasOnGround = isOnGround;
        wasSprinting = isSprinting;
        wasCrouching = isCrouching;
        wasInWater = isInWater;
    }

    private static void incrementPinnedStat(String statIdStr, long delta, List<ResourceLocation> pinnedStats) {
        if (delta <= 0L) {
            return;
        }
        ResourceLocation statId = new ResourceLocation(statIdStr);
        if (!pinnedStats.contains(statId)) {
            return;
        }
        StatEntry entry = STAT_CACHE.get(statId);
        if (entry != null) {
            entry.setValue(entry.getValue() + delta);
            StatHudRenderer.invalidateLayoutCache();
        }
    }

    public static void resetClientTracking() {
        ticksSinceLastSync = 0;
    }

    public static boolean isInitialized() {
        return initialized;
    }

    public static void requestServerSync() {
        StatDataManager.requestServerSyncInternal(2000L);
    }

    public static void requestServerSyncFast() {
        StatDataManager.requestServerSyncInternal(250L);
    }

    private static void requestServerSyncInternal(long minDelayMs) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc == null || mc.m_91403_() == null) {
            return;
        }
        long now = System.currentTimeMillis();
        if (now - lastSyncRequestMs < minDelayMs) {
            return;
        }
        lastSyncRequestMs = now;
        mc.m_91403_().m_104955_((Packet)new ServerboundClientCommandPacket(ServerboundClientCommandPacket.Action.REQUEST_STATS));
    }

    private static long resolveCurrentValue(LocalPlayer player, ResourceLocation composedId) {
        String path = composedId.m_135815_();
        String[] parts = path.split("/");
        if (parts.length != 2) {
            if (parts.length == 1) {
                try {
                    Stat stat = Stats.f_12988_.m_12902_((Object)composedId);
                    if (stat != null) {
                        return player.m_108630_().m_13015_(stat);
                    }
                }
                catch (Exception stat) {
                    // empty catch block
                }
            }
            return 0L;
        }
        String type = parts[0];
        String target = parts[1];
        ResourceLocation targetId = new ResourceLocation(composedId.m_135827_(), target);
        try {
            switch (type) {
                case "used": {
                    Item item = (Item)BuiltInRegistries.f_257033_.m_7745_(targetId);
                    if (item == null) break;
                    Stat stat = Stats.f_12982_.m_12902_((Object)item);
                    if (stat != null) {
                        return player.m_108630_().m_13015_(stat);
                    }
                    break;
                }
                case "crafted": {
                    Item item = (Item)BuiltInRegistries.f_257033_.m_7745_(targetId);
                    if (item == null) break;
                    Stat stat = Stats.f_12981_.m_12902_((Object)item);
                    if (stat != null) {
                        return player.m_108630_().m_13015_(stat);
                    }
                    break;
                }
                case "broken": {
                    Item item = (Item)BuiltInRegistries.f_257033_.m_7745_(targetId);
                    if (item == null) break;
                    Stat stat = Stats.f_12983_.m_12902_((Object)item);
                    if (stat != null) {
                        return player.m_108630_().m_13015_(stat);
                    }
                    break;
                }
                case "picked_up": {
                    Item item = (Item)BuiltInRegistries.f_257033_.m_7745_(targetId);
                    if (item == null) break;
                    Stat stat = Stats.f_12984_.m_12902_((Object)item);
                    if (stat != null) {
                        return player.m_108630_().m_13015_(stat);
                    }
                    break;
                }
                case "dropped": {
                    Item item = (Item)BuiltInRegistries.f_257033_.m_7745_(targetId);
                    if (item == null) break;
                    Stat stat = Stats.f_12985_.m_12902_((Object)item);
                    if (stat != null) {
                        return player.m_108630_().m_13015_(stat);
                    }
                    break;
                }
                case "mined": {
                    Block block = (Block)BuiltInRegistries.f_256975_.m_7745_(targetId);
                    if (block == null) break;
                    Stat stat = Stats.f_12949_.m_12902_((Object)block);
                    if (stat != null) {
                        return player.m_108630_().m_13015_(stat);
                    }
                    break;
                }
                case "killed": {
                    EntityType entityType = (EntityType)BuiltInRegistries.f_256780_.m_7745_(targetId);
                    if (entityType == null) break;
                    Stat stat = Stats.f_12986_.m_12902_((Object)entityType);
                    if (stat != null) {
                        return player.m_108630_().m_13015_(stat);
                    }
                    break;
                }
                case "killed_by": {
                    EntityType entityType = (EntityType)BuiltInRegistries.f_256780_.m_7745_(targetId);
                    if (entityType == null) break;
                    Stat stat = Stats.f_12987_.m_12902_((Object)entityType);
                    if (stat != null) {
                        return player.m_108630_().m_13015_(stat);
                    }
                    break;
                }
                case "custom": {
                    Stat stat = Stats.f_12988_.m_12902_((Object)targetId);
                    if (stat == null) break;
                    return player.m_108630_().m_13015_(stat);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0L;
    }

    private static IconRenderer getCustomStatIcon(String statPath) {
        Item iconItem = switch (statPath) {
            case "play_time", "play_one_minute", "total_world_time" -> Items.f_42524_;
            case "time_since_death" -> Items.f_42747_;
            case "time_since_rest" -> Items.f_42570_;
            case "sneak_time" -> Items.f_42463_;
            case "walk_one_cm", "walk_on_water_one_cm", "walk_under_water_one_cm" -> Items.f_42471_;
            case "sprint_one_cm" -> Items.f_42479_;
            case "crouch_one_cm" -> Items.f_42463_;
            case "fly_one_cm" -> Items.f_42741_;
            case "fall_one_cm" -> Items.f_42402_;
            case "climb_one_cm" -> Items.f_41963_;
            case "swim_one_cm" -> Items.f_42354_;
            case "boat_one_cm" -> Items.f_42453_;
            case "minecart_one_cm" -> Items.f_42449_;
            case "horse_one_cm" -> Items.f_42450_;
            case "pig_one_cm" -> Items.f_42684_;
            case "aviate_one_cm" -> Items.f_42741_;
            case "strider_one_cm" -> Items.f_42685_;
            case "damage_dealt", "damage_dealt_absorbed", "damage_dealt_resisted" -> Items.f_42388_;
            case "damage_taken" -> Items.f_42740_;
            case "damage_blocked_by_shield" -> Items.f_42740_;
            case "damage_absorbed" -> Items.f_42436_;
            case "damage_resisted" -> Items.f_42481_;
            case "mob_kills" -> Items.f_42383_;
            case "deaths" -> Items.f_42678_;
            case "player_kills" -> Items.f_42388_;
            case "jump" -> Items.f_42648_;
            case "leave_game" -> Items.f_42127_;
            case "open_chest" -> Items.f_42009_;
            case "open_enderchest" -> Items.f_42108_;
            case "open_shulker_box" -> Items.f_42265_;
            case "open_barrel" -> Items.f_42768_;
            case "inspect_hopper" -> Items.f_42155_;
            case "inspect_dispenser" -> Items.f_41855_;
            case "inspect_dropper" -> Items.f_42162_;
            case "play_noteblock" -> Items.f_41859_;
            case "tune_noteblock" -> Items.f_41859_;
            case "pot_flower" -> Items.f_42618_;
            case "trigger_trapped_chest" -> Items.f_42149_;
            case "play_record" -> Items.f_42701_;
            case "interact_with_furnace" -> Items.f_41962_;
            case "interact_with_blast_furnace" -> Items.f_42770_;
            case "interact_with_smoker" -> Items.f_42769_;
            case "interact_with_lectern" -> Items.f_42774_;
            case "interact_with_campfire" -> Items.f_42781_;
            case "interact_with_cartography_table" -> Items.f_42771_;
            case "interact_with_loom" -> Items.f_42719_;
            case "interact_with_stonecutter" -> Items.f_42776_;
            case "interact_with_beacon" -> Items.f_42065_;
            case "interact_with_brewingstand" -> Items.f_42543_;
            case "interact_with_crafting_table" -> Items.f_41960_;
            case "interact_with_anvil" -> Items.f_42146_;
            case "interact_with_grindstone" -> Items.f_42773_;
            case "interact_with_smithing_table" -> Items.f_42775_;
            case "animals_bred" -> Items.f_42405_;
            case "fish_caught" -> Items.f_42523_;
            case "talked_to_villager" -> Items.f_42616_;
            case "traded_with_villager" -> Items.f_42616_;
            case "eat_cake_slice" -> Items.f_42502_;
            case "fill_cauldron" -> Items.f_42544_;
            case "use_cauldron" -> Items.f_42544_;
            case "clean_armor" -> Items.f_42447_;
            case "clean_banner" -> Items.f_42660_;
            case "clean_shulker_box" -> Items.f_42265_;
            case "drop" -> Items.f_42162_;
            case "enchant_item" -> Items.f_42100_;
            case "bell_ring" -> Items.f_42777_;
            case "raid_trigger" -> Items.f_42777_;
            case "raid_win" -> Items.f_42747_;
            case "target_hit" -> Items.f_42793_;
            default -> Items.f_42516_;
        };
        return (graphics, x, y, size) -> {
            ItemStack stack = new ItemStack((ItemLike)iconItem);
            int offsetX = Math.max(0, (size - 16) / 2);
            int offsetY = Math.max(0, (size - 16) / 2);
            graphics.m_280480_(stack, x + offsetX, y + offsetY);
        };
    }
}

