/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.beautiful_statistics_screen.custom;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import org.texboobcat.beautiful_statistics_screen.custom.CustomStatDefinition;
import org.texboobcat.beautiful_statistics_screen.custom.StatGoal;

public class StatNotificationManager {
    private static final Queue<StatNotification> pendingNotifications = new ConcurrentLinkedQueue<StatNotification>();
    private static StatNotification currentNotification = null;
    private static long notificationStartTime = 0L;
    private static final long NOTIFICATION_DURATION = 5000L;

    public static void notifyGoalAchieved(CustomStatDefinition stat, StatGoal goal) {
        if (!goal.shouldShowNotification()) {
            return;
        }
        StatNotification notification = new StatNotification(stat, goal);
        pendingNotifications.offer(notification);
        if (goal.shouldPlaySound()) {
            StatNotificationManager.playAchievementSound();
        }
    }

    public static void tick() {
        long now = System.currentTimeMillis();
        if (currentNotification != null && now - notificationStartTime >= 5000L) {
            currentNotification = null;
        }
        if (currentNotification == null && !pendingNotifications.isEmpty()) {
            currentNotification = pendingNotifications.poll();
            notificationStartTime = now;
        }
    }

    public static StatNotification getCurrentNotification() {
        return currentNotification;
    }

    public static float getNotificationProgress() {
        if (currentNotification == null) {
            return 0.0f;
        }
        long elapsed = System.currentTimeMillis() - notificationStartTime;
        float progress = (float)elapsed / 5000.0f;
        if (progress < 0.1f) {
            return progress / 0.1f;
        }
        if (progress > 0.9f) {
            return (1.0f - progress) / 0.1f;
        }
        return 1.0f;
    }

    public static void clearCurrentNotification() {
        currentNotification = null;
    }

    public static void clearAll() {
        pendingNotifications.clear();
        currentNotification = null;
    }

    private static void playAchievementSound() {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ != null && mc.f_91073_ != null) {
            mc.f_91073_.m_7785_(mc.f_91074_.m_20185_(), mc.f_91074_.m_20186_(), mc.f_91074_.m_20189_(), SoundEvents.f_12275_, SoundSource.PLAYERS, 0.5f, 1.0f, false);
        }
    }

    public static void sendChatMessage(CustomStatDefinition stat, StatGoal goal) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ != null) {
            MutableComponent message = Component.m_237113_((String)"\u00a76[Custom Stats] ").m_7220_((Component)Component.m_237113_((String)("\u00a7eAchieved: \u00a7f" + goal.getName()))).m_7220_((Component)Component.m_237113_((String)(" \u00a77(" + stat.getName() + ")")));
            mc.f_91074_.m_213846_((Component)message);
            if (goal.getRewardMessage() != null && !goal.getRewardMessage().isEmpty()) {
                mc.f_91074_.m_213846_((Component)Component.m_237113_((String)("\u00a7a" + goal.getRewardMessage())));
            }
        }
    }

    public static int getPendingCount() {
        return pendingNotifications.size();
    }

    public static boolean hasActiveNotification() {
        return currentNotification != null;
    }

    public static class StatNotification {
        private final CustomStatDefinition stat;
        private final StatGoal goal;
        private final long timestamp;

        public StatNotification(CustomStatDefinition stat, StatGoal goal) {
            this.stat = stat;
            this.goal = goal;
            this.timestamp = System.currentTimeMillis();
        }

        public CustomStatDefinition getStat() {
            return this.stat;
        }

        public StatGoal getGoal() {
            return this.goal;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public Component getTitle() {
            return Component.m_237113_((String)"\u00a76\u00a7l\u2b50 Goal Achieved!");
        }

        public Component getMessage() {
            if (this.goal.getTimesAchieved() > 1) {
                return Component.m_237113_((String)("\u00a7e" + this.goal.getName() + " \u00a77(x" + this.goal.getTimesAchieved() + ")")).m_130946_("\n\u00a77" + this.stat.getName());
            }
            return Component.m_237113_((String)("\u00a7e" + this.goal.getName())).m_130946_("\n\u00a77" + this.stat.getName());
        }

        public Component getRewardMessage() {
            String reward = this.goal.getRewardMessage();
            if (reward != null && !reward.isEmpty()) {
                return Component.m_237113_((String)("\u00a7a" + reward));
            }
            return Component.m_237119_();
        }
    }
}

