/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.beautiful_statistics_screen.custom;

import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.List;
import org.texboobcat.beautiful_statistics_screen.custom.CustomStatDefinition;
import org.texboobcat.beautiful_statistics_screen.custom.StatGoal;
import org.texboobcat.beautiful_statistics_screen.custom.conditions.ComparisonOperator;
import org.texboobcat.beautiful_statistics_screen.custom.conditions.ConditionGroup;
import org.texboobcat.beautiful_statistics_screen.custom.conditions.ConditionType;
import org.texboobcat.beautiful_statistics_screen.custom.conditions.StatCondition;

public class StatTemplate {
    @SerializedName(value="id")
    private String id;
    @SerializedName(value="name")
    private String name;
    @SerializedName(value="description")
    private String description;
    @SerializedName(value="category")
    private String category;
    @SerializedName(value="icon")
    private String icon;
    @SerializedName(value="trackingType")
    private CustomStatDefinition.TrackingType trackingType;
    @SerializedName(value="defaultTargets")
    private List<String> defaultTargets = new ArrayList<String>();
    @SerializedName(value="defaultConditionGroup")
    private ConditionGroup defaultConditionGroup = new ConditionGroup();
    @SerializedName(value="aggregationType")
    private CustomStatDefinition.AggregationType aggregationType;
    @SerializedName(value="formatType")
    private CustomStatDefinition.FormatType formatType;
    @SerializedName(value="defaultGoals")
    private List<StatGoal> defaultGoals = new ArrayList<StatGoal>();
    @SerializedName(value="tags")
    private List<String> tags = new ArrayList<String>();
    @SerializedName(value="color")
    private String color;
    @SerializedName(value="builtin")
    private boolean builtin = false;

    public CustomStatDefinition createStat() {
        CustomStatDefinition stat = new CustomStatDefinition();
        stat.setName(this.name);
        stat.setDescription(this.description);
        stat.setCategory(this.category);
        stat.setIcon(this.icon);
        stat.setTrackingType(this.trackingType);
        stat.setTargets(new ArrayList<String>(this.defaultTargets));
        if (this.defaultConditionGroup != null) {
            stat.setConditionGroup(this.defaultConditionGroup);
        }
        stat.setAggregationType(this.aggregationType);
        stat.setFormatType(this.formatType);
        stat.setColor(this.color);
        stat.setTags(new ArrayList<String>(this.tags));
        for (StatGoal goal : this.defaultGoals) {
            StatGoal newGoal = new StatGoal(goal.getName(), goal.getTargetValue());
            newGoal.setDescription(goal.getDescription());
            newGoal.setRewardMessage(goal.getRewardMessage());
            stat.addGoal(newGoal);
        }
        return stat;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public CustomStatDefinition.TrackingType getTrackingType() {
        return this.trackingType;
    }

    public void setTrackingType(CustomStatDefinition.TrackingType trackingType) {
        this.trackingType = trackingType;
    }

    public List<String> getDefaultTargets() {
        return this.defaultTargets;
    }

    public void setDefaultTargets(List<String> targets) {
        this.defaultTargets = targets;
    }

    public CustomStatDefinition.AggregationType getAggregationType() {
        return this.aggregationType;
    }

    public void setAggregationType(CustomStatDefinition.AggregationType aggregationType) {
        this.aggregationType = aggregationType;
    }

    public CustomStatDefinition.FormatType getFormatType() {
        return this.formatType;
    }

    public void setFormatType(CustomStatDefinition.FormatType formatType) {
        this.formatType = formatType;
    }

    public String getColor() {
        return this.color;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public boolean isBuiltin() {
        return this.builtin;
    }

    public void setBuiltin(boolean builtin) {
        this.builtin = builtin;
    }

    public static class BuiltinTemplates {
        public static StatTemplate diamondMining() {
            StatTemplate template = new StatTemplate();
            template.setId("builtin_diamond_mining");
            template.setName("Diamond Mining");
            template.setDescription("Track diamonds mined");
            template.setCategory("mining");
            template.setIcon("minecraft:diamond");
            template.setTrackingType(CustomStatDefinition.TrackingType.BLOCK_MINED);
            template.getDefaultTargets().add("minecraft:diamond_ore");
            template.getDefaultTargets().add("minecraft:deepslate_diamond_ore");
            template.setAggregationType(CustomStatDefinition.AggregationType.SUM);
            template.setFormatType(CustomStatDefinition.FormatType.NUMBER);
            template.setColor("#55FFFF");
            template.setBuiltin(true);
            template.defaultGoals.add(new StatGoal("First Diamond!", 1L));
            template.defaultGoals.add(new StatGoal("Stack of Diamonds", 64L));
            template.defaultGoals.add(new StatGoal("Diamond Hoarder", 256L));
            return template;
        }

        public static StatTemplate mobHunter() {
            StatTemplate template = new StatTemplate();
            template.setId("builtin_mob_hunter");
            template.setName("Mob Hunter");
            template.setDescription("Track hostile mobs killed");
            template.setCategory("combat");
            template.setIcon("minecraft:iron_sword");
            template.setTrackingType(CustomStatDefinition.TrackingType.ENTITY_KILLED);
            template.getDefaultTargets().add("minecraft:zombie");
            template.getDefaultTargets().add("minecraft:skeleton");
            template.getDefaultTargets().add("minecraft:creeper");
            template.getDefaultTargets().add("minecraft:spider");
            template.setAggregationType(CustomStatDefinition.AggregationType.SUM);
            template.setFormatType(CustomStatDefinition.FormatType.NUMBER);
            template.setColor("#FF5555");
            template.setBuiltin(true);
            template.defaultGoals.add(new StatGoal("Monster Slayer", 100L));
            template.defaultGoals.add(new StatGoal("Mob Vanquisher", 500L));
            template.defaultGoals.add(new StatGoal("Legendary Hunter", 1000L));
            return template;
        }

        public static StatTemplate foodConsumption() {
            StatTemplate template = new StatTemplate();
            template.setId("builtin_food_consumption");
            template.setName("Food Eaten");
            template.setDescription("Track food items consumed");
            template.setCategory("survival");
            template.setIcon("minecraft:bread");
            template.setTrackingType(CustomStatDefinition.TrackingType.ITEM_USED);
            template.getDefaultTargets().add("*");
            template.setAggregationType(CustomStatDefinition.AggregationType.SUM);
            template.setFormatType(CustomStatDefinition.FormatType.NUMBER);
            template.setColor("#FFAA00");
            template.setBuiltin(true);
            template.defaultGoals.add(new StatGoal("First Meal", 1L));
            template.defaultGoals.add(new StatGoal("Well Fed", 100L));
            template.defaultGoals.add(new StatGoal("Glutton", 1000L));
            return template;
        }

        public static StatTemplate deepMining() {
            StatTemplate template = new StatTemplate();
            template.setId("builtin_deep_mining");
            template.setName("Deep Mining");
            template.setDescription("Track blocks mined deep underground");
            template.setCategory("mining");
            template.setIcon("minecraft:deepslate");
            template.setTrackingType(CustomStatDefinition.TrackingType.BLOCK_MINED);
            template.getDefaultTargets().add("*");
            template.setAggregationType(CustomStatDefinition.AggregationType.SUM);
            template.setFormatType(CustomStatDefinition.FormatType.NUMBER);
            template.setColor("#333333");
            template.setBuiltin(true);
            StatCondition yCondition = new StatCondition(ConditionType.Y_LEVEL, ComparisonOperator.LESS_THAN, "0");
            template.defaultConditionGroup.addCondition(yCondition);
            template.defaultGoals.add(new StatGoal("Underground Explorer", 1000L));
            template.defaultGoals.add(new StatGoal("Deep Delver", 5000L));
            template.defaultGoals.add(new StatGoal("Master Miner", 10000L));
            return template;
        }

        public static StatTemplate netherExploration() {
            StatTemplate template = new StatTemplate();
            template.setId("builtin_nether_time");
            template.setName("Nether Explorer");
            template.setDescription("Track time spent in the Nether");
            template.setCategory("exploration");
            template.setIcon("minecraft:netherrack");
            template.setTrackingType(CustomStatDefinition.TrackingType.TIME_ELAPSED);
            template.getDefaultTargets().add("*");
            template.setAggregationType(CustomStatDefinition.AggregationType.SUM);
            template.setFormatType(CustomStatDefinition.FormatType.TIME);
            template.setColor("#AA0000");
            template.setBuiltin(true);
            StatCondition dimCondition = new StatCondition(ConditionType.DIMENSION, ComparisonOperator.EQUALS, "minecraft:the_nether");
            template.defaultConditionGroup.addCondition(dimCondition);
            template.defaultGoals.add(new StatGoal("Nether Visitor", 1200L));
            template.defaultGoals.add(new StatGoal("Nether Dweller", 72000L));
            template.defaultGoals.add(new StatGoal("Nether Expert", 360000L));
            return template;
        }

        public static List<StatTemplate> getAllBuiltin() {
            ArrayList<StatTemplate> templates = new ArrayList<StatTemplate>();
            templates.add(BuiltinTemplates.diamondMining());
            templates.add(BuiltinTemplates.mobHunter());
            templates.add(BuiltinTemplates.foodConsumption());
            templates.add(BuiltinTemplates.deepMining());
            templates.add(BuiltinTemplates.netherExploration());
            return templates;
        }
    }
}

