/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.beautiful_statistics_screen.network;

import dev.architectury.networking.NetworkManager;
import io.netty.buffer.Unpooled;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.ServerStatsCounter;
import net.minecraft.stats.Stat;
import net.minecraft.stats.StatType;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import org.texboobcat.beautiful_statistics_screen.Beautiful_statistics_screen;
import org.texboobcat.beautiful_statistics_screen.client.gui.SharedStatsScreen;
import org.texboobcat.beautiful_statistics_screen.config.ModConfig;
import org.texboobcat.beautiful_statistics_screen.network.SharedStatsCache;

public class NetworkHandler {
    public static final ResourceLocation REQUEST_STATS = new ResourceLocation("beautiful_statistics_screen", "request_stats");
    public static final ResourceLocation STATS_DATA = new ResourceLocation("beautiful_statistics_screen", "stats_data");
    public static final ResourceLocation STAT_UPDATE = new ResourceLocation("beautiful_statistics_screen", "stat_update");
    public static final ResourceLocation SYNC_PINNED = new ResourceLocation("beautiful_statistics_screen", "sync_pinned");

    public static void register() {
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, (ResourceLocation)REQUEST_STATS, RequestStatsPacket::handle);
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, (ResourceLocation)STATS_DATA, StatsDataPacket::handle);
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, (ResourceLocation)STAT_UPDATE, StatUpdatePacket::handle);
    }

    public static class StatUpdatePacket {
        private final String statId;
        private final long value;

        public StatUpdatePacket(String statId, long value) {
            this.statId = statId;
            this.value = value;
        }

        public void encode(FriendlyByteBuf buf) {
            buf.m_130070_(this.statId);
            buf.writeLong(this.value);
        }

        public static StatUpdatePacket decode(FriendlyByteBuf buf) {
            return new StatUpdatePacket(buf.m_130277_(), buf.readLong());
        }

        public static void handle(FriendlyByteBuf buf, NetworkManager.PacketContext context) {
            StatUpdatePacket packet = StatUpdatePacket.decode(buf);
            context.queue(() -> {});
        }

        public static void sendToPlayer(ServerPlayer player, String statId, long value) {
            StatUpdatePacket packet = new StatUpdatePacket(statId, value);
            FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
            packet.encode(buf);
            NetworkManager.sendToPlayer((ServerPlayer)player, (ResourceLocation)STAT_UPDATE, (FriendlyByteBuf)buf);
        }
    }

    public static class StatsDataPacket {
        private final String playerName;
        private final Map<String, Long> stats;

        public StatsDataPacket(String playerName, Map<String, Long> stats) {
            this.playerName = playerName;
            this.stats = stats;
        }

        public void encode(FriendlyByteBuf buf) {
            buf.m_130070_(this.playerName);
            buf.writeInt(this.stats.size());
            for (Map.Entry<String, Long> entry : this.stats.entrySet()) {
                buf.m_130070_(entry.getKey());
                buf.writeLong(entry.getValue().longValue());
            }
        }

        public static StatsDataPacket decode(FriendlyByteBuf buf) {
            String playerName = buf.m_130277_();
            int size = buf.readInt();
            HashMap<String, Long> stats = new HashMap<String, Long>();
            for (int i = 0; i < size; ++i) {
                stats.put(buf.m_130277_(), buf.readLong());
            }
            return new StatsDataPacket(playerName, stats);
        }

        public static void handle(FriendlyByteBuf buf, NetworkManager.PacketContext context) {
            StatsDataPacket packet = StatsDataPacket.decode(buf);
            context.queue(() -> {
                Minecraft mc = Minecraft.m_91087_();
                if (mc.f_91074_ != null) {
                    SharedStatsCache.setSharedStats(packet.playerName, packet.stats);
                    mc.f_91074_.m_213846_((Component)Component.m_237113_((String)("\u00a7aReceived stats for " + packet.playerName)));
                    if (mc.f_91080_ == null) {
                        mc.m_91152_((Screen)new SharedStatsScreen(null, packet.playerName, packet.stats));
                    }
                }
            });
        }

        public static void sendToPlayer(ServerPlayer requestingPlayer, String targetPlayerName) {
            if (!ModConfig.getServer().allowStatSharing) {
                requestingPlayer.m_213846_((Component)Component.m_237113_((String)"\u00a7cStat sharing is disabled on this server"));
                return;
            }
            ServerPlayer targetPlayer = requestingPlayer.m_20194_().m_6846_().m_11255_(targetPlayerName);
            if (targetPlayer == null) {
                requestingPlayer.m_213846_((Component)Component.m_237113_((String)("\u00a7cPlayer not found: " + targetPlayerName)));
                return;
            }
            HashMap<String, Long> stats = new HashMap<String, Long>();
            ServerStatsCounter statsCounter = targetPlayer.m_8951_();
            for (ResourceLocation statId : BuiltInRegistries.f_256771_) {
                Stat stat = Stats.f_12988_.m_12902_((Object)statId);
                int value = statsCounter.m_13015_(stat);
                if (value <= 0) continue;
                stats.put("minecraft:custom/" + statId.m_135815_(), Long.valueOf(value));
            }
            StatsDataPacket.addItemStats(stats, statsCounter, (StatType<Item>)Stats.f_12982_, "used");
            StatsDataPacket.addItemStats(stats, statsCounter, (StatType<Item>)Stats.f_12981_, "crafted");
            StatsDataPacket.addItemStats(stats, statsCounter, (StatType<Item>)Stats.f_12983_, "broken");
            StatsDataPacket.addEntityStats(stats, statsCounter, Stats.f_12986_, "killed");
            StatsDataPacket.addEntityStats(stats, statsCounter, Stats.f_12987_, "killed_by");
            StatsDataPacket.addBlockStats(stats, statsCounter, (StatType<Block>)Stats.f_12949_, "mined");
            StatsDataPacket packet = new StatsDataPacket(targetPlayerName, stats);
            FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
            packet.encode(buf);
            NetworkManager.sendToPlayer((ServerPlayer)requestingPlayer, (ResourceLocation)STATS_DATA, (FriendlyByteBuf)buf);
            if (ModConfig.getServer().logStatChanges) {
                Beautiful_statistics_screen.LOGGER.info("Player {} requested stats for {}", (Object)requestingPlayer.m_7755_().getString(), (Object)targetPlayerName);
            }
        }

        private static void addItemStats(Map<String, Long> stats, ServerStatsCounter counter, StatType<Item> statType, String prefix) {
            for (Item item : BuiltInRegistries.f_257033_) {
                Stat stat = statType.m_12902_((Object)item);
                int value = counter.m_13015_(stat);
                if (value <= 0) continue;
                ResourceLocation itemId = BuiltInRegistries.f_257033_.m_7981_((Object)item);
                stats.put(itemId.m_135827_() + ":" + prefix + "/" + itemId.m_135815_(), Long.valueOf(value));
            }
        }

        private static void addEntityStats(Map<String, Long> stats, ServerStatsCounter counter, StatType<EntityType<?>> statType, String prefix) {
            for (EntityType entityType : BuiltInRegistries.f_256780_) {
                Stat stat = statType.m_12902_((Object)entityType);
                int value = counter.m_13015_(stat);
                if (value <= 0) continue;
                ResourceLocation entityId = BuiltInRegistries.f_256780_.m_7981_((Object)entityType);
                stats.put(entityId.m_135827_() + ":" + prefix + "/" + entityId.m_135815_(), Long.valueOf(value));
            }
        }

        private static void addBlockStats(Map<String, Long> stats, ServerStatsCounter counter, StatType<Block> statType, String prefix) {
            for (Block block : BuiltInRegistries.f_256975_) {
                Stat stat = statType.m_12902_((Object)block);
                int value = counter.m_13015_(stat);
                if (value <= 0) continue;
                ResourceLocation blockId = BuiltInRegistries.f_256975_.m_7981_((Object)block);
                stats.put(blockId.m_135827_() + ":" + prefix + "/" + blockId.m_135815_(), Long.valueOf(value));
            }
        }
    }

    public static class RequestStatsPacket {
        private final String targetPlayer;

        public RequestStatsPacket(String targetPlayer) {
            this.targetPlayer = targetPlayer;
        }

        public void encode(FriendlyByteBuf buf) {
            buf.m_130070_(this.targetPlayer);
        }

        public static RequestStatsPacket decode(FriendlyByteBuf buf) {
            return new RequestStatsPacket(buf.m_130277_());
        }

        public static void handle(FriendlyByteBuf buf, NetworkManager.PacketContext context) {
            RequestStatsPacket packet = RequestStatsPacket.decode(buf);
            context.queue(() -> {
                Player patt0$temp = context.getPlayer();
                if (patt0$temp instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)patt0$temp;
                    StatsDataPacket.sendToPlayer(serverPlayer, packet.targetPlayer);
                }
            });
        }

        public void send() {
            FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
            this.encode(buf);
            NetworkManager.sendToServer((ResourceLocation)REQUEST_STATS, (FriendlyByteBuf)buf);
        }
    }
}

