/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.beautiful_statistics_screen.network;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stat;
import org.texboobcat.beautiful_statistics_screen.Beautiful_statistics_screen;

public class StatUpdateTracker {
    private static final Map<UUID, Map<String, Integer>> LAST_KNOWN_VALUES = new ConcurrentHashMap<UUID, Map<String, Integer>>();
    private static final Map<UUID, Long> LAST_UPDATE_TIME = new ConcurrentHashMap<UUID, Long>();
    private static final int UPDATE_INTERVAL = 1000;

    public static void checkAndSendUpdate(ServerPlayer player, Stat<?> stat, int newValue) {
        UUID playerId = player.m_20148_();
        String statKey = StatUpdateTracker.getStatKey(stat);
        Map playerStats = LAST_KNOWN_VALUES.computeIfAbsent(playerId, k -> new HashMap());
        Integer lastValue = (Integer)playerStats.get(statKey);
        if (lastValue == null || lastValue != newValue) {
            playerStats.put(statKey, newValue);
            Long lastUpdate = LAST_UPDATE_TIME.get(playerId);
            long now = System.currentTimeMillis();
            if (lastUpdate == null || now - lastUpdate >= 1000L) {
                LAST_UPDATE_TIME.put(playerId, now);
                StatUpdateTracker.sendUpdateToSubscribers(player, statKey, newValue);
            }
        }
    }

    public static void subscribe(ServerPlayer subscriber, ServerPlayer target) {
        Beautiful_statistics_screen.LOGGER.info("Player {} subscribed to updates from {}", (Object)subscriber.m_7755_().getString(), (Object)target.m_7755_().getString());
    }

    public static void unsubscribe(ServerPlayer subscriber, ServerPlayer target) {
        Beautiful_statistics_screen.LOGGER.info("Player {} unsubscribed from updates from {}", (Object)subscriber.m_7755_().getString(), (Object)target.m_7755_().getString());
    }

    private static void sendUpdateToSubscribers(ServerPlayer player, String statKey, int value) {
        Beautiful_statistics_screen.LOGGER.debug("Stat update: {} - {} = {}", new Object[]{player.m_7755_().getString(), statKey, value});
    }

    private static String getStatKey(Stat<?> stat) {
        return stat.m_83620_();
    }

    public static void clearPlayer(UUID playerId) {
        LAST_KNOWN_VALUES.remove(playerId);
        LAST_UPDATE_TIME.remove(playerId);
    }

    public static void clearAll() {
        LAST_KNOWN_VALUES.clear();
        LAST_UPDATE_TIME.clear();
    }
}

