/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.beautiful_statistics_screen.util;

import java.text.DecimalFormat;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class StatFormatter {
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("#,###");
    private static final DecimalFormat COMPACT_FORMAT = new DecimalFormat("#.#");

    public static String formatValue(long value) {
        if (value >= 1000000000L) {
            return COMPACT_FORMAT.format((double)value / 1.0E9) + "B";
        }
        if (value >= 1000000L) {
            return COMPACT_FORMAT.format((double)value / 1000000.0) + "M";
        }
        if (value >= 1000L) {
            return COMPACT_FORMAT.format((double)value / 1000.0) + "K";
        }
        return DECIMAL_FORMAT.format(value);
    }

    public static String formatValueFull(long value) {
        return DECIMAL_FORMAT.format(value);
    }

    public static String formatDistance(long centimeters) {
        if (centimeters >= 100000L) {
            double kilometers = (double)centimeters / 100000.0;
            return COMPACT_FORMAT.format(kilometers) + " km";
        }
        if (centimeters >= 100L) {
            double meters = (double)centimeters / 100.0;
            return COMPACT_FORMAT.format(meters) + " m";
        }
        return centimeters + " cm";
    }

    public static String formatTime(long ticks) {
        long seconds = ticks / 20L;
        long minutes = seconds / 60L;
        long hours = minutes / 60L;
        long days = hours / 24L;
        if (days > 0L) {
            return days + "d " + hours % 24L + "h";
        }
        if (hours > 0L) {
            return hours + "h " + minutes % 60L + "m";
        }
        if (minutes > 0L) {
            return minutes + "m " + seconds % 60L + "s";
        }
        return seconds + "s";
    }

    public static String formatDamage(long halfHearts) {
        double hearts = (double)halfHearts / 2.0;
        return COMPACT_FORMAT.format(hearts) + " \u2764";
    }

    public static Component getDisplayName(ResourceLocation statId) {
        String path = statId.m_135815_();
        String[] parts = path.split("/");
        if (parts.length == 2) {
            String type = parts[0];
            String target = parts[1];
            String formattedTarget = StatFormatter.formatIdentifier(target);
            return Component.m_237115_((String)("stat.beautiful_statistics_screen." + type)).m_130946_(" ").m_7220_((Component)Component.m_237113_((String)formattedTarget));
        }
        return Component.m_237113_((String)StatFormatter.formatIdentifier(path));
    }

    private static String formatIdentifier(String identifier) {
        return identifier.replace("_", " ").replace("minecraft:", "").substring(0, 1).toUpperCase() + identifier.substring(1);
    }

    public static String formatStatValue(ResourceLocation statId, long value) {
        String path = statId.m_135815_();
        if (path.contains("one_cm") || path.contains("_cm")) {
            return StatFormatter.formatDistance(value);
        }
        if (path.contains("time") || path.contains("sneak_time")) {
            return StatFormatter.formatTime(value);
        }
        if (path.contains("damage")) {
            return StatFormatter.formatDamage(value);
        }
        return StatFormatter.formatValue(value);
    }

    public static Component getDescription(ResourceLocation statId) {
        String path = statId.m_135815_();
        if (path.contains("one_cm")) {
            return Component.m_237115_((String)"stat.description.beautiful_statistics_screen.distance");
        }
        if (path.contains("play_time")) {
            return Component.m_237115_((String)"stat.description.beautiful_statistics_screen.time");
        }
        if (path.contains("damage")) {
            return Component.m_237115_((String)"stat.description.beautiful_statistics_screen.damage");
        }
        return Component.m_237119_();
    }
}

