/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.beautiful_statistics_screen.client.gui;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4280;
import net.minecraft.class_437;
import org.texboobcat.beautiful_statistics_screen.client.gui.CustomStatEditorScreen;
import org.texboobcat.beautiful_statistics_screen.client.gui.CustomStatsHelpScreen;
import org.texboobcat.beautiful_statistics_screen.client.gui.StatImportExportScreen;
import org.texboobcat.beautiful_statistics_screen.client.gui.StatTemplatesScreen;
import org.texboobcat.beautiful_statistics_screen.config.ModConfig;
import org.texboobcat.beautiful_statistics_screen.custom.CustomStatDefinition;
import org.texboobcat.beautiful_statistics_screen.custom.CustomStatManager;
import org.texboobcat.beautiful_statistics_screen.custom.conditions.ConditionGroup;

public class CustomStatScreen
extends class_437 {
    private final class_437 parent;
    private List<CustomStatDefinition> customStats;
    private CustomStatListWidget statList;
    private class_4185 createButton;
    private class_4185 deleteButton;
    private class_4185 editButton;
    private class_4185 toggleButton;
    private class_4185 templatesButton;
    private class_4185 backButton;
    private class_342 searchBox;
    private int selectedIndex = -1;

    public CustomStatScreen(class_437 parent) {
        super((class_2561)class_2561.method_43470((String)"Custom Statistics"));
        this.parent = parent;
    }

    protected void method_25426() {
        this.customStats = new ArrayList<CustomStatDefinition>(CustomStatManager.getAllCustomStats());
        this.statList = new CustomStatListWidget(this.field_22787, this.field_22789, this.field_22790 - 96, 56, this.field_22790 - 64, 36);
        this.method_25429((class_364)this.statList);
        this.searchBox = new class_342(this.field_22793, this.field_22789 / 2 - 100, 32, 200, 20, (class_2561)class_2561.method_43470((String)"Search"));
        this.searchBox.method_47404((class_2561)class_2561.method_43470((String)"Search stats..."));
        this.searchBox.method_1863(this::onSearchChanged);
        this.method_37063((class_364)this.searchBox);
        int buttonY = this.field_22790 - 52;
        int buttonWidth = 75;
        int spacing = 5;
        int totalWidth = buttonWidth * 6 + spacing * 5;
        int startX = (this.field_22789 - totalWidth) / 2;
        this.createButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Create"), button -> this.openCreateStatScreen()).method_46434(startX, buttonY, buttonWidth, 20).method_46431();
        this.method_37063((class_364)this.createButton);
        this.templatesButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Templates"), button -> this.openTemplatesScreen()).method_46434(startX + buttonWidth + spacing, buttonY, buttonWidth, 20).method_46431();
        this.method_37063((class_364)this.templatesButton);
        this.editButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Edit"), button -> this.openEditStatScreen()).method_46434(startX + (buttonWidth + spacing) * 2, buttonY, buttonWidth, 20).method_46431();
        this.editButton.field_22763 = false;
        this.method_37063((class_364)this.editButton);
        this.deleteButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Delete"), button -> this.deleteStat()).method_46434(startX + (buttonWidth + spacing) * 3, buttonY, buttonWidth, 20).method_46431();
        this.deleteButton.field_22763 = false;
        this.method_37063((class_364)this.deleteButton);
        this.toggleButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Toggle"), button -> this.toggleStat()).method_46434(startX + (buttonWidth + spacing) * 4, buttonY, buttonWidth, 20).method_46431();
        this.toggleButton.field_22763 = false;
        this.method_37063((class_364)this.toggleButton);
        class_4185 importExportButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u00a76Import/Export"), button -> this.openImportExportScreen()).method_46434(startX + (buttonWidth + spacing) * 5, buttonY, buttonWidth, 20).method_46431();
        this.method_37063((class_364)importExportButton);
        this.backButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Back"), button -> this.field_22787.method_1507(this.parent)).method_46434(startX + (buttonWidth + spacing) * 6, buttonY, buttonWidth, 20).method_46431();
        this.method_37063((class_364)this.backButton);
        class_4185 helpButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"?"), button -> this.openHelpScreen()).method_46434(this.field_22789 - 30, 8, 20, 20).method_46431();
        this.method_37063((class_364)helpButton);
        this.refreshList();
    }

    private void onSearchChanged(String search) {
        this.refreshList();
    }

    private void refreshList() {
        String search = this.searchBox.method_1882().toLowerCase();
        ArrayList<CustomStatDefinition> filtered = new ArrayList<CustomStatDefinition>();
        for (CustomStatDefinition stat : CustomStatManager.getAllCustomStats()) {
            if (!search.isEmpty() && !stat.getName().toLowerCase().contains(search) && !stat.getDescription().toLowerCase().contains(search) && !stat.getCategory().toLowerCase().contains(search)) continue;
            filtered.add(stat);
        }
        this.customStats = filtered;
        this.statList.setStats(filtered);
    }

    private void openCreateStatScreen() {
        this.field_22787.method_1507((class_437)new CustomStatEditorScreen(this, null));
    }

    private void openEditStatScreen() {
        if (this.selectedIndex >= 0 && this.selectedIndex < this.customStats.size()) {
            CustomStatDefinition stat = this.customStats.get(this.selectedIndex);
            this.field_22787.method_1507((class_437)new CustomStatEditorScreen(this, stat));
        }
    }

    private void deleteStat() {
        if (this.selectedIndex >= 0 && this.selectedIndex < this.customStats.size()) {
            CustomStatDefinition stat = this.customStats.get(this.selectedIndex);
            CustomStatManager.deleteCustomStat(stat.getId());
            this.selectedIndex = -1;
            this.updateButtonStates();
            this.refreshList();
        }
    }

    private void toggleStat() {
        if (this.selectedIndex >= 0 && this.selectedIndex < this.customStats.size()) {
            CustomStatDefinition stat;
            stat.setEnabled(!(stat = this.customStats.get(this.selectedIndex)).isEnabled());
            CustomStatManager.updateCustomStat(stat);
            this.refreshList();
        }
    }

    private void openTemplatesScreen() {
        this.field_22787.method_1507((class_437)new StatTemplatesScreen(this));
    }

    private void openImportExportScreen() {
        this.field_22787.method_1507((class_437)new StatImportExportScreen(this));
    }

    private void openHelpScreen() {
        this.field_22787.method_1507((class_437)new CustomStatsHelpScreen(this));
    }

    public void setSelectedIndex(int index) {
        this.selectedIndex = index;
        this.updateButtonStates();
    }

    private void updateButtonStates() {
        boolean hasSelection;
        this.editButton.field_22763 = hasSelection = this.selectedIndex >= 0 && this.selectedIndex < this.customStats.size();
        this.deleteButton.field_22763 = hasSelection;
        this.toggleButton.field_22763 = hasSelection;
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTick) {
        this.method_25420(graphics);
        this.statList.method_25394(graphics, mouseX, mouseY, partialTick);
        graphics.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 16, 0xFFFFFF);
        String countText = this.customStats.size() + " custom stat" + (this.customStats.size() == 1 ? "" : "s");
        graphics.method_25303(this.field_22793, countText, 10, this.field_22790 - 26, 0xAAAAAA);
        super.method_25394(graphics, mouseX, mouseY, partialTick);
        if (this.selectedIndex >= 0 && this.selectedIndex < this.customStats.size()) {
            CustomStatDefinition stat = this.customStats.get(this.selectedIndex);
            int tooltipX = 10;
            int tooltipY = this.field_22790 - 90;
            graphics.method_25303(this.field_22793, "Selected: " + stat.getName(), tooltipX, tooltipY, 0xFFFFFF);
            graphics.method_25303(this.field_22793, "Type: " + stat.getTrackingType().getDisplayName(), tooltipX, tooltipY + 12, 0xAAAAAA);
            graphics.method_25303(this.field_22793, "Value: " + stat.getFormattedValue(), tooltipX, tooltipY + 24, 0xAAAAAA);
            graphics.method_25303(this.field_22793, "Status: " + (stat.isEnabled() ? "\u00a7aEnabled" : "\u00a7cDisabled"), tooltipX, tooltipY + 36, 0xAAAAAA);
        }
    }

    public void method_25419() {
        this.field_22787.method_1507(this.parent);
    }

    public boolean method_25421() {
        return ModConfig.getClient().pauseOnStatsScreens;
    }

    private class CustomStatListWidget
    extends class_4280<Entry> {
        private List<CustomStatDefinition> stats;

        public CustomStatListWidget(class_310 minecraft, int width, int height, int y0, int y1, int itemHeight) {
            super(minecraft, width, height, y0, y1, itemHeight);
            this.stats = new ArrayList<CustomStatDefinition>();
        }

        public void setStats(List<CustomStatDefinition> stats) {
            this.method_25339();
            this.stats = stats;
            for (int i = 0; i < stats.size(); ++i) {
                this.method_25321((class_350.class_351)new Entry(stats.get(i), i));
            }
        }

        public int method_25322() {
            return this.field_22742 - 20;
        }

        protected int method_25329() {
            return this.field_22742 - 6;
        }

        class Entry
        extends class_4280.class_4281<Entry> {
            private final CustomStatDefinition stat;
            private final int index;

            public Entry(CustomStatDefinition stat, int index) {
                this.stat = stat;
                this.index = index;
            }

            public void method_25343(class_332 graphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
                ConditionGroup group;
                int backgroundColor = hovering ? 0x40FFFFFF : (this.stat.isEnabled() ? 0x20FFFFFF : 0x10808080);
                graphics.method_25294(left, top, left + width, top + height, backgroundColor);
                Object name = this.stat.getName();
                if (((String)name).length() > 30) {
                    name = ((String)name).substring(0, 27) + "...";
                }
                graphics.method_25303(((CustomStatListWidget)CustomStatListWidget.this).field_22740.field_1772, (String)name, left + 5, top + 2, this.stat.isEnabled() ? 0xFFFFFF : 0x808080);
                String info = this.stat.getTrackingType().getDisplayName() + " | " + this.stat.getCategory();
                graphics.method_25303(((CustomStatListWidget)CustomStatListWidget.this).field_22740.field_1772, info, left + 5, top + 13, 0xAAAAAA);
                String value = this.stat.getFormattedValue();
                int valueWidth = ((CustomStatListWidget)CustomStatListWidget.this).field_22740.field_1772.method_1727(value);
                graphics.method_25303(((CustomStatListWidget)CustomStatListWidget.this).field_22740.field_1772, value, left + width - valueWidth - 5, top + 8, 0x55FF55);
                int targetCount = this.stat.getTargets().size();
                if (targetCount > 0) {
                    String targetsText = targetCount + " target" + (targetCount == 1 ? "" : "s");
                    graphics.method_25303(((CustomStatListWidget)CustomStatListWidget.this).field_22740.field_1772, targetsText, left + 5, top + 24, 0x888888);
                }
                if ((group = this.stat.getConditionGroup()) != null && !group.isEmpty()) {
                    int conditionCount;
                    String conditionsText = conditionCount + " condition" + ((conditionCount = group.getConditions().size()) == 1 ? "" : "s");
                    int condX = left + width - ((CustomStatListWidget)CustomStatListWidget.this).field_22740.field_1772.method_1727(conditionsText) - 5;
                    graphics.method_25303(((CustomStatListWidget)CustomStatListWidget.this).field_22740.field_1772, conditionsText, condX, top + 24, 0x888888);
                }
            }

            public class_2561 method_37006() {
                return class_2561.method_43470((String)this.stat.getName());
            }

            public boolean method_25402(double mouseX, double mouseY, int button) {
                CustomStatScreen.this.setSelectedIndex(this.index);
                return true;
            }
        }
    }
}

