/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.beautiful_statistics_screen.client.gui;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1826;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4280;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_7923;

public class IconPickerScreen
extends class_437 {
    private final class_437 parent;
    private final Consumer<String> onIconSelected;
    private final String currentIcon;
    private class_342 searchBox;
    private IconGridWidget iconGrid;
    private class_4185 selectItemsButton;
    private class_4185 selectEntitiesButton;
    private class_4185 selectButton;
    private class_4185 cancelButton;
    private IconType currentType = IconType.ITEMS;
    private String searchQuery = "";

    public IconPickerScreen(class_437 parent, String currentIcon, Consumer<String> onIconSelected) {
        super((class_2561)class_2561.method_43470((String)"Select Icon"));
        this.parent = parent;
        this.currentIcon = currentIcon;
        this.onIconSelected = onIconSelected;
    }

    protected void method_25426() {
        int topY = 40;
        int buttonHeight = 20;
        int buttonSpacing = 5;
        int searchBoxWidth = 200;
        this.searchBox = new class_342(this.field_22793, this.field_22789 / 2 - searchBoxWidth / 2, topY, searchBoxWidth, buttonHeight, (class_2561)class_2561.method_43470((String)"Search"));
        this.searchBox.method_1880(100);
        this.searchBox.method_1852(this.searchQuery);
        this.searchBox.method_1863(this::onSearchChanged);
        this.method_37063((class_364)this.searchBox);
        int typeButtonY = topY + buttonHeight + buttonSpacing;
        int typeButtonWidth = 80;
        int typeButtonX = this.field_22789 / 2 - (typeButtonWidth * 2 + buttonSpacing) / 2;
        this.selectItemsButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"\ud83d\udce6 Items"), btn -> this.switchToType(IconType.ITEMS)).method_46434(typeButtonX, typeButtonY, typeButtonWidth, buttonHeight).method_46431();
        this.method_37063((class_364)this.selectItemsButton);
        this.selectEntitiesButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"\ud83d\udc04 Entities"), btn -> this.switchToType(IconType.ENTITIES)).method_46434(typeButtonX + typeButtonWidth + buttonSpacing, typeButtonY, typeButtonWidth, buttonHeight).method_46431();
        this.method_37063((class_364)this.selectEntitiesButton);
        int gridY = typeButtonY + buttonHeight + 10;
        int gridBottom = this.field_22790 - 40;
        this.iconGrid = new IconGridWidget(this.field_22787, this.field_22789, this.field_22790, gridY, gridBottom, 50);
        this.updateIconGrid();
        this.method_37063((class_364)this.iconGrid);
        int bottomButtonY = this.field_22790 - 30;
        int bottomButtonWidth = 100;
        this.selectButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Select"), btn -> this.selectIcon()).method_46434(this.field_22789 / 2 - bottomButtonWidth - 5, bottomButtonY, bottomButtonWidth, buttonHeight).method_46431();
        this.selectButton.field_22763 = false;
        this.method_37063((class_364)this.selectButton);
        this.cancelButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Cancel"), btn -> this.field_22787.method_1507(this.parent)).method_46434(this.field_22789 / 2 + 5, bottomButtonY, bottomButtonWidth, buttonHeight).method_46431();
        this.method_37063((class_364)this.cancelButton);
        this.updateButtonStates();
    }

    private void onSearchChanged(String query) {
        this.searchQuery = query;
        this.updateIconGrid();
    }

    private void switchToType(IconType type) {
        this.currentType = type;
        this.updateIconGrid();
        this.updateButtonStates();
    }

    private void updateIconGrid() {
        if (this.iconGrid == null) {
            return;
        }
        ArrayList<IconEntry> icons = new ArrayList<IconEntry>();
        if (this.currentType == IconType.ITEMS) {
            for (class_1792 item : class_7923.field_41178) {
                class_2960 itemId = class_7923.field_41178.method_10221((Object)item);
                String iconStr = itemId.toString();
                if (!this.matchesSearch(iconStr)) continue;
                icons.add(new IconEntry(iconStr, new class_1799((class_1935)item), IconEntryType.ITEM));
            }
        } else if (this.currentType == IconType.ENTITIES) {
            for (class_1299 entityType : class_7923.field_41177) {
                class_2960 entityId = class_7923.field_41177.method_10221((Object)entityType);
                String iconStr = entityId.toString();
                if (!this.matchesSearch(iconStr)) continue;
                icons.add(new IconEntry(iconStr, entityType, IconEntryType.ENTITY));
            }
        }
        this.iconGrid.setIcons(icons);
    }

    private boolean matchesSearch(String iconStr) {
        if (this.searchQuery.isEmpty()) {
            return true;
        }
        return iconStr.toLowerCase().contains(this.searchQuery.toLowerCase());
    }

    private void updateButtonStates() {
        this.selectItemsButton.field_22763 = this.currentType != IconType.ITEMS;
        this.selectEntitiesButton.field_22763 = this.currentType != IconType.ENTITIES;
    }

    public void onIconSelectedInGrid() {
        if (this.selectButton != null) {
            this.selectButton.field_22763 = this.iconGrid != null && this.iconGrid.getSelectedIcon() != null;
        }
    }

    private void selectIcon() {
        IconEntry selected = this.iconGrid.getSelectedIcon();
        if (selected != null) {
            String iconId = selected.iconString;
            System.out.println("IconPickerScreen: Selected icon = " + iconId);
            this.onIconSelected.accept(iconId);
            this.field_22787.method_1507(this.parent);
        } else {
            System.out.println("IconPickerScreen: No icon selected");
        }
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTick) {
        this.method_25420(graphics);
        graphics.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 15, 0xFFFFFF);
        String typeText = "Showing: " + this.currentType.getDisplayName();
        graphics.method_25303(this.field_22793, typeText, 10, 75, 0xAAAAAA);
        if (this.iconGrid != null) {
            String countText = this.iconGrid.getIconCount() + " icons";
            graphics.method_25303(this.field_22793, countText, this.field_22789 - this.field_22793.method_1727(countText) - 10, 75, 0xAAAAAA);
        }
        super.method_25394(graphics, mouseX, mouseY, partialTick);
        if (this.iconGrid != null && this.iconGrid.getHoveredIcon() != null) {
            IconEntry hovered = this.iconGrid.getHoveredIcon();
            ArrayList<class_5250> tooltip = new ArrayList<class_5250>();
            Object displayName = hovered.iconString;
            if (((String)displayName).contains(":")) {
                displayName = ((String)displayName).substring(((String)displayName).indexOf(58) + 1);
            }
            if (((String)(displayName = ((String)displayName).replace("_", " "))).length() > 0) {
                displayName = Character.toUpperCase(((String)displayName).charAt(0)) + ((String)displayName).substring(1);
            }
            tooltip.add(class_2561.method_43470((String)displayName));
            tooltip.add(class_2561.method_43470((String)("\u00a78" + hovered.iconString)));
            graphics.method_51434(this.field_22793, tooltip, mouseX, mouseY);
        }
    }

    public void method_25419() {
        this.field_22787.method_1507(this.parent);
    }

    public boolean method_25421() {
        return false;
    }

    private static class_1799 findSpawnEgg(class_1299<?> entityType) {
        for (class_1792 item : class_7923.field_41178) {
            class_1826 eggItem;
            if (!(item instanceof class_1826) || (eggItem = (class_1826)item).method_8015(null) != entityType) continue;
            return new class_1799((class_1935)eggItem);
        }
        return class_1799.field_8037;
    }

    private static enum IconType {
        ITEMS("Items"),
        ENTITIES("Entities");

        private final String displayName;

        private IconType(String displayName) {
            this.displayName = displayName;
        }

        public String getDisplayName() {
            return this.displayName;
        }
    }

    private class IconGridWidget
    extends class_4280<IconSlot> {
        private List<IconEntry> icons;
        private IconEntry selectedIcon;
        private IconEntry hoveredIcon;

        public IconGridWidget(class_310 minecraft, int width, int height, int y0, int y1, int itemHeight) {
            super(minecraft, width, height, y0, y1, itemHeight);
            this.icons = new ArrayList<IconEntry>();
        }

        public void setIcons(List<IconEntry> icons) {
            this.method_25339();
            this.icons = icons;
            int iconSize = 48;
            int spacing = 4;
            int iconsPerRow = Math.max(1, (this.field_22742 - 80) / (iconSize + spacing));
            for (int i = 0; i < icons.size(); i += iconsPerRow) {
                int endIndex = Math.min(i + iconsPerRow, icons.size());
                List<IconEntry> rowIcons = icons.subList(i, endIndex);
                this.method_25321((class_350.class_351)new IconSlot(rowIcons, iconsPerRow));
            }
        }

        public IconEntry getSelectedIcon() {
            return this.selectedIcon;
        }

        public IconEntry getHoveredIcon() {
            return this.hoveredIcon;
        }

        public int getIconCount() {
            return this.icons.size();
        }

        public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTick) {
            this.hoveredIcon = null;
            super.method_25394(graphics, mouseX, mouseY, partialTick);
        }

        protected void method_44398(class_332 graphics, int top, int width, int height, int outerColor, int innerColor) {
        }

        public class IconSlot
        extends class_4280.class_4281<IconSlot> {
            private final List<IconEntry> rowIcons;
            private final int iconsPerRow;
            private int lastStartX = 0;
            private int lastTop = 0;
            private int lastIconSize = 44;
            private int lastSpacing = 4;

            public IconSlot(List<IconEntry> rowIcons, int iconsPerRow) {
                this.rowIcons = rowIcons;
                this.iconsPerRow = iconsPerRow;
            }

            public void method_25343(class_332 graphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isHovering, float partialTick) {
                int startX;
                int iconSize = 44;
                int spacing = 4;
                this.lastIconSize = iconSize;
                this.lastSpacing = spacing;
                this.lastTop = top;
                int totalIconsWidth = this.rowIcons.size() * iconSize + (this.rowIcons.size() - 1) * spacing;
                this.lastStartX = startX = left + (width - totalIconsWidth) / 2;
                for (int i = 0; i < this.rowIcons.size(); ++i) {
                    boolean hovering;
                    IconEntry icon = this.rowIcons.get(i);
                    int x = startX + i * (iconSize + spacing);
                    boolean selected = icon == IconGridWidget.this.selectedIcon;
                    boolean bl = hovering = mouseX >= x && mouseX < x + iconSize && mouseY >= top && mouseY < top + iconSize;
                    if (hovering) {
                        IconGridWidget.this.hoveredIcon = icon;
                    }
                    int bgColor = selected ? -16755456 : (hovering ? -12303292 : -14540254);
                    graphics.method_25294(x, top, x + iconSize, top + iconSize, bgColor);
                    if (icon.type == IconEntryType.ITEM && icon.displayObject instanceof class_1799) {
                        class_1799 stack = (class_1799)icon.displayObject;
                        graphics.method_51427(stack, x + 14, top + 14);
                    } else if (icon.type == IconEntryType.ENTITY && icon.displayObject instanceof class_1299) {
                        class_1299 entityType = (class_1299)icon.displayObject;
                        class_1799 eggStack = IconPickerScreen.findSpawnEgg(entityType);
                        if (eggStack != null && !eggStack.method_7960()) {
                            graphics.method_51427(eggStack, x + 14, top + 14);
                        } else {
                            class_1799 placeholderStack = new class_1799((class_1935)class_1802.field_8575);
                            graphics.method_51427(placeholderStack, x + 14, top + 14);
                            Object entityName = icon.iconString.substring(icon.iconString.indexOf(58) + 1);
                            entityName = ((String)entityName).replace("_", " ");
                            if (((String)entityName).length() > 0) {
                                entityName = Character.toUpperCase(((String)entityName).charAt(0)) + ((String)entityName).substring(1);
                            }
                            if (((String)entityName).length() > 8) {
                                entityName = ((String)entityName).substring(0, 7) + ".";
                            }
                            int textWidth = IconPickerScreen.this.field_22793.method_1727((String)entityName);
                            graphics.method_25303(IconPickerScreen.this.field_22793, (String)entityName, x + (iconSize - textWidth) / 2, top + iconSize - 10, 0xCCCCCC);
                        }
                    }
                    int borderColor = selected ? -16711936 : (hovering ? -5592406 : -10066330);
                    graphics.method_49601(x, top, iconSize, iconSize, borderColor);
                }
            }

            public class_2561 method_37006() {
                return class_2561.method_43470((String)"Icon row");
            }

            public boolean method_25402(double mouseX, double mouseY, int button) {
                for (int i = 0; i < this.rowIcons.size(); ++i) {
                    IconEntry clickedIcon;
                    int x = this.lastStartX + i * (this.lastIconSize + this.lastSpacing);
                    if (!(mouseX >= (double)x) || !(mouseX < (double)(x + this.lastIconSize)) || !(mouseY >= (double)this.lastTop) || !(mouseY < (double)(this.lastTop + this.lastIconSize))) continue;
                    IconGridWidget.this.selectedIcon = clickedIcon = this.rowIcons.get(i);
                    System.out.println("IconSlot: Selected " + clickedIcon.iconString);
                    IconPickerScreen.this.onIconSelectedInGrid();
                    return true;
                }
                return false;
            }
        }
    }

    private static class IconEntry {
        final String iconString;
        final Object displayObject;
        final IconEntryType type;

        IconEntry(String iconString, Object displayObject, IconEntryType type) {
            this.iconString = iconString;
            this.displayObject = displayObject;
            this.type = type;
        }
    }

    private static enum IconEntryType {
        ITEM,
        ENTITY;

    }
}

