/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.beautiful_statistics_screen.client.gui;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import org.texboobcat.beautiful_statistics_screen.client.gui.ConditionDebuggerPanel;
import org.texboobcat.beautiful_statistics_screen.client.gui.ConditionDetailScreen;
import org.texboobcat.beautiful_statistics_screen.client.gui.ScratchBlockRenderer;
import org.texboobcat.beautiful_statistics_screen.custom.conditions.ConditionGroup;
import org.texboobcat.beautiful_statistics_screen.custom.conditions.ConditionalBlock;
import org.texboobcat.beautiful_statistics_screen.custom.conditions.StatCondition;

public class ScratchBlockEditorScreenV2
extends class_437 {
    private final class_437 parent;
    private final ConditionalBlock rootBlock;
    private final Consumer<ConditionalBlock> onSave;
    private ConditionalBlock draggedBlock;
    private int dragStartX;
    private int dragStartY;
    private ConditionalBlock dragTarget;
    private DropType dragDropType = DropType.NONE;
    private ConditionalBlock selectedBlock;
    private ConditionDebuggerPanel debugger;
    private class_4185 toggleDebuggerButton;
    private static final int CANVAS_START_Y = 110;
    private static final int PALETTE_HEIGHT = 50;
    private static final int DEBUGGER_WIDTH = 250;
    private List<ConditionalBlock> allBlocks = new ArrayList<ConditionalBlock>();

    public ScratchBlockEditorScreenV2(class_437 parent, ConditionalBlock rootBlock, Consumer<ConditionalBlock> onSave) {
        super((class_2561)class_2561.method_43471((String)"screen.beautiful_statistics_screen.scratch_editor"));
        this.parent = parent;
        this.rootBlock = rootBlock != null ? rootBlock : new ConditionalBlock();
        this.onSave = onSave;
    }

    protected void method_25426() {
        super.method_25426();
        int debuggerX = this.field_22789 - 250 - 10;
        int debuggerY = 110;
        int debuggerHeight = this.field_22790 - 110 - 50;
        this.debugger = new ConditionDebuggerPanel(this.field_22787, debuggerX, debuggerY, 250, debuggerHeight);
        this.debugger.setRootBlock(this.rootBlock);
        this.toggleDebuggerButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.beautiful_statistics_screen.scratch.debugger"), btn -> {
            this.debugger.setVisible(!this.debugger.isVisible());
            this.layoutBlocks();
        }).method_46434(this.field_22789 - 30, 10, 20, 20).method_46431();
        this.method_37063((class_364)this.toggleDebuggerButton);
        int paletteY = 50;
        int buttonWidth = 70;
        int spacing = 5;
        int startX = 20;
        class_4185 addIfButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.beautiful_statistics_screen.scratch.add_if"), btn -> this.createBlockFromPalette(ConditionalBlock.BlockType.IF, btn.method_46426() + btn.method_25368() / 2, btn.method_46427() + btn.method_25364())).method_46434(startX, paletteY, buttonWidth, 20).method_46431();
        this.method_37063((class_364)addIfButton);
        class_4185 addAndButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.beautiful_statistics_screen.scratch.add_and"), btn -> this.createBlockFromPalette(ConditionalBlock.BlockType.AND, btn.method_46426() + btn.method_25368() / 2, btn.method_46427() + btn.method_25364())).method_46434(startX + (buttonWidth + spacing), paletteY, buttonWidth, 20).method_46431();
        this.method_37063((class_364)addAndButton);
        class_4185 addOrButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.beautiful_statistics_screen.scratch.add_or"), btn -> this.createBlockFromPalette(ConditionalBlock.BlockType.OR, btn.method_46426() + btn.method_25368() / 2, btn.method_46427() + btn.method_25364())).method_46434(startX + (buttonWidth + spacing) * 2, paletteY, buttonWidth, 20).method_46431();
        this.method_37063((class_364)addOrButton);
        class_4185 addNotButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.beautiful_statistics_screen.scratch.add_not"), btn -> this.createBlockFromPalette(ConditionalBlock.BlockType.NOT, btn.method_46426() + btn.method_25368() / 2, btn.method_46427() + btn.method_25364())).method_46434(startX + (buttonWidth + spacing) * 3, paletteY, buttonWidth, 20).method_46431();
        this.method_37063((class_364)addNotButton);
        int paletteY2 = 75;
        class_4185 addXorButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.beautiful_statistics_screen.scratch.add_xor"), btn -> this.createBlockFromPalette(ConditionalBlock.BlockType.XOR, btn.method_46426() + btn.method_25368() / 2, btn.method_46427() + btn.method_25364())).method_46434(startX, paletteY2, buttonWidth, 20).method_46431();
        this.method_37063((class_364)addXorButton);
        class_4185 addNandButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.beautiful_statistics_screen.scratch.add_nand"), btn -> this.createBlockFromPalette(ConditionalBlock.BlockType.NAND, btn.method_46426() + btn.method_25368() / 2, btn.method_46427() + btn.method_25364())).method_46434(startX + (buttonWidth + spacing), paletteY2, buttonWidth, 20).method_46431();
        this.method_37063((class_364)addNandButton);
        class_4185 addNorButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.beautiful_statistics_screen.scratch.add_nor"), btn -> this.createBlockFromPalette(ConditionalBlock.BlockType.NOR, btn.method_46426() + btn.method_25368() / 2, btn.method_46427() + btn.method_25364())).method_46434(startX + (buttonWidth + spacing) * 2, paletteY2, buttonWidth, 20).method_46431();
        this.method_37063((class_364)addNorButton);
        class_4185 addImpliesButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.beautiful_statistics_screen.scratch.add_implies"), btn -> this.createBlockFromPalette(ConditionalBlock.BlockType.IMPLIES, btn.method_46426() + btn.method_25368() / 2, btn.method_46427() + btn.method_25364())).method_46434(startX + (buttonWidth + spacing) * 3, paletteY2, buttonWidth, 20).method_46431();
        this.method_37063((class_364)addImpliesButton);
        class_4185 addElseIfButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.beautiful_statistics_screen.scratch.add_else_if"), btn -> this.addElseIf()).method_46434(startX + (buttonWidth + spacing) * 4, paletteY, buttonWidth, 20).method_46431();
        this.method_37063((class_364)addElseIfButton);
        class_4185 addElseButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.beautiful_statistics_screen.scratch.add_else"), btn -> this.addElse()).method_46434(startX + (buttonWidth + spacing) * 4, paletteY2, buttonWidth, 20).method_46431();
        this.method_37063((class_364)addElseButton);
        int bottomY = this.field_22790 - 30;
        class_4185 editButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.beautiful_statistics_screen.edit"), btn -> this.editSelectedBlock()).method_46434(this.field_22789 / 2 - 160, bottomY, 70, 20).method_46431();
        this.method_37063((class_364)editButton);
        class_4185 deleteButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.beautiful_statistics_screen.delete"), btn -> this.deleteSelectedBlock()).method_46434(this.field_22789 / 2 - 80, bottomY, 70, 20).method_46431();
        this.method_37063((class_364)deleteButton);
        class_4185 clearButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.beautiful_statistics_screen.clear"), btn -> this.clearAll()).method_46434(this.field_22789 / 2, bottomY, 70, 20).method_46431();
        this.method_37063((class_364)clearButton);
        class_4185 doneButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.beautiful_statistics_screen.done"), btn -> this.save()).method_46434(this.field_22789 / 2 + 80, bottomY, 70, 20).method_46431();
        this.method_37063((class_364)doneButton);
        this.layoutBlocks();
    }

    private void layoutBlocks() {
        this.allBlocks.clear();
        int canvasX = 20;
        int canvasY = 110;
        int canvasWidth = this.debugger.isVisible() ? this.field_22789 - 250 - 50 : this.field_22789 - 40;
        this.layoutBlockRecursive(this.rootBlock, canvasX, canvasY, canvasWidth, 0);
    }

    private int layoutBlockRecursive(ConditionalBlock block, int x, int y, int width, int depth) {
        int currentY = y;
        for (ConditionalBlock child : block.getChildren()) {
            child.setX(x + depth * 30);
            child.setY(currentY);
            child.setWidth(Math.min(200, width - depth * 30));
            child.setHeight(60);
            child.setParent(block);
            this.allBlocks.add(child);
            currentY += child.getHeight() + 10;
            if (!child.hasChildren()) continue;
            currentY = this.layoutBlockRecursive(child, x, currentY, width, depth + 1);
        }
        return currentY;
    }

    private void createBlockFromPalette(ConditionalBlock.BlockType type, int x, int y) {
        ConditionalBlock newBlock;
        this.draggedBlock = newBlock = new ConditionalBlock(type);
        this.dragStartX = x - newBlock.getWidth() / 2;
        this.dragStartY = y;
        newBlock.setX(this.dragStartX);
        newBlock.setY(this.dragStartY);
        newBlock.setDragging(true);
        this.field_22787.method_1507((class_437)new ConditionDetailScreen(this, newBlock.getCondition() != null ? newBlock.getCondition() : new StatCondition(), condition -> newBlock.setCondition((StatCondition)condition)));
    }

    private void editSelectedBlock() {
        if (this.selectedBlock != null && this.selectedBlock.getType() != ConditionalBlock.BlockType.ELSE) {
            StatCondition condition = this.selectedBlock.getCondition();
            if (condition == null) {
                condition = new StatCondition();
                this.selectedBlock.setCondition(condition);
            }
            this.field_22787.method_1507((class_437)new ConditionDetailScreen(this, condition, updatedCondition -> {
                this.selectedBlock.setCondition((StatCondition)updatedCondition);
                this.debugger.setRootBlock(this.rootBlock);
            }));
        }
    }

    private void deleteSelectedBlock() {
        if (this.selectedBlock != null && this.selectedBlock != this.rootBlock) {
            this.removeBlockFromTree(this.rootBlock, this.selectedBlock);
            this.selectedBlock = null;
            this.layoutBlocks();
            this.debugger.setRootBlock(this.rootBlock);
        }
    }

    private boolean removeBlockFromTree(ConditionalBlock parent, ConditionalBlock toRemove) {
        if (parent.getChildren().remove(toRemove)) {
            return true;
        }
        for (ConditionalBlock child : parent.getChildren()) {
            if (!this.removeBlockFromTree(child, toRemove)) continue;
            return true;
        }
        return false;
    }

    private void addElseIf() {
        if (this.selectedBlock != null && this.selectedBlock.getType() == ConditionalBlock.BlockType.IF) {
            ConditionalBlock elseIfBlock = new ConditionalBlock(ConditionalBlock.BlockType.ELSE_IF);
            this.selectedBlock.setElseBlock(elseIfBlock);
            this.layoutBlocks();
            this.debugger.setRootBlock(this.rootBlock);
            this.field_22787.method_1507((class_437)new ConditionDetailScreen(this, new StatCondition(), condition -> elseIfBlock.setCondition((StatCondition)condition)));
        }
    }

    private void addElse() {
        if (this.selectedBlock != null && this.selectedBlock.getType() == ConditionalBlock.BlockType.IF) {
            ConditionalBlock elseBlock = new ConditionalBlock(ConditionalBlock.BlockType.ELSE);
            this.selectedBlock.setElseBlock(elseBlock);
            this.layoutBlocks();
            this.debugger.setRootBlock(this.rootBlock);
        }
    }

    private void clearAll() {
        this.rootBlock.getChildren().clear();
        this.selectedBlock = null;
        this.layoutBlocks();
        this.debugger.setRootBlock(this.rootBlock);
    }

    private void save() {
        this.onSave.accept(this.rootBlock);
        this.field_22787.method_1507(this.parent);
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTick) {
        int blockCount;
        this.method_25420(graphics);
        graphics.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 15, 0xFFFFFF);
        String instructions = class_2561.method_43471((String)"gui.beautiful_statistics_screen.scratch.instruction").getString();
        graphics.method_25300(this.field_22793, instructions, this.field_22789 / 2, 30, 0x888888);
        int canvasWidth = this.debugger.isVisible() ? this.field_22789 - 250 - 50 : this.field_22789 - 40;
        graphics.method_25294(20, 80, 20 + canvasWidth, this.field_22790 - 40, 0x33000000);
        for (ConditionalBlock block : this.allBlocks) {
            boolean isHovered = block.containsPoint(mouseX, mouseY) && this.draggedBlock == null;
            boolean isSelected = block == this.selectedBlock;
            boolean isDragging = block == this.draggedBlock;
            ScratchBlockRenderer.renderBlock(graphics, block, this.field_22793, isHovered, isSelected, isDragging);
        }
        if (this.draggedBlock != null) {
            ScratchBlockRenderer.renderBlock(graphics, this.draggedBlock, this.field_22793, false, false, true);
            if (this.dragTarget != null) {
                int targetColor = this.dragDropType != DropType.NONE ? -2007629995 : -1996532395;
                graphics.method_25294(this.dragTarget.getX() - 2, this.dragTarget.getY() - 2, this.dragTarget.getX() + this.dragTarget.getWidth() + 2, this.dragTarget.getY() + this.dragTarget.getHeight() + 2, targetColor);
            }
        }
        if (this.debugger.isVisible()) {
            this.debugger.render(graphics, this.field_22793, mouseX, mouseY);
        }
        String countText = blockCount + " block" + ((blockCount = this.allBlocks.size()) == 1 ? "" : "s");
        graphics.method_25303(this.field_22793, countText, 25, 85, 0xAAAAAA);
        super.method_25394(graphics, mouseX, mouseY, partialTick);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (super.method_25402(mouseX, mouseY, button)) {
            return true;
        }
        for (ConditionalBlock block : this.allBlocks) {
            if (!block.containsPoint((int)mouseX, (int)mouseY)) continue;
            if (button == 0) {
                this.draggedBlock = block;
                this.dragStartX = (int)mouseX - block.getX();
                this.dragStartY = (int)mouseY - block.getY();
                block.setDragging(true);
                this.selectedBlock = block;
                return true;
            }
            if (button != 1) continue;
            this.selectedBlock = block;
            return true;
        }
        this.selectedBlock = null;
        return true;
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.draggedBlock != null) {
            this.draggedBlock.setX((int)mouseX - this.dragStartX);
            this.draggedBlock.setY((int)mouseY - this.dragStartY);
            this.dragTarget = null;
            this.dragDropType = DropType.NONE;
            for (ConditionalBlock block : this.allBlocks) {
                if (block == this.draggedBlock || !block.containsPoint((int)mouseX, (int)mouseY)) continue;
                this.dragTarget = block;
                if (!this.canNestInside(this.dragTarget)) break;
                this.dragDropType = DropType.NEST_INSIDE;
                break;
            }
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (this.draggedBlock != null) {
            this.draggedBlock.setDragging(false);
            if (this.dragTarget != null && this.dragDropType == DropType.NEST_INSIDE) {
                if (this.draggedBlock.getParent() != null) {
                    this.draggedBlock.getParent().removeChild(this.draggedBlock);
                } else {
                    this.rootBlock.removeChild(this.draggedBlock);
                }
                this.dragTarget.addChild(this.draggedBlock);
                this.draggedBlock.setParent(this.dragTarget);
            } else if (this.dragTarget == null && this.draggedBlock.getParent() == null && !this.rootBlock.getChildren().contains(this.draggedBlock)) {
                this.rootBlock.addChild(this.draggedBlock);
            }
            this.draggedBlock = null;
            this.dragTarget = null;
            this.dragDropType = DropType.NONE;
            this.layoutBlocks();
            this.debugger.setRootBlock(this.rootBlock);
            return true;
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    private boolean canNestInside(ConditionalBlock block) {
        return block.getType() == ConditionalBlock.BlockType.IF || block.getType() == ConditionalBlock.BlockType.AND || block.getType() == ConditionalBlock.BlockType.OR || block.getType() == ConditionalBlock.BlockType.XOR || block.getType() == ConditionalBlock.BlockType.NAND || block.getType() == ConditionalBlock.BlockType.NOR || block.getType() == ConditionalBlock.BlockType.IMPLIES || block.getType() == ConditionalBlock.BlockType.NOT;
    }

    public void method_25419() {
        this.field_22787.method_1507(this.parent);
    }

    public boolean method_25421() {
        return false;
    }

    public static ScratchBlockEditorScreenV2 fromConditionGroup(class_437 parent, ConditionGroup group, Consumer<ConditionGroup> onSave) {
        ConditionalBlock block = ConditionalBlock.fromConditionGroup(group);
        return new ScratchBlockEditorScreenV2(parent, block, resultBlock -> onSave.accept(resultBlock.toConditionGroup()));
    }

    private static enum DropType {
        NONE,
        NEST_INSIDE,
        INSERT_BEFORE,
        INSERT_AFTER;

    }
}

