/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.beautiful_statistics_screen.client.gui.widgets;

import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import org.texboobcat.beautiful_statistics_screen.client.gui.chart.ChartDataset;

public class DatasetSelectorWidget
extends class_339 {
    private static final int ROW_HEIGHT = 50;
    private static final int PADDING = 6;
    private final class_310 minecraft;
    private final List<ChartDataset> datasets;
    private final Runnable onChange;
    private int scrollOffset = 0;
    private ChartDataset hoveredDataset = null;

    public DatasetSelectorWidget(class_310 minecraft, int x, int y, int width, int height, List<ChartDataset> datasets, Runnable onChange) {
        super(x, y, width, height, (class_2561)class_2561.method_43470((String)"Datasets"));
        this.minecraft = minecraft;
        this.datasets = datasets;
        this.onChange = onChange;
    }

    protected void method_47399(class_6382 output) {
        output.method_37034(class_6381.field_33788, (class_2561)class_2561.method_43470((String)"Dataset Selector"));
    }

    public void method_48579(class_332 graphics, int mouseX, int mouseY, float partialTick) {
        graphics.method_25294(this.method_46426(), this.method_46427(), this.method_46426() + this.field_22758, this.method_46427() + this.field_22759, -1879048192);
        graphics.method_25303(this.minecraft.field_1772, "Datasets", this.method_46426() + 6, this.method_46427() + 6, 0xFFFFFF);
        if (this.datasets.isEmpty()) {
            String msg = "No datasets";
            graphics.method_25303(this.minecraft.field_1772, msg, this.method_46426() + (this.field_22758 - this.minecraft.field_1772.method_1727(msg)) / 2, this.method_46427() + this.field_22759 / 2, 0x888888);
            return;
        }
        int rowY = this.method_46427() + 25 - this.scrollOffset;
        int listX = this.method_46426() + 6;
        int listW = this.field_22758 - 12;
        this.hoveredDataset = null;
        for (ChartDataset dataset : this.datasets) {
            boolean hovered;
            if (rowY + 50 < this.method_46427() + 25 || rowY > this.method_46427() + this.field_22759) {
                rowY += 50;
                continue;
            }
            boolean bl = hovered = mouseX >= listX && mouseX < listX + listW && mouseY >= rowY && mouseY < rowY + 50;
            if (hovered) {
                this.hoveredDataset = dataset;
                graphics.method_25294(listX, rowY, listX + listW, rowY + 50, 0x40FFFFFF);
            }
            graphics.method_25294(listX, rowY, listX + listW, rowY + 50, dataset.isVisible() ? 0x30000000 : 0x20000000);
            graphics.method_25294(listX + 2, rowY + 2, listX + 10, rowY + 50 - 2, dataset.getColor());
            Object name = dataset.getDisplayName().getString();
            if (((String)name).length() > 18) {
                name = ((String)name).substring(0, 15) + "...";
            }
            int nameColor = dataset.isVisible() ? 0xFFFFFF : 0x888888;
            graphics.method_25303(this.minecraft.field_1772, (String)name, listX + 14, rowY + 4, nameColor);
            String count = dataset.getData().size() + " pts";
            graphics.method_25303(this.minecraft.field_1772, count, listX + 14, rowY + 15, 0x888888);
            String style = switch (dataset.getStyle()) {
                default -> throw new IncompatibleClassChangeError();
                case ChartDataset.ChartStyle.LINE -> "Line";
                case ChartDataset.ChartStyle.BAR -> "Bar";
                case ChartDataset.ChartStyle.AREA -> "Area";
                case ChartDataset.ChartStyle.SCATTER -> "Scatter";
                case ChartDataset.ChartStyle.STEP -> "Step";
            };
            graphics.method_25303(this.minecraft.field_1772, style, listX + 14, rowY + 26, 0xAAAAAAA);
            String visText = dataset.isVisible() ? "\ud83d\udc41" : "\u2715";
            int visX = listX + listW - 25;
            int visY = rowY + 5;
            boolean hoverVis = mouseX >= visX && mouseX < visX + 20 && mouseY >= visY && mouseY < visY + 15;
            graphics.method_25294(visX, visY, visX + 20, visY + 15, hoverVis ? 0x60FFFFFF : 0x40FFFFFF);
            graphics.method_25303(this.minecraft.field_1772, visText, visX + 5, visY + 3, 0xFFFFFF);
            String trendText = dataset.isShowTrendLine() ? "\ud83d\udcc8" : "\u2014";
            int trendX = listX + listW - 25;
            int trendY = rowY + 25;
            boolean hoverTrend = mouseX >= trendX && mouseX < trendX + 20 && mouseY >= trendY && mouseY < trendY + 15;
            graphics.method_25294(trendX, trendY, trendX + 20, trendY + 15, hoverTrend ? 0x60FFFFFF : 0x40FFFFFF);
            graphics.method_25303(this.minecraft.field_1772, trendText, trendX + 5, trendY + 3, 0xFFFFFF);
            rowY += 50;
        }
        if (this.getMaxScroll() > 0) {
            int scrollBarHeight = Math.max(20, this.field_22759 * this.field_22759 / (this.datasets.size() * 50 + 25));
            int scrollBarY = this.method_46427() + 25 + (int)((float)this.scrollOffset / (float)this.getMaxScroll() * (float)(this.field_22759 - 25 - scrollBarHeight));
            graphics.method_25294(this.method_46426() + this.field_22758 - 4, scrollBarY, this.method_46426() + this.field_22758 - 2, scrollBarY + scrollBarHeight, -16733441);
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (button != 0) {
            return false;
        }
        int listX = this.method_46426() + 6;
        int listW = this.field_22758 - 12;
        int rowY = this.method_46427() + 25 - this.scrollOffset;
        for (ChartDataset dataset : this.datasets) {
            if (mouseY >= (double)rowY && mouseY < (double)(rowY + 50) && mouseX >= (double)listX && mouseX < (double)(listX + listW)) {
                int visX = listX + listW - 25;
                int visY = rowY + 5;
                if (mouseX >= (double)visX && mouseX < (double)(visX + 20) && mouseY >= (double)visY && mouseY < (double)(visY + 15)) {
                    dataset.setVisible(!dataset.isVisible());
                    this.onChange.run();
                    return true;
                }
                int trendX = listX + listW - 25;
                int trendY = rowY + 25;
                if (mouseX >= (double)trendX && mouseX < (double)(trendX + 20) && mouseY >= (double)trendY && mouseY < (double)(trendY + 15)) {
                    dataset.setShowTrendLine(!dataset.isShowTrendLine());
                    this.onChange.run();
                    return true;
                }
                dataset.setStyle(this.nextStyle(dataset.getStyle()));
                this.onChange.run();
                return true;
            }
            rowY += 50;
        }
        return false;
    }

    public boolean method_25401(double mouseX, double mouseY, double delta) {
        int max = this.getMaxScroll();
        this.scrollOffset = Math.max(0, Math.min(max, this.scrollOffset - (int)(delta * 20.0)));
        return true;
    }

    public void refresh() {
    }

    private int getMaxScroll() {
        int totalHeight = this.datasets.size() * 50 + 25;
        return Math.max(0, totalHeight - this.field_22759);
    }

    private ChartDataset.ChartStyle nextStyle(ChartDataset.ChartStyle current) {
        ChartDataset.ChartStyle[] styles = ChartDataset.ChartStyle.values();
        int index = current.ordinal();
        return styles[(index + 1) % styles.length];
    }
}

