/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.beautiful_statistics_screen.client.gui.widgets;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import org.texboobcat.beautiful_statistics_screen.api.StatEntry;
import org.texboobcat.beautiful_statistics_screen.util.StatFormatter;

public class TextStatListWidget
extends class_339 {
    private static final int ROW_HEIGHT = 18;
    private static final int PADDING = 6;
    private final class_310 minecraft;
    private List<StatEntry> stats = new ArrayList<StatEntry>();
    private int scrollOffset = 0;
    private StatEntry selected = null;
    private final Consumer<StatEntry> onClick;
    private final Consumer<StatEntry> onRightClick;

    public TextStatListWidget(class_310 minecraft, int x, int y, int width, int height, Consumer<StatEntry> onClick, Consumer<StatEntry> onRightClick) {
        super(x, y, width, height, (class_2561)class_2561.method_43473());
        this.minecraft = minecraft;
        this.onClick = onClick;
        this.onRightClick = onRightClick;
    }

    public void setStats(List<StatEntry> stats) {
        this.stats = new ArrayList<StatEntry>(stats);
        if (this.scrollOffset > this.getMaxScroll()) {
            this.scrollOffset = Math.max(0, this.getMaxScroll());
        }
        if (this.selected != null && !this.stats.contains(this.selected)) {
            this.selected = null;
        }
    }

    public StatEntry getSelected() {
        return this.selected;
    }

    protected void method_47399(class_6382 output) {
        output.method_37034(class_6381.field_33788, (class_2561)class_2561.method_43470((String)"Statistics List"));
    }

    public void method_48579(class_332 graphics, int mouseX, int mouseY, float partialTick) {
        graphics.method_25294(this.method_46426(), this.method_46427(), this.method_46426() + this.field_22758, this.method_46427() + this.field_22759, -1879048192);
        int rowY = this.method_46427() + 6 - this.scrollOffset;
        int listX = this.method_46426() + 6;
        int listW = this.field_22758 - 12;
        for (int i = 0; i < this.stats.size(); ++i) {
            StatEntry entry = this.stats.get(i);
            if (rowY + 18 < this.method_46427() || rowY > this.method_46427() + this.field_22759) {
                rowY += 18;
                continue;
            }
            boolean hovered = mouseX >= listX && mouseX < listX + listW && mouseY >= rowY && mouseY < rowY + 18;
            boolean isSelected = entry == this.selected;
            int bgColor = 0;
            if (isSelected) {
                bgColor = -2147439873;
            } else if (hovered) {
                bgColor = 0x60303030;
            }
            if (bgColor != 0) {
                graphics.method_25294(listX, rowY, listX + listW, rowY + 18, bgColor);
            }
            if (i > 0) {
                graphics.method_25294(listX, rowY, listX + listW, rowY + 1, 0x20FFFFFF);
            }
            String name = entry.getDisplayName().getString();
            String value = StatFormatter.formatStatValue(entry.getStatId(), entry.getValue());
            Objects.requireNonNull(this.minecraft.field_1772);
            int textY = rowY + (18 - 9) / 2;
            int nameColor = isSelected ? 0xFFFFFF : (hovered ? 0xFFFFAA : 0xDDDDDD);
            graphics.method_25303(this.minecraft.field_1772, name, listX + 4, textY, nameColor);
            int valueWidth = this.minecraft.field_1772.method_1727(value);
            int valueColor = entry.getValue() > 0L ? 65416 : 0x888888;
            graphics.method_25303(this.minecraft.field_1772, value, listX + listW - valueWidth - 4, textY, valueColor);
            if (hovered && !isSelected) {
                String hint = "Right-click for chart";
                int hintWidth = this.minecraft.field_1772.method_1727(hint);
                graphics.method_25303(this.minecraft.field_1772, hint, listX + (listW - hintWidth) / 2, textY, -2130706433);
            }
            rowY += 18;
        }
        if (this.getMaxScroll() > 0) {
            int scrollBarHeight = Math.max(20, this.field_22759 * this.field_22759 / (this.stats.size() * 18 + 12));
            int scrollBarY = this.method_46427() + (int)((float)this.scrollOffset / (float)this.getMaxScroll() * (float)(this.field_22759 - scrollBarHeight));
            graphics.method_25294(this.method_46426() + this.field_22758 - 4, scrollBarY, this.method_46426() + this.field_22758 - 2, scrollBarY + scrollBarHeight, -16733441);
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        int listX = this.method_46426() + 6;
        int listW = this.field_22758 - 12;
        int rowY = this.method_46427() + 6 - this.scrollOffset;
        for (int i = 0; i < this.stats.size(); ++i) {
            if (mouseY >= (double)rowY && mouseY < (double)(rowY + 18) && mouseX >= (double)listX && mouseX < (double)(listX + listW)) {
                this.selected = this.stats.get(i);
                if (button == 0) {
                    this.onClick.accept(this.selected);
                } else if (button == 1) {
                    this.onRightClick.accept(this.selected);
                }
                return true;
            }
            rowY += 18;
        }
        return false;
    }

    public boolean method_25401(double mouseX, double mouseY, double delta) {
        int max = this.getMaxScroll();
        this.scrollOffset = Math.max(0, Math.min(max, this.scrollOffset - (int)(delta * 20.0)));
        return true;
    }

    private int getMaxScroll() {
        int totalHeight = this.stats.size() * 18 + 12;
        return Math.max(0, totalHeight - this.field_22759);
    }
}

