/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.beautiful_statistics_screen.client.hud;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import org.texboobcat.beautiful_statistics_screen.api.StatEntry;
import org.texboobcat.beautiful_statistics_screen.config.ModConfig;
import org.texboobcat.beautiful_statistics_screen.core.StatDataManager;
import org.texboobcat.beautiful_statistics_screen.util.StatFormatter;

public class StatHudRenderer {
    private static final int ENTRY_HEIGHT = 20;
    private static final int ENTRY_SPACING = 2;
    private static final int PADDING = 5;
    private static final int ICON_SIZE = 16;
    private static boolean visible = true;
    private static final long LAYOUT_CACHE_WINDOW_MS = 250L;
    private static long lastLayoutBuildMs = 0L;
    private static long lastValuesSignature = 0L;
    private static double lastScale = -1.0;
    private static int cachedMaxTextWidth = 0;
    private static int cachedEntryCount = 0;
    private static final List<String> cachedTexts = new ArrayList<String>();

    public static void render(class_332 graphics, float partialTick) {
        ModConfig.Client config = ModConfig.getClient();
        if (!config.enableHUD || !visible) {
            return;
        }
        class_310 mc = class_310.method_1551();
        if (mc.field_1724 == null || mc.field_1690.field_1866) {
            return;
        }
        List<class_2960> pinnedStats = ModConfig.getPinnedStats();
        if (pinnedStats.isEmpty()) {
            return;
        }
        ArrayList<StatEntry> entries = new ArrayList<StatEntry>();
        for (class_2960 statId : pinnedStats) {
            StatEntry entry = StatDataManager.getStatEntry(statId);
            if (entry == null) continue;
            entries.add(entry);
        }
        if (entries.isEmpty()) {
            return;
        }
        StatHudRenderer.renderStatEntries(graphics, mc, entries, config);
    }

    private static void renderStatEntries(class_332 graphics, class_310 mc, List<StatEntry> entries, ModConfig.Client config) {
        int windowWidth = mc.method_22683().method_4486();
        int windowHeight = mc.method_22683().method_4502();
        StatHudRenderer.ensureLayoutComputed(mc, entries, config);
        int maxWidth = cachedMaxTextWidth;
        int hudWidth = maxWidth + 10;
        if (config.hudShowIcons) {
            hudWidth += 21;
        }
        int hudHeight = entries.size() * 22 - 2 + 10;
        double scale = config.hudScale;
        hudWidth = (int)((double)hudWidth * scale);
        hudHeight = (int)((double)hudHeight * scale);
        int x = StatHudRenderer.calculateX(windowWidth, hudWidth, config);
        int y = StatHudRenderer.calculateY(windowHeight, hudHeight, config);
        graphics.method_51448().method_22903();
        graphics.method_51448().method_46416((float)x, (float)y, 0.0f);
        graphics.method_51448().method_22905((float)scale, (float)scale, 1.0f);
        graphics.method_25294(0, 0, (int)((double)hudWidth / scale), (int)((double)hudHeight / scale), -1073741824);
        if (config.enableBorders) {
            StatHudRenderer.drawBorder(graphics, 0, 0, (int)((double)hudWidth / scale), (int)((double)hudHeight / scale), config);
        }
        int entryY = 5;
        for (int i = 0; i < entries.size(); ++i) {
            StatEntry entry = entries.get(i);
            String text = i < cachedTexts.size() ? cachedTexts.get(i) : StatHudRenderer.buildEntryText(entry);
            StatHudRenderer.renderEntry(graphics, mc, entry, 5, entryY, config, text);
            entryY += 22;
        }
        graphics.method_51448().method_22909();
    }

    private static void renderEntry(class_332 graphics, class_310 mc, StatEntry entry, int x, int y, ModConfig.Client config, String precomputedText) {
        int currentX = x;
        if (config.hudShowIcons && entry.getIconRenderer() != null) {
            entry.getIconRenderer().render(graphics, currentX, y, 16);
            currentX += 21;
        }
        class_327 class_3272 = mc.field_1772;
        Objects.requireNonNull(mc.field_1772);
        graphics.method_25303(class_3272, precomputedText, currentX, y + (20 - 9) / 2, 0xFFFFFF);
    }

    private static String buildEntryText(StatEntry entry) {
        String valueStr = StatFormatter.formatStatValue(entry.getStatId(), entry.getValue());
        return entry.getDisplayName().getString() + ": " + valueStr;
    }

    private static long computeSignature(List<StatEntry> entries) {
        long sig = 1469598103934665603L;
        for (StatEntry e : entries) {
            sig ^= (long)e.getStatId().toString().hashCode();
            sig *= 1099511628211L;
            sig ^= (long)Long.hashCode(e.getValue());
            sig *= 1099511628211L;
        }
        return sig;
    }

    private static void ensureLayoutComputed(class_310 mc, List<StatEntry> entries, ModConfig.Client config) {
        boolean expired;
        long now = System.currentTimeMillis();
        long sig = StatHudRenderer.computeSignature(entries);
        boolean listChanged = entries.size() != cachedEntryCount;
        boolean scaleChanged = config.hudScale != lastScale;
        boolean bl = expired = now - lastLayoutBuildMs > 250L;
        if (cachedTexts.isEmpty() || listChanged || scaleChanged || expired && sig != lastValuesSignature) {
            cachedTexts.clear();
            int maxWidth = 0;
            for (StatEntry entry : entries) {
                String text = StatHudRenderer.buildEntryText(entry);
                cachedTexts.add(text);
                int w = mc.field_1772.method_1727(text);
                if (w <= maxWidth) continue;
                maxWidth = w;
            }
            cachedMaxTextWidth = maxWidth;
            cachedEntryCount = entries.size();
            lastValuesSignature = sig;
            lastScale = config.hudScale;
            lastLayoutBuildMs = now;
        }
    }

    private static void drawBorder(class_332 graphics, int x, int y, int width, int height, ModConfig.Client config) {
        int color = StatHudRenderer.getBorderColor(config);
        graphics.method_25294(x, y, x + width, y + 1, color);
        graphics.method_25294(x, y + height - 1, x + width, y + height, color);
        graphics.method_25294(x, y, x + 1, y + height, color);
        graphics.method_25294(x + width - 1, y, x + width, y + height, color);
    }

    private static int getBorderColor(ModConfig.Client config) {
        double opacity = Math.max(0.0, Math.min(1.0, config.borderOpacity));
        int alpha = (int)(opacity * 255.0);
        return switch (config.theme) {
            default -> throw new IncompatibleClassChangeError();
            case ModConfig.Theme.VANILLA -> alpha << 24 | 0xC6C6C6;
            case ModConfig.Theme.LIGHT -> alpha << 24 | 0x404040;
            case ModConfig.Theme.DARK -> alpha << 24 | 0x4080FF;
        };
    }

    private static int calculateX(int windowWidth, int hudWidth, ModConfig.Client config) {
        return switch (config.hudPosition) {
            case ModConfig.HUDPosition.TOP_LEFT, ModConfig.HUDPosition.CENTER_LEFT, ModConfig.HUDPosition.BOTTOM_LEFT -> config.hudOffsetX;
            case ModConfig.HUDPosition.TOP_RIGHT, ModConfig.HUDPosition.CENTER_RIGHT, ModConfig.HUDPosition.BOTTOM_RIGHT -> windowWidth - hudWidth - config.hudOffsetX;
            default -> (windowWidth - hudWidth) / 2;
        };
    }

    private static int calculateY(int windowHeight, int hudHeight, ModConfig.Client config) {
        return switch (config.hudPosition) {
            case ModConfig.HUDPosition.TOP_LEFT, ModConfig.HUDPosition.TOP_RIGHT -> config.hudOffsetY;
            case ModConfig.HUDPosition.BOTTOM_LEFT, ModConfig.HUDPosition.BOTTOM_RIGHT -> windowHeight - hudHeight - config.hudOffsetY;
            case ModConfig.HUDPosition.CENTER_LEFT, ModConfig.HUDPosition.CENTER_RIGHT -> (windowHeight - hudHeight) / 2;
            default -> config.hudOffsetY;
        };
    }

    public static void toggleVisibility() {
        visible = !visible;
    }

    public static void setVisible(boolean visible) {
        StatHudRenderer.visible = visible;
    }

    public static boolean isVisible() {
        return visible;
    }

    public static void invalidateLayoutCache() {
        cachedTexts.clear();
        cachedEntryCount = 0;
        cachedMaxTextWidth = 0;
        lastValuesSignature = 0L;
        lastLayoutBuildMs = 0L;
    }
}

