/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.beautiful_statistics_screen.client.render;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1511;
import net.minecraft.class_1538;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_7833;
import net.minecraft.class_898;
import org.texboobcat.beautiful_statistics_screen.api.IconRenderer;
import org.texboobcat.beautiful_statistics_screen.config.ModConfig;

public class EntityIconRenderer
implements IconRenderer {
    private final class_1299<?> entityType;
    private final boolean isKilledBy;
    private static final Map<class_1299<?>, class_1297> ENTITY_CACHE = new ConcurrentHashMap();
    private static class_1937 cachedLevel = null;

    public EntityIconRenderer(class_1299<?> entityType) {
        this(entityType, false);
    }

    public EntityIconRenderer(class_1299<?> entityType, boolean isKilledBy) {
        this.entityType = entityType;
        this.isKilledBy = isKilledBy;
    }

    @Override
    public void render(class_332 graphics, int x, int y, int size) {
        class_310 mc = class_310.method_1551();
        if (mc.field_1687 == null) {
            return;
        }
        boolean use3D = ModConfig.getClient().render3DMobIcons;
        if (!use3D) {
            class_1799 fallbackItem = EntityIconRenderer.getItemFallback(this.entityType);
            this.renderItemIcon(graphics, fallbackItem, x, y, size);
            if (this.isKilledBy) {
                this.renderDeathIndicator(graphics, x, y, size);
            }
            return;
        }
        if (cachedLevel != mc.field_1687) {
            ENTITY_CACHE.clear();
            cachedLevel = mc.field_1687;
        }
        try {
            class_1297 entity = ENTITY_CACHE.computeIfAbsent(this.entityType, type -> {
                try {
                    return type.method_5883((class_1937)mc.field_1687);
                }
                catch (Exception e) {
                    return null;
                }
            });
            if (entity != null) {
                if (entity instanceof class_1538) {
                    this.renderItemIcon(graphics, new class_1799((class_1935)class_1802.field_27051), x, y, size);
                    if (this.isKilledBy) {
                        this.renderDeathIndicator(graphics, x, y, size);
                    }
                    return;
                }
                if (entity instanceof class_1511) {
                    this.renderItemIcon(graphics, new class_1799((class_1935)class_1802.field_8301), x, y, size);
                    if (this.isKilledBy) {
                        this.renderDeathIndicator(graphics, x, y, size);
                    }
                    return;
                }
                String entityTypeName = class_1299.method_5890(this.entityType).method_12832();
                if ("ender_dragon".equals(entityTypeName)) {
                    this.renderItemIcon(graphics, new class_1799((class_1935)class_1802.field_8712), x, y, size);
                    if (this.isKilledBy) {
                        this.renderDeathIndicator(graphics, x, y, size);
                    }
                    return;
                }
                if ("wither".equals(entityTypeName)) {
                    this.renderItemIcon(graphics, new class_1799((class_1935)class_1802.field_8137), x, y, size);
                    if (this.isKilledBy) {
                        this.renderDeathIndicator(graphics, x, y, size);
                    }
                    return;
                }
                this.renderEntity(graphics, entity, x, y, size);
            } else {
                class_1799 fallbackItem = EntityIconRenderer.getItemFallback(this.entityType);
                this.renderItemIcon(graphics, fallbackItem, x, y, size);
            }
        }
        catch (Exception e) {
            class_1799 fallbackItem = EntityIconRenderer.getItemFallback(this.entityType);
            this.renderItemIcon(graphics, fallbackItem, x, y, size);
        }
        if (this.isKilledBy) {
            this.renderDeathIndicator(graphics, x, y, size);
        }
    }

    private void renderDeathIndicator(class_332 graphics, int x, int y, int size) {
        class_1799 skull = new class_1799((class_1935)class_1802.field_8398);
        int skullSize = Math.max(8, size / 4);
        int skullX = x + size - skullSize - 2;
        int skullY = y + 2;
        class_4587 poseStack = graphics.method_51448();
        poseStack.method_22903();
        float scale = (float)skullSize / 16.0f;
        poseStack.method_46416((float)skullX, (float)skullY, 200.0f);
        poseStack.method_22905(scale, scale, scale);
        graphics.method_51427(skull, 0, 0);
        poseStack.method_22909();
    }

    private void renderEntity(class_332 graphics, class_1297 entity, int x, int y, int size) {
        class_4587 poseStack = graphics.method_51448();
        poseStack.method_22903();
        float width = Math.max(0.001f, entity.method_17681());
        float height = Math.max(0.001f, entity.method_17682());
        float targetSize = (float)size * 0.7f;
        float scale = targetSize / Math.max(width, height);
        scale = Math.max(4.0f, Math.min(scale, 80.0f));
        if (height > width * 2.0f) {
            scale *= 0.75f;
        } else if (width > height * 2.0f) {
            scale *= 0.75f;
        }
        poseStack.method_46416((float)x + (float)size / 2.0f, (float)y + (float)size * 0.75f, 100.0f);
        poseStack.method_22905(scale, scale, -scale);
        poseStack.method_22907(class_7833.field_40718.rotationDegrees(180.0f));
        poseStack.method_22907(class_7833.field_40714.rotationDegrees(10.0f));
        float prevYRot = entity.method_36454();
        float prevXRot = entity.method_36455();
        float prevBodyRot = 0.0f;
        float prevHeadRot = 0.0f;
        if (entity instanceof class_1309) {
            class_1309 living = (class_1309)entity;
            prevBodyRot = living.field_6283;
            prevHeadRot = living.field_6241;
            living.field_6283 = 180.0f;
            living.field_6241 = 180.0f;
        }
        entity.method_36456(180.0f);
        entity.method_36457(0.0f);
        class_898 dispatcher = class_310.method_1551().method_1561();
        class_4597.class_4598 buffer = class_310.method_1551().method_22940().method_23000();
        RenderSystem.runAsFancy(() -> {
            dispatcher.method_3954(entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, poseStack, (class_4597)buffer, 0xF000F0);
            buffer.method_22993();
        });
        entity.method_36456(prevYRot);
        entity.method_36457(prevXRot);
        if (entity instanceof class_1309) {
            class_1309 living = (class_1309)entity;
            living.field_6283 = prevBodyRot;
            living.field_6241 = prevHeadRot;
        }
        poseStack.method_22909();
    }

    private void renderSimpleIcon(class_332 graphics, int x, int y, int size) {
        graphics.method_25294(x + 2, y + 2, x + size - 2, y + size - 2, -2139062144);
        String initial = this.entityType.method_5897().getString().substring(0, 1).toUpperCase();
        int textX = x + size / 2 - 3;
        int textY = y + size / 2 - 4;
        graphics.method_25303(class_310.method_1551().field_1772, initial, textX, textY, 0xFFFFFF);
    }

    private void renderItemIcon(class_332 graphics, class_1799 stack, int x, int y, int size) {
        int ix = x + Math.max(0, (size - 16) / 2);
        int iy = y + Math.max(0, (size - 16) / 2);
        graphics.method_51427(stack, ix, iy);
    }

    private static class_1799 getItemFallback(class_1299<?> entityType) {
        String entityName;
        return switch (entityName = class_1299.method_5890(entityType).method_12832()) {
            case "ender_dragon" -> new class_1799((class_1935)class_1802.field_8712);
            case "wither" -> new class_1799((class_1935)class_1802.field_8137);
            case "elder_guardian" -> new class_1799((class_1935)class_1802.field_8662);
            case "warden" -> new class_1799((class_1935)class_1802.field_37538);
            case "zombie" -> new class_1799((class_1935)class_1802.field_8441);
            case "skeleton" -> new class_1799((class_1935)class_1802.field_8300);
            case "creeper" -> new class_1799((class_1935)class_1802.field_8503);
            case "spider" -> new class_1799((class_1935)class_1802.field_8185);
            case "enderman" -> new class_1799((class_1935)class_1802.field_8374);
            case "zombie_villager" -> new class_1799((class_1935)class_1802.field_8136);
            case "husk" -> new class_1799((class_1935)class_1802.field_8760);
            case "stray" -> new class_1799((class_1935)class_1802.field_8514);
            case "phantom" -> new class_1799((class_1935)class_1802.field_8670);
            case "drowned" -> new class_1799((class_1935)class_1802.field_8083);
            case "blaze" -> new class_1799((class_1935)class_1802.field_8154);
            case "ghast" -> new class_1799((class_1935)class_1802.field_8265);
            case "magma_cube" -> new class_1799((class_1935)class_1802.field_8852);
            case "zombified_piglin" -> new class_1799((class_1935)class_1802.field_8093);
            case "piglin" -> new class_1799((class_1935)class_1802.field_22401);
            case "piglin_brute" -> new class_1799((class_1935)class_1802.field_25777);
            case "hoglin" -> new class_1799((class_1935)class_1802.field_22014);
            case "zoglin" -> new class_1799((class_1935)class_1802.field_23744);
            case "strider" -> new class_1799((class_1935)class_1802.field_23255);
            case "cow" -> new class_1799((class_1935)class_1802.field_8433);
            case "pig" -> new class_1799((class_1935)class_1802.field_8493);
            case "sheep" -> new class_1799((class_1935)class_1802.field_8607);
            case "chicken" -> new class_1799((class_1935)class_1802.field_8835);
            case "horse" -> new class_1799((class_1935)class_1802.field_8117);
            case "donkey" -> new class_1799((class_1935)class_1802.field_8306);
            case "mule" -> new class_1799((class_1935)class_1802.field_8331);
            case "llama" -> new class_1799((class_1935)class_1802.field_8633);
            case "cat" -> new class_1799((class_1935)class_1802.field_16314);
            case "wolf" -> new class_1799((class_1935)class_1802.field_8485);
            case "parrot" -> new class_1799((class_1935)class_1802.field_8274);
            case "rabbit" -> new class_1799((class_1935)class_1802.field_8227);
            case "fox" -> new class_1799((class_1935)class_1802.field_18005);
            case "panda" -> new class_1799((class_1935)class_1802.field_8193);
            case "polar_bear" -> new class_1799((class_1935)class_1802.field_8346);
            case "turtle" -> new class_1799((class_1935)class_1802.field_8435);
            case "bee" -> new class_1799((class_1935)class_1802.field_20413);
            case "axolotl" -> new class_1799((class_1935)class_1802.field_28355);
            case "goat" -> new class_1799((class_1935)class_1802.field_30905);
            case "frog" -> new class_1799((class_1935)class_1802.field_37535);
            case "allay" -> new class_1799((class_1935)class_1802.field_38419);
            case "cod" -> new class_1799((class_1935)class_1802.field_8661);
            case "salmon" -> new class_1799((class_1935)class_1802.field_8447);
            case "tropical_fish" -> new class_1799((class_1935)class_1802.field_8612);
            case "pufferfish" -> new class_1799((class_1935)class_1802.field_8100);
            case "dolphin" -> new class_1799((class_1935)class_1802.field_8751);
            case "squid" -> new class_1799((class_1935)class_1802.field_8307);
            case "glow_squid" -> new class_1799((class_1935)class_1802.field_28407);
            case "guardian" -> new class_1799((class_1935)class_1802.field_8409);
            case "villager" -> new class_1799((class_1935)class_1802.field_8086);
            case "wandering_trader" -> new class_1799((class_1935)class_1802.field_17732);
            case "pillager" -> new class_1799((class_1935)class_1802.field_8325);
            case "vindicator" -> new class_1799((class_1935)class_1802.field_8149);
            case "evoker" -> new class_1799((class_1935)class_1802.field_8795);
            case "ravager" -> new class_1799((class_1935)class_1802.field_8297);
            case "vex" -> new class_1799((class_1935)class_1802.field_8235);
            case "witch" -> new class_1799((class_1935)class_1802.field_8254);
            case "slime" -> new class_1799((class_1935)class_1802.field_8881);
            case "cave_spider" -> new class_1799((class_1935)class_1802.field_8068);
            case "silverfish" -> new class_1799((class_1935)class_1802.field_8564);
            case "endermite" -> new class_1799((class_1935)class_1802.field_8510);
            case "shulker" -> new class_1799((class_1935)class_1802.field_8480);
            case "iron_golem" -> new class_1799((class_1935)class_1802.field_8773);
            case "snow_golem" -> new class_1799((class_1935)class_1802.field_17519);
            case "lightning_bolt" -> new class_1799((class_1935)class_1802.field_27051);
            case "end_crystal" -> new class_1799((class_1935)class_1802.field_8301);
            case "armor_stand" -> new class_1799((class_1935)class_1802.field_8694);
            case "item_frame" -> new class_1799((class_1935)class_1802.field_8143);
            case "glow_item_frame" -> new class_1799((class_1935)class_1802.field_28408);
            case "painting" -> new class_1799((class_1935)class_1802.field_8892);
            case "player" -> new class_1799((class_1935)class_1802.field_8575);
            default -> new class_1799((class_1935)class_1802.field_8077);
        };
    }
}

