/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.beautiful_statistics_screen.client.theme;

import org.texboobcat.beautiful_statistics_screen.config.ModConfig;

public class ThemeManager {
    private static Theme currentTheme;

    public static void initialize() {
        ThemeManager.setTheme(ModConfig.getClient().theme);
    }

    public static void setTheme(ModConfig.Theme themeType) {
        currentTheme = switch (themeType) {
            default -> throw new IncompatibleClassChangeError();
            case ModConfig.Theme.DARK -> new DarkTheme();
            case ModConfig.Theme.LIGHT -> new LightTheme();
            case ModConfig.Theme.VANILLA -> new VanillaTheme();
        };
    }

    public static Theme getCurrentTheme() {
        if (currentTheme == null) {
            ThemeManager.initialize();
        }
        return currentTheme;
    }

    public static class DarkTheme
    implements Theme {
        @Override
        public int getBackgroundColor() {
            return -1073741824;
        }

        @Override
        public int getBackgroundAltColor() {
            return -2143272896;
        }

        @Override
        public int getBorderColor() {
            return -16711681;
        }

        @Override
        public int getTextColor() {
            return 0xFFFFFF;
        }

        @Override
        public int getTextSecondaryColor() {
            return 0xCCCCCC;
        }

        @Override
        public int getTextTertiaryColor() {
            return 0x888888;
        }

        @Override
        public int getHighlightColor() {
            return -256;
        }

        @Override
        public int getSelectionColor() {
            return -2141167520;
        }

        @Override
        public int getHoverColor() {
            return 0x60404040;
        }

        @Override
        public int getAccentColor() {
            return -16711681;
        }
    }

    public static class LightTheme
    implements Theme {
        @Override
        public int getBackgroundColor() {
            return -1056964609;
        }

        @Override
        public int getBackgroundAltColor() {
            return -2134061876;
        }

        @Override
        public int getBorderColor() {
            return -16737844;
        }

        @Override
        public int getTextColor() {
            return 0;
        }

        @Override
        public int getTextSecondaryColor() {
            return 0x333333;
        }

        @Override
        public int getTextTertiaryColor() {
            return 0x666666;
        }

        @Override
        public int getHighlightColor() {
            return -16737844;
        }

        @Override
        public int getSelectionColor() {
            return -2136298838;
        }

        @Override
        public int getHoverColor() {
            return 0x60CCCCCC;
        }

        @Override
        public int getAccentColor() {
            return -16737844;
        }
    }

    public static class VanillaTheme
    implements Theme {
        @Override
        public int getBackgroundColor() {
            return -1072689136;
        }

        @Override
        public int getBackgroundAltColor() {
            return -2144325584;
        }

        @Override
        public int getBorderColor() {
            return -6250336;
        }

        @Override
        public int getTextColor() {
            return 0xFFFFFF;
        }

        @Override
        public int getTextSecondaryColor() {
            return 0xA0A0A0;
        }

        @Override
        public int getTextTertiaryColor() {
            return 0x808080;
        }

        @Override
        public int getHighlightColor() {
            return -256;
        }

        @Override
        public int getSelectionColor() {
            return -2142220208;
        }

        @Override
        public int getHoverColor() {
            return 0x60404040;
        }

        @Override
        public int getAccentColor() {
            return -6250336;
        }
    }

    public static interface Theme {
        public int getBackgroundColor();

        public int getBackgroundAltColor();

        public int getBorderColor();

        public int getTextColor();

        public int getTextSecondaryColor();

        public int getTextTertiaryColor();

        public int getHighlightColor();

        public int getSelectionColor();

        public int getHoverColor();

        public int getAccentColor();
    }
}

