/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.beautiful_statistics_screen.custom;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_7923;
import org.texboobcat.beautiful_statistics_screen.custom.CustomStatDefinition;
import org.texboobcat.beautiful_statistics_screen.custom.StatGoal;
import org.texboobcat.beautiful_statistics_screen.custom.StatNotificationManager;
import org.texboobcat.beautiful_statistics_screen.custom.StatTemplate;
import org.texboobcat.beautiful_statistics_screen.custom.conditions.BlockEvaluator;
import org.texboobcat.beautiful_statistics_screen.custom.conditions.ConditionGroup;
import org.texboobcat.beautiful_statistics_screen.custom.conditions.StatConditionEvaluator;

public class CustomStatManager {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Map<String, CustomStatDefinition> CUSTOM_STATS = new ConcurrentHashMap<String, CustomStatDefinition>();
    private static final Map<String, StatTemplate> STAT_TEMPLATES = new ConcurrentHashMap<String, StatTemplate>();
    private static Path customStatsFile;
    private static Path templatesFile;
    private static boolean initialized;

    public static void initialize(Path configDirectory) {
        try {
            Files.createDirectories(configDirectory, new FileAttribute[0]);
            customStatsFile = configDirectory.resolve("custom_stats.json");
            templatesFile = configDirectory.resolve("stat_templates.json");
            CustomStatManager.loadCustomStats();
            CustomStatManager.loadTemplates();
            CustomStatManager.loadBuiltinTemplates();
            initialized = true;
        }
        catch (IOException e) {
            System.err.println("Failed to initialize custom stats: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public static void loadCustomStats() {
        if (customStatsFile == null || !Files.exists(customStatsFile, new LinkOption[0])) {
            return;
        }
        try (BufferedReader reader = Files.newBufferedReader(customStatsFile);){
            Type type = new TypeToken<List<CustomStatDefinition>>(){}.getType();
            List stats = (List)GSON.fromJson((Reader)reader, type);
            if (stats != null) {
                CUSTOM_STATS.clear();
                for (CustomStatDefinition stat : stats) {
                    CUSTOM_STATS.put(stat.getId(), stat);
                }
                System.out.println("Loaded " + stats.size() + " custom stats");
            }
        }
        catch (IOException e) {
            System.err.println("Failed to load custom stats: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public static void saveCustomStats() {
        if (customStatsFile == null) {
            return;
        }
        try (BufferedWriter writer = Files.newBufferedWriter(customStatsFile, new OpenOption[0]);){
            ArrayList<CustomStatDefinition> stats = new ArrayList<CustomStatDefinition>(CUSTOM_STATS.values());
            GSON.toJson(stats, (Appendable)writer);
        }
        catch (IOException e) {
            System.err.println("Failed to save custom stats: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public static CustomStatDefinition createCustomStat(String name, String description) {
        CustomStatDefinition stat = new CustomStatDefinition();
        stat.setName(name);
        stat.setDescription(description);
        CUSTOM_STATS.put(stat.getId(), stat);
        CustomStatManager.saveCustomStats();
        return stat;
    }

    public static CustomStatDefinition getCustomStat(String id) {
        return CUSTOM_STATS.get(id);
    }

    public static Collection<CustomStatDefinition> getAllCustomStats() {
        return new ArrayList<CustomStatDefinition>(CUSTOM_STATS.values());
    }

    public static List<CustomStatDefinition> getEnabledCustomStats() {
        ArrayList<CustomStatDefinition> enabled = new ArrayList<CustomStatDefinition>();
        for (CustomStatDefinition stat : CUSTOM_STATS.values()) {
            if (!stat.isEnabled()) continue;
            enabled.add(stat);
        }
        return enabled;
    }

    public static void updateCustomStat(CustomStatDefinition stat) {
        CUSTOM_STATS.put(stat.getId(), stat);
        CustomStatManager.saveCustomStats();
    }

    public static void deleteCustomStat(String id) {
        CUSTOM_STATS.remove(id);
        CustomStatManager.saveCustomStats();
    }

    public static List<CustomStatDefinition> getMatchingStats(CustomStatDefinition.TrackingType trackingType, String targetId) {
        ArrayList<CustomStatDefinition> matching = new ArrayList<CustomStatDefinition>();
        for (CustomStatDefinition stat : CustomStatManager.getEnabledCustomStats()) {
            if (stat.getTrackingType() != trackingType || !stat.getTargets().isEmpty() && !stat.getTargets().contains(targetId) && !stat.getTargets().contains("*")) continue;
            matching.add(stat);
        }
        return matching;
    }

    public static void incrementStat(String id, long amount) {
        CustomStatDefinition stat = CUSTOM_STATS.get(id);
        if (stat != null && stat.isEnabled()) {
            long oldValue = stat.getCurrentValue();
            stat.increment(amount);
            List<StatGoal> newlyAchieved = stat.checkGoals();
            for (StatGoal goal : newlyAchieved) {
                StatNotificationManager.notifyGoalAchieved(stat, goal);
                StatNotificationManager.sendChatMessage(stat, goal);
            }
            if (stat.getCurrentValue() % 10L == 0L) {
                CustomStatManager.saveCustomStats();
            }
        }
    }

    public static void resetStat(String id) {
        CustomStatDefinition stat = CUSTOM_STATS.get(id);
        if (stat != null) {
            stat.reset();
            CustomStatManager.saveCustomStats();
        }
    }

    public static void resetAllStats() {
        for (CustomStatDefinition stat : CUSTOM_STATS.values()) {
            stat.reset();
        }
        CustomStatManager.saveCustomStats();
    }

    public static boolean checkConditions(CustomStatDefinition stat) {
        class_310 minecraft = class_310.method_1551();
        if (minecraft.field_1724 == null || minecraft.field_1687 == null) {
            return false;
        }
        if (stat.usesAdvancedBlocks() && stat.getConditionalBlock() != null) {
            return BlockEvaluator.evaluate(stat.getConditionalBlock(), (class_1657)minecraft.field_1724);
        }
        ConditionGroup effectiveGroup = stat.getEffectiveConditionGroup();
        if (effectiveGroup == null || effectiveGroup.isEmpty()) {
            return true;
        }
        return StatConditionEvaluator.evaluate(effectiveGroup, minecraft.field_1724);
    }

    private static boolean checkCondition(CustomStatDefinition.Condition condition) {
        class_310 minecraft = class_310.method_1551();
        if (minecraft.field_1724 == null || minecraft.field_1687 == null) {
            return false;
        }
        try {
            switch (condition.getType()) {
                case BIOME: {
                    class_2960 biome = minecraft.field_1687.method_23753(minecraft.field_1724.method_24515()).method_40230().map(key -> key.method_29177()).orElse(null);
                    return biome != null && CustomStatManager.compareValue(biome.toString(), condition.getValue(), condition.getOperator());
                }
                case DIMENSION: {
                    class_2960 dimension = minecraft.field_1687.method_27983().method_29177();
                    return CustomStatManager.compareValue(dimension.toString(), condition.getValue(), condition.getOperator());
                }
                case Y_LEVEL: {
                    int y = minecraft.field_1724.method_24515().method_10264();
                    return CustomStatManager.compareNumeric(y, condition.getValue(), condition.getOperator());
                }
                case LIGHT_LEVEL: {
                    int light = minecraft.field_1687.method_22336().method_22363(minecraft.field_1724.method_24515(), 0);
                    return CustomStatManager.compareNumeric(light, condition.getValue(), condition.getOperator());
                }
                case WEATHER: {
                    String weather = minecraft.field_1687.method_8419() ? "rain" : (minecraft.field_1687.method_8546() ? "thunder" : "clear");
                    return CustomStatManager.compareValue(weather, condition.getValue(), condition.getOperator());
                }
                case TIME_OF_DAY: {
                    long time = minecraft.field_1687.method_8532() % 24000L;
                    String timeOfDay = time >= 0L && time < 12000L ? "day" : "night";
                    return CustomStatManager.compareValue(timeOfDay, condition.getValue(), condition.getOperator());
                }
                case GAME_MODE: {
                    String gameMode = minecraft.field_1724.method_31549().field_7477 ? "creative" : "survival";
                    return CustomStatManager.compareValue(gameMode, condition.getValue(), condition.getOperator());
                }
                case EFFECT: {
                    class_2960 effectId = new class_2960(condition.getValue());
                    return minecraft.field_1724.method_6026().stream().anyMatch(effect -> class_7923.field_41174.method_10221((Object)effect.method_5579()).equals((Object)effectId));
                }
            }
            return true;
        }
        catch (Exception e) {
            System.err.println("Error checking condition: " + e.getMessage());
            return false;
        }
    }

    private static boolean compareValue(String actual, String expected, CustomStatDefinition.Condition.Operator operator) {
        switch (operator) {
            case EQUALS: {
                return actual.equals(expected);
            }
            case NOT_EQUALS: {
                return !actual.equals(expected);
            }
            case CONTAINS: {
                return actual.contains(expected);
            }
        }
        return false;
    }

    private static boolean compareNumeric(double actual, String expectedStr, CustomStatDefinition.Condition.Operator operator) {
        try {
            double expected = Double.parseDouble(expectedStr);
            switch (operator) {
                case EQUALS: {
                    return actual == expected;
                }
                case NOT_EQUALS: {
                    return actual != expected;
                }
                case GREATER_THAN: {
                    return actual > expected;
                }
                case LESS_THAN: {
                    return actual < expected;
                }
                case GREATER_OR_EQUAL: {
                    return actual >= expected;
                }
                case LESS_OR_EQUAL: {
                    return actual <= expected;
                }
            }
            return false;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static List<CustomStatDefinition> getStatsByCategory(String category) {
        ArrayList<CustomStatDefinition> stats = new ArrayList<CustomStatDefinition>();
        for (CustomStatDefinition stat : CUSTOM_STATS.values()) {
            if (!category.equals(stat.getCategory())) continue;
            stats.add(stat);
        }
        return stats;
    }

    public static Set<String> getAllCategories() {
        HashSet<String> categories = new HashSet<String>();
        for (CustomStatDefinition stat : CUSTOM_STATS.values()) {
            categories.add(stat.getCategory());
        }
        return categories;
    }

    public static void exportStats(Path exportPath) throws IOException {
        try (BufferedWriter writer = Files.newBufferedWriter(exportPath, new OpenOption[0]);){
            ArrayList<CustomStatDefinition> stats = new ArrayList<CustomStatDefinition>(CUSTOM_STATS.values());
            GSON.toJson(stats, (Appendable)writer);
        }
    }

    public static int importStats(Path importPath, boolean overwrite) throws IOException {
        try (BufferedReader reader = Files.newBufferedReader(importPath);){
            Type type = new TypeToken<List<CustomStatDefinition>>(){}.getType();
            List stats = (List)GSON.fromJson((Reader)reader, type);
            if (stats == null) {
                int n = 0;
                return n;
            }
            int imported = 0;
            for (CustomStatDefinition stat : stats) {
                if (!overwrite && CUSTOM_STATS.containsKey(stat.getId())) continue;
                CUSTOM_STATS.put(stat.getId(), stat);
                ++imported;
            }
            if (imported > 0) {
                CustomStatManager.saveCustomStats();
            }
            int n = imported;
            return n;
        }
    }

    public static boolean isInitialized() {
        return initialized;
    }

    private static void loadTemplates() {
        if (templatesFile == null || !Files.exists(templatesFile, new LinkOption[0])) {
            return;
        }
        try (BufferedReader reader = Files.newBufferedReader(templatesFile);){
            Type type = new TypeToken<List<StatTemplate>>(){}.getType();
            List templates = (List)GSON.fromJson((Reader)reader, type);
            if (templates != null) {
                for (StatTemplate template : templates) {
                    STAT_TEMPLATES.put(template.getId(), template);
                }
                System.out.println("Loaded " + templates.size() + " stat templates");
            }
        }
        catch (IOException e) {
            System.err.println("Failed to load stat templates: " + e.getMessage());
        }
    }

    public static void saveTemplates() {
        if (templatesFile == null) {
            return;
        }
        try (BufferedWriter writer = Files.newBufferedWriter(templatesFile, new OpenOption[0]);){
            ArrayList<StatTemplate> templates = new ArrayList<StatTemplate>(STAT_TEMPLATES.values());
            templates.removeIf(StatTemplate::isBuiltin);
            GSON.toJson(templates, (Appendable)writer);
        }
        catch (IOException e) {
            System.err.println("Failed to save stat templates: " + e.getMessage());
        }
    }

    private static void loadBuiltinTemplates() {
        for (StatTemplate template : StatTemplate.BuiltinTemplates.getAllBuiltin()) {
            STAT_TEMPLATES.put(template.getId(), template);
        }
    }

    public static Collection<StatTemplate> getAllTemplates() {
        return new ArrayList<StatTemplate>(STAT_TEMPLATES.values());
    }

    public static StatTemplate getTemplate(String id) {
        return STAT_TEMPLATES.get(id);
    }

    public static CustomStatDefinition createFromTemplate(String templateId) {
        StatTemplate template = STAT_TEMPLATES.get(templateId);
        if (template == null) {
            return null;
        }
        CustomStatDefinition stat = template.createStat();
        CUSTOM_STATS.put(stat.getId(), stat);
        CustomStatManager.saveCustomStats();
        return stat;
    }

    public static void saveTemplate(StatTemplate template) {
        STAT_TEMPLATES.put(template.getId(), template);
        CustomStatManager.saveTemplates();
    }

    public static void deleteTemplate(String id) {
        StatTemplate template = STAT_TEMPLATES.get(id);
        if (template != null && !template.isBuiltin()) {
            STAT_TEMPLATES.remove(id);
            CustomStatManager.saveTemplates();
        }
    }

    public static void enableStats(List<String> statIds) {
        for (String id : statIds) {
            CustomStatDefinition stat = CUSTOM_STATS.get(id);
            if (stat == null) continue;
            stat.setEnabled(true);
        }
        CustomStatManager.saveCustomStats();
    }

    public static void disableStats(List<String> statIds) {
        for (String id : statIds) {
            CustomStatDefinition stat = CUSTOM_STATS.get(id);
            if (stat == null) continue;
            stat.setEnabled(false);
        }
        CustomStatManager.saveCustomStats();
    }

    public static void deleteStats(List<String> statIds) {
        for (String id : statIds) {
            CUSTOM_STATS.remove(id);
        }
        CustomStatManager.saveCustomStats();
    }

    public static void resetStats(List<String> statIds) {
        for (String id : statIds) {
            CustomStatDefinition stat = CUSTOM_STATS.get(id);
            if (stat == null) continue;
            stat.reset();
        }
        CustomStatManager.saveCustomStats();
    }

    public static void tagStats(List<String> statIds, String tag) {
        for (String id : statIds) {
            CustomStatDefinition stat = CUSTOM_STATS.get(id);
            if (stat == null) continue;
            stat.addTag(tag);
        }
        CustomStatManager.saveCustomStats();
    }

    public static void changeCategory(List<String> statIds, String newCategory) {
        for (String id : statIds) {
            CustomStatDefinition stat = CUSTOM_STATS.get(id);
            if (stat == null) continue;
            stat.setCategory(newCategory);
        }
        CustomStatManager.saveCustomStats();
    }

    public static List<CustomStatDefinition> getPinnedStats() {
        ArrayList<CustomStatDefinition> pinned = new ArrayList<CustomStatDefinition>();
        for (CustomStatDefinition stat : CUSTOM_STATS.values()) {
            if (!stat.isPinned()) continue;
            pinned.add(stat);
        }
        return pinned;
    }

    public static List<CustomStatDefinition> getHudStats() {
        ArrayList<CustomStatDefinition> hudStats = new ArrayList<CustomStatDefinition>();
        for (CustomStatDefinition stat : CUSTOM_STATS.values()) {
            if (!stat.isShowInHud()) continue;
            hudStats.add(stat);
        }
        return hudStats;
    }

    public static List<CustomStatDefinition> getStatsByTag(String tag) {
        ArrayList<CustomStatDefinition> tagged = new ArrayList<CustomStatDefinition>();
        for (CustomStatDefinition stat : CUSTOM_STATS.values()) {
            if (!stat.getTags().contains(tag)) continue;
            tagged.add(stat);
        }
        return tagged;
    }

    public static Set<String> getAllTags() {
        HashSet<String> tags = new HashSet<String>();
        for (CustomStatDefinition stat : CUSTOM_STATS.values()) {
            tags.addAll(stat.getTags());
        }
        return tags;
    }

    public static List<CustomStatDefinition> getStatsWithGoals() {
        ArrayList<CustomStatDefinition> withGoals = new ArrayList<CustomStatDefinition>();
        for (CustomStatDefinition stat : CUSTOM_STATS.values()) {
            if (stat.getGoals().isEmpty()) continue;
            withGoals.add(stat);
        }
        return withGoals;
    }

    public static List<CustomStatDefinition> getStatsWithUnachievedGoals() {
        ArrayList<CustomStatDefinition> withUnachieved = new ArrayList<CustomStatDefinition>();
        for (CustomStatDefinition stat : CUSTOM_STATS.values()) {
            boolean hasUnachieved = stat.getGoals().stream().anyMatch(g -> !g.isAchieved());
            if (!hasUnachieved) continue;
            withUnachieved.add(stat);
        }
        return withUnachieved;
    }

    static {
        initialized = false;
    }
}

