/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.beautiful_statistics_screen.custom.conditions;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_746;
import org.texboobcat.beautiful_statistics_screen.custom.conditions.ConditionGroup;
import org.texboobcat.beautiful_statistics_screen.custom.conditions.ConditionalBlock;
import org.texboobcat.beautiful_statistics_screen.custom.conditions.StatCondition;
import org.texboobcat.beautiful_statistics_screen.custom.conditions.StatConditionEvaluator;

public class BlockEvaluator {
    public static boolean evaluate(ConditionalBlock block, class_1657 player) {
        if (block == null || player == null) {
            return true;
        }
        return BlockEvaluator.evaluateBlock(block, player);
    }

    private static boolean evaluateBlock(ConditionalBlock block, class_1657 player) {
        switch (block.getType()) {
            case IF: {
                return BlockEvaluator.evaluateIf(block, player);
            }
            case AND: {
                return BlockEvaluator.evaluateAnd(block, player);
            }
            case OR: {
                return BlockEvaluator.evaluateOr(block, player);
            }
            case NOT: {
                return BlockEvaluator.evaluateNot(block, player);
            }
            case XOR: {
                return BlockEvaluator.evaluateXor(block, player);
            }
            case NAND: {
                return BlockEvaluator.evaluateNand(block, player);
            }
            case NOR: {
                return BlockEvaluator.evaluateNor(block, player);
            }
            case IMPLIES: {
                return BlockEvaluator.evaluateImplies(block, player);
            }
            case ELSE_IF: {
                return BlockEvaluator.evaluateElseIf(block, player);
            }
            case ELSE: {
                return true;
            }
        }
        return true;
    }

    private static boolean evaluateIf(ConditionalBlock block, class_1657 player) {
        boolean condition = BlockEvaluator.evaluateCondition(block, player);
        if (condition) {
            return BlockEvaluator.evaluateChildren(block, player, true);
        }
        ConditionalBlock elseBlock = block.getElseBlock();
        if (elseBlock != null) {
            return BlockEvaluator.evaluateBlock(elseBlock, player);
        }
        return false;
    }

    private static boolean evaluateAnd(ConditionalBlock block, class_1657 player) {
        if (!BlockEvaluator.evaluateCondition(block, player)) {
            return false;
        }
        return BlockEvaluator.evaluateChildren(block, player, true);
    }

    private static boolean evaluateOr(ConditionalBlock block, class_1657 player) {
        if (BlockEvaluator.evaluateCondition(block, player)) {
            return true;
        }
        return BlockEvaluator.evaluateChildren(block, player, false);
    }

    private static boolean evaluateNot(ConditionalBlock block, class_1657 player) {
        boolean condition = BlockEvaluator.evaluateCondition(block, player);
        boolean childrenResult = BlockEvaluator.evaluateChildren(block, player, true);
        return !condition || !childrenResult;
    }

    private static boolean evaluateXor(ConditionalBlock block, class_1657 player) {
        boolean thisCondition = BlockEvaluator.evaluateCondition(block, player);
        int trueCount = 0;
        if (thisCondition) {
            ++trueCount;
        }
        for (ConditionalBlock child : block.getChildren()) {
            if (!BlockEvaluator.evaluateBlock(child, player)) continue;
            ++trueCount;
        }
        return trueCount == 1;
    }

    private static boolean evaluateNand(ConditionalBlock block, class_1657 player) {
        boolean andResult = BlockEvaluator.evaluateCondition(block, player) && BlockEvaluator.evaluateChildren(block, player, true);
        return !andResult;
    }

    private static boolean evaluateNor(ConditionalBlock block, class_1657 player) {
        boolean orResult = BlockEvaluator.evaluateCondition(block, player) || BlockEvaluator.evaluateChildren(block, player, false);
        return !orResult;
    }

    private static boolean evaluateImplies(ConditionalBlock block, class_1657 player) {
        boolean antecedent = BlockEvaluator.evaluateCondition(block, player);
        boolean consequent = BlockEvaluator.evaluateChildren(block, player, true);
        return !antecedent || consequent;
    }

    private static boolean evaluateElseIf(ConditionalBlock block, class_1657 player) {
        return BlockEvaluator.evaluateIf(block, player);
    }

    private static boolean evaluateChildren(ConditionalBlock block, class_1657 player, boolean andMode) {
        if (!block.hasChildren()) {
            return true;
        }
        if (andMode) {
            for (ConditionalBlock child : block.getChildren()) {
                if (BlockEvaluator.evaluateBlock(child, player)) continue;
                return false;
            }
            return true;
        }
        for (ConditionalBlock child : block.getChildren()) {
            if (!BlockEvaluator.evaluateBlock(child, player)) continue;
            return true;
        }
        return false;
    }

    private static boolean evaluateCondition(ConditionalBlock block, class_1657 player) {
        if (!block.hasCondition()) {
            return true;
        }
        if (!(player instanceof class_746)) {
            return true;
        }
        StatCondition condition = block.getCondition();
        ConditionGroup tempGroup = new ConditionGroup();
        tempGroup.addCondition(condition);
        return StatConditionEvaluator.evaluate(tempGroup, (class_746)player);
    }

    public static EvaluationTrace evaluateWithTrace(ConditionalBlock block, class_1657 player) {
        EvaluationTrace trace = new EvaluationTrace();
        BlockEvaluator.evaluateBlockWithTrace(block, player, trace, 0);
        return trace;
    }

    private static boolean evaluateBlockWithTrace(ConditionalBlock block, class_1657 player, EvaluationTrace trace, int depth) {
        boolean result = BlockEvaluator.evaluateBlock(block, player);
        Object description = block.getType().getDisplayName();
        if (block.hasCondition()) {
            description = (String)description + ": " + block.getCondition().toString();
        }
        trace.addStep((String)description, result, depth);
        for (ConditionalBlock child : block.getChildren()) {
            BlockEvaluator.evaluateBlockWithTrace(child, player, trace, depth + 1);
        }
        return result;
    }

    public static class EvaluationTrace {
        private final List<TraceStep> steps = new ArrayList<TraceStep>();

        public void addStep(String description, boolean result, int depth) {
            this.steps.add(new TraceStep(description, result, depth));
        }

        public List<TraceStep> getSteps() {
            return this.steps;
        }

        public boolean getFinalResult() {
            return this.steps.isEmpty() ? true : this.steps.get((int)(this.steps.size() - 1)).result;
        }
    }

    public static class TraceStep {
        public final String description;
        public final boolean result;
        public final int depth;

        public TraceStep(String description, boolean result, int depth) {
            this.description = description;
            this.result = result;
            this.depth = depth;
        }
    }
}

