/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.beautiful_statistics_screen.custom.conditions;

import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.texboobcat.beautiful_statistics_screen.custom.conditions.ConditionGroup;
import org.texboobcat.beautiful_statistics_screen.custom.conditions.LogicMode;
import org.texboobcat.beautiful_statistics_screen.custom.conditions.StatCondition;

public class ConditionalBlock {
    @SerializedName(value="id")
    private String id = UUID.randomUUID().toString();
    @SerializedName(value="type")
    private BlockType type;
    @SerializedName(value="condition")
    private StatCondition condition;
    @SerializedName(value="children")
    private List<ConditionalBlock> children;
    @SerializedName(value="elseBlock")
    private ConditionalBlock elseBlock;
    @SerializedName(value="color")
    private String color;
    private transient int x;
    private transient int y;
    private transient int width = 200;
    private transient int height = 60;
    private transient boolean isDragging = false;
    private transient ConditionalBlock parent;

    public ConditionalBlock() {
        this.type = BlockType.IF;
        this.children = new ArrayList<ConditionalBlock>();
        this.color = BlockType.IF.getDefaultColor();
    }

    public ConditionalBlock(BlockType type) {
        this.type = type;
        this.children = new ArrayList<ConditionalBlock>();
        this.color = type.getDefaultColor();
    }

    public ConditionalBlock(BlockType type, StatCondition condition) {
        this.type = type;
        this.condition = condition;
        this.children = new ArrayList<ConditionalBlock>();
        this.color = type.getDefaultColor();
    }

    public String getId() {
        return this.id;
    }

    public BlockType getType() {
        return this.type;
    }

    public StatCondition getCondition() {
        return this.condition;
    }

    public List<ConditionalBlock> getChildren() {
        return this.children;
    }

    public ConditionalBlock getElseBlock() {
        return this.elseBlock;
    }

    public String getColor() {
        return this.color;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public boolean isDragging() {
        return this.isDragging;
    }

    public ConditionalBlock getParent() {
        return this.parent;
    }

    public void setType(BlockType type) {
        this.type = type;
        if (this.color == null || this.color.isEmpty()) {
            this.color = type.getDefaultColor();
        }
    }

    public void setCondition(StatCondition condition) {
        this.condition = condition;
    }

    public void setElseBlock(ConditionalBlock elseBlock) {
        this.elseBlock = elseBlock;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public void setX(int x) {
        this.x = x;
    }

    public void setY(int y) {
        this.y = y;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void setDragging(boolean dragging) {
        this.isDragging = dragging;
    }

    public void setParent(ConditionalBlock parent) {
        this.parent = parent;
    }

    public void addChild(ConditionalBlock child) {
        this.children.add(child);
    }

    public void removeChild(ConditionalBlock child) {
        this.children.remove(child);
    }

    public void removeChild(int index) {
        if (index >= 0 && index < this.children.size()) {
            this.children.remove(index);
        }
    }

    public boolean hasCondition() {
        return this.condition != null;
    }

    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    public boolean hasElse() {
        return this.elseBlock != null;
    }

    public boolean containsPoint(int px, int py) {
        return px >= this.x && px <= this.x + this.width && py >= this.y && py <= this.y + this.height;
    }

    public int calculateTotalHeight() {
        int total = this.height;
        if (this.hasChildren()) {
            for (ConditionalBlock child : this.children) {
                total += child.calculateTotalHeight() + 5;
            }
        }
        if (this.hasElse()) {
            total += this.elseBlock.calculateTotalHeight() + 5;
        }
        return total;
    }

    public ConditionGroup toConditionGroup() {
        ConditionGroup group = new ConditionGroup();
        if (this.type == BlockType.OR) {
            group.setLogicMode(LogicMode.OR);
        } else {
            group.setLogicMode(LogicMode.AND);
        }
        if (this.condition != null) {
            if (this.type == BlockType.NOT && this.condition != null) {
                this.condition.setNegated(true);
            }
            group.addCondition(this.condition);
        }
        for (ConditionalBlock child : this.children) {
            ConditionGroup childGroup = child.toConditionGroup();
            for (StatCondition childCondition : childGroup.getConditions()) {
                group.addCondition(childCondition);
            }
        }
        return group;
    }

    public static ConditionalBlock fromConditionGroup(ConditionGroup group) {
        if (group == null || group.isEmpty()) {
            return new ConditionalBlock(BlockType.IF);
        }
        BlockType type = group.getLogicMode() == LogicMode.OR ? BlockType.OR : BlockType.AND;
        ConditionalBlock block = new ConditionalBlock(type);
        for (StatCondition condition : group.getConditions()) {
            BlockType childType = condition.isNegated() ? BlockType.NOT : BlockType.IF;
            ConditionalBlock childBlock = new ConditionalBlock(childType, condition);
            block.addChild(childBlock);
        }
        return block;
    }

    public int getDepth() {
        int maxChildDepth = 0;
        for (ConditionalBlock child : this.children) {
            maxChildDepth = Math.max(maxChildDepth, child.getDepth());
        }
        return 1 + maxChildDepth;
    }

    public int getTotalBlockCount() {
        int count = 1;
        for (ConditionalBlock child : this.children) {
            count += child.getTotalBlockCount();
        }
        if (this.elseBlock != null) {
            count += this.elseBlock.getTotalBlockCount();
        }
        return count;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.type.getDisplayName());
        if (this.condition != null) {
            sb.append(" (").append(this.condition.toString()).append(")");
        }
        if (this.hasChildren()) {
            sb.append(" [").append(this.children.size()).append(" blocks]");
        }
        return sb.toString();
    }

    public static enum BlockType {
        IF("If", "#4A90E2"),
        AND("And", "#50C878"),
        OR("Or", "#FFB347"),
        NOT("Not", "#FF6B6B"),
        ELSE_IF("Else If", "#9B59B6"),
        ELSE("Else", "#7F8C8D"),
        XOR("Xor", "#FF9800"),
        NAND("Nand", "#795548"),
        NOR("Nor", "#607D8B"),
        IMPLIES("Implies", "#00BCD4");

        private final String displayName;
        private final String defaultColor;

        private BlockType(String displayName, String defaultColor) {
            this.displayName = displayName;
            this.defaultColor = defaultColor;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public String getDefaultColor() {
            return this.defaultColor;
        }
    }
}

