/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.beautiful_statistics_screen.snapshot;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_746;
import org.texboobcat.beautiful_statistics_screen.api.StatEntry;
import org.texboobcat.beautiful_statistics_screen.core.StatDataManager;

public class SnapshotManager {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final String SNAPSHOT_VERSION = "1.0";
    private static Path snapshotDirectory;

    public static void initialize(Path gameDirectory) {
        snapshotDirectory = gameDirectory.resolve("beautiful_statistics_screen").resolve("snapshots");
        try {
            Files.createDirectories(snapshotDirectory, new FileAttribute[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static boolean exportSnapshot(String customName, boolean compress) {
        class_310 mc = class_310.method_1551();
        class_746 player = mc.field_1724;
        if (player == null) {
            return false;
        }
        SnapshotData snapshot = new SnapshotData();
        snapshot.version = SNAPSHOT_VERSION;
        snapshot.modVersion = "1.0.0";
        snapshot.timestamp = System.currentTimeMillis();
        snapshot.playerName = player.method_5477().getString();
        snapshot.playerUUID = player.method_5667().toString();
        snapshot.stats = new HashMap<String, Long>();
        for (StatEntry entry : StatDataManager.getAllStats()) {
            if (entry.isZero()) {
                // empty if block
            }
            snapshot.stats.put(entry.getStatId().toString(), entry.getValue());
        }
        String timestamp = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss").format(new Date());
        String filename = customName != null && !customName.isEmpty() ? customName + "_" + timestamp : player.method_5477().getString() + "_" + timestamp;
        filename = filename + (compress ? ".mcbs.gz" : ".mcbs");
        Path file = snapshotDirectory.resolve(filename);
        try {
            if (compress) {
                try (OutputStreamWriter writer = new OutputStreamWriter(new GZIPOutputStream(Files.newOutputStream(file, new OpenOption[0])));){
                    GSON.toJson((Object)snapshot, (Appendable)writer);
                }
            }
            try (BufferedWriter writer = Files.newBufferedWriter(file, new OpenOption[0]);){
                GSON.toJson((Object)snapshot, (Appendable)writer);
            }
            if (mc.field_1724 != null) {
                mc.field_1724.method_43496((class_2561)class_2561.method_43470((String)("Snapshot saved: " + filename)));
            }
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            if (mc.field_1724 != null) {
                mc.field_1724.method_43496((class_2561)class_2561.method_43470((String)("Failed to save snapshot: " + e.getMessage())));
            }
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static SnapshotData importSnapshot(Path file) throws IOException {
        if (!Files.exists(file, new LinkOption[0])) {
            throw new FileNotFoundException("Snapshot file not found: " + String.valueOf(file));
        }
        boolean compressed = file.toString().endsWith(".gz");
        try {
            if (compressed) {
                try (InputStreamReader reader = new InputStreamReader(new GZIPInputStream(Files.newInputStream(file, new OpenOption[0])));){
                    SnapshotData snapshotData = (SnapshotData)GSON.fromJson((Reader)reader, SnapshotData.class);
                    return snapshotData;
                }
            }
            try (BufferedReader reader = Files.newBufferedReader(file);){
                SnapshotData snapshotData = (SnapshotData)GSON.fromJson((Reader)reader, SnapshotData.class);
                return snapshotData;
            }
        }
        catch (Exception e) {
            throw new IOException("Failed to parse snapshot file", e);
        }
    }

    public static List<SnapshotInfo> listSnapshots() {
        ArrayList<SnapshotInfo> snapshots = new ArrayList<SnapshotInfo>();
        if (!Files.exists(snapshotDirectory, new LinkOption[0])) {
            return snapshots;
        }
        try {
            Files.walk(snapshotDirectory, 1, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(p -> p.toString().endsWith(".mcbs") || p.toString().endsWith(".mcbs.gz")).forEach(path -> {
                try {
                    SnapshotData data = SnapshotManager.importSnapshot(path);
                    snapshots.add(new SnapshotInfo(path.getFileName().toString(), (Path)path, data.timestamp, data.playerName, data.stats.size()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        snapshots.sort(Comparator.comparingLong(s -> -s.timestamp));
        return snapshots;
    }

    public static boolean deleteSnapshot(Path file) {
        try {
            return Files.deleteIfExists(file);
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static Path getSnapshotDirectory() {
        return snapshotDirectory;
    }

    public static class SnapshotData {
        public String version;
        public String modVersion;
        public long timestamp;
        public String playerName;
        public String playerUUID;
        public Map<String, Long> stats = new HashMap<String, Long>();
        public UIState uiState = new UIState();
    }

    public static class SnapshotInfo {
        public final String filename;
        public final Path path;
        public final long timestamp;
        public final String playerName;
        public final int statCount;

        public SnapshotInfo(String filename, Path path, long timestamp, String playerName, int statCount) {
            this.filename = filename;
            this.path = path;
            this.timestamp = timestamp;
            this.playerName = playerName;
            this.statCount = statCount;
        }

        public String getFormattedTimestamp() {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date(this.timestamp));
        }
    }

    public static class FilterState {
        public String search = "";
        public boolean hideZero = false;
    }

    public static class UIState {
        public String selectedTab;
        public FilterState filter = new FilterState();
    }
}

