/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.beautiful_statistics_screen.api;

import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.texboobcat.beautiful_statistics_screen.api.IconRenderer;
import org.texboobcat.beautiful_statistics_screen.api.StatCategory;

public class StatEntry {
    private final ResourceLocation statId;
    private final StatCategory category;
    private long value;
    private final Component displayName;
    private final Component description;
    private final IconRenderer iconRenderer;
    private final String searchableName;

    public StatEntry(ResourceLocation statId, StatCategory category, long value, Component displayName, Component description, IconRenderer iconRenderer) {
        this.statId = statId;
        this.category = category;
        this.value = value;
        this.displayName = displayName;
        this.description = description;
        this.iconRenderer = iconRenderer;
        this.searchableName = displayName.getString().toLowerCase();
    }

    public ResourceLocation getStatId() {
        return this.statId;
    }

    public StatCategory getCategory() {
        return this.category;
    }

    public long getValue() {
        return this.value;
    }

    public void setValue(long value) {
        this.value = value;
    }

    public Component getDisplayName() {
        return this.displayName;
    }

    public Component getDescription() {
        return this.description;
    }

    public IconRenderer getIconRenderer() {
        return this.iconRenderer;
    }

    public String getSearchableName() {
        return this.searchableName;
    }

    public boolean isZero() {
        return this.value == 0L;
    }

    public boolean matchesSearch(String query) {
        if (query == null || query.isEmpty()) {
            return true;
        }
        String lowerQuery = query.toLowerCase();
        return this.searchableName.contains(lowerQuery) || this.statId.toString().toLowerCase().contains(lowerQuery);
    }
}

