/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.beautiful_statistics_screen.api;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceLocation;
import org.texboobcat.beautiful_statistics_screen.api.IconRenderer;
import org.texboobcat.beautiful_statistics_screen.api.StatCategory;
import org.texboobcat.beautiful_statistics_screen.api.StatEntry;
import org.texboobcat.beautiful_statistics_screen.core.StatCategoryRegistry;

public class StatExtensionAPI {
    private static final List<Consumer<StatEntry>> statClickListeners = new ArrayList<Consumer<StatEntry>>();
    private static final List<Consumer<StatEntry>> statTooltipListeners = new ArrayList<Consumer<StatEntry>>();
    private static final List<StatRenderer> customRenderers = new ArrayList<StatRenderer>();

    public static void registerCategory(StatCategory category) {
        StatCategoryRegistry.register(category);
    }

    public static void registerStatClickListener(Consumer<StatEntry> listener) {
        statClickListeners.add(listener);
    }

    public static void registerStatTooltipListener(Consumer<StatEntry> listener) {
        statTooltipListeners.add(listener);
    }

    public static void registerStatRenderer(StatRenderer renderer) {
        customRenderers.add(renderer);
    }

    public static void fireStatClickEvent(StatEntry entry) {
        for (Consumer<StatEntry> listener : statClickListeners) {
            try {
                listener.accept(entry);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void fireStatTooltipEvent(StatEntry entry) {
        for (Consumer<StatEntry> listener : statTooltipListeners) {
            try {
                listener.accept(entry);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static StatRenderer getCustomRenderer(ResourceLocation statId) {
        for (StatRenderer renderer : customRenderers) {
            if (!renderer.canRender(statId)) continue;
            return renderer;
        }
        return null;
    }

    public static interface StatRenderer {
        public boolean canRender(ResourceLocation var1);

        public IconRenderer getIconRenderer(ResourceLocation var1);
    }
}

