/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.beautiful_statistics_screen.client;

import dev.architectury.event.CompoundEventResult;
import dev.architectury.event.events.client.ClientGuiEvent;
import dev.architectury.event.events.client.ClientTickEvent;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.achievement.StatsScreen;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import org.texboobcat.beautiful_statistics_screen.Beautiful_statistics_screen;
import org.texboobcat.beautiful_statistics_screen.backup.StatBackupManager;
import org.texboobcat.beautiful_statistics_screen.client.KeyBindings;
import org.texboobcat.beautiful_statistics_screen.client.gui.ImprovedStatsScreen;
import org.texboobcat.beautiful_statistics_screen.client.hud.StatHudRenderer;
import org.texboobcat.beautiful_statistics_screen.config.ModConfig;
import org.texboobcat.beautiful_statistics_screen.core.StatDataManager;
import org.texboobcat.beautiful_statistics_screen.custom.CustomStatTracker;
import org.texboobcat.beautiful_statistics_screen.custom.StatNotificationManager;
import org.texboobcat.beautiful_statistics_screen.history.HistoryManager;
import org.texboobcat.beautiful_statistics_screen.snapshot.SnapshotManager;

public class ClientEvents {
    private static int tickCounter = 0;
    private static int historyTickCounter = 0;
    private static int statSaveCounter = 0;
    private static int backupCounter = 0;
    private static int hudRefreshCounter = 0;
    private static final int STAT_REFRESH_INTERVAL = 100;
    private static final int HUD_REFRESH_INTERVAL = 5;
    private static boolean hasCheckedForStatReset = false;
    private static int initDelayCounter = -1;
    private static boolean hasShownStatResetThisSession = false;
    private static final ExecutorService IO_EXEC = Executors.newSingleThreadExecutor(r -> {
        Thread t = new Thread(r, "BSS-IO-Worker");
        t.setDaemon(true);
        return t;
    });

    public static void register() {
        ClientGuiEvent.RENDER_HUD.register(ClientEvents::onRenderHud);
        ClientTickEvent.CLIENT_POST.register(ClientEvents::onClientTick);
        ClientGuiEvent.SET_SCREEN.register(ClientEvents::onSetScreen);
    }

    private static CompoundEventResult<Screen> onSetScreen(Screen screen) {
        if (screen instanceof StatsScreen) {
            Minecraft mc = Minecraft.m_91087_();
            Screen parent = mc.f_91080_;
            return CompoundEventResult.interruptTrue((Object)((Object)new ImprovedStatsScreen(parent)));
        }
        return CompoundEventResult.pass();
    }

    private static void onRenderHud(GuiGraphics graphics, float tickDelta) {
        StatHudRenderer.render(graphics, tickDelta);
    }

    private static void onClientTick(Minecraft minecraft) {
        int backupInterval;
        int autosaveInterval;
        int historyInterval;
        if (minecraft.f_91074_ != null && minecraft.f_91080_ == null) {
            boolean success;
            if (KeyBindings.OPEN_STATS.m_90859_()) {
                minecraft.m_91152_((Screen)new ImprovedStatsScreen(null));
            }
            if (KeyBindings.TOGGLE_HUD.m_90859_()) {
                StatHudRenderer.toggleVisibility();
                minecraft.f_91074_.m_213846_((Component)Component.m_237115_((String)("message.beautiful_statistics_screen.hud_" + (StatHudRenderer.isVisible() ? "enabled" : "disabled"))));
            }
            if (KeyBindings.QUICK_EXPORT.m_90859_() && (success = SnapshotManager.exportSnapshot(null, true))) {
                minecraft.f_91074_.m_213846_((Component)Component.m_237115_((String)"message.beautiful_statistics_screen.snapshot_exported"));
            }
        }
        if (minecraft.f_91074_ != null && !StatDataManager.isInitialized()) {
            if (initDelayCounter < 0) {
                initDelayCounter = Math.max(0, ModConfig.getClient().initialFullRefreshDelayTicks);
            }
            if (initDelayCounter > 0) {
                --initDelayCounter;
            } else {
                StatDataManager.refresh();
                statSaveCounter = 0;
                backupCounter = 0;
                hasCheckedForStatReset = false;
                initDelayCounter = Integer.MIN_VALUE;
            }
        }
        if (minecraft.f_91074_ != null && StatDataManager.isInitialized() && !hasCheckedForStatReset && !hasShownStatResetThisSession && ModConfig.getClient().autoDetectStatReset) {
            hasCheckedForStatReset = true;
            hasShownStatResetThisSession = true;
            new Thread(() -> {
                try {
                    Thread.sleep(5000L);
                    StatBackupManager.detectAndRestoreIfNeeded();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }, "StatResetDetector").start();
        }
        if (minecraft.f_91074_ == null && StatDataManager.isInitialized()) {
            statSaveCounter = 0;
            backupCounter = 0;
            hasCheckedForStatReset = false;
            hasShownStatResetThisSession = false;
            initDelayCounter = -1;
            hudRefreshCounter = 0;
        }
        if (minecraft.f_91074_ != null && StatHudRenderer.isVisible()) {
            StatDataManager.updateClientSideStats();
        }
        if (minecraft.f_91074_ != null && StatHudRenderer.isVisible()) {
            if (++hudRefreshCounter >= 5) {
                hudRefreshCounter = 0;
                StatDataManager.refreshPinned();
            }
        } else {
            hudRefreshCounter = 0;
        }
        if (minecraft.f_91074_ != null) {
            CustomStatTracker.onTick();
        }
        StatNotificationManager.tick();
        int refreshInterval = Math.max(ModConfig.getClient().statRefreshInterval, ModConfig.getClient().minFullRefreshInterval);
        if (++tickCounter >= refreshInterval) {
            tickCounter = 0;
            if (minecraft.f_91074_ != null && !StatHudRenderer.isVisible() && !ModConfig.getClient().enableSmoothStatUpdates && ModConfig.getClient().enablePeriodicFullRefreshWhenHudHidden) {
                StatDataManager.refresh();
            }
        }
        if (minecraft.f_91074_ != null && ModConfig.getClient().enableHistoryTracking && ++historyTickCounter >= (historyInterval = ModConfig.getClient().historyLogInterval * 20)) {
            historyTickCounter = 0;
            IO_EXEC.submit(() -> {
                try {
                    HistoryManager.logCurrentStats();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
        }
        if (minecraft.f_91074_ != null && ModConfig.getClient().enableStatsAutosave && ++statSaveCounter >= (autosaveInterval = ModConfig.getClient().statsAutosaveInterval * 20)) {
            statSaveCounter = 0;
            ClientEvents.savePlayerStats(minecraft);
        }
        if (minecraft.f_91074_ != null && ModConfig.getClient().enableStatsBackups && ++backupCounter >= (backupInterval = ModConfig.getClient().statsBackupInterval * 20)) {
            backupCounter = 0;
            IO_EXEC.submit(() -> {
                try {
                    boolean success = StatBackupManager.createBackup();
                    if (success) {
                        Beautiful_statistics_screen.LOGGER.info("Created stat backup for player " + minecraft.f_91074_.m_7755_().getString());
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
        }
    }

    private static void savePlayerStats(Minecraft minecraft) {
        try {
            IntegratedServer server;
            ServerPlayer serverPlayer;
            if (minecraft.m_91091_() && minecraft.m_91092_() != null && (serverPlayer = (server = minecraft.m_91092_()).m_6846_().m_11259_(minecraft.f_91074_.m_20148_())) != null) {
                serverPlayer.m_8951_().m_12818_();
                if (ModConfig.getClient().saveAllChunksOnAutosave) {
                    server.m_129885_(false, false, false);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

