/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.beautiful_statistics_screen.client.gui;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.texboobcat.beautiful_statistics_screen.custom.conditions.BlockEvaluator;
import org.texboobcat.beautiful_statistics_screen.custom.conditions.ConditionalBlock;

public class ConditionDebuggerPanel {
    private final Minecraft minecraft;
    private int x;
    private int y;
    private int width;
    private int height;
    private boolean visible = true;
    private ConditionalBlock rootBlock;
    private boolean lastResult = false;
    private List<EvaluationResult> blockResults = new ArrayList<EvaluationResult>();

    public ConditionDebuggerPanel(Minecraft minecraft, int x, int y, int width, int height) {
        this.minecraft = minecraft;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public void setRootBlock(ConditionalBlock block) {
        this.rootBlock = block;
        this.evaluateBlocks();
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setPosition(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public void setSize(int width, int height) {
        this.width = width;
        this.height = height;
    }

    private void evaluateBlocks() {
        this.blockResults.clear();
        if (this.rootBlock == null || this.minecraft.f_91074_ == null) {
            this.lastResult = false;
            return;
        }
        BlockEvaluator.EvaluationTrace trace = BlockEvaluator.evaluateWithTrace(this.rootBlock, (Player)this.minecraft.f_91074_);
        this.lastResult = trace.getFinalResult();
        for (BlockEvaluator.TraceStep step : trace.getSteps()) {
            this.blockResults.add(new EvaluationResult(this.extractBlockType(step.description), step.description, step.result, step.depth));
        }
    }

    private String extractBlockType(String description) {
        int colonIndex = description.indexOf(58);
        if (colonIndex > 0) {
            return description.substring(0, colonIndex);
        }
        return description;
    }

    public void render(GuiGraphics graphics, Font font, int mouseX, int mouseY) {
        if (!this.visible) {
            return;
        }
        this.evaluateBlocks();
        graphics.m_280509_(this.x, this.y, this.x + this.width, this.y + this.height, -300279270);
        graphics.m_280637_(this.x, this.y, this.width, this.height, -11184811);
        graphics.m_280488_(font, Component.m_237115_((String)"gui.beautiful_statistics_screen.debugger.title").getString(), this.x + 10, this.y + 10, 0x55FF55);
        int currentY = this.y + 25;
        LocalPlayer player = this.minecraft.f_91074_;
        if (player != null && player.m_9236_() != null) {
            graphics.m_280488_(font, Component.m_237115_((String)"gui.beautiful_statistics_screen.debugger.current_state").getString(), this.x + 10, currentY, 0xFFFFFF);
            String biome = this.getCurrentBiome(player);
            graphics.m_280488_(font, Component.m_237110_((String)"gui.beautiful_statistics_screen.debugger.biome", (Object[])new Object[]{biome}).getString(), this.x + 15, currentY += 12, 0xAAAAAA);
            String dimension = this.getCurrentDimension(player);
            graphics.m_280488_(font, Component.m_237110_((String)"gui.beautiful_statistics_screen.debugger.dimension", (Object[])new Object[]{dimension}).getString(), this.x + 15, currentY += 11, 0xAAAAAA);
            int yLevel = player.m_20183_().m_123342_();
            graphics.m_280488_(font, Component.m_237110_((String)"gui.beautiful_statistics_screen.debugger.y_level", (Object[])new Object[]{yLevel}).getString(), this.x + 15, currentY += 11, 0xAAAAAA);
            int light = player.m_9236_().m_46803_(player.m_20183_());
            graphics.m_280488_(font, Component.m_237110_((String)"gui.beautiful_statistics_screen.debugger.light", (Object[])new Object[]{light}).getString(), this.x + 15, currentY += 11, 0xAAAAAA);
            String time = this.getCurrentTime(player.m_9236_());
            graphics.m_280488_(font, Component.m_237110_((String)"gui.beautiful_statistics_screen.debugger.time", (Object[])new Object[]{time}).getString(), this.x + 15, currentY += 11, 0xAAAAAA);
            String weather = this.getCurrentWeather(player.m_9236_());
            graphics.m_280488_(font, Component.m_237110_((String)"gui.beautiful_statistics_screen.debugger.weather", (Object[])new Object[]{weather}).getString(), this.x + 15, currentY += 11, 0xAAAAAA);
            currentY += 15;
        }
        String resultText = this.lastResult ? Component.m_237115_((String)"gui.beautiful_statistics_screen.debugger.true_track").getString() : Component.m_237115_((String)"gui.beautiful_statistics_screen.debugger.false_no_track").getString();
        int resultColor = this.lastResult ? 0x55FF55 : 0xFF5555;
        graphics.m_280488_(font, Component.m_237115_((String)"gui.beautiful_statistics_screen.debugger.result").getString(), this.x + 10, currentY, 0xFFFFFF);
        graphics.m_280488_(font, resultText, this.x + 15, currentY += 12, resultColor);
        currentY += 15;
        if (!this.blockResults.isEmpty()) {
            graphics.m_280488_(font, Component.m_237115_((String)"gui.beautiful_statistics_screen.debugger.block_by_block").getString(), this.x + 10, currentY, 0xFFFFFF);
            currentY += 12;
            for (EvaluationResult result : this.blockResults) {
                if (currentY + 11 > this.y + this.height - 10) {
                    graphics.m_280488_(font, "\u00a77...", this.x + 15, currentY, 0x888888);
                    break;
                }
                String icon = result.result ? "\u2713" : "\u2717";
                int color = result.result ? 0x55FF55 : 0xFF5555;
                int indent = this.x + 15 + result.depth * 10;
                String text = icon + " " + result.blockType + ": " + result.conditionText;
                if (font.m_92895_(text) > this.width - 30) {
                    text = text.substring(0, Math.min(text.length(), 30)) + "...";
                }
                graphics.m_280488_(font, text, indent, currentY, color);
                currentY += 11;
            }
        }
        if (this.rootBlock == null || this.rootBlock.getChildren().isEmpty()) {
            graphics.m_280488_(font, Component.m_237115_((String)"gui.beautiful_statistics_screen.debugger.no_blocks").getString(), this.x + 15, currentY, 0x888888);
        }
    }

    private String getCurrentBiome(LocalPlayer player) {
        try {
            BlockPos pos = player.m_20183_();
            Holder biomeHolder = player.m_9236_().m_204166_(pos);
            ResourceLocation biomeId = biomeHolder.m_203543_().map(key -> key.m_135782_()).orElse(new ResourceLocation("minecraft", "unknown"));
            return biomeId.toString();
        }
        catch (Exception e) {
            return "unknown";
        }
    }

    private String getCurrentDimension(LocalPlayer player) {
        try {
            return player.m_9236_().m_46472_().m_135782_().toString();
        }
        catch (Exception e) {
            return "unknown";
        }
    }

    private String getCurrentTime(Level level) {
        long time = level.m_46468_() % 24000L;
        if (time >= 0L && time < 6000L) {
            return "morning";
        }
        if (time >= 6000L && time < 12000L) {
            return "day";
        }
        if (time >= 12000L && time < 18000L) {
            return "evening";
        }
        return "night";
    }

    private String getCurrentWeather(Level level) {
        if (level.m_46470_()) {
            return "thunder";
        }
        if (level.m_46471_()) {
            return "rain";
        }
        return "clear";
    }

    public boolean isMouseOver(double mouseX, double mouseY) {
        return mouseX >= (double)this.x && mouseX <= (double)(this.x + this.width) && mouseY >= (double)this.y && mouseY <= (double)(this.y + this.height);
    }

    private static class EvaluationResult {
        final String blockType;
        final String conditionText;
        final boolean result;
        final int depth;

        EvaluationResult(String blockType, String conditionText, boolean result, int depth) {
            this.blockType = blockType;
            this.conditionText = conditionText;
            this.result = result;
            this.depth = depth;
        }
    }
}

