/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.beautiful_statistics_screen.client.gui;

import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.texboobcat.beautiful_statistics_screen.client.gui.ConditionDetailScreen;
import org.texboobcat.beautiful_statistics_screen.custom.conditions.ComparisonOperator;
import org.texboobcat.beautiful_statistics_screen.custom.conditions.ConditionGroup;
import org.texboobcat.beautiful_statistics_screen.custom.conditions.ConditionType;
import org.texboobcat.beautiful_statistics_screen.custom.conditions.LogicMode;
import org.texboobcat.beautiful_statistics_screen.custom.conditions.StatCondition;

public class ConditionEditorScreen
extends Screen {
    private final Screen parent;
    private final ConditionGroup conditionGroup;
    private final Consumer<ConditionGroup> onSave;
    private ConditionListWidget conditionList;
    private CycleButton<LogicMode> logicModeButton;
    private Button addButton;
    private Button doneButton;
    private Button cancelButton;
    private StatCondition selectedCondition;

    public ConditionEditorScreen(Screen parent, ConditionGroup conditionGroup, Consumer<ConditionGroup> onSave) {
        super((Component)Component.m_237113_((String)"Edit Conditions"));
        this.parent = parent;
        this.conditionGroup = conditionGroup != null ? conditionGroup : new ConditionGroup();
        this.onSave = onSave;
    }

    protected void m_7856_() {
        super.m_7856_();
        int topY = 40;
        int centerX = this.f_96543_ / 2;
        this.logicModeButton = CycleButton.m_168894_(mode -> Component.m_237113_((String)mode.getDisplayName())).m_168961_((Object[])LogicMode.values()).m_168948_((Object)this.conditionGroup.getLogicMode()).m_168936_(centerX - 100, topY, 200, 20, (Component)Component.m_237113_((String)"Logic Mode"), (btn, value) -> this.conditionGroup.setLogicMode((LogicMode)((Object)value)));
        this.m_142416_((GuiEventListener)this.logicModeButton);
        int listTop = topY + 30;
        int listHeight = this.f_96544_ - listTop - 70;
        this.conditionList = new ConditionListWidget(this.f_96541_, this.f_96543_ - 40, listHeight, listTop, this.f_96544_ - 70, 35);
        this.conditionList.setConditions(this.conditionGroup.getConditions());
        this.m_142416_((GuiEventListener)this.conditionList);
        int bottomY = this.f_96544_ - 35;
        int buttonWidth = 100;
        this.addButton = Button.m_253074_((Component)Component.m_237113_((String)"Add Condition"), btn -> this.addNewCondition()).m_252987_(centerX - buttonWidth * 2 - 10, bottomY, buttonWidth, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.addButton);
        Button editButton = Button.m_253074_((Component)Component.m_237113_((String)"Edit"), btn -> this.editSelectedCondition()).m_252987_(centerX - buttonWidth - 5, bottomY, buttonWidth, 20).m_253136_();
        this.m_142416_((GuiEventListener)editButton);
        Button removeButton = Button.m_253074_((Component)Component.m_237113_((String)"Remove"), btn -> this.removeSelectedCondition()).m_252987_(centerX + 5, bottomY, buttonWidth, 20).m_253136_();
        this.m_142416_((GuiEventListener)removeButton);
        this.doneButton = Button.m_253074_((Component)Component.m_237113_((String)"Done"), btn -> this.save()).m_252987_(centerX + buttonWidth + 10, bottomY, buttonWidth, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.doneButton);
        this.cancelButton = Button.m_253074_((Component)Component.m_237113_((String)"Cancel"), btn -> this.f_96541_.m_91152_(this.parent)).m_252987_(this.f_96543_ - 110, 10, 100, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.cancelButton);
    }

    private void addNewCondition() {
        StatCondition newCondition = new StatCondition(ConditionType.BIOME, ComparisonOperator.EQUALS, "minecraft:plains");
        this.f_96541_.m_91152_((Screen)new ConditionDetailScreen(this, newCondition, condition -> {
            this.conditionGroup.addCondition((StatCondition)condition);
            this.refreshList();
        }));
    }

    private void editSelectedCondition() {
        StatCondition selected = this.conditionList.getSelectedCondition();
        if (selected != null) {
            this.f_96541_.m_91152_((Screen)new ConditionDetailScreen(this, selected, condition -> this.refreshList()));
        }
    }

    private void removeSelectedCondition() {
        int index;
        StatCondition selected = this.conditionList.getSelectedCondition();
        if (selected != null && (index = this.conditionGroup.getConditions().indexOf(selected)) >= 0) {
            this.conditionGroup.removeCondition(index);
            this.refreshList();
        }
    }

    private void refreshList() {
        this.conditionList.setConditions(this.conditionGroup.getConditions());
    }

    private void save() {
        this.onSave.accept(this.conditionGroup);
        this.f_96541_.m_91152_(this.parent);
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(graphics);
        graphics.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, 15, 0xFFFFFF);
        String instructions = "Configure when this stat should track";
        graphics.m_280137_(this.f_96547_, instructions, this.f_96543_ / 2, 65, 0x888888);
        int count = this.conditionGroup.getConditions().size();
        String countText = count + " condition" + (count == 1 ? "" : "s");
        graphics.m_280488_(this.f_96547_, countText, 20, 75, 0xAAAAAA);
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
    }

    public void m_7379_() {
        this.f_96541_.m_91152_(this.parent);
    }

    public boolean m_7043_() {
        return false;
    }

    private class ConditionListWidget
    extends ObjectSelectionList<ConditionEntry> {
        private StatCondition selectedCondition;

        public ConditionListWidget(Minecraft minecraft, int width, int height, int y0, int y1, int itemHeight) {
            super(minecraft, width, height, y0, y1, itemHeight);
        }

        public void setConditions(List<StatCondition> conditions) {
            this.m_93516_();
            for (StatCondition condition : conditions) {
                this.m_7085_((AbstractSelectionList.Entry)new ConditionEntry(condition));
            }
        }

        public StatCondition getSelectedCondition() {
            return this.selectedCondition;
        }

        public class ConditionEntry
        extends ObjectSelectionList.Entry<ConditionEntry> {
            private final StatCondition condition;

            public ConditionEntry(StatCondition condition) {
                this.condition = condition;
            }

            public void m_6311_(GuiGraphics graphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isHovering, float partialTick) {
                boolean selected;
                boolean bl = selected = this.condition == ConditionListWidget.this.selectedCondition;
                int bgColor = selected ? -2141891243 : (isHovering ? 0x40FFFFFF : 0x20000000);
                graphics.m_280509_(left, top, left + width, top + height, bgColor);
                int textX = left + 5;
                if (this.condition.isNegated()) {
                    graphics.m_280488_(((ConditionListWidget)ConditionListWidget.this).f_93386_.f_91062_, "\u00a7cNOT", textX, top + 5, 0xFFFFFF);
                    textX += 30;
                }
                String typeText = this.condition.getType().getDisplayName();
                graphics.m_280488_(((ConditionListWidget)ConditionListWidget.this).f_93386_.f_91062_, typeText, textX, top + 5, 0xFFFF55);
                String opText = this.condition.getOperator().getSymbol() + " " + this.condition.getValue();
                graphics.m_280488_(((ConditionListWidget)ConditionListWidget.this).f_93386_.f_91062_, opText, textX, top + 18, 0xAAAAAA);
                Object desc = this.condition.getType().getDescription();
                if (((String)desc).length() > 60) {
                    desc = ((String)desc).substring(0, 57) + "...";
                }
                graphics.m_280488_(((ConditionListWidget)ConditionListWidget.this).f_93386_.f_91062_, "\u00a77" + (String)desc, left + width - ((ConditionListWidget)ConditionListWidget.this).f_93386_.f_91062_.m_92895_((String)desc) - 5, top + 5, 0xAAAAAA);
            }

            public Component m_142172_() {
                return Component.m_237113_((String)this.condition.toString());
            }

            public boolean m_6375_(double mouseX, double mouseY, int button) {
                ConditionListWidget.this.selectedCondition = this.condition;
                return true;
            }
        }
    }
}

