/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.beautiful_statistics_screen.client.gui;

import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.texboobcat.beautiful_statistics_screen.client.gui.ConditionEditorScreen;
import org.texboobcat.beautiful_statistics_screen.client.gui.IconPickerScreen;
import org.texboobcat.beautiful_statistics_screen.client.gui.ScratchBlockEditorScreenV2;
import org.texboobcat.beautiful_statistics_screen.client.gui.StatImportExportScreen;
import org.texboobcat.beautiful_statistics_screen.client.gui.StatPreviewScreen;
import org.texboobcat.beautiful_statistics_screen.custom.CustomStatDefinition;
import org.texboobcat.beautiful_statistics_screen.custom.CustomStatManager;
import org.texboobcat.beautiful_statistics_screen.custom.conditions.ConditionGroup;
import org.texboobcat.beautiful_statistics_screen.custom.conditions.ConditionalBlock;
import org.texboobcat.beautiful_statistics_screen.custom.conditions.StatCondition;

public class CustomStatEditorScreen
extends Screen {
    private final Screen parent;
    private final CustomStatDefinition stat;
    private final boolean isNew;
    private String pendingIconValue = null;
    private EditBox nameField;
    private EditBox descriptionField;
    private EditBox iconField;
    private EditBox categoryField;
    private EditBox targetsField;
    private CycleButton<CustomStatDefinition.TrackingType> trackingTypeButton;
    private CycleButton<CustomStatDefinition.AggregationType> aggregationTypeButton;
    private CycleButton<CustomStatDefinition.FormatType> formatTypeButton;
    private Button saveButton;
    private Button cancelButton;
    private Button addConditionButton;
    private Button previewButton;
    private int scrollOffset = 0;
    private static final int CONTENT_HEIGHT = 550;
    private static final int SCROLL_SPEED = 10;
    private String errorMessage = null;
    private long errorMessageTime = 0L;
    private static final long ERROR_DISPLAY_DURATION = 3000L;

    public CustomStatEditorScreen(Screen parent, CustomStatDefinition stat) {
        super((Component)Component.m_237115_((String)"screen.beautiful_statistics_screen.custom_stat_editor"));
        this.parent = parent;
        this.isNew = stat == null;
        this.stat = stat != null ? stat : new CustomStatDefinition();
    }

    protected void m_7856_() {
        int leftX = this.f_96543_ / 2 - 150;
        int rightX = this.f_96543_ / 2 + 10;
        int labelWidth = 140;
        int fieldWidth = 140;
        int currentY = 40 - this.scrollOffset;
        int lineHeight = 30;
        this.nameField = new EditBox(this.f_96547_, rightX, currentY, fieldWidth, 20, (Component)Component.m_237115_((String)"gui.beautiful_statistics_screen.name"));
        this.nameField.m_94199_(50);
        this.nameField.m_94144_(this.stat.getName() != null ? this.stat.getName() : "");
        this.m_142416_((GuiEventListener)this.nameField);
        this.descriptionField = new EditBox(this.f_96547_, rightX, currentY += lineHeight, fieldWidth, 20, (Component)Component.m_237115_((String)"gui.beautiful_statistics_screen.description"));
        this.descriptionField.m_94199_(200);
        this.descriptionField.m_94144_(this.stat.getDescription() != null ? this.stat.getDescription() : "");
        this.m_142416_((GuiEventListener)this.descriptionField);
        this.categoryField = new EditBox(this.f_96547_, rightX, currentY += lineHeight, fieldWidth, 20, (Component)Component.m_237115_((String)"gui.beautiful_statistics_screen.category"));
        this.categoryField.m_94199_(30);
        this.categoryField.m_94144_(this.stat.getCategory() != null ? this.stat.getCategory() : Component.m_237115_((String)"gui.beautiful_statistics_screen.default_category").getString());
        this.m_142416_((GuiEventListener)this.categoryField);
        int iconFieldWidth = fieldWidth - 25;
        this.iconField = new EditBox(this.f_96547_, rightX, currentY += lineHeight, iconFieldWidth, 20, (Component)Component.m_237115_((String)"gui.beautiful_statistics_screen.icon"));
        this.iconField.m_94199_(100);
        String iconValue = this.pendingIconValue != null ? this.pendingIconValue : (this.stat.getIcon() != null ? this.stat.getIcon() : Component.m_237115_((String)"gui.beautiful_statistics_screen.icon_hint").getString());
        this.iconField.m_94144_(iconValue);
        this.iconField.m_257771_((Component)Component.m_237115_((String)"gui.beautiful_statistics_screen.icon_hint"));
        this.m_142416_((GuiEventListener)this.iconField);
        System.out.println("CustomStatEditorScreen.init(): Icon field set to: " + iconValue);
        Button iconPickerButton = Button.m_253074_((Component)Component.m_237115_((String)"gui.beautiful_statistics_screen.ellipsis"), button -> this.openIconPicker()).m_252987_(rightX + iconFieldWidth + 5, currentY, 20, 20).m_253136_();
        this.m_142416_((GuiEventListener)iconPickerButton);
        this.trackingTypeButton = CycleButton.m_168894_(type -> Component.m_237113_((String)type.getDisplayName())).m_168961_((Object[])CustomStatDefinition.TrackingType.values()).m_168948_((Object)(this.stat.getTrackingType() != null ? this.stat.getTrackingType() : CustomStatDefinition.TrackingType.BLOCK_MINED)).m_168930_(rightX, currentY += lineHeight, fieldWidth, 20, (Component)Component.m_237113_((String)"Tracking Type"));
        this.m_142416_((GuiEventListener)this.trackingTypeButton);
        this.targetsField = new EditBox(this.f_96547_, rightX, currentY += lineHeight, fieldWidth, 20, (Component)Component.m_237113_((String)"Targets"));
        this.targetsField.m_94199_(500);
        this.targetsField.m_94144_(String.join((CharSequence)", ", this.stat.getTargets()));
        this.targetsField.m_257771_((Component)Component.m_237113_((String)"minecraft:stone, minecraft:dirt"));
        this.m_142416_((GuiEventListener)this.targetsField);
        this.aggregationTypeButton = CycleButton.m_168894_(type -> Component.m_237113_((String)type.getDisplayName())).m_168961_((Object[])CustomStatDefinition.AggregationType.values()).m_168948_((Object)(this.stat.getAggregationType() != null ? this.stat.getAggregationType() : CustomStatDefinition.AggregationType.SUM)).m_168930_(rightX, currentY += lineHeight, fieldWidth, 20, (Component)Component.m_237113_((String)"Aggregation"));
        this.m_142416_((GuiEventListener)this.aggregationTypeButton);
        this.formatTypeButton = CycleButton.m_168894_(type -> Component.m_237113_((String)type.getDisplayName())).m_168961_((Object[])CustomStatDefinition.FormatType.values()).m_168948_((Object)(this.stat.getFormatType() != null ? this.stat.getFormatType() : CustomStatDefinition.FormatType.NUMBER)).m_168930_(rightX, currentY += lineHeight, fieldWidth, 20, (Component)Component.m_237113_((String)"Format"));
        this.m_142416_((GuiEventListener)this.formatTypeButton);
        int condButtonWidth = (fieldWidth - 5) / 2;
        this.addConditionButton = Button.m_253074_((Component)Component.m_237115_((String)"gui.beautiful_statistics_screen.conditions"), button -> this.addCondition()).m_252987_(rightX, currentY += lineHeight + 10, condButtonWidth, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.addConditionButton);
        Button scratchButton = Button.m_253074_((Component)Component.m_237115_((String)"gui.beautiful_statistics_screen.scratch_blocks"), button -> this.openScratchEditor()).m_252987_(rightX + condButtonWidth + 5, currentY, condButtonWidth, 20).m_253136_();
        this.m_142416_((GuiEventListener)scratchButton);
        currentY += lineHeight;
        int buttonY = this.f_96544_ - 40;
        int buttonWidth = 100;
        this.saveButton = Button.m_253074_((Component)Component.m_237115_((String)"gui.beautiful_statistics_screen.save"), button -> this.saveStat()).m_252987_(this.f_96543_ / 2 - buttonWidth - 5, buttonY, buttonWidth, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.saveButton);
        this.cancelButton = Button.m_253074_((Component)Component.m_237115_((String)"gui.beautiful_statistics_screen.cancel"), button -> this.cancel()).m_252987_(this.f_96543_ / 2 + 5, buttonY, buttonWidth, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.cancelButton);
        Button exportButton = Button.m_253074_((Component)Component.m_237115_((String)"gui.beautiful_statistics_screen.import_export"), button -> this.exportStat()).m_252987_(this.f_96543_ - 220, 10, 100, 20).m_253136_();
        this.m_142416_((GuiEventListener)exportButton);
        this.previewButton = Button.m_253074_((Component)Component.m_237115_((String)"gui.beautiful_statistics_screen.preview"), button -> this.previewStat()).m_252987_(this.f_96543_ - 110, 10, 100, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.previewButton);
    }

    private void addCondition() {
        if (this.stat.getConditionGroup() == null) {
            this.stat.setConditionGroup(new ConditionGroup());
        }
        this.f_96541_.m_91152_((Screen)new ConditionEditorScreen(this, this.stat.getConditionGroup(), group -> this.stat.setConditionGroup((ConditionGroup)group)));
    }

    private void openScratchEditor() {
        ConditionalBlock block = this.stat.getConditionalBlock();
        if (block == null) {
            block = this.stat.getConditionGroup() != null ? ConditionalBlock.fromConditionGroup(this.stat.getConditionGroup()) : new ConditionalBlock();
        }
        this.f_96541_.m_91152_((Screen)new ScratchBlockEditorScreenV2(this, block, resultBlock -> this.stat.setConditionalBlock((ConditionalBlock)resultBlock)));
    }

    private void saveStat() {
        String name = this.nameField.m_94155_().trim();
        if (name.isEmpty()) {
            this.showError("Stat name cannot be empty!");
            return;
        }
        this.stat.setName(name);
        this.stat.setDescription(this.descriptionField.m_94155_().trim());
        this.stat.setIcon(this.iconField.m_94155_().trim());
        this.stat.setCategory(this.categoryField.m_94155_().trim());
        this.stat.setTrackingType((CustomStatDefinition.TrackingType)((Object)this.trackingTypeButton.m_168883_()));
        this.stat.setAggregationType((CustomStatDefinition.AggregationType)((Object)this.aggregationTypeButton.m_168883_()));
        this.stat.setFormatType((CustomStatDefinition.FormatType)((Object)this.formatTypeButton.m_168883_()));
        String targetsStr = this.targetsField.m_94155_().trim();
        if (!targetsStr.isEmpty()) {
            ArrayList<String> targets = new ArrayList<String>(Arrays.asList(targetsStr.split("\\s*,\\s*")));
            this.stat.setTargets(targets);
        }
        if (this.isNew) {
            CustomStatManager.updateCustomStat(this.stat);
        } else {
            CustomStatManager.updateCustomStat(this.stat);
        }
        this.pendingIconValue = null;
        this.f_96541_.m_91152_(this.parent);
    }

    private void cancel() {
        this.pendingIconValue = null;
        this.f_96541_.m_91152_(this.parent);
    }

    private void exportStat() {
        this.f_96541_.m_91152_((Screen)new StatImportExportScreen(this, this.stat));
    }

    private void previewStat() {
        CustomStatDefinition previewStat = new CustomStatDefinition();
        previewStat.setName(this.nameField.m_94155_());
        previewStat.setDescription(this.descriptionField.m_94155_());
        previewStat.setIcon(this.iconField.m_94155_());
        previewStat.setCategory(this.categoryField.m_94155_());
        previewStat.setTrackingType((CustomStatDefinition.TrackingType)((Object)this.trackingTypeButton.m_168883_()));
        previewStat.setAggregationType((CustomStatDefinition.AggregationType)((Object)this.aggregationTypeButton.m_168883_()));
        previewStat.setFormatType((CustomStatDefinition.FormatType)((Object)this.formatTypeButton.m_168883_()));
        this.f_96541_.m_91152_((Screen)new StatPreviewScreen(this, previewStat));
    }

    private void openIconPicker() {
        this.f_96541_.m_91152_((Screen)new IconPickerScreen(this, this.iconField.m_94155_(), this::onIconSelected));
    }

    private void onIconSelected(String icon) {
        System.out.println("CustomStatEditorScreen: onIconSelected called with: " + icon);
        this.pendingIconValue = icon;
        if (this.iconField != null) {
            this.iconField.m_94144_(icon);
            System.out.println("CustomStatEditorScreen: Set iconField to: " + icon);
        }
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(graphics);
        graphics.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, 15, 0xFFFFFF);
        graphics.m_280588_(0, 30, this.f_96543_, this.f_96544_ - 50);
        int leftX = this.f_96543_ / 2 - 150;
        int rightX = this.f_96543_ / 2 + 10;
        int currentY = 40 - this.scrollOffset;
        int lineHeight = 30;
        graphics.m_280488_(this.f_96547_, Component.m_237115_((String)"gui.beautiful_statistics_screen.name").getString(), leftX, currentY + 6, 0xFFFFFF);
        graphics.m_280488_(this.f_96547_, Component.m_237115_((String)"gui.beautiful_statistics_screen.description").getString(), leftX, (currentY += lineHeight) + 6, 0xFFFFFF);
        graphics.m_280488_(this.f_96547_, Component.m_237115_((String)"gui.beautiful_statistics_screen.category").getString(), leftX, (currentY += lineHeight) + 6, 0xFFFFFF);
        graphics.m_280488_(this.f_96547_, Component.m_237115_((String)"gui.beautiful_statistics_screen.icon").getString(), leftX, (currentY += lineHeight) + 6, 0xFFFFFF);
        graphics.m_280488_(this.f_96547_, Component.m_237115_((String)"gui.beautiful_statistics_screen.tracking_type").getString(), leftX, (currentY += lineHeight) + 6, 0xFFFFFF);
        graphics.m_280488_(this.f_96547_, Component.m_237115_((String)"gui.beautiful_statistics_screen.targets").getString(), leftX, (currentY += lineHeight) + 6, 0xFFFFFF);
        graphics.m_280488_(this.f_96547_, Component.m_237115_((String)"gui.beautiful_statistics_screen.aggregation").getString(), leftX, (currentY += lineHeight) + 6, 0xFFFFFF);
        graphics.m_280488_(this.f_96547_, Component.m_237115_((String)"gui.beautiful_statistics_screen.format").getString(), leftX, (currentY += lineHeight) + 6, 0xFFFFFF);
        graphics.m_280488_(this.f_96547_, Component.m_237115_((String)"gui.beautiful_statistics_screen.conditions").getString(), leftX, (currentY += lineHeight + 10) + 6, 0xFFFFFF);
        int conditionY = currentY += lineHeight;
        if (this.stat.getConditionalBlock() != null) {
            ConditionalBlock block = this.stat.getConditionalBlock();
            graphics.m_280488_(this.f_96547_, Component.m_237115_((String)"gui.beautiful_statistics_screen.visual_mode").getString(), leftX + 10, conditionY, 0xFFAA00);
            int totalBlocks = block.getTotalBlockCount() - 1;
            String blockKey = totalBlocks == 1 ? "gui.beautiful_statistics_screen.block_count_singular" : "gui.beautiful_statistics_screen.block_count_plural";
            graphics.m_280488_(this.f_96547_, Component.m_237110_((String)blockKey, (Object[])new Object[]{totalBlocks}).getString(), leftX + 10, conditionY += 12, 0xAAAAAA);
            conditionY += 12;
        } else if (this.stat.getConditionGroup() != null && !this.stat.getConditionGroup().isEmpty()) {
            ConditionGroup group = this.stat.getConditionGroup();
            graphics.m_280488_(this.f_96547_, "\u00a7aMode: List", leftX + 10, conditionY, 0x55FF55);
            graphics.m_280488_(this.f_96547_, "Logic: " + group.getLogicMode().getDisplayName(), leftX + 10, conditionY += 12, 0x88FF88);
            conditionY += 12;
            for (StatCondition condition : group.getConditions()) {
                String prefix = condition.isNegated() ? "NOT " : "";
                String condText = prefix + condition.getType().getDisplayName() + " " + condition.getOperator().getSymbol() + " " + condition.getValue();
                graphics.m_280488_(this.f_96547_, "\u2022 " + condText, leftX + 10, conditionY, 0xAAAAAA);
                conditionY += 12;
            }
        } else {
            graphics.m_280488_(this.f_96547_, Component.m_237115_((String)"gui.beautiful_statistics_screen.no_conditions").getString(), leftX + 10, conditionY, 0x888888);
        }
        if (this.trackingTypeButton.m_93696_()) {
            String helpText = ((CustomStatDefinition.TrackingType)((Object)this.trackingTypeButton.m_168883_())).getDescription();
            graphics.m_280488_(this.f_96547_, helpText, leftX, this.f_96544_ - 60, 0x888888);
        }
        graphics.m_280618_();
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
        if (this.targetsField.m_5953_((double)mouseX, (double)mouseY)) {
            ArrayList<MutableComponent> tooltip = new ArrayList<MutableComponent>();
            tooltip.add(Component.m_237115_((String)"gui.beautiful_statistics_screen.tooltip.targets"));
            tooltip.add(Component.m_237115_((String)"gui.beautiful_statistics_screen.tooltip.targets_example"));
            tooltip.add(Component.m_237115_((String)"gui.beautiful_statistics_screen.tooltip.targets_wildcard"));
            graphics.m_280666_(this.f_96547_, tooltip, mouseX, mouseY);
        }
        if (this.errorMessage != null) {
            long currentTime = System.currentTimeMillis();
            if (currentTime - this.errorMessageTime < 3000L) {
                int errorX = this.f_96543_ / 2;
                int errorY = this.f_96544_ - 60;
                int textWidth = this.f_96547_.m_92895_(this.errorMessage);
                graphics.m_280509_(errorX - textWidth / 2 - 10, errorY - 5, errorX + textWidth / 2 + 10, errorY + 15, -587202560);
                graphics.m_280637_(errorX - textWidth / 2 - 10, errorY - 5, textWidth + 20, 20, -65536);
                graphics.m_280137_(this.f_96547_, "\u00a7c" + this.errorMessage, errorX, errorY, 0xFFFFFF);
            } else {
                this.errorMessage = null;
            }
        }
    }

    private void showError(String message) {
        this.errorMessage = message;
        this.errorMessageTime = System.currentTimeMillis();
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        int visibleHeight = this.f_96544_ - 80;
        int maxScroll = Math.max(0, 550 - visibleHeight);
        this.scrollOffset = (int)Math.max(0.0, Math.min((double)maxScroll, (double)this.scrollOffset - delta * 10.0));
        this.m_232761_();
        return true;
    }

    public void m_7379_() {
        this.pendingIconValue = null;
        this.f_96541_.m_91152_(this.parent);
    }

    public boolean m_7043_() {
        return false;
    }
}

