/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.beautiful_statistics_screen.client.gui;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.ItemLike;

public class IconPickerScreen
extends Screen {
    private final Screen parent;
    private final Consumer<String> onIconSelected;
    private final String currentIcon;
    private EditBox searchBox;
    private IconGridWidget iconGrid;
    private Button selectItemsButton;
    private Button selectEntitiesButton;
    private Button selectButton;
    private Button cancelButton;
    private IconType currentType = IconType.ITEMS;
    private String searchQuery = "";

    public IconPickerScreen(Screen parent, String currentIcon, Consumer<String> onIconSelected) {
        super((Component)Component.m_237113_((String)"Select Icon"));
        this.parent = parent;
        this.currentIcon = currentIcon;
        this.onIconSelected = onIconSelected;
    }

    protected void m_7856_() {
        int topY = 40;
        int buttonHeight = 20;
        int buttonSpacing = 5;
        int searchBoxWidth = 200;
        this.searchBox = new EditBox(this.f_96547_, this.f_96543_ / 2 - searchBoxWidth / 2, topY, searchBoxWidth, buttonHeight, (Component)Component.m_237113_((String)"Search"));
        this.searchBox.m_94199_(100);
        this.searchBox.m_94144_(this.searchQuery);
        this.searchBox.m_94151_(this::onSearchChanged);
        this.m_142416_((GuiEventListener)this.searchBox);
        int typeButtonY = topY + buttonHeight + buttonSpacing;
        int typeButtonWidth = 80;
        int typeButtonX = this.f_96543_ / 2 - (typeButtonWidth * 2 + buttonSpacing) / 2;
        this.selectItemsButton = Button.m_253074_((Component)Component.m_237113_((String)"\ud83d\udce6 Items"), btn -> this.switchToType(IconType.ITEMS)).m_252987_(typeButtonX, typeButtonY, typeButtonWidth, buttonHeight).m_253136_();
        this.m_142416_((GuiEventListener)this.selectItemsButton);
        this.selectEntitiesButton = Button.m_253074_((Component)Component.m_237113_((String)"\ud83d\udc04 Entities"), btn -> this.switchToType(IconType.ENTITIES)).m_252987_(typeButtonX + typeButtonWidth + buttonSpacing, typeButtonY, typeButtonWidth, buttonHeight).m_253136_();
        this.m_142416_((GuiEventListener)this.selectEntitiesButton);
        int gridY = typeButtonY + buttonHeight + 10;
        int gridBottom = this.f_96544_ - 40;
        this.iconGrid = new IconGridWidget(this.f_96541_, this.f_96543_, this.f_96544_, gridY, gridBottom, 50);
        this.updateIconGrid();
        this.m_142416_((GuiEventListener)this.iconGrid);
        int bottomButtonY = this.f_96544_ - 30;
        int bottomButtonWidth = 100;
        this.selectButton = Button.m_253074_((Component)Component.m_237113_((String)"Select"), btn -> this.selectIcon()).m_252987_(this.f_96543_ / 2 - bottomButtonWidth - 5, bottomButtonY, bottomButtonWidth, buttonHeight).m_253136_();
        this.selectButton.f_93623_ = false;
        this.m_142416_((GuiEventListener)this.selectButton);
        this.cancelButton = Button.m_253074_((Component)Component.m_237113_((String)"Cancel"), btn -> this.f_96541_.m_91152_(this.parent)).m_252987_(this.f_96543_ / 2 + 5, bottomButtonY, bottomButtonWidth, buttonHeight).m_253136_();
        this.m_142416_((GuiEventListener)this.cancelButton);
        this.updateButtonStates();
    }

    private void onSearchChanged(String query) {
        this.searchQuery = query;
        this.updateIconGrid();
    }

    private void switchToType(IconType type) {
        this.currentType = type;
        this.updateIconGrid();
        this.updateButtonStates();
    }

    private void updateIconGrid() {
        if (this.iconGrid == null) {
            return;
        }
        ArrayList<IconEntry> icons = new ArrayList<IconEntry>();
        if (this.currentType == IconType.ITEMS) {
            for (Item item : BuiltInRegistries.f_257033_) {
                ResourceLocation itemId = BuiltInRegistries.f_257033_.m_7981_((Object)item);
                String iconStr = itemId.toString();
                if (!this.matchesSearch(iconStr)) continue;
                icons.add(new IconEntry(iconStr, new ItemStack((ItemLike)item), IconEntryType.ITEM));
            }
        } else if (this.currentType == IconType.ENTITIES) {
            for (EntityType entityType : BuiltInRegistries.f_256780_) {
                ResourceLocation entityId = BuiltInRegistries.f_256780_.m_7981_((Object)entityType);
                String iconStr = entityId.toString();
                if (!this.matchesSearch(iconStr)) continue;
                icons.add(new IconEntry(iconStr, entityType, IconEntryType.ENTITY));
            }
        }
        this.iconGrid.setIcons(icons);
    }

    private boolean matchesSearch(String iconStr) {
        if (this.searchQuery.isEmpty()) {
            return true;
        }
        return iconStr.toLowerCase().contains(this.searchQuery.toLowerCase());
    }

    private void updateButtonStates() {
        this.selectItemsButton.f_93623_ = this.currentType != IconType.ITEMS;
        this.selectEntitiesButton.f_93623_ = this.currentType != IconType.ENTITIES;
    }

    public void onIconSelectedInGrid() {
        if (this.selectButton != null) {
            this.selectButton.f_93623_ = this.iconGrid != null && this.iconGrid.getSelectedIcon() != null;
        }
    }

    private void selectIcon() {
        IconEntry selected = this.iconGrid.getSelectedIcon();
        if (selected != null) {
            String iconId = selected.iconString;
            System.out.println("IconPickerScreen: Selected icon = " + iconId);
            this.onIconSelected.accept(iconId);
            this.f_96541_.m_91152_(this.parent);
        } else {
            System.out.println("IconPickerScreen: No icon selected");
        }
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(graphics);
        graphics.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, 15, 0xFFFFFF);
        String typeText = "Showing: " + this.currentType.getDisplayName();
        graphics.m_280488_(this.f_96547_, typeText, 10, 75, 0xAAAAAA);
        if (this.iconGrid != null) {
            String countText = this.iconGrid.getIconCount() + " icons";
            graphics.m_280488_(this.f_96547_, countText, this.f_96543_ - this.f_96547_.m_92895_(countText) - 10, 75, 0xAAAAAA);
        }
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
        if (this.iconGrid != null && this.iconGrid.getHoveredIcon() != null) {
            IconEntry hovered = this.iconGrid.getHoveredIcon();
            ArrayList<MutableComponent> tooltip = new ArrayList<MutableComponent>();
            Object displayName = hovered.iconString;
            if (((String)displayName).contains(":")) {
                displayName = ((String)displayName).substring(((String)displayName).indexOf(58) + 1);
            }
            if (((String)(displayName = ((String)displayName).replace("_", " "))).length() > 0) {
                displayName = Character.toUpperCase(((String)displayName).charAt(0)) + ((String)displayName).substring(1);
            }
            tooltip.add(Component.m_237113_((String)displayName));
            tooltip.add(Component.m_237113_((String)("\u00a78" + hovered.iconString)));
            graphics.m_280666_(this.f_96547_, tooltip, mouseX, mouseY);
        }
    }

    public void m_7379_() {
        this.f_96541_.m_91152_(this.parent);
    }

    public boolean m_7043_() {
        return false;
    }

    private static ItemStack findSpawnEgg(EntityType<?> entityType) {
        for (Item item : BuiltInRegistries.f_257033_) {
            SpawnEggItem eggItem;
            if (!(item instanceof SpawnEggItem) || (eggItem = (SpawnEggItem)item).m_43228_(null) != entityType) continue;
            return new ItemStack((ItemLike)eggItem);
        }
        return ItemStack.f_41583_;
    }

    private static enum IconType {
        ITEMS("Items"),
        ENTITIES("Entities");

        private final String displayName;

        private IconType(String displayName) {
            this.displayName = displayName;
        }

        public String getDisplayName() {
            return this.displayName;
        }
    }

    private class IconGridWidget
    extends ObjectSelectionList<IconSlot> {
        private List<IconEntry> icons;
        private IconEntry selectedIcon;
        private IconEntry hoveredIcon;

        public IconGridWidget(Minecraft minecraft, int width, int height, int y0, int y1, int itemHeight) {
            super(minecraft, width, height, y0, y1, itemHeight);
            this.icons = new ArrayList<IconEntry>();
        }

        public void setIcons(List<IconEntry> icons) {
            this.m_93516_();
            this.icons = icons;
            int iconSize = 48;
            int spacing = 4;
            int iconsPerRow = Math.max(1, (this.f_93388_ - 80) / (iconSize + spacing));
            for (int i = 0; i < icons.size(); i += iconsPerRow) {
                int endIndex = Math.min(i + iconsPerRow, icons.size());
                List<IconEntry> rowIcons = icons.subList(i, endIndex);
                this.m_7085_((AbstractSelectionList.Entry)new IconSlot(rowIcons, iconsPerRow));
            }
        }

        public IconEntry getSelectedIcon() {
            return this.selectedIcon;
        }

        public IconEntry getHoveredIcon() {
            return this.hoveredIcon;
        }

        public int getIconCount() {
            return this.icons.size();
        }

        public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
            this.hoveredIcon = null;
            super.m_88315_(graphics, mouseX, mouseY, partialTick);
        }

        protected void m_240140_(GuiGraphics graphics, int top, int width, int height, int outerColor, int innerColor) {
        }

        public class IconSlot
        extends ObjectSelectionList.Entry<IconSlot> {
            private final List<IconEntry> rowIcons;
            private final int iconsPerRow;
            private int lastStartX = 0;
            private int lastTop = 0;
            private int lastIconSize = 44;
            private int lastSpacing = 4;

            public IconSlot(List<IconEntry> rowIcons, int iconsPerRow) {
                this.rowIcons = rowIcons;
                this.iconsPerRow = iconsPerRow;
            }

            public void m_6311_(GuiGraphics graphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isHovering, float partialTick) {
                int startX;
                int iconSize = 44;
                int spacing = 4;
                this.lastIconSize = iconSize;
                this.lastSpacing = spacing;
                this.lastTop = top;
                int totalIconsWidth = this.rowIcons.size() * iconSize + (this.rowIcons.size() - 1) * spacing;
                this.lastStartX = startX = left + (width - totalIconsWidth) / 2;
                for (int i = 0; i < this.rowIcons.size(); ++i) {
                    boolean hovering;
                    IconEntry icon = this.rowIcons.get(i);
                    int x = startX + i * (iconSize + spacing);
                    boolean selected = icon == IconGridWidget.this.selectedIcon;
                    boolean bl = hovering = mouseX >= x && mouseX < x + iconSize && mouseY >= top && mouseY < top + iconSize;
                    if (hovering) {
                        IconGridWidget.this.hoveredIcon = icon;
                    }
                    int bgColor = selected ? -16755456 : (hovering ? -12303292 : -14540254);
                    graphics.m_280509_(x, top, x + iconSize, top + iconSize, bgColor);
                    if (icon.type == IconEntryType.ITEM && icon.displayObject instanceof ItemStack) {
                        ItemStack stack = (ItemStack)icon.displayObject;
                        graphics.m_280480_(stack, x + 14, top + 14);
                    } else if (icon.type == IconEntryType.ENTITY && icon.displayObject instanceof EntityType) {
                        EntityType entityType = (EntityType)icon.displayObject;
                        ItemStack eggStack = IconPickerScreen.findSpawnEgg(entityType);
                        if (eggStack != null && !eggStack.m_41619_()) {
                            graphics.m_280480_(eggStack, x + 14, top + 14);
                        } else {
                            ItemStack placeholderStack = new ItemStack((ItemLike)Items.f_42680_);
                            graphics.m_280480_(placeholderStack, x + 14, top + 14);
                            Object entityName = icon.iconString.substring(icon.iconString.indexOf(58) + 1);
                            entityName = ((String)entityName).replace("_", " ");
                            if (((String)entityName).length() > 0) {
                                entityName = Character.toUpperCase(((String)entityName).charAt(0)) + ((String)entityName).substring(1);
                            }
                            if (((String)entityName).length() > 8) {
                                entityName = ((String)entityName).substring(0, 7) + ".";
                            }
                            int textWidth = IconPickerScreen.this.f_96547_.m_92895_((String)entityName);
                            graphics.m_280488_(IconPickerScreen.this.f_96547_, (String)entityName, x + (iconSize - textWidth) / 2, top + iconSize - 10, 0xCCCCCC);
                        }
                    }
                    int borderColor = selected ? -16711936 : (hovering ? -5592406 : -10066330);
                    graphics.m_280637_(x, top, iconSize, iconSize, borderColor);
                }
            }

            public Component m_142172_() {
                return Component.m_237113_((String)"Icon row");
            }

            public boolean m_6375_(double mouseX, double mouseY, int button) {
                for (int i = 0; i < this.rowIcons.size(); ++i) {
                    IconEntry clickedIcon;
                    int x = this.lastStartX + i * (this.lastIconSize + this.lastSpacing);
                    if (!(mouseX >= (double)x) || !(mouseX < (double)(x + this.lastIconSize)) || !(mouseY >= (double)this.lastTop) || !(mouseY < (double)(this.lastTop + this.lastIconSize))) continue;
                    IconGridWidget.this.selectedIcon = clickedIcon = this.rowIcons.get(i);
                    System.out.println("IconSlot: Selected " + clickedIcon.iconString);
                    IconPickerScreen.this.onIconSelectedInGrid();
                    return true;
                }
                return false;
            }
        }
    }

    private static class IconEntry {
        final String iconString;
        final Object displayObject;
        final IconEntryType type;

        IconEntry(String iconString, Object displayObject, IconEntryType type) {
            this.iconString = iconString;
            this.displayObject = displayObject;
            this.type = type;
        }
    }

    private static enum IconEntryType {
        ITEM,
        ENTITY;

    }
}

