/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.beautiful_statistics_screen.client.gui;

import java.util.Comparator;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.texboobcat.beautiful_statistics_screen.api.StatCategory;
import org.texboobcat.beautiful_statistics_screen.api.StatEntry;
import org.texboobcat.beautiful_statistics_screen.client.gui.AdvancedChartScreen;
import org.texboobcat.beautiful_statistics_screen.client.gui.ConfigScreen;
import org.texboobcat.beautiful_statistics_screen.client.gui.CustomStatScreen;
import org.texboobcat.beautiful_statistics_screen.client.gui.StatGridWidget;
import org.texboobcat.beautiful_statistics_screen.client.gui.TextStatsScreen;
import org.texboobcat.beautiful_statistics_screen.config.ModConfig;
import org.texboobcat.beautiful_statistics_screen.core.StatCategoryRegistry;
import org.texboobcat.beautiful_statistics_screen.core.StatDataManager;
import org.texboobcat.beautiful_statistics_screen.snapshot.SnapshotManager;

public class ImprovedStatsScreen
extends Screen {
    private static final int TAB_WIDTH = 120;
    private static final int TAB_HEIGHT = 24;
    private static final int GRID_PADDING = 10;
    private static final int GRID_ITEM_SIZE = 40;
    private static final int GRID_SPACING = 5;
    private final Screen parent;
    private StatCategory selectedCategory;
    private EditBox searchBox;
    private Button hideZeroButton;
    private Button sortButton;
    private StatGridWidget statGrid;
    private boolean hideZero;
    private String searchQuery = "";
    private final List<StatCategory> categories;
    private int scrollOffset = 0;
    private SortMode sortMode = SortMode.NAME_ASC;
    private int tickCounter = 0;

    public ImprovedStatsScreen(Screen parent) {
        super((Component)Component.m_237115_((String)"screen.beautiful_statistics_screen.statistics"));
        this.parent = parent;
        this.categories = StatCategoryRegistry.getAllCategories();
        this.hideZero = ModConfig.getClient().hideZeroByDefault;
        if (ModConfig.getClient().rememberLastTab) {
            String lastTab = ModConfig.getClient().lastSelectedTab;
            for (StatCategory category : this.categories) {
                if (!category.getId().m_135815_().equals(lastTab)) continue;
                this.selectedCategory = category;
                break;
            }
        }
        if (this.selectedCategory == null && !this.categories.isEmpty()) {
            this.selectedCategory = this.categories.get(0);
        }
    }

    protected void m_7856_() {
        super.m_7856_();
        if (this.f_96541_ != null && this.f_96541_.f_91074_ != null) {
            StatDataManager.refresh();
        }
        int topRowY = 30;
        int secondRowY = 55;
        int buttonHeight = 20;
        int buttonSpacing = 5;
        int leftMargin = 140;
        int rightMargin = 10;
        int searchBoxWidth = Math.min(300, this.f_96543_ - leftMargin - rightMargin - 200);
        this.searchBox = new EditBox(this.f_96547_, leftMargin, topRowY, searchBoxWidth, buttonHeight, (Component)Component.m_237115_((String)"gui.beautiful_statistics_screen.search"));
        this.searchBox.m_94199_(50);
        this.searchBox.m_94144_(this.searchQuery);
        this.searchBox.m_94151_(this::onSearchChanged);
        this.m_142416_((GuiEventListener)this.searchBox);
        int topRightX = leftMargin + searchBoxWidth + buttonSpacing;
        int smallButtonWidth = 70;
        this.hideZeroButton = Button.m_253074_((Component)Component.m_237113_((String)((this.hideZero ? "\u2611" : "\u2610") + " Zero")), btn -> this.toggleHideZero()).m_252987_(topRightX, topRowY, smallButtonWidth, buttonHeight).m_253136_();
        this.m_142416_((GuiEventListener)this.hideZeroButton);
        this.sortButton = Button.m_253074_((Component)this.getSortButtonLabel(), btn -> this.cycleSortMode()).m_252987_(topRightX + smallButtonWidth + buttonSpacing, topRowY, smallButtonWidth, buttonHeight).m_253136_();
        this.m_142416_((GuiEventListener)this.sortButton);
        int secondRowButtonWidth = 65;
        int secondRowX = leftMargin;
        Button refreshButton = Button.m_253074_((Component)Component.m_237113_((String)"\u27f3 Refresh"), btn -> this.refreshStats()).m_252987_(secondRowX, secondRowY, secondRowButtonWidth, buttonHeight).m_253136_();
        this.m_142416_((GuiEventListener)refreshButton);
        Button exportButton = Button.m_253074_((Component)Component.m_237113_((String)"\u2b07 Export"), btn -> this.exportSnapshot()).m_252987_(secondRowX += secondRowButtonWidth + buttonSpacing, secondRowY, secondRowButtonWidth, buttonHeight).m_253136_();
        this.m_142416_((GuiEventListener)exportButton);
        Button configButton = Button.m_253074_((Component)Component.m_237113_((String)"\u2699 Config"), btn -> this.openConfig()).m_252987_(secondRowX += secondRowButtonWidth + buttonSpacing, secondRowY, secondRowButtonWidth, buttonHeight).m_253136_();
        this.m_142416_((GuiEventListener)configButton);
        Button textStatsButton = Button.m_253074_((Component)Component.m_237113_((String)"\u2139 Text Stats"), btn -> this.openTextStats()).m_252987_(secondRowX += secondRowButtonWidth + buttonSpacing, secondRowY, secondRowButtonWidth + 20, buttonHeight).m_253136_();
        this.m_142416_((GuiEventListener)textStatsButton);
        Button customStatsButton = Button.m_253074_((Component)Component.m_237113_((String)"\u270e Custom"), btn -> this.openCustomStats()).m_252987_(secondRowX += secondRowButtonWidth + 20 + buttonSpacing, secondRowY, secondRowButtonWidth + 10, buttonHeight).m_253136_();
        this.m_142416_((GuiEventListener)customStatsButton);
        Button categoryChartsButton = Button.m_253074_((Component)Component.m_237113_((String)"\ud83d\udcca Charts"), btn -> this.openCategoryChart()).m_252987_(secondRowX += secondRowButtonWidth + 10 + buttonSpacing, secondRowY, secondRowButtonWidth + 10, buttonHeight).m_253136_();
        this.m_142416_((GuiEventListener)categoryChartsButton);
        Button backButton = Button.m_253074_((Component)Component.m_237115_((String)"gui.done"), btn -> this.m_7379_()).m_252987_((this.f_96543_ - 200) / 2, this.f_96544_ - 30, 200, 20).m_253136_();
        this.m_142416_((GuiEventListener)backButton);
        int gridX = 140;
        int gridY = 85;
        int gridWidth = this.f_96543_ - gridX - 20;
        int gridHeight = this.f_96544_ - gridY - 40;
        this.statGrid = new StatGridWidget(this.f_96541_, gridX, gridY, gridWidth, gridHeight, this::onStatClicked, this::onStatRightClicked);
        this.m_142416_((GuiEventListener)this.statGrid);
        this.updateDisplayedStats();
    }

    private void onSearchChanged(String query) {
        this.searchQuery = query;
        this.updateDisplayedStats();
    }

    private void toggleHideZero() {
        this.hideZero = !this.hideZero;
        this.hideZeroButton.m_93666_((Component)Component.m_237113_((String)((this.hideZero ? "\u2611" : "\u2610") + " Zero")));
        ModConfig.getClient().hideZeroByDefault = this.hideZero;
        ModConfig.saveClientConfig();
        this.updateDisplayedStats();
    }

    private Component getSortButtonLabel() {
        return switch (this.sortMode.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> Component.m_237113_((String)"Name \u25b2");
            case 1 -> Component.m_237113_((String)"Name \u25bc");
            case 2 -> Component.m_237113_((String)"Value \u25b2");
            case 3 -> Component.m_237113_((String)"Value \u25bc");
        };
    }

    private void cycleSortMode() {
        switch (this.sortMode.ordinal()) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case 0: {
                SortMode sortMode = SortMode.NAME_DESC;
                break;
            }
            case 1: {
                SortMode sortMode = SortMode.VALUE_ASC;
                break;
            }
            case 2: {
                SortMode sortMode = SortMode.VALUE_DESC;
                break;
            }
            case 3: {
                SortMode sortMode = this.sortMode = SortMode.NAME_ASC;
            }
        }
        if (this.sortButton != null) {
            this.sortButton.m_93666_(this.getSortButtonLabel());
        }
        this.updateDisplayedStats();
    }

    private void refreshStats() {
        StatDataManager.refresh();
        this.updateDisplayedStats();
    }

    private void exportSnapshot() {
        boolean success = SnapshotManager.exportSnapshot(null, true);
        if (this.f_96541_ != null && this.f_96541_.f_91074_ != null) {
            if (success) {
                this.f_96541_.f_91074_.m_213846_((Component)Component.m_237115_((String)"message.beautiful_statistics_screen.snapshot_exported"));
            } else {
                this.f_96541_.f_91074_.m_213846_((Component)Component.m_237113_((String)"Failed to export snapshot"));
            }
        }
    }

    private void openConfig() {
        if (this.f_96541_ != null) {
            this.f_96541_.m_91152_((Screen)new ConfigScreen(this));
        }
    }

    private void openTextStats() {
        if (this.f_96541_ != null) {
            this.f_96541_.m_91152_((Screen)new TextStatsScreen(this));
        }
    }

    private void openCustomStats() {
        if (this.f_96541_ != null) {
            this.f_96541_.m_91152_((Screen)new CustomStatScreen(this));
        }
    }

    private void openCategoryChart() {
        if (this.f_96541_ != null) {
            this.f_96541_.m_91152_((Screen)new AdvancedChartScreen(this));
        }
    }

    private void updateDisplayedStats() {
        List<StatEntry> stats = StatDataManager.getFilteredStats(this.selectedCategory, this.searchQuery, this.hideZero);
        stats.sort(this.getSortComparator());
        if (this.statGrid != null) {
            this.statGrid.setStats(stats);
        }
    }

    private Comparator<StatEntry> getSortComparator() {
        return switch (this.sortMode.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> Comparator.comparing(e -> e.getDisplayName().getString());
            case 1 -> Comparator.comparing(e -> e.getDisplayName().getString()).reversed();
            case 2 -> Comparator.comparingLong(StatEntry::getValue);
            case 3 -> Comparator.comparingLong(StatEntry::getValue).reversed();
        };
    }

    private void onStatClicked(StatEntry entry) {
    }

    private void onStatRightClicked(StatEntry entry) {
        if (ModConfig.isPinned(entry.getStatId())) {
            ModConfig.removePinnedStat(entry.getStatId());
            if (this.f_96541_ != null && this.f_96541_.f_91074_ != null) {
                this.f_96541_.f_91074_.m_213846_((Component)Component.m_237115_((String)"gui.beautiful_statistics_screen.unpinned").m_130946_(" ").m_7220_(entry.getDisplayName()));
            }
        } else {
            ModConfig.addPinnedStat(entry.getStatId());
            if (this.f_96541_ != null && this.f_96541_.f_91074_ != null) {
                this.f_96541_.f_91074_.m_213846_((Component)Component.m_237115_((String)"gui.beautiful_statistics_screen.pinned").m_130946_(" ").m_7220_(entry.getDisplayName()));
            }
        }
        this.updateDisplayedStats();
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(graphics);
        this.renderTabs(graphics, mouseX, mouseY);
        graphics.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, 10, 0xFFFFFF);
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
        if (this.statGrid != null) {
            this.statGrid.renderTooltip(graphics, mouseX, mouseY);
        }
    }

    public void m_86600_() {
        super.m_86600_();
        int autoRefreshInterval = ModConfig.getClient().statScreenAutoRefreshTicks;
        if (autoRefreshInterval > 0 && this.f_96541_ != null && this.f_96541_.f_91074_ != null) {
            ++this.tickCounter;
            if (this.tickCounter >= autoRefreshInterval) {
                this.tickCounter = 0;
                StatDataManager.refreshValues(this.f_96541_.f_91074_);
                this.updateDisplayedStats();
            }
        }
    }

    private void renderTabs(GuiGraphics graphics, int mouseX, int mouseY) {
        int tabX = 10;
        int tabY = 60;
        for (StatCategory category : this.categories) {
            boolean hovered;
            boolean selected = category.equals(this.selectedCategory);
            boolean bl = hovered = mouseX >= tabX && mouseX < tabX + 120 && mouseY >= tabY && mouseY < tabY + 24;
            int color = selected ? -2143272896 : (hovered ? 0x60404040 : 0x40404040);
            graphics.m_280509_(tabX, tabY, tabX + 120, tabY + 24, color);
            if (selected && ModConfig.getClient().enableBorders) {
                int borderColor = this.getTabBorderColor();
                graphics.m_280509_(tabX, tabY, tabX + 2, tabY + 24, borderColor);
            }
            String text = category.getDisplayName().getString();
            int textColor = selected ? 0xFFFFFF : (hovered ? 0xCCCCCC : 0x999999);
            graphics.m_280488_(this.f_96547_, text, tabX + 5, tabY + 8, textColor);
            tabY += 26;
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        int tabX = 10;
        int tabY = 60;
        for (StatCategory category : this.categories) {
            if (mouseX >= (double)tabX && mouseX < (double)(tabX + 120) && mouseY >= (double)tabY && mouseY < (double)(tabY + 24)) {
                this.selectCategory(category);
                return true;
            }
            tabY += 26;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    private void selectCategory(StatCategory category) {
        if (!category.equals(this.selectedCategory)) {
            this.selectedCategory = category;
            this.scrollOffset = 0;
            if (ModConfig.getClient().rememberLastTab) {
                ModConfig.getClient().lastSelectedTab = category.getId().m_135815_();
                ModConfig.saveClientConfig();
            }
            if (this.f_96541_ != null && this.f_96541_.f_91074_ != null) {
                StatDataManager.refreshValues(this.f_96541_.f_91074_);
            }
            this.updateDisplayedStats();
        }
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (this.statGrid != null) {
            return this.statGrid.m_6050_(mouseX, mouseY, delta);
        }
        return super.m_6050_(mouseX, mouseY, delta);
    }

    public void m_7379_() {
        if (this.f_96541_ != null) {
            this.f_96541_.m_91152_(this.parent);
        }
    }

    public boolean m_7043_() {
        return ModConfig.getClient().pauseOnStatsScreens;
    }

    private int getTabBorderColor() {
        ModConfig.Client config = ModConfig.getClient();
        double opacity = Math.max(0.0, Math.min(1.0, config.borderOpacity));
        int alpha = (int)(opacity * 255.0);
        return switch (config.theme) {
            default -> throw new IncompatibleClassChangeError();
            case ModConfig.Theme.VANILLA -> alpha << 24 | 0xC6C6C6;
            case ModConfig.Theme.LIGHT -> alpha << 24 | 0x404040;
            case ModConfig.Theme.DARK -> alpha << 24 | 0x4080FF;
        };
    }

    private static enum SortMode {
        NAME_ASC,
        NAME_DESC,
        VALUE_ASC,
        VALUE_DESC;

    }
}

