/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.beautiful_statistics_screen.client.gui;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.texboobcat.beautiful_statistics_screen.client.gui.ConditionDebuggerPanel;
import org.texboobcat.beautiful_statistics_screen.client.gui.ConditionDetailScreen;
import org.texboobcat.beautiful_statistics_screen.client.gui.ScratchBlockRenderer;
import org.texboobcat.beautiful_statistics_screen.custom.conditions.ConditionGroup;
import org.texboobcat.beautiful_statistics_screen.custom.conditions.ConditionalBlock;
import org.texboobcat.beautiful_statistics_screen.custom.conditions.StatCondition;

public class ScratchBlockEditorScreenV2
extends Screen {
    private final Screen parent;
    private final ConditionalBlock rootBlock;
    private final Consumer<ConditionalBlock> onSave;
    private ConditionalBlock draggedBlock;
    private int dragStartX;
    private int dragStartY;
    private ConditionalBlock dragTarget;
    private DropType dragDropType = DropType.NONE;
    private ConditionalBlock selectedBlock;
    private ConditionDebuggerPanel debugger;
    private Button toggleDebuggerButton;
    private static final int CANVAS_START_Y = 110;
    private static final int PALETTE_HEIGHT = 50;
    private static final int DEBUGGER_WIDTH = 250;
    private List<ConditionalBlock> allBlocks = new ArrayList<ConditionalBlock>();

    public ScratchBlockEditorScreenV2(Screen parent, ConditionalBlock rootBlock, Consumer<ConditionalBlock> onSave) {
        super((Component)Component.m_237115_((String)"screen.beautiful_statistics_screen.scratch_editor"));
        this.parent = parent;
        this.rootBlock = rootBlock != null ? rootBlock : new ConditionalBlock();
        this.onSave = onSave;
    }

    protected void m_7856_() {
        super.m_7856_();
        int debuggerX = this.f_96543_ - 250 - 10;
        int debuggerY = 110;
        int debuggerHeight = this.f_96544_ - 110 - 50;
        this.debugger = new ConditionDebuggerPanel(this.f_96541_, debuggerX, debuggerY, 250, debuggerHeight);
        this.debugger.setRootBlock(this.rootBlock);
        this.toggleDebuggerButton = Button.m_253074_((Component)Component.m_237115_((String)"gui.beautiful_statistics_screen.scratch.debugger"), btn -> {
            this.debugger.setVisible(!this.debugger.isVisible());
            this.layoutBlocks();
        }).m_252987_(this.f_96543_ - 30, 10, 20, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.toggleDebuggerButton);
        int paletteY = 50;
        int buttonWidth = 70;
        int spacing = 5;
        int startX = 20;
        Button addIfButton = Button.m_253074_((Component)Component.m_237115_((String)"gui.beautiful_statistics_screen.scratch.add_if"), btn -> this.createBlockFromPalette(ConditionalBlock.BlockType.IF, btn.m_252754_() + btn.m_5711_() / 2, btn.m_252907_() + btn.m_93694_())).m_252987_(startX, paletteY, buttonWidth, 20).m_253136_();
        this.m_142416_((GuiEventListener)addIfButton);
        Button addAndButton = Button.m_253074_((Component)Component.m_237115_((String)"gui.beautiful_statistics_screen.scratch.add_and"), btn -> this.createBlockFromPalette(ConditionalBlock.BlockType.AND, btn.m_252754_() + btn.m_5711_() / 2, btn.m_252907_() + btn.m_93694_())).m_252987_(startX + (buttonWidth + spacing), paletteY, buttonWidth, 20).m_253136_();
        this.m_142416_((GuiEventListener)addAndButton);
        Button addOrButton = Button.m_253074_((Component)Component.m_237115_((String)"gui.beautiful_statistics_screen.scratch.add_or"), btn -> this.createBlockFromPalette(ConditionalBlock.BlockType.OR, btn.m_252754_() + btn.m_5711_() / 2, btn.m_252907_() + btn.m_93694_())).m_252987_(startX + (buttonWidth + spacing) * 2, paletteY, buttonWidth, 20).m_253136_();
        this.m_142416_((GuiEventListener)addOrButton);
        Button addNotButton = Button.m_253074_((Component)Component.m_237115_((String)"gui.beautiful_statistics_screen.scratch.add_not"), btn -> this.createBlockFromPalette(ConditionalBlock.BlockType.NOT, btn.m_252754_() + btn.m_5711_() / 2, btn.m_252907_() + btn.m_93694_())).m_252987_(startX + (buttonWidth + spacing) * 3, paletteY, buttonWidth, 20).m_253136_();
        this.m_142416_((GuiEventListener)addNotButton);
        int paletteY2 = 75;
        Button addXorButton = Button.m_253074_((Component)Component.m_237115_((String)"gui.beautiful_statistics_screen.scratch.add_xor"), btn -> this.createBlockFromPalette(ConditionalBlock.BlockType.XOR, btn.m_252754_() + btn.m_5711_() / 2, btn.m_252907_() + btn.m_93694_())).m_252987_(startX, paletteY2, buttonWidth, 20).m_253136_();
        this.m_142416_((GuiEventListener)addXorButton);
        Button addNandButton = Button.m_253074_((Component)Component.m_237115_((String)"gui.beautiful_statistics_screen.scratch.add_nand"), btn -> this.createBlockFromPalette(ConditionalBlock.BlockType.NAND, btn.m_252754_() + btn.m_5711_() / 2, btn.m_252907_() + btn.m_93694_())).m_252987_(startX + (buttonWidth + spacing), paletteY2, buttonWidth, 20).m_253136_();
        this.m_142416_((GuiEventListener)addNandButton);
        Button addNorButton = Button.m_253074_((Component)Component.m_237115_((String)"gui.beautiful_statistics_screen.scratch.add_nor"), btn -> this.createBlockFromPalette(ConditionalBlock.BlockType.NOR, btn.m_252754_() + btn.m_5711_() / 2, btn.m_252907_() + btn.m_93694_())).m_252987_(startX + (buttonWidth + spacing) * 2, paletteY2, buttonWidth, 20).m_253136_();
        this.m_142416_((GuiEventListener)addNorButton);
        Button addImpliesButton = Button.m_253074_((Component)Component.m_237115_((String)"gui.beautiful_statistics_screen.scratch.add_implies"), btn -> this.createBlockFromPalette(ConditionalBlock.BlockType.IMPLIES, btn.m_252754_() + btn.m_5711_() / 2, btn.m_252907_() + btn.m_93694_())).m_252987_(startX + (buttonWidth + spacing) * 3, paletteY2, buttonWidth, 20).m_253136_();
        this.m_142416_((GuiEventListener)addImpliesButton);
        Button addElseIfButton = Button.m_253074_((Component)Component.m_237115_((String)"gui.beautiful_statistics_screen.scratch.add_else_if"), btn -> this.addElseIf()).m_252987_(startX + (buttonWidth + spacing) * 4, paletteY, buttonWidth, 20).m_253136_();
        this.m_142416_((GuiEventListener)addElseIfButton);
        Button addElseButton = Button.m_253074_((Component)Component.m_237115_((String)"gui.beautiful_statistics_screen.scratch.add_else"), btn -> this.addElse()).m_252987_(startX + (buttonWidth + spacing) * 4, paletteY2, buttonWidth, 20).m_253136_();
        this.m_142416_((GuiEventListener)addElseButton);
        int bottomY = this.f_96544_ - 30;
        Button editButton = Button.m_253074_((Component)Component.m_237115_((String)"gui.beautiful_statistics_screen.edit"), btn -> this.editSelectedBlock()).m_252987_(this.f_96543_ / 2 - 160, bottomY, 70, 20).m_253136_();
        this.m_142416_((GuiEventListener)editButton);
        Button deleteButton = Button.m_253074_((Component)Component.m_237115_((String)"gui.beautiful_statistics_screen.delete"), btn -> this.deleteSelectedBlock()).m_252987_(this.f_96543_ / 2 - 80, bottomY, 70, 20).m_253136_();
        this.m_142416_((GuiEventListener)deleteButton);
        Button clearButton = Button.m_253074_((Component)Component.m_237115_((String)"gui.beautiful_statistics_screen.clear"), btn -> this.clearAll()).m_252987_(this.f_96543_ / 2, bottomY, 70, 20).m_253136_();
        this.m_142416_((GuiEventListener)clearButton);
        Button doneButton = Button.m_253074_((Component)Component.m_237115_((String)"gui.beautiful_statistics_screen.done"), btn -> this.save()).m_252987_(this.f_96543_ / 2 + 80, bottomY, 70, 20).m_253136_();
        this.m_142416_((GuiEventListener)doneButton);
        this.layoutBlocks();
    }

    private void layoutBlocks() {
        this.allBlocks.clear();
        int canvasX = 20;
        int canvasY = 110;
        int canvasWidth = this.debugger.isVisible() ? this.f_96543_ - 250 - 50 : this.f_96543_ - 40;
        this.layoutBlockRecursive(this.rootBlock, canvasX, canvasY, canvasWidth, 0);
    }

    private int layoutBlockRecursive(ConditionalBlock block, int x, int y, int width, int depth) {
        int currentY = y;
        for (ConditionalBlock child : block.getChildren()) {
            child.setX(x + depth * 30);
            child.setY(currentY);
            child.setWidth(Math.min(200, width - depth * 30));
            child.setHeight(60);
            child.setParent(block);
            this.allBlocks.add(child);
            currentY += child.getHeight() + 10;
            if (!child.hasChildren()) continue;
            currentY = this.layoutBlockRecursive(child, x, currentY, width, depth + 1);
        }
        return currentY;
    }

    private void createBlockFromPalette(ConditionalBlock.BlockType type, int x, int y) {
        ConditionalBlock newBlock;
        this.draggedBlock = newBlock = new ConditionalBlock(type);
        this.dragStartX = x - newBlock.getWidth() / 2;
        this.dragStartY = y;
        newBlock.setX(this.dragStartX);
        newBlock.setY(this.dragStartY);
        newBlock.setDragging(true);
        this.f_96541_.m_91152_((Screen)new ConditionDetailScreen(this, newBlock.getCondition() != null ? newBlock.getCondition() : new StatCondition(), condition -> newBlock.setCondition((StatCondition)condition)));
    }

    private void editSelectedBlock() {
        if (this.selectedBlock != null && this.selectedBlock.getType() != ConditionalBlock.BlockType.ELSE) {
            StatCondition condition = this.selectedBlock.getCondition();
            if (condition == null) {
                condition = new StatCondition();
                this.selectedBlock.setCondition(condition);
            }
            this.f_96541_.m_91152_((Screen)new ConditionDetailScreen(this, condition, updatedCondition -> {
                this.selectedBlock.setCondition((StatCondition)updatedCondition);
                this.debugger.setRootBlock(this.rootBlock);
            }));
        }
    }

    private void deleteSelectedBlock() {
        if (this.selectedBlock != null && this.selectedBlock != this.rootBlock) {
            this.removeBlockFromTree(this.rootBlock, this.selectedBlock);
            this.selectedBlock = null;
            this.layoutBlocks();
            this.debugger.setRootBlock(this.rootBlock);
        }
    }

    private boolean removeBlockFromTree(ConditionalBlock parent, ConditionalBlock toRemove) {
        if (parent.getChildren().remove(toRemove)) {
            return true;
        }
        for (ConditionalBlock child : parent.getChildren()) {
            if (!this.removeBlockFromTree(child, toRemove)) continue;
            return true;
        }
        return false;
    }

    private void addElseIf() {
        if (this.selectedBlock != null && this.selectedBlock.getType() == ConditionalBlock.BlockType.IF) {
            ConditionalBlock elseIfBlock = new ConditionalBlock(ConditionalBlock.BlockType.ELSE_IF);
            this.selectedBlock.setElseBlock(elseIfBlock);
            this.layoutBlocks();
            this.debugger.setRootBlock(this.rootBlock);
            this.f_96541_.m_91152_((Screen)new ConditionDetailScreen(this, new StatCondition(), condition -> elseIfBlock.setCondition((StatCondition)condition)));
        }
    }

    private void addElse() {
        if (this.selectedBlock != null && this.selectedBlock.getType() == ConditionalBlock.BlockType.IF) {
            ConditionalBlock elseBlock = new ConditionalBlock(ConditionalBlock.BlockType.ELSE);
            this.selectedBlock.setElseBlock(elseBlock);
            this.layoutBlocks();
            this.debugger.setRootBlock(this.rootBlock);
        }
    }

    private void clearAll() {
        this.rootBlock.getChildren().clear();
        this.selectedBlock = null;
        this.layoutBlocks();
        this.debugger.setRootBlock(this.rootBlock);
    }

    private void save() {
        this.onSave.accept(this.rootBlock);
        this.f_96541_.m_91152_(this.parent);
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        int blockCount;
        this.m_280273_(graphics);
        graphics.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, 15, 0xFFFFFF);
        String instructions = Component.m_237115_((String)"gui.beautiful_statistics_screen.scratch.instruction").getString();
        graphics.m_280137_(this.f_96547_, instructions, this.f_96543_ / 2, 30, 0x888888);
        int canvasWidth = this.debugger.isVisible() ? this.f_96543_ - 250 - 50 : this.f_96543_ - 40;
        graphics.m_280509_(20, 80, 20 + canvasWidth, this.f_96544_ - 40, 0x33000000);
        for (ConditionalBlock block : this.allBlocks) {
            boolean isHovered = block.containsPoint(mouseX, mouseY) && this.draggedBlock == null;
            boolean isSelected = block == this.selectedBlock;
            boolean isDragging = block == this.draggedBlock;
            ScratchBlockRenderer.renderBlock(graphics, block, this.f_96547_, isHovered, isSelected, isDragging);
        }
        if (this.draggedBlock != null) {
            ScratchBlockRenderer.renderBlock(graphics, this.draggedBlock, this.f_96547_, false, false, true);
            if (this.dragTarget != null) {
                int targetColor = this.dragDropType != DropType.NONE ? -2007629995 : -1996532395;
                graphics.m_280509_(this.dragTarget.getX() - 2, this.dragTarget.getY() - 2, this.dragTarget.getX() + this.dragTarget.getWidth() + 2, this.dragTarget.getY() + this.dragTarget.getHeight() + 2, targetColor);
            }
        }
        if (this.debugger.isVisible()) {
            this.debugger.render(graphics, this.f_96547_, mouseX, mouseY);
        }
        String countText = blockCount + " block" + ((blockCount = this.allBlocks.size()) == 1 ? "" : "s");
        graphics.m_280488_(this.f_96547_, countText, 25, 85, 0xAAAAAA);
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (super.m_6375_(mouseX, mouseY, button)) {
            return true;
        }
        for (ConditionalBlock block : this.allBlocks) {
            if (!block.containsPoint((int)mouseX, (int)mouseY)) continue;
            if (button == 0) {
                this.draggedBlock = block;
                this.dragStartX = (int)mouseX - block.getX();
                this.dragStartY = (int)mouseY - block.getY();
                block.setDragging(true);
                this.selectedBlock = block;
                return true;
            }
            if (button != 1) continue;
            this.selectedBlock = block;
            return true;
        }
        this.selectedBlock = null;
        return true;
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.draggedBlock != null) {
            this.draggedBlock.setX((int)mouseX - this.dragStartX);
            this.draggedBlock.setY((int)mouseY - this.dragStartY);
            this.dragTarget = null;
            this.dragDropType = DropType.NONE;
            for (ConditionalBlock block : this.allBlocks) {
                if (block == this.draggedBlock || !block.containsPoint((int)mouseX, (int)mouseY)) continue;
                this.dragTarget = block;
                if (!this.canNestInside(this.dragTarget)) break;
                this.dragDropType = DropType.NEST_INSIDE;
                break;
            }
            return true;
        }
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (this.draggedBlock != null) {
            this.draggedBlock.setDragging(false);
            if (this.dragTarget != null && this.dragDropType == DropType.NEST_INSIDE) {
                if (this.draggedBlock.getParent() != null) {
                    this.draggedBlock.getParent().removeChild(this.draggedBlock);
                } else {
                    this.rootBlock.removeChild(this.draggedBlock);
                }
                this.dragTarget.addChild(this.draggedBlock);
                this.draggedBlock.setParent(this.dragTarget);
            } else if (this.dragTarget == null && this.draggedBlock.getParent() == null && !this.rootBlock.getChildren().contains(this.draggedBlock)) {
                this.rootBlock.addChild(this.draggedBlock);
            }
            this.draggedBlock = null;
            this.dragTarget = null;
            this.dragDropType = DropType.NONE;
            this.layoutBlocks();
            this.debugger.setRootBlock(this.rootBlock);
            return true;
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    private boolean canNestInside(ConditionalBlock block) {
        return block.getType() == ConditionalBlock.BlockType.IF || block.getType() == ConditionalBlock.BlockType.AND || block.getType() == ConditionalBlock.BlockType.OR || block.getType() == ConditionalBlock.BlockType.XOR || block.getType() == ConditionalBlock.BlockType.NAND || block.getType() == ConditionalBlock.BlockType.NOR || block.getType() == ConditionalBlock.BlockType.IMPLIES || block.getType() == ConditionalBlock.BlockType.NOT;
    }

    public void m_7379_() {
        this.f_96541_.m_91152_(this.parent);
    }

    public boolean m_7043_() {
        return false;
    }

    public static ScratchBlockEditorScreenV2 fromConditionGroup(Screen parent, ConditionGroup group, Consumer<ConditionGroup> onSave) {
        ConditionalBlock block = ConditionalBlock.fromConditionGroup(group);
        return new ScratchBlockEditorScreenV2(parent, block, resultBlock -> onSave.accept(resultBlock.toConditionGroup()));
    }

    private static enum DropType {
        NONE,
        NEST_INSIDE,
        INSERT_BEFORE,
        INSERT_AFTER;

    }
}

