/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.beautiful_statistics_screen.client.gui;

import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import org.texboobcat.beautiful_statistics_screen.custom.conditions.ConditionalBlock;

public class ScratchBlockRenderer {
    private static final int NOTCH_WIDTH = 20;
    private static final int NOTCH_HEIGHT = 4;
    private static final int CORNER_RADIUS = 4;
    private static final int SOCKET_INDENT = 15;
    private static final int SOCKET_HEIGHT = 30;

    public static void renderBlock(GuiGraphics graphics, ConditionalBlock block, Font font, boolean isHovered, boolean isSelected, boolean isDragging) {
        int x = block.getX();
        int y = block.getY();
        int width = block.getWidth();
        int height = block.getHeight();
        int color = ScratchBlockRenderer.parseColor(block.getColor());
        if (isDragging) {
            color = ScratchBlockRenderer.applyAlpha(color, 0.7f);
        } else if (isSelected) {
            color = ScratchBlockRenderer.lighten(color, 0.3f);
        } else if (isHovered) {
            color = ScratchBlockRenderer.lighten(color, 0.15f);
        }
        if (!isDragging) {
            graphics.m_280509_(x + 2, y + 2, x + width + 2, y + height + 2, -2013265920);
        }
        ScratchBlockRenderer.renderBlockBody(graphics, x, y, width, height, color);
        if (block.getType() != ConditionalBlock.BlockType.IF) {
            ScratchBlockRenderer.renderTopNotch(graphics, x, y, color);
        }
        ScratchBlockRenderer.renderBottomNotch(graphics, x, y + height, color);
        if (ScratchBlockRenderer.canHaveChildren(block)) {
            ScratchBlockRenderer.renderInnerSocket(graphics, x, y, width, height, ScratchBlockRenderer.darken(color, 0.2f));
        }
        ScratchBlockRenderer.renderBlockText(graphics, block, font, x, y, width);
        if (isHovered || isSelected) {
            int glowColor = isSelected ? 0xFFFFFF : 0xFFFFFF;
            ScratchBlockRenderer.renderGlow(graphics, x, y, width, height, ScratchBlockRenderer.applyAlpha(glowColor, 0.3f));
        }
    }

    private static void renderBlockBody(GuiGraphics graphics, int x, int y, int width, int height, int color) {
        graphics.m_280509_(x + 4, y, x + width - 4, y + height, color);
        graphics.m_280509_(x, y + 4, x + 4, y + height - 4, color);
        graphics.m_280509_(x + width - 4, y + 4, x + width, y + height - 4, color);
        graphics.m_280509_(x + 1, y + 1, x + 4, y + 4, color);
        graphics.m_280509_(x + width - 4, y + 1, x + width - 1, y + 4, color);
        graphics.m_280509_(x + 1, y + height - 4, x + 4, y + height - 1, color);
        graphics.m_280509_(x + width - 4, y + height - 4, x + width - 1, y + height - 1, color);
        int borderColor = ScratchBlockRenderer.darken(color, 0.3f);
        graphics.m_280509_(x + 4, y, x + width - 4, y + 1, borderColor);
        graphics.m_280509_(x + 4, y + height - 1, x + width - 4, y + height, borderColor);
        graphics.m_280509_(x, y + 4, x + 1, y + height - 4, borderColor);
        graphics.m_280509_(x + width - 1, y + 4, x + width, y + height - 4, borderColor);
    }

    private static void renderTopNotch(GuiGraphics graphics, int x, int y, int color) {
        int notchX = x + 15;
        graphics.m_280509_(notchX, y, notchX + 20, y + 4, color);
        graphics.m_280509_(notchX - 2, y + 2, notchX, y + 4, color);
        graphics.m_280509_(notchX + 20, y + 2, notchX + 20 + 2, y + 4, color);
    }

    private static void renderBottomNotch(GuiGraphics graphics, int x, int y, int color) {
        int notchX = x + 15;
        graphics.m_280509_(notchX, y, notchX + 20, y + 4, color);
        graphics.m_280509_(notchX - 2, y, notchX, y + 4 - 2, color);
        graphics.m_280509_(notchX + 20, y, notchX + 20 + 2, y + 4 - 2, color);
    }

    private static void renderInnerSocket(GuiGraphics graphics, int x, int y, int width, int height, int color) {
        int socketY = y + 35;
        int socketHeight = height - 45;
        if (socketHeight > 10) {
            graphics.m_280509_(x + 15, socketY, x + width - 10, socketY + socketHeight, color);
            graphics.m_280509_(x + 15 + 10, socketY - 4, x + 15 + 10 + 20, socketY, color);
        }
    }

    private static void renderBlockText(GuiGraphics graphics, ConditionalBlock block, Font font, int x, int y, int width) {
        int textColor = 0xFFFFFF;
        String typeText = block.getType().getDisplayName();
        graphics.m_280488_(font, typeText, x + 10, y + 8, textColor);
        if (block.hasCondition()) {
            String condText = block.getCondition().getType().getDisplayName() + " " + block.getCondition().getOperator().getSymbol() + " " + block.getCondition().getValue();
            if (condText.length() > 25) {
                condText = condText.substring(0, 22) + "...";
            }
            graphics.m_280488_(font, condText, x + 10, y + 22, 0xEEEEEE);
        }
        if (block.hasChildren()) {
            String childText = "[" + block.getChildren().size() + " nested]";
            graphics.m_280488_(font, childText, x + width - font.m_92895_(childText) - 10, y + 8, 0xCCCCCC);
        }
    }

    private static void renderGlow(GuiGraphics graphics, int x, int y, int width, int height, int color) {
        int glowSize = 2;
        graphics.m_280509_(x - glowSize, y - glowSize, x + width + glowSize, y, color);
        graphics.m_280509_(x - glowSize, y + height, x + width + glowSize, y + height + glowSize, color);
        graphics.m_280509_(x - glowSize, y, x, y + height, color);
        graphics.m_280509_(x + width, y, x + width + glowSize, y + height, color);
    }

    private static boolean canHaveChildren(ConditionalBlock block) {
        return block.getType() == ConditionalBlock.BlockType.IF || block.getType() == ConditionalBlock.BlockType.AND || block.getType() == ConditionalBlock.BlockType.OR || block.getType() == ConditionalBlock.BlockType.NOT || block.getType() == ConditionalBlock.BlockType.XOR || block.getType() == ConditionalBlock.BlockType.NAND || block.getType() == ConditionalBlock.BlockType.NOR || block.getType() == ConditionalBlock.BlockType.IMPLIES;
    }

    private static int parseColor(String hex) {
        try {
            return (int)Long.parseLong(hex.substring(1), 16) | 0xFF000000;
        }
        catch (Exception e) {
            return -11890462;
        }
    }

    private static int lighten(int color, float amount) {
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        r = Math.min(255, (int)((float)r + (float)(255 - r) * amount));
        g = Math.min(255, (int)((float)g + (float)(255 - g) * amount));
        b = Math.min(255, (int)((float)b + (float)(255 - b) * amount));
        return 0xFF000000 | r << 16 | g << 8 | b;
    }

    private static int darken(int color, float amount) {
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        r = (int)((float)r * (1.0f - amount));
        g = (int)((float)g * (1.0f - amount));
        b = (int)((float)b * (1.0f - amount));
        return 0xFF000000 | r << 16 | g << 8 | b;
    }

    private static int applyAlpha(int color, float alpha) {
        int a = (int)(alpha * 255.0f);
        return a << 24 | color & 0xFFFFFF;
    }
}

