/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.beautiful_statistics_screen.client.gui;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import org.texboobcat.beautiful_statistics_screen.api.IconRenderer;
import org.texboobcat.beautiful_statistics_screen.api.StatCategory;
import org.texboobcat.beautiful_statistics_screen.api.StatEntry;
import org.texboobcat.beautiful_statistics_screen.client.gui.StatGridWidget;
import org.texboobcat.beautiful_statistics_screen.core.StatCategoryRegistry;

public class SharedStatsScreen
extends Screen {
    private final Screen parent;
    private final String playerName;
    private final Map<String, Long> stats;
    private final List<StatEntry> statEntries;
    private StatGridWidget statGrid;
    private StatCategory selectedCategory;
    private final List<StatCategory> categories;

    public SharedStatsScreen(Screen parent, String playerName, Map<String, Long> stats) {
        super((Component)Component.m_237113_((String)("Statistics: " + playerName)));
        this.parent = parent;
        this.playerName = playerName;
        this.stats = stats;
        this.statEntries = new ArrayList<StatEntry>();
        this.categories = StatCategoryRegistry.getAllCategories();
        if (!this.categories.isEmpty()) {
            this.selectedCategory = this.categories.get(0);
        }
        this.convertStatsToEntries();
    }

    private void convertStatsToEntries() {
        for (Map.Entry<String, Long> entry : this.stats.entrySet()) {
            try {
                ResourceLocation statId = new ResourceLocation(entry.getKey());
                StatCategory category = StatCategoryRegistry.findCategory(statId);
                MutableComponent displayName = Component.m_237115_((String)("stat." + statId.m_135827_() + "." + statId.m_135815_()));
                MutableComponent description = Component.m_237119_();
                StatEntry statEntry = new StatEntry(statId, category, entry.getValue(), (Component)displayName, (Component)description, IconRenderer.EMPTY);
                this.statEntries.add(statEntry);
            }
            catch (Exception exception) {}
        }
    }

    protected void m_7856_() {
        super.m_7856_();
        int titleY = 10;
        int buttonWidth = 80;
        int buttonSpacing = 5;
        int totalWidth = this.categories.size() * (buttonWidth + buttonSpacing);
        int startX = (this.f_96543_ - totalWidth) / 2;
        int y = 35;
        for (int i = 0; i < this.categories.size(); ++i) {
            StatCategory category = this.categories.get(i);
            int x = startX + i * (buttonWidth + buttonSpacing);
            Button categoryButton = Button.m_253074_((Component)Component.m_237113_((String)category.getDisplayName().getString()), btn -> this.selectCategory(category)).m_252987_(x, y, buttonWidth, 20).m_253136_();
            this.m_142416_((GuiEventListener)categoryButton);
        }
        int gridY = 65;
        int gridWidth = this.f_96543_ - 40;
        int gridHeight = this.f_96544_ - gridY - 50;
        this.statGrid = new StatGridWidget(this.f_96541_, 20, gridY, gridWidth, gridHeight, this::onStatClicked, this::onStatRightClicked);
        this.m_142416_((GuiEventListener)this.statGrid);
        Button backButton = Button.m_253074_((Component)Component.m_237115_((String)"gui.done"), btn -> this.m_7379_()).m_252987_((this.f_96543_ - 200) / 2, this.f_96544_ - 30, 200, 20).m_253136_();
        this.m_142416_((GuiEventListener)backButton);
        this.updateDisplayedStats();
    }

    private void selectCategory(StatCategory category) {
        this.selectedCategory = category;
        this.updateDisplayedStats();
        this.m_6575_(this.f_96541_, this.f_96543_, this.f_96544_);
    }

    private void updateDisplayedStats() {
        if (this.statGrid == null) {
            return;
        }
        ArrayList<StatEntry> filtered = new ArrayList<StatEntry>();
        for (StatEntry entry : this.statEntries) {
            if (this.selectedCategory != null && !entry.getCategory().equals(this.selectedCategory)) continue;
            filtered.add(entry);
        }
        filtered.sort((a, b) -> Long.compare(b.getValue(), a.getValue()));
        this.statGrid.setStats(filtered);
    }

    private void onStatClicked(StatEntry entry) {
    }

    private void onStatRightClicked(StatEntry entry) {
        if (this.f_96541_ != null && this.f_96541_.f_91074_ != null) {
            this.f_96541_.f_91074_.m_213846_((Component)Component.m_237113_((String)"\u00a77Compare feature coming soon"));
        }
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(graphics);
        graphics.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, 10, 0xFFFFFF);
        String info = "\u00a77Viewing stats for: \u00a7f" + this.playerName + " \u00a77(\u00a7e" + this.stats.size() + " stats\u00a77)";
        graphics.m_280653_(this.f_96547_, (Component)Component.m_237113_((String)info), this.f_96543_ / 2, 22, 0xFFFFFF);
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
        if (this.statGrid != null) {
            this.statGrid.renderTooltip(graphics, mouseX, mouseY);
        }
    }

    public void m_7379_() {
        if (this.f_96541_ != null) {
            this.f_96541_.m_91152_(this.parent);
        }
    }

    public boolean m_7043_() {
        return false;
    }
}

