/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.beautiful_statistics_screen.client.gui;

import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.texboobcat.beautiful_statistics_screen.client.gui.SnapshotDetailScreen;
import org.texboobcat.beautiful_statistics_screen.snapshot.SnapshotManager;

public class SnapshotViewerScreen
extends Screen {
    private static final int ENTRY_HEIGHT = 50;
    private static final int PADDING = 10;
    private final Screen parent;
    private List<SnapshotManager.SnapshotInfo> snapshots;
    private int scrollOffset = 0;
    private SnapshotManager.SnapshotInfo selectedSnapshot = null;

    public SnapshotViewerScreen(Screen parent) {
        super((Component)Component.m_237115_((String)"screen.beautiful_statistics_screen.snapshots"));
        this.parent = parent;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.snapshots = SnapshotManager.listSnapshots();
        Button refreshButton = Button.m_253074_((Component)Component.m_237115_((String)"gui.beautiful_statistics_screen.refresh"), btn -> this.refresh()).m_252987_(this.f_96543_ - 90, 10, 80, 20).m_253136_();
        this.m_142416_((GuiEventListener)refreshButton);
        Button viewButton = Button.m_253074_((Component)Component.m_237115_((String)"gui.beautiful_statistics_screen.view"), btn -> this.viewSelected()).m_252987_(this.f_96543_ / 2 - 205, this.f_96544_ - 30, 100, 20).m_253136_();
        this.m_142416_((GuiEventListener)viewButton);
        Button deleteButton = Button.m_253074_((Component)Component.m_237115_((String)"gui.beautiful_statistics_screen.delete"), btn -> this.deleteSelected()).m_252987_(this.f_96543_ / 2 - 100, this.f_96544_ - 30, 100, 20).m_253136_();
        this.m_142416_((GuiEventListener)deleteButton);
        Button backButton = Button.m_253074_((Component)Component.m_237115_((String)"gui.done"), btn -> this.m_7379_()).m_252987_(this.f_96543_ / 2 + 5, this.f_96544_ - 30, 100, 20).m_253136_();
        this.m_142416_((GuiEventListener)backButton);
        Button exportButton = Button.m_253074_((Component)Component.m_237115_((String)"gui.beautiful_statistics_screen.export_new"), btn -> this.exportNew()).m_252987_(this.f_96543_ / 2 + 110, this.f_96544_ - 30, 100, 20).m_253136_();
        this.m_142416_((GuiEventListener)exportButton);
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(graphics);
        graphics.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, 15, 0xFFFFFF);
        this.renderSnapshotList(graphics, mouseX, mouseY);
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
    }

    private void renderSnapshotList(GuiGraphics graphics, int mouseX, int mouseY) {
        int listX = 10;
        int listY = 40;
        int listWidth = this.f_96543_ - 20;
        int listHeight = this.f_96544_ - 80;
        graphics.m_280509_(listX, listY, listX + listWidth, listY + listHeight, Integer.MIN_VALUE);
        if (this.snapshots.isEmpty()) {
            String text = "No snapshots found";
            int textWidth = this.f_96547_.m_92895_(text);
            graphics.m_280488_(this.f_96547_, text, listX + (listWidth - textWidth) / 2, listY + listHeight / 2, 0x888888);
            return;
        }
        int entryY = listY + 10 - this.scrollOffset;
        for (SnapshotManager.SnapshotInfo snapshot : this.snapshots) {
            if (entryY + 50 < listY || entryY > listY + listHeight) {
                entryY += 60;
                continue;
            }
            boolean selected = snapshot == this.selectedSnapshot;
            boolean hovered = mouseX >= listX + 10 && mouseX < listX + listWidth - 10 && mouseY >= entryY && mouseY < entryY + 50;
            this.renderSnapshotEntry(graphics, snapshot, listX + 10, entryY, listWidth - 20, selected, hovered);
            entryY += 60;
        }
    }

    private void renderSnapshotEntry(GuiGraphics graphics, SnapshotManager.SnapshotInfo snapshot, int x, int y, int width, boolean selected, boolean hovered) {
        int bgColor = selected ? -2141167520 : (hovered ? 0x60404040 : 0x40404040);
        graphics.m_280509_(x, y, x + width, y + 50, bgColor);
        if (selected) {
            graphics.m_280509_(x, y, x + width, y + 2, -16711681);
            graphics.m_280509_(x, y + 50 - 2, x + width, y + 50, -16711681);
        }
        int textX = x + 5;
        int textY = y + 5;
        graphics.m_280488_(this.f_96547_, snapshot.filename, textX, textY, 0xFFFFFF);
        String playerText = "Player: " + snapshot.playerName;
        graphics.m_280488_(this.f_96547_, playerText, textX, textY += 12, 0xCCCCCC);
        String timeText = snapshot.getFormattedTimestamp();
        int timeWidth = this.f_96547_.m_92895_(timeText);
        graphics.m_280488_(this.f_96547_, timeText, x + width - timeWidth - 5, textY, 0xCCCCCC);
        String statText = snapshot.statCount + " statistics";
        graphics.m_280488_(this.f_96547_, statText, textX, textY += 12, 0x888888);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        int listX = 10;
        int listY = 40;
        int listWidth = this.f_96543_ - 20;
        int listHeight = this.f_96544_ - 80;
        if (mouseX >= (double)(listX + 10) && mouseX < (double)(listX + listWidth - 10) && mouseY >= (double)(listY + 10) && mouseY < (double)(listY + listHeight - 10)) {
            int entryY = listY + 10 - this.scrollOffset;
            for (SnapshotManager.SnapshotInfo snapshot : this.snapshots) {
                if (mouseY >= (double)entryY && mouseY < (double)(entryY + 50)) {
                    if (button == 0) {
                        this.selectedSnapshot = snapshot;
                        return true;
                    }
                    if (button == 1) {
                        this.viewSnapshot(snapshot);
                        return true;
                    }
                }
                entryY += 60;
            }
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        int maxScroll = Math.max(0, this.snapshots.size() * 60 - (this.f_96544_ - 120));
        this.scrollOffset = Math.max(0, Math.min(maxScroll, this.scrollOffset - (int)(delta * 20.0)));
        return true;
    }

    private void refresh() {
        this.snapshots = SnapshotManager.listSnapshots();
        this.selectedSnapshot = null;
        this.scrollOffset = 0;
    }

    private void viewSelected() {
        if (this.selectedSnapshot != null) {
            this.viewSnapshot(this.selectedSnapshot);
        }
    }

    private void viewSnapshot(SnapshotManager.SnapshotInfo snapshot) {
        block3: {
            try {
                SnapshotManager.SnapshotData data = SnapshotManager.importSnapshot(snapshot.path);
                if (this.f_96541_ != null) {
                    this.f_96541_.m_91152_((Screen)new SnapshotDetailScreen(this, snapshot, data));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                if (this.f_96541_ == null || this.f_96541_.f_91074_ == null) break block3;
                this.f_96541_.f_91074_.m_213846_((Component)Component.m_237113_((String)("Failed to load snapshot: " + e.getMessage())));
            }
        }
    }

    private void deleteSelected() {
        if (this.selectedSnapshot != null) {
            if (SnapshotManager.deleteSnapshot(this.selectedSnapshot.path)) {
                this.snapshots.remove(this.selectedSnapshot);
                this.selectedSnapshot = null;
                if (this.f_96541_ != null && this.f_96541_.f_91074_ != null) {
                    this.f_96541_.f_91074_.m_213846_((Component)Component.m_237113_((String)"Snapshot deleted"));
                }
            } else if (this.f_96541_ != null && this.f_96541_.f_91074_ != null) {
                this.f_96541_.f_91074_.m_213846_((Component)Component.m_237113_((String)"Failed to delete snapshot"));
            }
        }
    }

    private void exportNew() {
        boolean success = SnapshotManager.exportSnapshot(null, true);
        if (success) {
            this.refresh();
        }
    }

    public void m_7379_() {
        if (this.f_96541_ != null) {
            this.f_96541_.m_91152_(this.parent);
        }
    }

    public boolean m_7043_() {
        return false;
    }
}

