/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.beautiful_statistics_screen.client.gui;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.texboobcat.beautiful_statistics_screen.config.ModConfig;
import org.texboobcat.beautiful_statistics_screen.history.HistoryManager;
import org.texboobcat.beautiful_statistics_screen.snapshot.SnapshotManager;
import org.texboobcat.beautiful_statistics_screen.util.StatFormatter;

public class StatGraphScreen
extends Screen {
    private static final int PADDING = 10;
    private static final int MAX_DATA_POINTS = 500;
    private final Screen parent;
    private final ResourceLocation statId;
    private final Component statName;
    private List<Point> series = new ArrayList<Point>();
    private long minTime;
    private long maxTime;
    private long minVal;
    private long maxVal;
    private ChartType chartType = ChartType.LINE;
    private TimeRange timeRange = TimeRange.ALL;
    private boolean useHistory = true;
    private Point hoveredPoint = null;
    private int hoveredScreenX = -1;
    private int hoveredScreenY = -1;

    public StatGraphScreen(Screen parent, ResourceLocation statId, Component statName) {
        super((Component)Component.m_237115_((String)"screen.beautiful_statistics_screen.stat_graph"));
        this.parent = parent;
        this.statId = statId;
        this.statName = statName;
    }

    protected void m_7856_() {
        super.m_7856_();
        int buttonY = 40;
        int buttonX = 10;
        int buttonW = 90;
        int spacing = 5;
        Button chartTypeBtn = Button.m_253074_((Component)Component.m_237113_((String)("Chart: " + this.chartType.label)), b -> {
            this.chartType = this.chartType.next();
            b.m_93666_((Component)Component.m_237113_((String)("Chart: " + this.chartType.label)));
        }).m_252987_(buttonX, buttonY, buttonW, 20).m_253136_();
        this.m_142416_((GuiEventListener)chartTypeBtn);
        Button timeRangeBtn = Button.m_253074_((Component)Component.m_237113_((String)("Range: " + this.timeRange.label)), b -> {
            this.timeRange = this.timeRange.next();
            b.m_93666_((Component)Component.m_237113_((String)("Range: " + this.timeRange.label)));
            this.reload();
        }).m_252987_(buttonX += buttonW + spacing, buttonY, buttonW + 20, 20).m_253136_();
        this.m_142416_((GuiEventListener)timeRangeBtn);
        Button sourceBtn = Button.m_253074_((Component)Component.m_237113_((String)("Source: " + (this.useHistory ? "History" : "Snapshots"))), b -> {
            this.useHistory = !this.useHistory;
            b.m_93666_((Component)Component.m_237113_((String)("Source: " + (this.useHistory ? "History" : "Snapshots"))));
            this.reload();
        }).m_252987_(buttonX += buttonW + 20 + spacing, buttonY, buttonW + 20, 20).m_253136_();
        this.m_142416_((GuiEventListener)sourceBtn);
        if (this.useHistory) {
            Button clearHistoryBtn = Button.m_253074_((Component)Component.m_237113_((String)"\u00a7cClear History"), b -> {
                if (this.f_96541_ != null) {
                    this.f_96541_.m_91152_((Screen)new ConfirmClearStatHistoryScreen(this, this.statId, this.statName));
                }
            }).m_252987_(buttonX += buttonW + 20 + spacing, buttonY, buttonW + 20, 20).m_253136_();
            this.m_142416_((GuiEventListener)clearHistoryBtn);
        }
        Button refresh = Button.m_253074_((Component)Component.m_237113_((String)"\u21bb Refresh"), b -> this.reload()).m_252987_(this.f_96543_ - buttonW - 10, buttonY, buttonW, 20).m_253136_();
        this.m_142416_((GuiEventListener)refresh);
        Button back = Button.m_253074_((Component)Component.m_237115_((String)"gui.done"), b -> this.m_7379_()).m_252987_((this.f_96543_ - 200) / 2, this.f_96544_ - 28, 200, 20).m_253136_();
        this.m_142416_((GuiEventListener)back);
        this.reload();
    }

    public void reload() {
        this.series.clear();
        if (this.useHistory) {
            List<HistoryManager.DataPoint> history = HistoryManager.getHistory(this.statId);
            cutoffTime = System.currentTimeMillis() - this.timeRange.milliseconds;
            for (HistoryManager.DataPoint dp : history) {
                if (this.timeRange != TimeRange.ALL && dp.timestamp < cutoffTime) continue;
                this.series.add(new Point(dp.timestamp, dp.value));
            }
            if (this.series.size() > 500) {
                int step = this.series.size() / 500;
                ArrayList<Point> sampled = new ArrayList<Point>();
                for (int i2 = 0; i2 < this.series.size(); i2 += step) {
                    sampled.add(this.series.get(i2));
                }
                if (!this.series.isEmpty() && !sampled.contains(this.series.get(this.series.size() - 1))) {
                    sampled.add(this.series.get(this.series.size() - 1));
                }
                this.series = sampled;
            }
        } else {
            List<SnapshotManager.SnapshotInfo> infos = SnapshotManager.listSnapshots();
            infos.sort(Comparator.comparingLong(i -> i.timestamp));
            cutoffTime = System.currentTimeMillis() - this.timeRange.milliseconds;
            for (SnapshotManager.SnapshotInfo info : infos) {
                if (this.timeRange != TimeRange.ALL && info.timestamp < cutoffTime) continue;
                try {
                    SnapshotManager.SnapshotData data = SnapshotManager.importSnapshot(info.path);
                    Long val = data.stats.get(this.statId.toString());
                    if (val == null) {
                        val = 0L;
                    }
                    this.series.add(new Point(info.timestamp, val));
                }
                catch (Exception exception) {}
            }
        }
        if (this.series.isEmpty()) {
            this.minTime = this.maxTime = System.currentTimeMillis();
            this.minVal = 0L;
            this.maxVal = 1L;
            return;
        }
        this.series.sort(Comparator.comparingLong(p -> p.t));
        this.minTime = this.series.get((int)0).t;
        this.maxTime = this.series.get((int)(this.series.size() - 1)).t;
        this.minVal = Long.MAX_VALUE;
        this.maxVal = Long.MIN_VALUE;
        for (Point p2 : this.series) {
            this.minVal = Math.min(this.minVal, p2.v);
            this.maxVal = Math.max(this.maxVal, p2.v);
        }
        if (this.minVal == this.maxVal) {
            this.maxVal = this.minVal + 1L;
        }
    }

    public void m_88315_(GuiGraphics g, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(g);
        g.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, 8, 0xFFFFFF);
        g.m_280488_(this.f_96547_, this.statName.getString(), 10, 25, 0xCCCCCC);
        int gx = 50;
        int gy = 70;
        int gw = this.f_96543_ - 20 - 40;
        int gh = this.f_96544_ - gy - 60;
        g.m_280509_(gx, gy, gx + gw, gy + gh, Integer.MIN_VALUE);
        if (this.series.isEmpty()) {
            String msg = this.useHistory ? "No history data. Play for a while and it will be logged automatically." : "No snapshots found. Switch to History mode or create snapshots.";
            int tw = this.f_96547_.m_92895_(msg);
            g.m_280488_(this.f_96547_, msg, gx + (gw - tw) / 2, gy + gh / 2, 0x888888);
        } else {
            g.m_280509_(gx, gy + gh - 1, gx + gw, gy + gh, -10461088);
            g.m_280509_(gx, gy, gx + 1, gy + gh, -10461088);
            String minLabel = StatFormatter.formatValue(this.minVal);
            String maxLabel = StatFormatter.formatValue(this.maxVal);
            g.m_280488_(this.f_96547_, maxLabel, gx - this.f_96547_.m_92895_(maxLabel) - 4, gy + 2, 0xAAAAAA);
            g.m_280488_(this.f_96547_, minLabel, gx - this.f_96547_.m_92895_(minLabel) - 4, gy + gh - 10, 0xAAAAAA);
            long midVal = (this.minVal + this.maxVal) / 2L;
            String midLabel = StatFormatter.formatValue(midVal);
            g.m_280488_(this.f_96547_, midLabel, gx - this.f_96547_.m_92895_(midLabel) - 4, gy + gh / 2 - 4, 0xAAAAAA);
            g.m_280509_(gx, gy + gh / 2, gx + gw, gy + gh / 2 + 1, 0x40FFFFFF);
            switch (this.chartType.ordinal()) {
                case 0: {
                    this.renderLineChart(g, gx, gy, gw, gh);
                    break;
                }
                case 1: {
                    this.renderBarChart(g, gx, gy, gw, gh);
                    break;
                }
                case 2: {
                    this.renderAreaChart(g, gx, gy, gw, gh);
                }
            }
            Point last = this.series.get(this.series.size() - 1);
            Point first = this.series.get(0);
            long change = last.v - first.v;
            String changeStr = (change >= 0L ? "+" : "") + StatFormatter.formatValue(change);
            String infoText = "Latest: " + StatFormatter.formatValue(last.v) + " | Change: " + changeStr + " | Points: " + this.series.size();
            g.m_280488_(this.f_96547_, infoText, gx + 4, gy + 4, 0xFFFFFF);
            SimpleDateFormat sdf = new SimpleDateFormat("MMM dd HH:mm");
            String startTime = sdf.format(new Date(this.minTime));
            String endTime = sdf.format(new Date(this.maxTime));
            g.m_280488_(this.f_96547_, startTime, gx + 4, gy + gh + 4, 0x888888);
            g.m_280488_(this.f_96547_, endTime, gx + gw - this.f_96547_.m_92895_(endTime) - 4, gy + gh + 4, 0x888888);
            this.detectHoveredPoint(mouseX, mouseY, gx, gy, gw, gh);
            if (this.hoveredPoint != null) {
                this.renderHoverTooltip(g, gx, gy, gw, gh);
            }
        }
        super.m_88315_(g, mouseX, mouseY, partialTick);
    }

    private void detectHoveredPoint(int mouseX, int mouseY, int gx, int gy, int gw, int gh) {
        this.hoveredPoint = null;
        this.hoveredScreenX = -1;
        this.hoveredScreenY = -1;
        if (mouseX < gx || mouseX > gx + gw || mouseY < gy || mouseY > gy + gh) {
            return;
        }
        if (this.series.isEmpty()) {
            return;
        }
        long tSpan = Math.max(1L, this.maxTime - this.minTime);
        double pxPerMs = (double)gw / (double)tSpan;
        double pxPerVal = (double)gh / (double)(this.maxVal - this.minVal);
        Point nearest = null;
        int nearestX = -1;
        int nearestY = -1;
        int minDist = Integer.MAX_VALUE;
        for (Point p : this.series) {
            int px = gx + (int)((double)(p.t - this.minTime) * pxPerMs);
            int py = gy + gh - (int)((double)(p.v - this.minVal) * pxPerVal);
            int dist = Math.abs(px - mouseX);
            if (dist >= minDist) continue;
            minDist = dist;
            nearest = p;
            nearestX = px;
            nearestY = py;
        }
        if (nearest != null && minDist < 50) {
            this.hoveredPoint = nearest;
            this.hoveredScreenX = nearestX;
            this.hoveredScreenY = nearestY;
        }
    }

    private void renderHoverTooltip(GuiGraphics g, int gx, int gy, int gw, int gh) {
        if (this.hoveredPoint == null) {
            return;
        }
        g.m_280509_(this.hoveredScreenX, gy, this.hoveredScreenX + 1, gy + gh, -2130728448);
        g.m_280509_(this.hoveredScreenX - 3, this.hoveredScreenY - 3, this.hoveredScreenX + 3, this.hoveredScreenY + 3, -22016);
        g.m_280509_(this.hoveredScreenX - 2, this.hoveredScreenY - 2, this.hoveredScreenX + 2, this.hoveredScreenY + 2, -256);
        SimpleDateFormat sdf = new SimpleDateFormat("MMM dd HH:mm:ss");
        String timeStr = sdf.format(new Date(this.hoveredPoint.t));
        String valueStr = "Value: " + StatFormatter.formatStatValue(this.statId, this.hoveredPoint.v);
        Objects.requireNonNull(this.f_96547_);
        int lineHeight = 9;
        int tooltipWidth = Math.max(this.f_96547_.m_92895_(timeStr), this.f_96547_.m_92895_(valueStr)) + 8;
        int tooltipHeight = lineHeight * 2 + 8;
        int tooltipX = this.hoveredScreenX + 10;
        int tooltipY = this.hoveredScreenY - tooltipHeight / 2;
        if (tooltipX + tooltipWidth > gx + gw) {
            tooltipX = this.hoveredScreenX - tooltipWidth - 10;
        }
        if (tooltipY < gy) {
            tooltipY = gy;
        }
        if (tooltipY + tooltipHeight > gy + gh) {
            tooltipY = gy + gh - tooltipHeight;
        }
        g.m_280509_(tooltipX, tooltipY, tooltipX + tooltipWidth, tooltipY + tooltipHeight, -536870912);
        int borderColor = -22016;
        g.m_280509_(tooltipX, tooltipY, tooltipX + tooltipWidth, tooltipY + 1, borderColor);
        g.m_280509_(tooltipX, tooltipY + tooltipHeight - 1, tooltipX + tooltipWidth, tooltipY + tooltipHeight, borderColor);
        g.m_280509_(tooltipX, tooltipY, tooltipX + 1, tooltipY + tooltipHeight, borderColor);
        g.m_280509_(tooltipX + tooltipWidth - 1, tooltipY, tooltipX + tooltipWidth, tooltipY + tooltipHeight, borderColor);
        g.m_280488_(this.f_96547_, timeStr, tooltipX + 4, tooltipY + 4, 0xFFFFFF);
        g.m_280488_(this.f_96547_, valueStr, tooltipX + 4, tooltipY + 4 + lineHeight, 0xFFFFFF);
    }

    private void renderLineChart(GuiGraphics g, int gx, int gy, int gw, int gh) {
        long tSpan = Math.max(1L, this.maxTime - this.minTime);
        double pxPerMs = (double)gw / (double)tSpan;
        double pxPerVal = (double)gh / (double)(this.maxVal - this.minVal);
        int prevX = -1;
        int prevY = -1;
        for (Point p : this.series) {
            int x = gx + (int)((double)(p.t - this.minTime) * pxPerMs);
            int y = gy + gh - (int)((double)(p.v - this.minVal) * pxPerVal);
            if (prevX >= 0) {
                this.drawLine(g, prevX, prevY, x, y, -16733441);
            }
            g.m_280509_(x - 2, y - 2, x + 2, y + 2, -22016);
            prevX = x;
            prevY = y;
        }
    }

    private void renderBarChart(GuiGraphics g, int gx, int gy, int gw, int gh) {
        if (this.series.isEmpty()) {
            return;
        }
        long tSpan = Math.max(1L, this.maxTime - this.minTime);
        double pxPerMs = (double)gw / (double)tSpan;
        double pxPerVal = (double)gh / (double)(this.maxVal - this.minVal);
        int barWidth = Math.max(2, gw / this.series.size());
        barWidth = Math.min(barWidth, 20);
        for (Point p : this.series) {
            int x = gx + (int)((double)(p.t - this.minTime) * pxPerMs);
            int barHeight = (int)((double)(p.v - this.minVal) * pxPerVal);
            int y = gy + gh - barHeight;
            if (barHeight <= 0) continue;
            int bottomHeight = barHeight / 2;
            g.m_280509_(x - barWidth / 2, y + bottomHeight, x + barWidth / 2, y + barHeight, -16750934);
            if (bottomHeight <= 0) continue;
            g.m_280509_(x - barWidth / 2, y, x + barWidth / 2, y + bottomHeight, -16733441);
        }
    }

    private void renderAreaChart(GuiGraphics g, int gx, int gy, int gw, int gh) {
        long tSpan = Math.max(1L, this.maxTime - this.minTime);
        double pxPerMs = (double)gw / (double)tSpan;
        double pxPerVal = (double)gh / (double)(this.maxVal - this.minVal);
        int prevX = -1;
        int prevY = -1;
        for (Point p : this.series) {
            int x = gx + (int)((double)(p.t - this.minTime) * pxPerMs);
            int y = gy + gh - (int)((double)(p.v - this.minVal) * pxPerVal);
            g.m_280509_(x, y, x + 1, gy + gh, 1610656511);
            if (prevX >= 0) {
                this.drawLine(g, prevX, prevY, x, y, -16711766);
            }
            prevX = x;
            prevY = y;
        }
    }

    private int blendColors(int color1, int color2, float ratio) {
        int a1 = color1 >> 24 & 0xFF;
        int r1 = color1 >> 16 & 0xFF;
        int g1 = color1 >> 8 & 0xFF;
        int b1 = color1 & 0xFF;
        int a2 = color2 >> 24 & 0xFF;
        int r2 = color2 >> 16 & 0xFF;
        int g2 = color2 >> 8 & 0xFF;
        int b2 = color2 & 0xFF;
        int a = (int)((float)a1 + (float)(a2 - a1) * ratio);
        int r = (int)((float)r1 + (float)(r2 - r1) * ratio);
        int g = (int)((float)g1 + (float)(g2 - g1) * ratio);
        int b = (int)((float)b1 + (float)(b2 - b1) * ratio);
        return a << 24 | r << 16 | g << 8 | b;
    }

    private void drawLine(GuiGraphics g, int x1, int y1, int x2, int y2, int color) {
        int dx = Math.abs(x2 - x1);
        int dy = Math.abs(y2 - y1);
        int sx = x1 < x2 ? 1 : -1;
        int sy = y1 < y2 ? 1 : -1;
        int err = dx - dy;
        int x = x1;
        int y = y1;
        while (true) {
            g.m_280509_(x, y, x + 1, y + 1, color);
            if (x == x2 && y == y2) break;
            int e2 = 2 * err;
            if (e2 > -dy) {
                err -= dy;
                x += sx;
            }
            if (e2 >= dx) continue;
            err += dx;
            y += sy;
        }
    }

    public void m_7379_() {
        if (this.f_96541_ != null) {
            this.f_96541_.m_91152_(this.parent);
        }
    }

    public boolean m_7043_() {
        return ModConfig.getClient().pauseOnStatsScreens;
    }

    private static enum ChartType {
        LINE("Line"),
        BAR("Bar"),
        AREA("Area");

        final String label;

        private ChartType(String label) {
            this.label = label;
        }

        ChartType next() {
            return ChartType.values()[(this.ordinal() + 1) % ChartType.values().length];
        }
    }

    private static enum TimeRange {
        HOUR("1 Hour", 3600000L),
        DAY("24 Hours", 86400000L),
        WEEK("7 Days", 604800000L),
        MONTH("30 Days", 2592000000L),
        ALL("All Time", Long.MAX_VALUE);

        final String label;
        final long milliseconds;

        private TimeRange(String label, long milliseconds) {
            this.label = label;
            this.milliseconds = milliseconds;
        }

        TimeRange next() {
            return TimeRange.values()[(this.ordinal() + 1) % TimeRange.values().length];
        }
    }

    private record Point(long t, long v) {
    }

    private static class ConfirmClearStatHistoryScreen
    extends Screen {
        private final Screen parent;
        private final ResourceLocation statId;
        private final Component statName;

        public ConfirmClearStatHistoryScreen(Screen parent, ResourceLocation statId, Component statName) {
            super((Component)Component.m_237113_((String)"Confirm Clear History"));
            this.parent = parent;
            this.statId = statId;
            this.statName = statName;
        }

        protected void m_7856_() {
            super.m_7856_();
            int centerX = this.f_96543_ / 2;
            int centerY = this.f_96544_ / 2;
            this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"\u00a7cYes, Clear History"), btn -> {
                Screen patt0$temp;
                HistoryManager.clearHistory(this.statId);
                if (this.f_96541_ != null && this.f_96541_.f_91074_ != null) {
                    this.f_96541_.f_91074_.m_213846_((Component)Component.m_237113_((String)"\u00a7aHistory cleared for: ").m_7220_(this.statName));
                }
                if ((patt0$temp = this.parent) instanceof StatGraphScreen) {
                    StatGraphScreen graphScreen = (StatGraphScreen)patt0$temp;
                    this.f_96541_.m_91152_(this.parent);
                    graphScreen.reload();
                } else {
                    this.f_96541_.m_91152_(this.parent);
                }
            }).m_252987_(centerX - 100, centerY + 20, 200, 20).m_253136_());
            this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Cancel"), btn -> this.f_96541_.m_91152_(this.parent)).m_252987_(centerX - 100, centerY + 45, 200, 20).m_253136_());
        }

        public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
            this.m_280273_(graphics);
            int centerX = this.f_96543_ / 2;
            int centerY = this.f_96544_ / 2;
            graphics.m_280137_(this.f_96547_, "\u00a7c\u00a7lWarning!", centerX, centerY - 50, 0xFFFFFF);
            graphics.m_280137_(this.f_96547_, "Clear history for:", centerX, centerY - 30, 0xFFFFFF);
            graphics.m_280653_(this.f_96547_, this.statName, centerX, centerY - 15, 0xFFFF00);
            graphics.m_280137_(this.f_96547_, "This cannot be undone!", centerX, centerY, 0xFF5555);
            super.m_88315_(graphics, mouseX, mouseY, partialTick);
        }

        public boolean m_7043_() {
            return true;
        }
    }
}

