/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.beautiful_statistics_screen.client.gui;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import org.texboobcat.beautiful_statistics_screen.api.StatEntry;
import org.texboobcat.beautiful_statistics_screen.config.ModConfig;
import org.texboobcat.beautiful_statistics_screen.util.StatFormatter;

public class StatGridWidget
extends AbstractWidget {
    private static final int ITEM_SIZE = 40;
    private static final int ITEM_SPACING = 5;
    private static final int PADDING = 5;
    private final Minecraft minecraft;
    private List<StatEntry> stats = new ArrayList<StatEntry>();
    private int scrollOffset = 0;
    private final Consumer<StatEntry> onLeftClick;
    private final Consumer<StatEntry> onRightClick;
    private StatEntry hoveredEntry = null;

    public StatGridWidget(Minecraft minecraft, int x, int y, int width, int height, Consumer<StatEntry> onLeftClick, Consumer<StatEntry> onRightClick) {
        super(x, y, width, height, (Component)Component.m_237119_());
        this.minecraft = minecraft;
        this.onLeftClick = onLeftClick;
        this.onRightClick = onRightClick;
    }

    public void setStats(List<StatEntry> stats) {
        this.stats = new ArrayList<StatEntry>(stats);
        if (this.scrollOffset > this.getMaxScroll()) {
            this.scrollOffset = Math.max(0, this.getMaxScroll());
        }
    }

    public void m_87963_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        int y;
        int x;
        int row;
        int col;
        graphics.m_280509_(this.m_252754_(), this.m_252907_(), this.m_252754_() + this.f_93618_, this.m_252907_() + this.f_93619_, Integer.MIN_VALUE);
        graphics.m_280588_(this.m_252754_(), this.m_252907_(), this.m_252754_() + this.f_93618_, this.m_252907_() + this.f_93619_);
        this.hoveredEntry = null;
        int innerWidth = this.f_93618_ - 10;
        int columns = Math.max(1, (innerWidth + 5) / 45);
        int itemX = this.m_252754_() + 5;
        int itemY = this.m_252907_() + 5 - this.scrollOffset;
        int index = 0;
        for (StatEntry entry : this.stats) {
            boolean hovered;
            col = index % columns;
            row = index / columns;
            x = itemX + col * 45;
            y = itemY + row * 45;
            if (y + 40 < this.m_252907_() || y > this.m_252907_() + this.f_93619_) {
                ++index;
                continue;
            }
            boolean bl = hovered = mouseX >= x && mouseX < x + 40 && mouseY >= y && mouseY < y + 40;
            if (hovered) {
                this.hoveredEntry = entry;
            }
            boolean pinned = ModConfig.isPinned(entry.getStatId());
            int bgColor = hovered ? -2141167520 : -2143272896;
            graphics.m_280509_(x, y, x + 40, y + 40, bgColor);
            if (pinned) {
                graphics.m_280509_(x, y, x + 40, y + 2, -256);
            }
            if (entry.getIconRenderer() != null) {
                int iconSize = 36;
                int iconX = x + 2;
                int iconY = y + 2;
                entry.getIconRenderer().render(graphics, iconX, iconY, iconSize);
            }
            if (hovered) {
                graphics.m_280509_(x, y, x + 40, y + 1, -1);
                graphics.m_280509_(x, y + 40 - 1, x + 40, y + 40, -1);
                graphics.m_280509_(x, y, x + 1, y + 40, -1);
                graphics.m_280509_(x + 40 - 1, y, x + 40, y + 40, -1);
            }
            ++index;
        }
        index = 0;
        for (StatEntry entry : this.stats) {
            col = index % columns;
            row = index / columns;
            x = itemX + col * 45;
            y = itemY + row * 45;
            if (y + 40 < this.m_252907_() || y > this.m_252907_() + this.f_93619_) {
                ++index;
                continue;
            }
            String valueStr = StatFormatter.formatStatValue(entry.getStatId(), entry.getValue());
            valueStr = valueStr.replaceAll("\\s+[a-zA-Z]+$", "");
            int textWidth = this.minecraft.f_91062_.m_92895_(valueStr);
            int textX = x + (40 - textWidth) / 2;
            int textY = y + 40 - 10;
            graphics.m_280509_(textX - 1, textY - 1, textX + textWidth + 1, textY + 9, -872415232);
            graphics.m_280488_(this.minecraft.f_91062_, valueStr, textX, textY, 0xFFFFFF);
            ++index;
        }
        graphics.m_280618_();
    }

    public void renderTooltip(GuiGraphics graphics, int mouseX, int mouseY) {
        if (this.hoveredEntry != null) {
            ArrayList<Object> tooltip = new ArrayList<Object>();
            tooltip.add(this.hoveredEntry.getDisplayName());
            String formattedValue = StatFormatter.formatStatValue(this.hoveredEntry.getStatId(), this.hoveredEntry.getValue());
            tooltip.add(Component.m_237113_((String)formattedValue));
            String rawValue = StatFormatter.formatValueFull(this.hoveredEntry.getValue());
            tooltip.add(Component.m_237113_((String)("\u00a77Raw: " + rawValue)));
            if (!this.hoveredEntry.getDescription().getString().isEmpty()) {
                tooltip.add(this.hoveredEntry.getDescription());
            }
            if (ModConfig.isPinned(this.hoveredEntry.getStatId())) {
                tooltip.add(Component.m_237115_((String)"gui.beautiful_statistics_screen.pinned_indicator"));
            } else {
                tooltip.add(Component.m_237115_((String)"gui.beautiful_statistics_screen.right_click_to_pin"));
            }
            graphics.m_280677_(this.minecraft.f_91062_, tooltip, Optional.empty(), mouseX, mouseY);
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.hoveredEntry != null) {
            if (button == 0) {
                this.onLeftClick.accept(this.hoveredEntry);
            } else if (button == 1) {
                this.onRightClick.accept(this.hoveredEntry);
            }
            return true;
        }
        return false;
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        int maxScroll = this.getMaxScroll();
        this.scrollOffset = Math.max(0, Math.min(maxScroll, this.scrollOffset - (int)(delta * 20.0)));
        return true;
    }

    private int getMaxScroll() {
        int innerWidth = this.f_93618_ - 10;
        int columns = Math.max(1, (innerWidth + 5) / 45);
        int rows = (this.stats.size() + columns - 1) / columns;
        int totalHeight = rows * 45 + 10;
        return Math.max(0, totalHeight - this.f_93619_);
    }

    protected void m_168797_(NarrationElementOutput output) {
        output.m_169146_(NarratedElementType.TITLE, (Component)Component.m_237113_((String)"Statistics Grid"));
    }
}

