/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.beautiful_statistics_screen.client.gui;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.texboobcat.beautiful_statistics_screen.api.StatEntry;
import org.texboobcat.beautiful_statistics_screen.client.gui.AdvancedChartScreen;
import org.texboobcat.beautiful_statistics_screen.client.gui.widgets.TextStatListWidget;
import org.texboobcat.beautiful_statistics_screen.config.ModConfig;
import org.texboobcat.beautiful_statistics_screen.core.StatDataManager;

public class TextStatsScreen
extends Screen {
    private static final int PADDING = 10;
    private final Screen parent;
    private EditBox searchBox;
    private Button hideZeroButton;
    private Button sortButton;
    private TextStatListWidget listWidget;
    private boolean hideZero = true;
    private SortMode sortMode = SortMode.NAME_ASC;
    private List<StatEntry> allCustomStats = new ArrayList<StatEntry>();

    public TextStatsScreen(Screen parent) {
        super((Component)Component.m_237115_((String)"screen.beautiful_statistics_screen.text_stats"));
        this.parent = parent;
    }

    protected void m_7856_() {
        super.m_7856_();
        StatDataManager.refresh();
        this.allCustomStats = StatDataManager.getAllStats().stream().filter(e -> e.getStatId().m_135815_().startsWith("custom/")).collect(Collectors.toCollection(ArrayList::new));
        int topY = 28;
        int leftX = 10;
        int buttonH = 20;
        int spacing = 5;
        int availableWidth = this.f_96543_ - 20;
        int buttonWidth = 80;
        int searchBoxWidth = Math.max(200, availableWidth - buttonWidth * 3 - spacing * 4);
        this.searchBox = new EditBox(this.f_96547_, leftX, topY, searchBoxWidth, buttonH, (Component)Component.m_237113_((String)"Search"));
        this.searchBox.m_94151_(s -> this.updateList());
        this.searchBox.m_257771_((Component)Component.m_237113_((String)"Search stats..."));
        this.m_142416_((GuiEventListener)this.searchBox);
        int btnX = leftX + searchBoxWidth + spacing;
        this.hideZeroButton = Button.m_253074_((Component)this.labelForHide(), btn -> {
            this.hideZero = !this.hideZero;
            this.hideZeroButton.m_93666_(this.labelForHide());
            this.updateList();
        }).m_252987_(btnX, topY, buttonWidth, buttonH).m_253136_();
        this.m_142416_((GuiEventListener)this.hideZeroButton);
        this.sortButton = Button.m_253074_((Component)this.labelForSort(), btn -> {
            this.sortMode = this.sortMode.next();
            this.sortButton.m_93666_(this.labelForSort());
            this.updateList();
        }).m_252987_(btnX += buttonWidth + spacing, topY, buttonWidth, buttonH).m_253136_();
        this.m_142416_((GuiEventListener)this.sortButton);
        Button chartBtn = Button.m_253074_((Component)Component.m_237113_((String)"Chart"), btn -> {
            if (this.listWidget.getSelected() != null) {
                StatEntry selected = this.listWidget.getSelected();
                this.f_96541_.m_91152_((Screen)new AdvancedChartScreen(this, selected.getStatId(), selected.getDisplayName()));
            }
        }).m_252987_(btnX += buttonWidth + spacing, topY, buttonWidth, buttonH).m_253136_();
        this.m_142416_((GuiEventListener)chartBtn);
        Button back = Button.m_253074_((Component)Component.m_237115_((String)"gui.done"), b -> this.m_7379_()).m_252987_((this.f_96543_ - 200) / 2, this.f_96544_ - 28, 200, 20).m_253136_();
        this.m_142416_((GuiEventListener)back);
        int listY = topY + buttonH + spacing;
        this.listWidget = new TextStatListWidget(this.f_96541_, 10, listY, this.f_96543_ - 20, this.f_96544_ - listY - 40, this::onEntryClick, this::onEntryRightClick);
        this.m_142416_((GuiEventListener)this.listWidget);
        this.updateList();
    }

    private Component labelForHide() {
        return Component.m_237113_((String)(this.hideZero ? "Hide Zero" : "Show Zero"));
    }

    private Component labelForSort() {
        String s = switch (this.sortMode.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> "Name \u25b2";
            case 1 -> "Name \u25bc";
            case 2 -> "Value \u25b2";
            case 3 -> "Value \u25bc";
        };
        return Component.m_237113_((String)s);
    }

    private void updateList() {
        String query = this.searchBox.m_94155_() == null ? "" : this.searchBox.m_94155_().toLowerCase(Locale.ROOT);
        List filtered = this.allCustomStats.stream().filter(e -> query.isEmpty() || e.getSearchableName().contains(query) || e.getStatId().toString().toLowerCase(Locale.ROOT).contains(query)).filter(e -> !this.hideZero || !e.isZero()).collect(Collectors.toCollection(ArrayList::new));
        Comparator<StatEntry> cmp = switch (this.sortMode.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> Comparator.comparing(a -> a.getDisplayName().getString());
            case 1 -> Comparator.comparing(a -> a.getDisplayName().getString()).reversed();
            case 2 -> Comparator.comparingLong(StatEntry::getValue);
            case 3 -> Comparator.comparingLong(StatEntry::getValue).reversed();
        };
        filtered.sort(cmp);
        this.listWidget.setStats(filtered);
    }

    private void onEntryClick(StatEntry entry) {
        if (ModConfig.isPinned(entry.getStatId())) {
            ModConfig.removePinnedStat(entry.getStatId());
        } else {
            ModConfig.addPinnedStat(entry.getStatId());
        }
    }

    private void onEntryRightClick(StatEntry entry) {
        if (this.f_96541_ != null) {
            this.f_96541_.m_91152_((Screen)new AdvancedChartScreen(this, entry.getStatId(), entry.getDisplayName()));
        }
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(graphics);
        graphics.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, 8, 0xFFFFFF);
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
    }

    public void m_7379_() {
        if (this.f_96541_ != null) {
            this.f_96541_.m_91152_(this.parent);
        }
    }

    public boolean m_7043_() {
        return ModConfig.getClient().pauseOnStatsScreens;
    }

    private static enum SortMode {
        NAME_ASC,
        NAME_DESC,
        VALUE_ASC,
        VALUE_DESC;


        public SortMode next() {
            return SortMode.values()[(this.ordinal() + 1) % SortMode.values().length];
        }
    }
}

