/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.beautiful_statistics_screen.client.gui.chart;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import org.texboobcat.beautiful_statistics_screen.client.gui.chart.ChartDataset;
import org.texboobcat.beautiful_statistics_screen.util.StatFormatter;

public class ChartRenderer {
    private static final int AXIS_COLOR = -10461088;
    private static final int GRID_COLOR = 0x30FFFFFF;
    private static final int TEXT_COLOR = -5592406;
    private static final int HIGHLIGHT_COLOR = -1;
    private final Font font;
    private final int x;
    private final int y;
    private final int width;
    private final int height;
    private final int leftMargin = 50;
    private final int rightMargin = 50;
    private final int bottomMargin = 30;
    private final int topMargin = 40;
    private long minTime;
    private long maxTime;
    private long minVal;
    private long maxVal;
    private long minValRight;
    private long maxValRight;
    private boolean autoScale = true;
    private boolean hasDualAxis = false;
    private String leftAxisType = null;
    private String rightAxisType = null;

    public ChartRenderer(Font font, int x, int y, int width, int height) {
        this.font = font;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public void render(GuiGraphics graphics, List<ChartDataset> datasets, int mouseX, int mouseY) {
        if (datasets.isEmpty()) {
            this.renderEmptyState(graphics);
            return;
        }
        this.calculateBounds(datasets);
        this.renderBackground(graphics);
        this.renderGrid(graphics);
        this.renderAxes(graphics);
        this.renderAxisLabels(graphics, datasets);
        for (ChartDataset dataset : datasets) {
            if (!dataset.isVisible()) continue;
            this.renderDataset(graphics, dataset);
            if (!dataset.isShowTrendLine()) continue;
            this.renderTrendLine(graphics, dataset);
        }
        this.renderLegend(graphics, datasets);
        this.renderTooltip(graphics, datasets, mouseX, mouseY);
    }

    private void calculateBounds(List<ChartDataset> datasets) {
        String statType;
        this.minTime = Long.MAX_VALUE;
        this.maxTime = Long.MIN_VALUE;
        this.minVal = Long.MAX_VALUE;
        this.maxVal = Long.MIN_VALUE;
        this.minValRight = Long.MAX_VALUE;
        this.maxValRight = Long.MIN_VALUE;
        List<ChartDataset> visibleDatasets = datasets.stream().filter(ChartDataset::isVisible).toList();
        if (visibleDatasets.isEmpty()) {
            return;
        }
        this.leftAxisType = this.getStatType(visibleDatasets.get(0).getStatId());
        this.hasDualAxis = false;
        for (ChartDataset dataset : visibleDatasets) {
            statType = this.getStatType(dataset.getStatId());
            if (statType.equals(this.leftAxisType)) continue;
            this.hasDualAxis = true;
            this.rightAxisType = statType;
            break;
        }
        for (ChartDataset dataset : visibleDatasets) {
            if (!dataset.isVisible()) continue;
            statType = this.getStatType(dataset.getStatId());
            boolean useRightAxis = this.hasDualAxis && !statType.equals(this.leftAxisType);
            for (ChartDataset.DataPoint point : dataset.getData()) {
                this.minTime = Math.min(this.minTime, point.timestamp());
                this.maxTime = Math.max(this.maxTime, point.timestamp());
                if (useRightAxis) {
                    this.minValRight = Math.min(this.minValRight, point.value());
                    this.maxValRight = Math.max(this.maxValRight, point.value());
                    continue;
                }
                this.minVal = Math.min(this.minVal, point.value());
                this.maxVal = Math.max(this.maxVal, point.value());
            }
        }
        if (this.minVal == Long.MAX_VALUE) {
            this.minVal = 0L;
            this.maxVal = 1L;
        } else if (this.autoScale && this.minVal == this.maxVal) {
            this.maxVal = this.minVal + 1L;
        } else if (this.autoScale) {
            long range = this.maxVal - this.minVal;
            long padding = range / 10L;
            this.minVal = Math.max(0L, this.minVal - padding);
            this.maxVal += padding;
        }
        if (this.hasDualAxis) {
            if (this.minValRight == Long.MAX_VALUE) {
                this.minValRight = 0L;
                this.maxValRight = 1L;
            } else if (this.autoScale && this.minValRight == this.maxValRight) {
                this.maxValRight = this.minValRight + 1L;
            } else if (this.autoScale) {
                long range = this.maxValRight - this.minValRight;
                long padding = range / 10L;
                this.minValRight = Math.max(0L, this.minValRight - padding);
                this.maxValRight += padding;
            }
        }
        if (this.minTime == this.maxTime) {
            this.maxTime = this.minTime + 1L;
        }
    }

    private String getStatType(ResourceLocation statId) {
        String path = statId.m_135815_();
        if (path.contains("time") || path.contains("sneak_time")) {
            return "time";
        }
        if (path.contains("one_cm") || path.contains("_cm")) {
            return "distance";
        }
        if (path.contains("damage")) {
            return "damage";
        }
        return "other";
    }

    private void renderBackground(GuiGraphics graphics) {
        graphics.m_280509_(this.getChartX(), this.getChartY(), this.getChartX() + this.getChartWidth(), this.getChartY() + this.getChartHeight(), -1879048192);
    }

    private void renderGrid(GuiGraphics graphics) {
        int i;
        int chartX = this.getChartX();
        int chartY = this.getChartY();
        int chartW = this.getChartWidth();
        int chartH = this.getChartHeight();
        for (i = 0; i <= 4; ++i) {
            int lineY = chartY + chartH * i / 4;
            graphics.m_280509_(chartX, lineY, chartX + chartW, lineY + 1, 0x30FFFFFF);
        }
        for (i = 0; i <= 5; ++i) {
            int lineX = chartX + chartW * i / 5;
            graphics.m_280509_(lineX, chartY, lineX + 1, chartY + chartH, 0x30FFFFFF);
        }
    }

    private void renderAxes(GuiGraphics graphics) {
        int chartX = this.getChartX();
        int chartY = this.getChartY();
        int chartW = this.getChartWidth();
        int chartH = this.getChartHeight();
        graphics.m_280509_(chartX - 1, chartY, chartX, chartY + chartH, -10461088);
        if (this.hasDualAxis) {
            graphics.m_280509_(chartX + chartW, chartY, chartX + chartW + 1, chartY + chartH, -10461088);
        }
        graphics.m_280509_(chartX, chartY + chartH, chartX + chartW, chartY + chartH + 1, -10461088);
    }

    private void renderAxisLabels(GuiGraphics graphics, List<ChartDataset> datasets) {
        int labelY;
        String label;
        int i;
        int chartX = this.getChartX();
        int chartY = this.getChartY();
        int chartH = this.getChartHeight();
        int chartW = this.getChartWidth();
        ChartDataset leftDataset = null;
        ChartDataset rightDataset = null;
        for (ChartDataset dataset : datasets) {
            if (!dataset.isVisible()) continue;
            String statType = this.getStatType(dataset.getStatId());
            if (leftDataset == null) {
                leftDataset = dataset;
                continue;
            }
            if (!this.hasDualAxis || rightDataset != null || statType.equals(this.leftAxisType)) continue;
            rightDataset = dataset;
        }
        for (i = 0; i <= 4; ++i) {
            long value = this.minVal + (this.maxVal - this.minVal) * (long)(4 - i) / 4L;
            label = leftDataset != null ? StatFormatter.formatStatValue(leftDataset.getStatId(), value) : StatFormatter.formatValue(value);
            labelY = chartY + chartH * i / 4 - 4;
            graphics.m_280488_(this.font, label, chartX - this.font.m_92895_(label) - 5, labelY, -5592406);
        }
        if (this.hasDualAxis && rightDataset != null) {
            for (i = 0; i <= 4; ++i) {
                long value = this.minValRight + (this.maxValRight - this.minValRight) * (long)(4 - i) / 4L;
                label = StatFormatter.formatStatValue(rightDataset.getStatId(), value);
                labelY = chartY + chartH * i / 4 - 4;
                graphics.m_280488_(this.font, label, chartX + chartW + 5, labelY, -5592406);
            }
        }
        SimpleDateFormat sdf = new SimpleDateFormat("MMM dd HH:mm");
        String startLabel = sdf.format(new Date(this.minTime));
        String endLabel = sdf.format(new Date(this.maxTime));
        graphics.m_280488_(this.font, startLabel, chartX, chartY + chartH + 5, -5592406);
        graphics.m_280488_(this.font, endLabel, chartX + chartW - this.font.m_92895_(endLabel), chartY + chartH + 5, -5592406);
        if (this.hasDualAxis) {
            String warning = "\u26a0 Multiple data types: Left=" + this.formatAxisType(this.leftAxisType) + ", Right=" + this.formatAxisType(this.rightAxisType);
            int warningWidth = this.font.m_92895_(warning);
            graphics.m_280488_(this.font, warning, chartX + (chartW - warningWidth) / 2, chartY - 15, -22016);
        }
    }

    private String formatAxisType(String type) {
        return switch (type) {
            case "time" -> "Time";
            case "distance" -> "Distance";
            case "damage" -> "Damage";
            default -> "Other";
        };
    }

    private int calculateYPosition(ChartDataset dataset, long value) {
        boolean useRightAxis;
        int chartY = this.getChartY();
        int chartH = this.getChartHeight();
        boolean bl = useRightAxis = this.hasDualAxis && !this.getStatType(dataset.getStatId()).equals(this.leftAxisType);
        if (useRightAxis) {
            long range = this.maxValRight - this.minValRight;
            if (range == 0L) {
                return chartY + chartH / 2;
            }
            return chartY + chartH - (int)((value - this.minValRight) * (long)chartH / range);
        }
        long range = this.maxVal - this.minVal;
        if (range == 0L) {
            return chartY + chartH / 2;
        }
        return chartY + chartH - (int)((value - this.minVal) * (long)chartH / range);
    }

    private void renderDataset(GuiGraphics graphics, ChartDataset dataset) {
        switch (dataset.getStyle()) {
            case LINE: {
                this.renderLineChart(graphics, dataset);
                break;
            }
            case BAR: {
                this.renderBarChart(graphics, dataset);
                break;
            }
            case AREA: {
                this.renderAreaChart(graphics, dataset);
                break;
            }
            case SCATTER: {
                this.renderScatterChart(graphics, dataset);
                break;
            }
            case STEP: {
                this.renderStepChart(graphics, dataset);
            }
        }
    }

    private void renderLineChart(GuiGraphics graphics, ChartDataset dataset) {
        List<ChartDataset.DataPoint> data = dataset.getData();
        if (data.isEmpty()) {
            return;
        }
        int chartX = this.getChartX();
        int chartW = this.getChartWidth();
        long timeRange = this.maxTime - this.minTime;
        if (timeRange == 0L) {
            timeRange = 1L;
        }
        int prevX = -1;
        int prevY = -1;
        for (ChartDataset.DataPoint point : data) {
            int px = chartX + (int)((point.timestamp() - this.minTime) * (long)chartW / timeRange);
            int py = this.calculateYPosition(dataset, point.value());
            if (prevX >= 0) {
                this.drawThickLine(graphics, prevX, prevY, px, py, dataset.getColor(), 2);
            }
            graphics.m_280509_(px - 2, py - 2, px + 2, py + 2, dataset.getColor());
            prevX = px;
            prevY = py;
        }
    }

    private void renderBarChart(GuiGraphics graphics, ChartDataset dataset) {
        List<ChartDataset.DataPoint> data = dataset.getData();
        if (data.isEmpty()) {
            return;
        }
        int chartX = this.getChartX();
        int chartY = this.getChartY();
        int chartW = this.getChartWidth();
        int chartH = this.getChartHeight();
        long timeRange = this.maxTime - this.minTime;
        if (timeRange == 0L) {
            timeRange = 1L;
        }
        int barWidth = Math.max(2, Math.min(15, chartW / Math.max(1, data.size())));
        for (ChartDataset.DataPoint point : data) {
            int px = chartX + (int)((point.timestamp() - this.minTime) * (long)chartW / timeRange);
            int py = this.calculateYPosition(dataset, point.value());
            int barHeight = Math.max(0, chartY + chartH - py);
            if (barHeight <= 0) continue;
            for (int i = 0; i < barHeight; ++i) {
                float ratio = barHeight > 1 ? (float)i / (float)barHeight : 0.0f;
                int color = this.blendColors(dataset.getColor(), this.darkenColor(dataset.getColor()), ratio);
                graphics.m_280509_(px - barWidth / 2, py + i, px + barWidth / 2, py + i + 1, color);
            }
        }
    }

    private void renderAreaChart(GuiGraphics graphics, ChartDataset dataset) {
        List<ChartDataset.DataPoint> data = dataset.getData();
        if (data.isEmpty()) {
            return;
        }
        int chartX = this.getChartX();
        int chartY = this.getChartY();
        int chartW = this.getChartWidth();
        int chartH = this.getChartHeight();
        long timeRange = this.maxTime - this.minTime;
        if (timeRange == 0L) {
            timeRange = 1L;
        }
        int areaColor = this.adjustColorAlpha(dataset.getColor(), 96);
        int prevX = -1;
        int prevY = -1;
        for (ChartDataset.DataPoint point : data) {
            int px = chartX + (int)((point.timestamp() - this.minTime) * (long)chartW / timeRange);
            int py = this.calculateYPosition(dataset, point.value());
            graphics.m_280509_(px, py, px + 1, chartY + chartH, areaColor);
            if (prevX >= 0) {
                this.drawThickLine(graphics, prevX, prevY, px, py, dataset.getColor(), 2);
            }
            prevX = px;
            prevY = py;
        }
    }

    private void renderScatterChart(GuiGraphics graphics, ChartDataset dataset) {
        List<ChartDataset.DataPoint> data = dataset.getData();
        if (data.isEmpty()) {
            return;
        }
        int chartX = this.getChartX();
        int chartW = this.getChartWidth();
        long timeRange = this.maxTime - this.minTime;
        if (timeRange == 0L) {
            timeRange = 1L;
        }
        for (ChartDataset.DataPoint point : data) {
            int px = chartX + (int)((point.timestamp() - this.minTime) * (long)chartW / timeRange);
            int py = this.calculateYPosition(dataset, point.value());
            graphics.m_280509_(px - 3, py - 3, px + 3, py + 3, dataset.getColor());
            graphics.m_280509_(px - 2, py - 2, px + 2, py + 2, this.lightenColor(dataset.getColor()));
        }
    }

    private void renderStepChart(GuiGraphics graphics, ChartDataset dataset) {
        List<ChartDataset.DataPoint> data = dataset.getData();
        if (data.isEmpty()) {
            return;
        }
        int chartX = this.getChartX();
        int chartW = this.getChartWidth();
        long timeRange = this.maxTime - this.minTime;
        if (timeRange == 0L) {
            timeRange = 1L;
        }
        int prevX = -1;
        int prevY = -1;
        for (ChartDataset.DataPoint point : data) {
            int px = chartX + (int)((point.timestamp() - this.minTime) * (long)chartW / timeRange);
            int py = this.calculateYPosition(dataset, point.value());
            if (prevX >= 0) {
                this.drawThickLine(graphics, prevX, prevY, px, prevY, dataset.getColor(), 2);
                this.drawThickLine(graphics, px, prevY, px, py, dataset.getColor(), 2);
            }
            prevX = px;
            prevY = py;
        }
    }

    private void renderTrendLine(GuiGraphics graphics, ChartDataset dataset) {
        ChartDataset.TrendLine trend = dataset.calculateTrendLine();
        if (trend == null) {
            return;
        }
        int chartX = this.getChartX();
        int chartW = this.getChartWidth();
        long startVal = trend.getValueAt(this.minTime);
        long endVal = trend.getValueAt(this.maxTime);
        int x1 = chartX;
        int y1 = this.calculateYPosition(dataset, startVal);
        int x2 = chartX + chartW;
        int y2 = this.calculateYPosition(dataset, endVal);
        this.drawDashedLine(graphics, x1, y1, x2, y2, dataset.getTrendLineColor(), 2, 5);
    }

    private void renderLegend(GuiGraphics graphics, List<ChartDataset> datasets) {
        int legendX = this.x + 10;
        int legendY = this.y + 10;
        int lineHeight = 12;
        int visibleCount = (int)datasets.stream().filter(ChartDataset::isVisible).count();
        if (visibleCount == 0) {
            return;
        }
        graphics.m_280509_(legendX - 3, legendY - 3, legendX + 150, legendY + visibleCount * lineHeight + 3, -1073741824);
        int currentY = legendY;
        for (ChartDataset dataset : datasets) {
            if (!dataset.isVisible()) continue;
            graphics.m_280509_(legendX, currentY, legendX + 8, currentY + 8, dataset.getColor());
            Object name = dataset.getDisplayName().getString();
            if (((String)name).length() > 20) {
                name = ((String)name).substring(0, 17) + "...";
            }
            graphics.m_280488_(this.font, (String)name, legendX + 12, currentY, -1);
            currentY += lineHeight;
        }
    }

    private void renderTooltip(GuiGraphics graphics, List<ChartDataset> datasets, int mouseX, int mouseY) {
        if (!this.isMouseInChart(mouseX, mouseY)) {
            return;
        }
        int chartX = this.getChartX();
        long hoverTime = this.minTime + (long)((double)((long)(mouseX - chartX) * (this.maxTime - this.minTime)) / (double)this.getChartWidth());
        StringBuilder tooltip = new StringBuilder();
        SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss");
        tooltip.append("Time: ").append(sdf.format(new Date(hoverTime))).append("\n");
        for (ChartDataset dataset : datasets) {
            Object closest;
            if (!dataset.isVisible() || (closest = this.findClosestPoint(dataset.getData(), hoverTime)) == null) continue;
            String value = StatFormatter.formatStatValue(dataset.getStatId(), ((ChartDataset.DataPoint)closest).value());
            tooltip.append(dataset.getDisplayName().getString()).append(": ").append(value).append("\n");
        }
        if (tooltip.length() > 0) {
            String[] lines = tooltip.toString().split("\n");
            int maxWidth = 0;
            for (String line : lines) {
                maxWidth = Math.max(maxWidth, this.font.m_92895_(line));
            }
            int tooltipX = mouseX + 10;
            int tooltipY = mouseY + 10;
            int tooltipW = maxWidth + 8;
            int tooltipH = lines.length * 10 + 4;
            if (tooltipX + tooltipW > this.x + this.width) {
                tooltipX = mouseX - tooltipW - 10;
            }
            if (tooltipY + tooltipH > this.y + this.height) {
                tooltipY = mouseY - tooltipH - 10;
            }
            graphics.m_280509_(tooltipX, tooltipY, tooltipX + tooltipW, tooltipY + tooltipH, -536870912);
            for (int i = 0; i < lines.length; ++i) {
                graphics.m_280488_(this.font, lines[i], tooltipX + 4, tooltipY + 4 + i * 10, -1);
            }
        }
    }

    private void renderEmptyState(GuiGraphics graphics) {
        String msg = "No data to display";
        int msgWidth = this.font.m_92895_(msg);
        graphics.m_280488_(this.font, msg, this.x + (this.width - msgWidth) / 2, this.y + this.height / 2, -5592406);
    }

    private ChartDataset.DataPoint findClosestPoint(List<ChartDataset.DataPoint> data, long targetTime) {
        if (data.isEmpty()) {
            return null;
        }
        ChartDataset.DataPoint closest = data.get(0);
        long minDiff = Math.abs(closest.timestamp() - targetTime);
        for (ChartDataset.DataPoint point : data) {
            long diff = Math.abs(point.timestamp() - targetTime);
            if (diff >= minDiff) continue;
            minDiff = diff;
            closest = point;
        }
        return closest;
    }

    private boolean isMouseInChart(int mouseX, int mouseY) {
        int chartX = this.getChartX();
        int chartY = this.getChartY();
        return mouseX >= chartX && mouseX <= chartX + this.getChartWidth() && mouseY >= chartY && mouseY <= chartY + this.getChartHeight();
    }

    private void drawThickLine(GuiGraphics g, int x1, int y1, int x2, int y2, int color, int thickness) {
        for (int i = -thickness / 2; i <= thickness / 2; ++i) {
            this.drawLine(g, x1 + i, y1, x2 + i, y2, color);
            this.drawLine(g, x1, y1 + i, x2, y2 + i, color);
        }
    }

    private void drawDashedLine(GuiGraphics g, int x1, int y1, int x2, int y2, int color, int thickness, int dashLength) {
        int dx = Math.abs(x2 - x1);
        int dy = Math.abs(y2 - y1);
        int sx = x1 < x2 ? 1 : -1;
        int sy = y1 < y2 ? 1 : -1;
        int err = dx - dy;
        int x = x1;
        int y = y1;
        int count = 0;
        boolean draw = true;
        while (true) {
            if (draw) {
                for (int i = -thickness / 2; i <= thickness / 2; ++i) {
                    g.m_280509_(x + i, y, x + i + 1, y + 1, color);
                    g.m_280509_(x, y + i, x + 1, y + i + 1, color);
                }
            }
            if (++count >= dashLength) {
                count = 0;
                boolean bl = draw = !draw;
            }
            if (x == x2 && y == y2) break;
            int e2 = 2 * err;
            if (e2 > -dy) {
                err -= dy;
                x += sx;
            }
            if (e2 >= dx) continue;
            err += dx;
            y += sy;
        }
    }

    private void drawLine(GuiGraphics g, int x1, int y1, int x2, int y2, int color) {
        int dx = Math.abs(x2 - x1);
        int dy = Math.abs(y2 - y1);
        int sx = x1 < x2 ? 1 : -1;
        int sy = y1 < y2 ? 1 : -1;
        int err = dx - dy;
        int x = x1;
        int y = y1;
        while (true) {
            g.m_280509_(x, y, x + 1, y + 1, color);
            if (x == x2 && y == y2) break;
            int e2 = 2 * err;
            if (e2 > -dy) {
                err -= dy;
                x += sx;
            }
            if (e2 >= dx) continue;
            err += dx;
            y += sy;
        }
    }

    private int blendColors(int color1, int color2, float ratio) {
        int a = (int)((float)(color1 >> 24 & 0xFF) * (1.0f - ratio) + (float)(color2 >> 24 & 0xFF) * ratio);
        int r = (int)((float)(color1 >> 16 & 0xFF) * (1.0f - ratio) + (float)(color2 >> 16 & 0xFF) * ratio);
        int g = (int)((float)(color1 >> 8 & 0xFF) * (1.0f - ratio) + (float)(color2 >> 8 & 0xFF) * ratio);
        int b = (int)((float)(color1 & 0xFF) * (1.0f - ratio) + (float)(color2 & 0xFF) * ratio);
        return a << 24 | r << 16 | g << 8 | b;
    }

    private int adjustColorAlpha(int color, int alpha) {
        return alpha << 24 | color & 0xFFFFFF;
    }

    private int darkenColor(int color) {
        int r = (color >> 16 & 0xFF) * 2 / 3;
        int g = (color >> 8 & 0xFF) * 2 / 3;
        int b = (color & 0xFF) * 2 / 3;
        return color & 0xFF000000 | r << 16 | g << 8 | b;
    }

    private int lightenColor(int color) {
        int r = Math.min(255, (color >> 16 & 0xFF) + 50);
        int g = Math.min(255, (color >> 8 & 0xFF) + 50);
        int b = Math.min(255, (color & 0xFF) + 50);
        return color & 0xFF000000 | r << 16 | g << 8 | b;
    }

    private int getChartX() {
        return this.x + 50;
    }

    private int getChartY() {
        return this.y + 40;
    }

    private int getChartWidth() {
        int rightSpace = this.hasDualAxis ? 50 : 10;
        return this.width - 50 - rightSpace;
    }

    private int getChartHeight() {
        return this.height - 40 - 30;
    }
}

