/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.beautiful_statistics_screen.client.gui.widgets;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import org.texboobcat.beautiful_statistics_screen.client.gui.chart.ChartDataset;

public class DatasetSelectorWidget
extends AbstractWidget {
    private static final int ROW_HEIGHT = 50;
    private static final int PADDING = 6;
    private final Minecraft minecraft;
    private final List<ChartDataset> datasets;
    private final Runnable onChange;
    private int scrollOffset = 0;
    private ChartDataset hoveredDataset = null;

    public DatasetSelectorWidget(Minecraft minecraft, int x, int y, int width, int height, List<ChartDataset> datasets, Runnable onChange) {
        super(x, y, width, height, (Component)Component.m_237113_((String)"Datasets"));
        this.minecraft = minecraft;
        this.datasets = datasets;
        this.onChange = onChange;
    }

    protected void m_168797_(NarrationElementOutput output) {
        output.m_169146_(NarratedElementType.TITLE, (Component)Component.m_237113_((String)"Dataset Selector"));
    }

    public void m_87963_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        graphics.m_280509_(this.m_252754_(), this.m_252907_(), this.m_252754_() + this.f_93618_, this.m_252907_() + this.f_93619_, -1879048192);
        graphics.m_280488_(this.minecraft.f_91062_, "Datasets", this.m_252754_() + 6, this.m_252907_() + 6, 0xFFFFFF);
        if (this.datasets.isEmpty()) {
            String msg = "No datasets";
            graphics.m_280488_(this.minecraft.f_91062_, msg, this.m_252754_() + (this.f_93618_ - this.minecraft.f_91062_.m_92895_(msg)) / 2, this.m_252907_() + this.f_93619_ / 2, 0x888888);
            return;
        }
        int rowY = this.m_252907_() + 25 - this.scrollOffset;
        int listX = this.m_252754_() + 6;
        int listW = this.f_93618_ - 12;
        this.hoveredDataset = null;
        for (ChartDataset dataset : this.datasets) {
            boolean hovered;
            if (rowY + 50 < this.m_252907_() + 25 || rowY > this.m_252907_() + this.f_93619_) {
                rowY += 50;
                continue;
            }
            boolean bl = hovered = mouseX >= listX && mouseX < listX + listW && mouseY >= rowY && mouseY < rowY + 50;
            if (hovered) {
                this.hoveredDataset = dataset;
                graphics.m_280509_(listX, rowY, listX + listW, rowY + 50, 0x40FFFFFF);
            }
            graphics.m_280509_(listX, rowY, listX + listW, rowY + 50, dataset.isVisible() ? 0x30000000 : 0x20000000);
            graphics.m_280509_(listX + 2, rowY + 2, listX + 10, rowY + 50 - 2, dataset.getColor());
            Object name = dataset.getDisplayName().getString();
            if (((String)name).length() > 18) {
                name = ((String)name).substring(0, 15) + "...";
            }
            int nameColor = dataset.isVisible() ? 0xFFFFFF : 0x888888;
            graphics.m_280488_(this.minecraft.f_91062_, (String)name, listX + 14, rowY + 4, nameColor);
            String count = dataset.getData().size() + " pts";
            graphics.m_280488_(this.minecraft.f_91062_, count, listX + 14, rowY + 15, 0x888888);
            String style = switch (dataset.getStyle()) {
                default -> throw new IncompatibleClassChangeError();
                case ChartDataset.ChartStyle.LINE -> "Line";
                case ChartDataset.ChartStyle.BAR -> "Bar";
                case ChartDataset.ChartStyle.AREA -> "Area";
                case ChartDataset.ChartStyle.SCATTER -> "Scatter";
                case ChartDataset.ChartStyle.STEP -> "Step";
            };
            graphics.m_280488_(this.minecraft.f_91062_, style, listX + 14, rowY + 26, 0xAAAAAAA);
            String visText = dataset.isVisible() ? "\ud83d\udc41" : "\u2715";
            int visX = listX + listW - 25;
            int visY = rowY + 5;
            boolean hoverVis = mouseX >= visX && mouseX < visX + 20 && mouseY >= visY && mouseY < visY + 15;
            graphics.m_280509_(visX, visY, visX + 20, visY + 15, hoverVis ? 0x60FFFFFF : 0x40FFFFFF);
            graphics.m_280488_(this.minecraft.f_91062_, visText, visX + 5, visY + 3, 0xFFFFFF);
            String trendText = dataset.isShowTrendLine() ? "\ud83d\udcc8" : "\u2014";
            int trendX = listX + listW - 25;
            int trendY = rowY + 25;
            boolean hoverTrend = mouseX >= trendX && mouseX < trendX + 20 && mouseY >= trendY && mouseY < trendY + 15;
            graphics.m_280509_(trendX, trendY, trendX + 20, trendY + 15, hoverTrend ? 0x60FFFFFF : 0x40FFFFFF);
            graphics.m_280488_(this.minecraft.f_91062_, trendText, trendX + 5, trendY + 3, 0xFFFFFF);
            rowY += 50;
        }
        if (this.getMaxScroll() > 0) {
            int scrollBarHeight = Math.max(20, this.f_93619_ * this.f_93619_ / (this.datasets.size() * 50 + 25));
            int scrollBarY = this.m_252907_() + 25 + (int)((float)this.scrollOffset / (float)this.getMaxScroll() * (float)(this.f_93619_ - 25 - scrollBarHeight));
            graphics.m_280509_(this.m_252754_() + this.f_93618_ - 4, scrollBarY, this.m_252754_() + this.f_93618_ - 2, scrollBarY + scrollBarHeight, -16733441);
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (button != 0) {
            return false;
        }
        int listX = this.m_252754_() + 6;
        int listW = this.f_93618_ - 12;
        int rowY = this.m_252907_() + 25 - this.scrollOffset;
        for (ChartDataset dataset : this.datasets) {
            if (mouseY >= (double)rowY && mouseY < (double)(rowY + 50) && mouseX >= (double)listX && mouseX < (double)(listX + listW)) {
                int visX = listX + listW - 25;
                int visY = rowY + 5;
                if (mouseX >= (double)visX && mouseX < (double)(visX + 20) && mouseY >= (double)visY && mouseY < (double)(visY + 15)) {
                    dataset.setVisible(!dataset.isVisible());
                    this.onChange.run();
                    return true;
                }
                int trendX = listX + listW - 25;
                int trendY = rowY + 25;
                if (mouseX >= (double)trendX && mouseX < (double)(trendX + 20) && mouseY >= (double)trendY && mouseY < (double)(trendY + 15)) {
                    dataset.setShowTrendLine(!dataset.isShowTrendLine());
                    this.onChange.run();
                    return true;
                }
                dataset.setStyle(this.nextStyle(dataset.getStyle()));
                this.onChange.run();
                return true;
            }
            rowY += 50;
        }
        return false;
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        int max = this.getMaxScroll();
        this.scrollOffset = Math.max(0, Math.min(max, this.scrollOffset - (int)(delta * 20.0)));
        return true;
    }

    public void refresh() {
    }

    private int getMaxScroll() {
        int totalHeight = this.datasets.size() * 50 + 25;
        return Math.max(0, totalHeight - this.f_93619_);
    }

    private ChartDataset.ChartStyle nextStyle(ChartDataset.ChartStyle current) {
        ChartDataset.ChartStyle[] styles = ChartDataset.ChartStyle.values();
        int index = current.ordinal();
        return styles[(index + 1) % styles.length];
    }
}

