/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.beautiful_statistics_screen.client.gui.widgets;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import org.texboobcat.beautiful_statistics_screen.api.StatEntry;
import org.texboobcat.beautiful_statistics_screen.util.StatFormatter;

public class TextStatListWidget
extends AbstractWidget {
    private static final int ROW_HEIGHT = 18;
    private static final int PADDING = 6;
    private final Minecraft minecraft;
    private List<StatEntry> stats = new ArrayList<StatEntry>();
    private int scrollOffset = 0;
    private StatEntry selected = null;
    private final Consumer<StatEntry> onClick;
    private final Consumer<StatEntry> onRightClick;

    public TextStatListWidget(Minecraft minecraft, int x, int y, int width, int height, Consumer<StatEntry> onClick, Consumer<StatEntry> onRightClick) {
        super(x, y, width, height, (Component)Component.m_237119_());
        this.minecraft = minecraft;
        this.onClick = onClick;
        this.onRightClick = onRightClick;
    }

    public void setStats(List<StatEntry> stats) {
        this.stats = new ArrayList<StatEntry>(stats);
        if (this.scrollOffset > this.getMaxScroll()) {
            this.scrollOffset = Math.max(0, this.getMaxScroll());
        }
        if (this.selected != null && !this.stats.contains(this.selected)) {
            this.selected = null;
        }
    }

    public StatEntry getSelected() {
        return this.selected;
    }

    protected void m_168797_(NarrationElementOutput output) {
        output.m_169146_(NarratedElementType.TITLE, (Component)Component.m_237113_((String)"Statistics List"));
    }

    public void m_87963_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        graphics.m_280509_(this.m_252754_(), this.m_252907_(), this.m_252754_() + this.f_93618_, this.m_252907_() + this.f_93619_, -1879048192);
        int rowY = this.m_252907_() + 6 - this.scrollOffset;
        int listX = this.m_252754_() + 6;
        int listW = this.f_93618_ - 12;
        for (int i = 0; i < this.stats.size(); ++i) {
            StatEntry entry = this.stats.get(i);
            if (rowY + 18 < this.m_252907_() || rowY > this.m_252907_() + this.f_93619_) {
                rowY += 18;
                continue;
            }
            boolean hovered = mouseX >= listX && mouseX < listX + listW && mouseY >= rowY && mouseY < rowY + 18;
            boolean isSelected = entry == this.selected;
            int bgColor = 0;
            if (isSelected) {
                bgColor = -2147439873;
            } else if (hovered) {
                bgColor = 0x60303030;
            }
            if (bgColor != 0) {
                graphics.m_280509_(listX, rowY, listX + listW, rowY + 18, bgColor);
            }
            if (i > 0) {
                graphics.m_280509_(listX, rowY, listX + listW, rowY + 1, 0x20FFFFFF);
            }
            String name = entry.getDisplayName().getString();
            String value = StatFormatter.formatStatValue(entry.getStatId(), entry.getValue());
            Objects.requireNonNull(this.minecraft.f_91062_);
            int textY = rowY + (18 - 9) / 2;
            int nameColor = isSelected ? 0xFFFFFF : (hovered ? 0xFFFFAA : 0xDDDDDD);
            graphics.m_280488_(this.minecraft.f_91062_, name, listX + 4, textY, nameColor);
            int valueWidth = this.minecraft.f_91062_.m_92895_(value);
            int valueColor = entry.getValue() > 0L ? 65416 : 0x888888;
            graphics.m_280488_(this.minecraft.f_91062_, value, listX + listW - valueWidth - 4, textY, valueColor);
            if (hovered && !isSelected) {
                String hint = "Right-click for chart";
                int hintWidth = this.minecraft.f_91062_.m_92895_(hint);
                graphics.m_280488_(this.minecraft.f_91062_, hint, listX + (listW - hintWidth) / 2, textY, -2130706433);
            }
            rowY += 18;
        }
        if (this.getMaxScroll() > 0) {
            int scrollBarHeight = Math.max(20, this.f_93619_ * this.f_93619_ / (this.stats.size() * 18 + 12));
            int scrollBarY = this.m_252907_() + (int)((float)this.scrollOffset / (float)this.getMaxScroll() * (float)(this.f_93619_ - scrollBarHeight));
            graphics.m_280509_(this.m_252754_() + this.f_93618_ - 4, scrollBarY, this.m_252754_() + this.f_93618_ - 2, scrollBarY + scrollBarHeight, -16733441);
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        int listX = this.m_252754_() + 6;
        int listW = this.f_93618_ - 12;
        int rowY = this.m_252907_() + 6 - this.scrollOffset;
        for (int i = 0; i < this.stats.size(); ++i) {
            if (mouseY >= (double)rowY && mouseY < (double)(rowY + 18) && mouseX >= (double)listX && mouseX < (double)(listX + listW)) {
                this.selected = this.stats.get(i);
                if (button == 0) {
                    this.onClick.accept(this.selected);
                } else if (button == 1) {
                    this.onRightClick.accept(this.selected);
                }
                return true;
            }
            rowY += 18;
        }
        return false;
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        int max = this.getMaxScroll();
        this.scrollOffset = Math.max(0, Math.min(max, this.scrollOffset - (int)(delta * 20.0)));
        return true;
    }

    private int getMaxScroll() {
        int totalHeight = this.stats.size() * 18 + 12;
        return Math.max(0, totalHeight - this.f_93619_);
    }
}

