/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.beautiful_statistics_screen.client.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.boss.enderdragon.EndCrystal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.texboobcat.beautiful_statistics_screen.api.IconRenderer;
import org.texboobcat.beautiful_statistics_screen.config.ModConfig;

public class EntityIconRenderer
implements IconRenderer {
    private final EntityType<?> entityType;
    private final boolean isKilledBy;
    private static final Map<EntityType<?>, Entity> ENTITY_CACHE = new ConcurrentHashMap();
    private static Level cachedLevel = null;

    public EntityIconRenderer(EntityType<?> entityType) {
        this(entityType, false);
    }

    public EntityIconRenderer(EntityType<?> entityType, boolean isKilledBy) {
        this.entityType = entityType;
        this.isKilledBy = isKilledBy;
    }

    @Override
    public void render(GuiGraphics graphics, int x, int y, int size) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null) {
            return;
        }
        boolean use3D = ModConfig.getClient().render3DMobIcons;
        if (!use3D) {
            ItemStack fallbackItem = EntityIconRenderer.getItemFallback(this.entityType);
            this.renderItemIcon(graphics, fallbackItem, x, y, size);
            if (this.isKilledBy) {
                this.renderDeathIndicator(graphics, x, y, size);
            }
            return;
        }
        if (cachedLevel != mc.f_91073_) {
            ENTITY_CACHE.clear();
            cachedLevel = mc.f_91073_;
        }
        try {
            Entity entity = ENTITY_CACHE.computeIfAbsent(this.entityType, type -> {
                try {
                    return type.m_20615_((Level)mc.f_91073_);
                }
                catch (Exception e) {
                    return null;
                }
            });
            if (entity != null) {
                if (entity instanceof LightningBolt) {
                    this.renderItemIcon(graphics, new ItemStack((ItemLike)Items.f_151041_), x, y, size);
                    if (this.isKilledBy) {
                        this.renderDeathIndicator(graphics, x, y, size);
                    }
                    return;
                }
                if (entity instanceof EndCrystal) {
                    this.renderItemIcon(graphics, new ItemStack((ItemLike)Items.f_42729_), x, y, size);
                    if (this.isKilledBy) {
                        this.renderDeathIndicator(graphics, x, y, size);
                    }
                    return;
                }
                String entityTypeName = EntityType.m_20613_(this.entityType).m_135815_();
                if ("ender_dragon".equals(entityTypeName)) {
                    this.renderItemIcon(graphics, new ItemStack((ItemLike)Items.f_42683_), x, y, size);
                    if (this.isKilledBy) {
                        this.renderDeathIndicator(graphics, x, y, size);
                    }
                    return;
                }
                if ("wither".equals(entityTypeName)) {
                    this.renderItemIcon(graphics, new ItemStack((ItemLike)Items.f_42686_), x, y, size);
                    if (this.isKilledBy) {
                        this.renderDeathIndicator(graphics, x, y, size);
                    }
                    return;
                }
                this.renderEntity(graphics, entity, x, y, size);
            } else {
                ItemStack fallbackItem = EntityIconRenderer.getItemFallback(this.entityType);
                this.renderItemIcon(graphics, fallbackItem, x, y, size);
            }
        }
        catch (Exception e) {
            ItemStack fallbackItem = EntityIconRenderer.getItemFallback(this.entityType);
            this.renderItemIcon(graphics, fallbackItem, x, y, size);
        }
        if (this.isKilledBy) {
            this.renderDeathIndicator(graphics, x, y, size);
        }
    }

    private void renderDeathIndicator(GuiGraphics graphics, int x, int y, int size) {
        ItemStack skull = new ItemStack((ItemLike)Items.f_42678_);
        int skullSize = Math.max(8, size / 4);
        int skullX = x + size - skullSize - 2;
        int skullY = y + 2;
        PoseStack poseStack = graphics.m_280168_();
        poseStack.m_85836_();
        float scale = (float)skullSize / 16.0f;
        poseStack.m_252880_((float)skullX, (float)skullY, 200.0f);
        poseStack.m_85841_(scale, scale, scale);
        graphics.m_280480_(skull, 0, 0);
        poseStack.m_85849_();
    }

    private void renderEntity(GuiGraphics graphics, Entity entity, int x, int y, int size) {
        PoseStack poseStack = graphics.m_280168_();
        poseStack.m_85836_();
        float width = Math.max(0.001f, entity.m_20205_());
        float height = Math.max(0.001f, entity.m_20206_());
        float targetSize = (float)size * 0.7f;
        float scale = targetSize / Math.max(width, height);
        scale = Math.max(4.0f, Math.min(scale, 80.0f));
        if (height > width * 2.0f) {
            scale *= 0.75f;
        } else if (width > height * 2.0f) {
            scale *= 0.75f;
        }
        poseStack.m_252880_((float)x + (float)size / 2.0f, (float)y + (float)size * 0.75f, 100.0f);
        poseStack.m_85841_(scale, scale, -scale);
        poseStack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
        poseStack.m_252781_(Axis.f_252529_.m_252977_(10.0f));
        float prevYRot = entity.m_146908_();
        float prevXRot = entity.m_146909_();
        float prevBodyRot = 0.0f;
        float prevHeadRot = 0.0f;
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            prevBodyRot = living.f_20883_;
            prevHeadRot = living.f_20885_;
            living.f_20883_ = 180.0f;
            living.f_20885_ = 180.0f;
        }
        entity.m_146922_(180.0f);
        entity.m_146926_(0.0f);
        EntityRenderDispatcher dispatcher = Minecraft.m_91087_().m_91290_();
        MultiBufferSource.BufferSource buffer = Minecraft.m_91087_().m_91269_().m_110104_();
        RenderSystem.runAsFancy(() -> {
            dispatcher.m_114384_(entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, poseStack, (MultiBufferSource)buffer, 0xF000F0);
            buffer.m_109911_();
        });
        entity.m_146922_(prevYRot);
        entity.m_146926_(prevXRot);
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            living.f_20883_ = prevBodyRot;
            living.f_20885_ = prevHeadRot;
        }
        poseStack.m_85849_();
    }

    private void renderSimpleIcon(GuiGraphics graphics, int x, int y, int size) {
        graphics.m_280509_(x + 2, y + 2, x + size - 2, y + size - 2, -2139062144);
        String initial = this.entityType.m_20676_().getString().substring(0, 1).toUpperCase();
        int textX = x + size / 2 - 3;
        int textY = y + size / 2 - 4;
        graphics.m_280488_(Minecraft.m_91087_().f_91062_, initial, textX, textY, 0xFFFFFF);
    }

    private void renderItemIcon(GuiGraphics graphics, ItemStack stack, int x, int y, int size) {
        int ix = x + Math.max(0, (size - 16) / 2);
        int iy = y + Math.max(0, (size - 16) / 2);
        graphics.m_280480_(stack, ix, iy);
    }

    private static ItemStack getItemFallback(EntityType<?> entityType) {
        String entityName;
        return switch (entityName = EntityType.m_20613_(entityType).m_135815_()) {
            case "ender_dragon" -> new ItemStack((ItemLike)Items.f_42683_);
            case "wither" -> new ItemStack((ItemLike)Items.f_42686_);
            case "elder_guardian" -> new ItemStack((ItemLike)Items.f_42695_);
            case "warden" -> new ItemStack((ItemLike)Items.f_220195_);
            case "zombie" -> new ItemStack((ItemLike)Items.f_42608_);
            case "skeleton" -> new ItemStack((ItemLike)Items.f_42642_);
            case "creeper" -> new ItemStack((ItemLike)Items.f_42555_);
            case "spider" -> new ItemStack((ItemLike)Items.f_42645_);
            case "enderman" -> new ItemStack((ItemLike)Items.f_42560_);
            case "zombie_villager" -> new ItemStack((ItemLike)Items.f_42610_);
            case "husk" -> new ItemStack((ItemLike)Items.f_42621_);
            case "stray" -> new ItemStack((ItemLike)Items.f_42595_);
            case "phantom" -> new ItemStack((ItemLike)Items.f_42629_);
            case "drowned" -> new ItemStack((ItemLike)Items.f_42558_);
            case "blaze" -> new ItemStack((ItemLike)Items.f_42549_);
            case "ghast" -> new ItemStack((ItemLike)Items.f_42564_);
            case "magma_cube" -> new ItemStack((ItemLike)Items.f_42623_);
            case "zombified_piglin" -> new ItemStack((ItemLike)Items.f_42611_);
            case "piglin" -> new ItemStack((ItemLike)Items.f_42631_);
            case "piglin_brute" -> new ItemStack((ItemLike)Items.f_42632_);
            case "hoglin" -> new ItemStack((ItemLike)Items.f_42566_);
            case "zoglin" -> new ItemStack((ItemLike)Items.f_42607_);
            case "strider" -> new ItemStack((ItemLike)Items.f_42596_);
            case "cow" -> new ItemStack((ItemLike)Items.f_42554_);
            case "pig" -> new ItemStack((ItemLike)Items.f_42630_);
            case "sheep" -> new ItemStack((ItemLike)Items.f_42639_);
            case "chicken" -> new ItemStack((ItemLike)Items.f_42552_);
            case "horse" -> new ItemStack((ItemLike)Items.f_42567_);
            case "donkey" -> new ItemStack((ItemLike)Items.f_42557_);
            case "mule" -> new ItemStack((ItemLike)Items.f_42625_);
            case "llama" -> new ItemStack((ItemLike)Items.f_42622_);
            case "cat" -> new ItemStack((ItemLike)Items.f_42550_);
            case "wolf" -> new ItemStack((ItemLike)Items.f_42606_);
            case "parrot" -> new ItemStack((ItemLike)Items.f_42628_);
            case "rabbit" -> new ItemStack((ItemLike)Items.f_42636_);
            case "fox" -> new ItemStack((ItemLike)Items.f_42563_);
            case "panda" -> new ItemStack((ItemLike)Items.f_42627_);
            case "polar_bear" -> new ItemStack((ItemLike)Items.f_42634_);
            case "turtle" -> new ItemStack((ItemLike)Items.f_42599_);
            case "bee" -> new ItemStack((ItemLike)Items.f_42548_);
            case "axolotl" -> new ItemStack((ItemLike)Items.f_151060_);
            case "goat" -> new ItemStack((ItemLike)Items.f_151062_);
            case "frog" -> new ItemStack((ItemLike)Items.f_220213_);
            case "allay" -> new ItemStack((ItemLike)Items.f_220212_);
            case "cod" -> new ItemStack((ItemLike)Items.f_42553_);
            case "salmon" -> new ItemStack((ItemLike)Items.f_42638_);
            case "tropical_fish" -> new ItemStack((ItemLike)Items.f_42598_);
            case "pufferfish" -> new ItemStack((ItemLike)Items.f_42635_);
            case "dolphin" -> new ItemStack((ItemLike)Items.f_42556_);
            case "squid" -> new ItemStack((ItemLike)Items.f_42646_);
            case "glow_squid" -> new ItemStack((ItemLike)Items.f_151061_);
            case "guardian" -> new ItemStack((ItemLike)Items.f_42565_);
            case "villager" -> new ItemStack((ItemLike)Items.f_42601_);
            case "wandering_trader" -> new ItemStack((ItemLike)Items.f_42603_);
            case "pillager" -> new ItemStack((ItemLike)Items.f_42633_);
            case "vindicator" -> new ItemStack((ItemLike)Items.f_42602_);
            case "evoker" -> new ItemStack((ItemLike)Items.f_42562_);
            case "ravager" -> new ItemStack((ItemLike)Items.f_42637_);
            case "vex" -> new ItemStack((ItemLike)Items.f_42600_);
            case "witch" -> new ItemStack((ItemLike)Items.f_42604_);
            case "slime" -> new ItemStack((ItemLike)Items.f_42644_);
            case "cave_spider" -> new ItemStack((ItemLike)Items.f_42551_);
            case "silverfish" -> new ItemStack((ItemLike)Items.f_42641_);
            case "endermite" -> new ItemStack((ItemLike)Items.f_42561_);
            case "shulker" -> new ItemStack((ItemLike)Items.f_42640_);
            case "iron_golem" -> new ItemStack((ItemLike)Items.f_41913_);
            case "snow_golem" -> new ItemStack((ItemLike)Items.f_42047_);
            case "lightning_bolt" -> new ItemStack((ItemLike)Items.f_151041_);
            case "end_crystal" -> new ItemStack((ItemLike)Items.f_42729_);
            case "armor_stand" -> new ItemStack((ItemLike)Items.f_42650_);
            case "item_frame" -> new ItemStack((ItemLike)Items.f_42617_);
            case "glow_item_frame" -> new ItemStack((ItemLike)Items.f_151063_);
            case "painting" -> new ItemStack((ItemLike)Items.f_42487_);
            case "player" -> new ItemStack((ItemLike)Items.f_42680_);
            default -> new ItemStack((ItemLike)Items.f_42127_);
        };
    }
}

