/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.beautiful_statistics_screen.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.texboobcat.beautiful_statistics_screen.history.HistoryManager;

public class HistoryCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"statshistory").then(Commands.m_82127_((String)"info").executes(HistoryCommand::executeInfo))).then(Commands.m_82127_((String)"stats").executes(HistoryCommand::executeStats))).then(Commands.m_82127_((String)"list").executes(HistoryCommand::executeList))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"clear").then(Commands.m_82129_((String)"stat", (ArgumentType)StringArgumentType.string()).executes(HistoryCommand::executeClearStat))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"all").requires(source -> source.m_6761_(2))).executes(HistoryCommand::executeClearAll))));
    }

    private static int executeInfo(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        HistoryManager.CompressionStats stats = HistoryManager.getCompressionStats();
        long lastLogTime = HistoryManager.getLastLogTime();
        int statsWithHistory = HistoryManager.getStatsWithHistory().size();
        source.m_288197_(() -> Component.m_237113_((String)"\u00a76=== Statistics History Info ==="), false);
        source.m_288197_(() -> Component.m_237113_((String)("\u00a7eStats being tracked: \u00a7f" + statsWithHistory)), false);
        source.m_288197_(() -> Component.m_237113_((String)("\u00a7eTotal history files: \u00a7f" + stats.getTotalFileCount())), false);
        source.m_288197_(() -> Component.m_237113_((String)("\u00a7eCompressed files: \u00a7a" + stats.compressedFileCount)), false);
        source.m_288197_(() -> Component.m_237113_((String)("\u00a7eUncompressed files: \u00a77" + stats.uncompressedFileCount)), false);
        source.m_288197_(() -> Component.m_237113_((String)("\u00a7eTotal disk usage: \u00a7f" + stats.getFormattedSize())), false);
        if (lastLogTime > 0L) {
            long secondsSinceLog = (System.currentTimeMillis() - lastLogTime) / 1000L;
            long minutes = secondsSinceLog / 60L;
            long seconds = secondsSinceLog % 60L;
            source.m_288197_(() -> Component.m_237113_((String)("\u00a7eLast log: \u00a7f" + minutes + "m " + seconds + "s ago")), false);
        } else {
            source.m_288197_(() -> Component.m_237113_((String)"\u00a7eLast log: \u00a77Never"), false);
        }
        if (stats.compressedFileCount > 0L && stats.uncompressedFileCount > 0L) {
            source.m_288197_(() -> Component.m_237113_((String)"\u00a7eMixed compression format detected"), false);
        } else if (stats.compressedFileCount > 0L) {
            source.m_288197_(() -> Component.m_237113_((String)"\u00a7aAll files compressed"), false);
        }
        return 1;
    }

    private static int executeStats(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        List<ResourceLocation> trackedStats = HistoryManager.getStatsWithHistory();
        if (trackedStats.isEmpty()) {
            source.m_288197_(() -> Component.m_237113_((String)"\u00a7cNo statistics are being tracked"), false);
            return 0;
        }
        source.m_288197_(() -> Component.m_237113_((String)("\u00a76=== Tracked Statistics (" + trackedStats.size() + ") ===")), false);
        int limit = Math.min(20, trackedStats.size());
        for (int i = 0; i < limit; ++i) {
            ResourceLocation stat = trackedStats.get(i);
            List<HistoryManager.DataPoint> history = HistoryManager.getHistory(stat);
            int dataPoints = history.size();
            source.m_288197_(() -> Component.m_237113_((String)("\u00a7e" + String.valueOf(stat) + " \u00a77(" + dataPoints + " points)")), false);
        }
        if (trackedStats.size() > 20) {
            int remaining = trackedStats.size() - 20;
            source.m_288197_(() -> Component.m_237113_((String)("\u00a77... and " + remaining + " more")), false);
        }
        return 1;
    }

    private static int executeList(CommandContext<CommandSourceStack> context) {
        return HistoryCommand.executeStats(context);
    }

    private static int executeClearStat(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        String statIdStr = StringArgumentType.getString(context, (String)"stat");
        try {
            ResourceLocation statId = new ResourceLocation(statIdStr);
            HistoryManager.clearHistory(statId);
            source.m_288197_(() -> Component.m_237113_((String)("\u00a7aCleared history for: \u00a7f" + String.valueOf(statId))), false);
            return 1;
        }
        catch (Exception e) {
            source.m_81352_((Component)Component.m_237113_((String)("\u00a7cInvalid stat ID: " + statIdStr)));
            return 0;
        }
    }

    private static int executeClearAll(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        int count = HistoryManager.getStatsWithHistory().size();
        HistoryManager.clearAllHistory();
        source.m_288197_(() -> Component.m_237113_((String)("\u00a7aCleared all history data for " + count + " statistics")), false);
        return 1;
    }
}

