/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.beautiful_statistics_screen.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import org.texboobcat.beautiful_statistics_screen.config.ModConfig;
import org.texboobcat.beautiful_statistics_screen.network.NetworkHandler;

public class ShareStatsCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"sharestats").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(ctx -> ShareStatsCommand.requestStats((CommandContext<CommandSourceStack>)ctx, EntityArgument.m_91474_((CommandContext)ctx, (String)"player")))));
    }

    private static int requestStats(CommandContext<CommandSourceStack> ctx, ServerPlayer targetPlayer) {
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        if (!ModConfig.getServer().allowStatSharing) {
            source.m_81352_((Component)Component.m_237113_((String)"\u00a7cStat sharing is disabled on this server"));
            return 0;
        }
        Entity entity = source.m_81373_();
        if (!(entity instanceof ServerPlayer)) {
            source.m_81352_((Component)Component.m_237113_((String)"\u00a7cThis command must be executed by a player"));
            return 0;
        }
        ServerPlayer requestingPlayer = (ServerPlayer)entity;
        if (requestingPlayer.equals((Object)targetPlayer)) {
            source.m_81352_((Component)Component.m_237113_((String)"\u00a7cYou can't request your own stats"));
            return 0;
        }
        NetworkHandler.StatsDataPacket.sendToPlayer(requestingPlayer, targetPlayer.m_7755_().getString());
        source.m_288197_(() -> Component.m_237113_((String)("\u00a7aRequesting stats from " + targetPlayer.m_7755_().getString() + "...")), false);
        return 1;
    }
}

