/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.beautiful_statistics_screen.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.item.Item;
import org.texboobcat.beautiful_statistics_screen.api.StatCategory;

public class StatCategoryRegistry {
    private static final Map<ResourceLocation, StatCategory> CATEGORIES = new ConcurrentHashMap<ResourceLocation, StatCategory>();
    private static final List<StatCategory> ORDERED_CATEGORIES = new ArrayList<StatCategory>();
    private static boolean initialized = false;
    public static final ResourceLocation GENERAL_ID = new ResourceLocation("beautiful_statistics_screen", "general");
    public static final ResourceLocation ITEMS_ID = new ResourceLocation("beautiful_statistics_screen", "items");
    public static final ResourceLocation MOBS_ID = new ResourceLocation("beautiful_statistics_screen", "mobs");
    public static final ResourceLocation FOOD_ID = new ResourceLocation("beautiful_statistics_screen", "food");
    public static final ResourceLocation HOSTILE_ID = new ResourceLocation("beautiful_statistics_screen", "hostile");
    public static final ResourceLocation BLOCKS_ID = new ResourceLocation("beautiful_statistics_screen", "blocks");
    public static final ResourceLocation CUSTOM_ID = new ResourceLocation("beautiful_statistics_screen", "custom");

    public static synchronized void register(StatCategory category) {
        if (CATEGORIES.containsKey(category.getId())) {
            throw new IllegalStateException("Stat category already registered: " + String.valueOf(category.getId()));
        }
        CATEGORIES.put(category.getId(), category);
        ORDERED_CATEGORIES.add(category);
        ORDERED_CATEGORIES.sort(Comparator.comparingInt(StatCategory::getPriority));
    }

    public static StatCategory getCategory(ResourceLocation id) {
        return CATEGORIES.get(id);
    }

    public static List<StatCategory> getAllCategories() {
        return Collections.unmodifiableList(ORDERED_CATEGORIES);
    }

    public static synchronized void initializeDefaults() {
        if (initialized) {
            return;
        }
        initialized = true;
        StatCategoryRegistry.register(new StatCategory(GENERAL_ID, (Component)Component.m_237115_((String)"category.beautiful_statistics_screen.general"), 0, id -> id.m_135815_().startsWith("custom/")));
        StatCategoryRegistry.register(new StatCategory(FOOD_ID, (Component)Component.m_237115_((String)"category.beautiful_statistics_screen.food"), 1, id -> id.m_135815_().startsWith("used/") && StatCategoryRegistry.isFoodItem(id)));
        StatCategoryRegistry.register(new StatCategory(HOSTILE_ID, (Component)Component.m_237115_((String)"category.beautiful_statistics_screen.hostile"), 2, id -> {
            String path = id.m_135815_();
            return (path.startsWith("killed/") || path.startsWith("killed_by/")) && StatCategoryRegistry.isHostileMob(id);
        }));
        StatCategoryRegistry.register(new StatCategory(ITEMS_ID, (Component)Component.m_237115_((String)"category.beautiful_statistics_screen.items"), 3, id -> id.m_135815_().startsWith("used/") || id.m_135815_().startsWith("crafted/") || id.m_135815_().startsWith("broken/") || id.m_135815_().startsWith("picked_up/") || id.m_135815_().startsWith("dropped/")));
        StatCategoryRegistry.register(new StatCategory(MOBS_ID, (Component)Component.m_237115_((String)"category.beautiful_statistics_screen.mobs"), 4, id -> id.m_135815_().startsWith("killed/") || id.m_135815_().startsWith("killed_by/")));
        StatCategoryRegistry.register(new StatCategory(BLOCKS_ID, (Component)Component.m_237115_((String)"category.beautiful_statistics_screen.blocks"), 5, id -> id.m_135815_().startsWith("mined/")));
        StatCategoryRegistry.register(new StatCategory(CUSTOM_ID, (Component)Component.m_237115_((String)"category.beautiful_statistics_screen.custom"), 100, id -> id.m_135815_().startsWith("custom_stat/")));
    }

    private static boolean isFoodItem(ResourceLocation statId) {
        String path = statId.m_135815_();
        if (!path.startsWith("used/")) {
            return false;
        }
        String itemName = path.substring("used/".length());
        ResourceLocation itemId = new ResourceLocation(statId.m_135827_(), itemName);
        try {
            Item item = (Item)BuiltInRegistries.f_257033_.m_7745_(itemId);
            if (item == null) {
                return false;
            }
            return item.m_41473_() != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static boolean isHostileMob(ResourceLocation statId) {
        String entityName;
        String path = statId.m_135815_();
        if (path.startsWith("killed/")) {
            entityName = path.substring("killed/".length());
        } else if (path.startsWith("killed_by/")) {
            entityName = path.substring("killed_by/".length());
        } else {
            return false;
        }
        ResourceLocation entityId = new ResourceLocation(statId.m_135827_(), entityName);
        try {
            EntityType entityType = (EntityType)BuiltInRegistries.f_256780_.m_7745_(entityId);
            if (entityType == null) {
                return false;
            }
            MobCategory category = entityType.m_20674_();
            return category == MobCategory.MONSTER;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static StatCategory findCategory(ResourceLocation statId) {
        for (StatCategory category : ORDERED_CATEGORIES) {
            if (!category.getFilter().test(statId)) continue;
            return category;
        }
        return CATEGORIES.get(GENERAL_ID);
    }
}

