/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.beautiful_statistics_screen.custom;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.texboobcat.beautiful_statistics_screen.api.IconRenderer;
import org.texboobcat.beautiful_statistics_screen.api.StatCategory;
import org.texboobcat.beautiful_statistics_screen.api.StatEntry;
import org.texboobcat.beautiful_statistics_screen.core.StatCategoryRegistry;
import org.texboobcat.beautiful_statistics_screen.custom.CustomStatDefinition;
import org.texboobcat.beautiful_statistics_screen.custom.CustomStatManager;

public class CustomStatAdapter {
    public static List<StatEntry> getCustomStatEntries() {
        ArrayList<StatEntry> entries = new ArrayList<StatEntry>();
        Collection<CustomStatDefinition> customStats = CustomStatManager.getAllCustomStats();
        for (CustomStatDefinition customStat : customStats) {
            if (!customStat.isEnabled()) continue;
            ResourceLocation statId = new ResourceLocation("beautiful_statistics_screen", "custom_stat/" + customStat.getId());
            StatCategory category = StatCategoryRegistry.getCategory(StatCategoryRegistry.CUSTOM_ID);
            IconRenderer iconRenderer = CustomStatAdapter.createIconRenderer(customStat.getIcon());
            StatEntry entry = new StatEntry(statId, category, customStat.getCurrentValue(), (Component)Component.m_237113_((String)customStat.getName()), (Component)Component.m_237113_((String)(customStat.getDescription() != null ? customStat.getDescription() : "")), iconRenderer);
            entries.add(entry);
        }
        return entries;
    }

    public static StatEntry getCustomStatEntry(String customStatId) {
        CustomStatDefinition customStat = CustomStatManager.getCustomStat(customStatId);
        if (customStat == null) {
            return null;
        }
        ResourceLocation statId = new ResourceLocation("beautiful_statistics_screen", "custom_stat/" + customStat.getId());
        StatCategory category = StatCategoryRegistry.getCategory(StatCategoryRegistry.CUSTOM_ID);
        IconRenderer iconRenderer = CustomStatAdapter.createIconRenderer(customStat.getIcon());
        return new StatEntry(statId, category, customStat.getCurrentValue(), (Component)Component.m_237113_((String)customStat.getName()), (Component)Component.m_237113_((String)(customStat.getDescription() != null ? customStat.getDescription() : "")), iconRenderer);
    }

    public static boolean isCustomStat(ResourceLocation statId) {
        return statId.m_135827_().equals("beautiful_statistics_screen") && statId.m_135815_().startsWith("custom_stat/");
    }

    public static String extractCustomStatId(ResourceLocation statId) {
        if (!CustomStatAdapter.isCustomStat(statId)) {
            return null;
        }
        return statId.m_135815_().substring("custom_stat/".length());
    }

    private static IconRenderer createIconRenderer(String iconString) {
        if (iconString == null || iconString.isEmpty()) {
            return IconRenderer.EMPTY;
        }
        try {
            ResourceLocation iconId = new ResourceLocation(iconString);
            Item item = (Item)BuiltInRegistries.f_257033_.m_7745_(iconId);
            if (item == null || item == Items.f_41852_) {
                return IconRenderer.EMPTY;
            }
            return (graphics, x, y, size) -> {
                ItemStack stack = new ItemStack((ItemLike)item);
                int offsetX = Math.max(0, (size - 16) / 2);
                int offsetY = Math.max(0, (size - 16) / 2);
                graphics.m_280480_(stack, x + offsetX, y + offsetY);
            };
        }
        catch (Exception e) {
            return IconRenderer.EMPTY;
        }
    }
}

