/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.beautiful_statistics_screen.custom;

import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.texboobcat.beautiful_statistics_screen.custom.StatGoal;
import org.texboobcat.beautiful_statistics_screen.custom.conditions.ConditionGroup;
import org.texboobcat.beautiful_statistics_screen.custom.conditions.ConditionalBlock;
import org.texboobcat.beautiful_statistics_screen.util.StatFormatter;

public class CustomStatDefinition {
    @SerializedName(value="id")
    private String id = UUID.randomUUID().toString();
    @SerializedName(value="name")
    private String name;
    @SerializedName(value="description")
    private String description;
    @SerializedName(value="icon")
    private String icon;
    @SerializedName(value="trackingType")
    private TrackingType trackingType;
    @SerializedName(value="targets")
    private List<String> targets = new ArrayList<String>();
    @SerializedName(value="conditionGroup")
    private ConditionGroup conditionGroup = new ConditionGroup();
    @SerializedName(value="conditionalBlock")
    private ConditionalBlock conditionalBlock;
    @SerializedName(value="aggregationType")
    private AggregationType aggregationType;
    @SerializedName(value="formatType")
    private FormatType formatType;
    @SerializedName(value="category")
    private String category = "custom";
    @SerializedName(value="currentValue")
    private long currentValue = 0L;
    @SerializedName(value="enabled")
    private boolean enabled = true;
    @SerializedName(value="createdTime")
    private long createdTime;
    @SerializedName(value="lastUpdated")
    private long lastUpdated;
    @SerializedName(value="goals")
    private List<StatGoal> goals = new ArrayList<StatGoal>();
    @SerializedName(value="color")
    private String color = "#FFFFFF";
    @SerializedName(value="tags")
    private List<String> tags = new ArrayList<String>();
    @SerializedName(value="pinned")
    private boolean pinned = false;
    @SerializedName(value="showInHud")
    private boolean showInHud = false;
    @SerializedName(value="notes")
    private String notes;

    public CustomStatDefinition() {
        this.createdTime = System.currentTimeMillis();
        this.lastUpdated = System.currentTimeMillis();
        this.aggregationType = AggregationType.SUM;
        this.formatType = FormatType.NUMBER;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getIcon() {
        return this.icon;
    }

    public TrackingType getTrackingType() {
        return this.trackingType;
    }

    public List<String> getTargets() {
        return this.targets;
    }

    public ConditionGroup getConditionGroup() {
        return this.conditionGroup;
    }

    public ConditionalBlock getConditionalBlock() {
        return this.conditionalBlock;
    }

    public ConditionGroup getEffectiveConditionGroup() {
        if (this.conditionalBlock != null) {
            return this.conditionalBlock.toConditionGroup();
        }
        return this.conditionGroup;
    }

    public boolean usesAdvancedBlocks() {
        return this.conditionalBlock != null;
    }

    public AggregationType getAggregationType() {
        return this.aggregationType;
    }

    public FormatType getFormatType() {
        return this.formatType;
    }

    public String getCategory() {
        return this.category;
    }

    public long getCurrentValue() {
        return this.currentValue;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public long getCreatedTime() {
        return this.createdTime;
    }

    public long getLastUpdated() {
        return this.lastUpdated;
    }

    public List<StatGoal> getGoals() {
        return this.goals;
    }

    public String getColor() {
        return this.color;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public boolean isPinned() {
        return this.pinned;
    }

    public boolean isShowInHud() {
        return this.showInHud;
    }

    public String getNotes() {
        return this.notes;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public void setTrackingType(TrackingType trackingType) {
        this.trackingType = trackingType;
    }

    public void setTargets(List<String> targets) {
        this.targets = targets;
    }

    public void setConditionGroup(ConditionGroup conditionGroup) {
        this.conditionGroup = conditionGroup;
        this.conditionalBlock = null;
    }

    public void setConditionalBlock(ConditionalBlock conditionalBlock) {
        this.conditionalBlock = conditionalBlock;
        this.conditionGroup = null;
    }

    public void setAggregationType(AggregationType aggregationType) {
        this.aggregationType = aggregationType;
    }

    public void setFormatType(FormatType formatType) {
        this.formatType = formatType;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setGoals(List<StatGoal> goals) {
        this.goals = goals;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public void setPinned(boolean pinned) {
        this.pinned = pinned;
    }

    public void setShowInHud(boolean showInHud) {
        this.showInHud = showInHud;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    public void addTarget(String target) {
        if (!this.targets.contains(target)) {
            this.targets.add(target);
        }
    }

    public void removeTarget(String target) {
        this.targets.remove(target);
    }

    public void addGoal(StatGoal goal) {
        this.goals.add(goal);
    }

    public void removeGoal(StatGoal goal) {
        this.goals.remove(goal);
    }

    public void addTag(String tag) {
        if (!this.tags.contains(tag)) {
            this.tags.add(tag);
        }
    }

    public void removeTag(String tag) {
        this.tags.remove(tag);
    }

    public void increment(long amount) {
        this.currentValue += amount;
        this.lastUpdated = System.currentTimeMillis();
        this.checkGoals();
    }

    public List<StatGoal> checkGoals() {
        ArrayList<StatGoal> newlyAchieved = new ArrayList<StatGoal>();
        for (StatGoal goal : this.goals) {
            if (!goal.checkAndMarkAchieved(this.currentValue)) continue;
            newlyAchieved.add(goal);
        }
        return newlyAchieved;
    }

    public void reset() {
        this.currentValue = 0L;
        this.lastUpdated = System.currentTimeMillis();
    }

    public void regenerateId() {
        this.id = UUID.randomUUID().toString();
        this.createdTime = System.currentTimeMillis();
        this.lastUpdated = System.currentTimeMillis();
    }

    public Component getDisplayName() {
        return Component.m_237113_((String)(this.name != null ? this.name : "Unnamed Stat"));
    }

    public Component getDescriptionComponent() {
        return Component.m_237113_((String)(this.description != null ? this.description : ""));
    }

    public String getFormattedValue() {
        switch (this.formatType.ordinal()) {
            case 1: {
                return StatFormatter.formatDistance(this.currentValue);
            }
            case 2: {
                return StatFormatter.formatTime(this.currentValue);
            }
            case 4: {
                return StatFormatter.formatDamage(this.currentValue);
            }
            case 3: {
                return String.format("%.2f%%", (double)this.currentValue / 100.0);
            }
        }
        return StatFormatter.formatValueFull(this.currentValue);
    }

    public ResourceLocation getResourceLocation() {
        return new ResourceLocation("beautiful_statistics_screen", "custom/" + this.id);
    }

    public String toString() {
        return "CustomStat{name='" + this.name + "', trackingType=" + String.valueOf((Object)this.trackingType) + ", targets=" + this.targets.size() + ", value=" + this.currentValue + "}";
    }

    public static enum AggregationType {
        SUM("Sum All", "Add all tracked values together"),
        INDIVIDUAL("Track Each", "Track each target separately"),
        AVERAGE("Average", "Calculate average of all targets"),
        MAX("Maximum", "Track only the highest value"),
        MIN("Minimum", "Track only the lowest value");

        private final String displayName;
        private final String description;

        private AggregationType(String displayName, String description) {
            this.displayName = displayName;
            this.description = description;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public String getDescription() {
            return this.description;
        }
    }

    public static enum FormatType {
        NUMBER("Number", "1,234,567"),
        DISTANCE("Distance", "12.3 km"),
        TIME("Time", "1h 23m 45s"),
        PERCENTAGE("Percentage", "78.9%"),
        DAMAGE("Damage", "123.5 HP");

        private final String displayName;
        private final String example;

        private FormatType(String displayName, String example) {
            this.displayName = displayName;
            this.example = example;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public String getExample() {
            return this.example;
        }
    }

    public static enum TrackingType {
        BLOCK_MINED("Block Mined", "Track blocks broken"),
        BLOCK_PLACED("Block Placed", "Track blocks placed"),
        ITEM_USED("Item Used", "Track items used"),
        ITEM_CRAFTED("Item Crafted", "Track items crafted"),
        ITEM_PICKED_UP("Item Picked Up", "Track items picked up"),
        ITEM_DROPPED("Item Dropped", "Track items dropped"),
        ENTITY_KILLED("Entity Killed", "Track entities killed"),
        ENTITY_BRED("Entity Bred", "Track entities bred"),
        DAMAGE_DEALT("Damage Dealt", "Track damage dealt"),
        DAMAGE_TAKEN("Damage Taken", "Track damage taken"),
        DISTANCE_TRAVELED("Distance Traveled", "Track distance in specific conditions"),
        TIME_ELAPSED("Time Elapsed", "Track time spent in conditions"),
        CUSTOM_EVENT("Custom Event", "Track custom game events");

        private final String displayName;
        private final String description;

        private TrackingType(String displayName, String description) {
            this.displayName = displayName;
            this.description = description;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public String getDescription() {
            return this.description;
        }
    }

    public static class Condition {
        @SerializedName(value="type")
        private ConditionType type;
        @SerializedName(value="value")
        private String value;
        @SerializedName(value="operator")
        private Operator operator;

        public Condition() {
        }

        public Condition(ConditionType type, Operator operator, String value) {
            this.type = type;
            this.operator = operator;
            this.value = value;
        }

        public ConditionType getType() {
            return this.type;
        }

        public Operator getOperator() {
            return this.operator;
        }

        public String getValue() {
            return this.value;
        }

        public void setType(ConditionType type) {
            this.type = type;
        }

        public void setOperator(Operator operator) {
            this.operator = operator;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public static enum ConditionType {
            BIOME("In Biome", "minecraft:plains"),
            DIMENSION("In Dimension", "minecraft:overworld"),
            Y_LEVEL("Y Level", "64"),
            LIGHT_LEVEL("Light Level", "15"),
            WEATHER("Weather", "rain"),
            TIME_OF_DAY("Time of Day", "day"),
            GAME_MODE("Game Mode", "survival"),
            EFFECT("Has Effect", "minecraft:speed"),
            TOOL_TYPE("Tool Type", "minecraft:diamond_pickaxe"),
            ENCHANTMENT("Has Enchantment", "minecraft:fortune");

            private final String displayName;
            private final String exampleValue;

            private ConditionType(String displayName, String exampleValue) {
                this.displayName = displayName;
                this.exampleValue = exampleValue;
            }

            public String getDisplayName() {
                return this.displayName;
            }

            public String getExampleValue() {
                return this.exampleValue;
            }
        }

        public static enum Operator {
            EQUALS("="),
            NOT_EQUALS("\u2260"),
            GREATER_THAN(">"),
            LESS_THAN("<"),
            GREATER_OR_EQUAL("\u2265"),
            LESS_OR_EQUAL("\u2264"),
            CONTAINS("contains");

            private final String symbol;

            private Operator(String symbol) {
                this.symbol = symbol;
            }

            public String getSymbol() {
                return this.symbol;
            }
        }
    }
}

