/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.beautiful_statistics_screen.custom;

import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import org.texboobcat.beautiful_statistics_screen.custom.CustomStatDefinition;
import org.texboobcat.beautiful_statistics_screen.custom.CustomStatManager;

public class CustomStatTracker {
    public static void onBlockMined(Block block, int count) {
        ResourceLocation blockId = BuiltInRegistries.f_256975_.m_7981_((Object)block);
        CustomStatTracker.trackEvent(CustomStatDefinition.TrackingType.BLOCK_MINED, blockId.toString(), count);
    }

    public static void onBlockPlaced(Block block, int count) {
        ResourceLocation blockId = BuiltInRegistries.f_256975_.m_7981_((Object)block);
        CustomStatTracker.trackEvent(CustomStatDefinition.TrackingType.BLOCK_PLACED, blockId.toString(), count);
    }

    public static void onItemUsed(Item item, int count) {
        ResourceLocation itemId = BuiltInRegistries.f_257033_.m_7981_((Object)item);
        CustomStatTracker.trackEvent(CustomStatDefinition.TrackingType.ITEM_USED, itemId.toString(), count);
    }

    public static void onItemCrafted(Item item, int count) {
        ResourceLocation itemId = BuiltInRegistries.f_257033_.m_7981_((Object)item);
        CustomStatTracker.trackEvent(CustomStatDefinition.TrackingType.ITEM_CRAFTED, itemId.toString(), count);
    }

    public static void onItemPickedUp(Item item, int count) {
        ResourceLocation itemId = BuiltInRegistries.f_257033_.m_7981_((Object)item);
        CustomStatTracker.trackEvent(CustomStatDefinition.TrackingType.ITEM_PICKED_UP, itemId.toString(), count);
    }

    public static void onItemDropped(Item item, int count) {
        ResourceLocation itemId = BuiltInRegistries.f_257033_.m_7981_((Object)item);
        CustomStatTracker.trackEvent(CustomStatDefinition.TrackingType.ITEM_DROPPED, itemId.toString(), count);
    }

    public static void onEntityKilled(Entity entity) {
        ResourceLocation entityId = BuiltInRegistries.f_256780_.m_7981_((Object)entity.m_6095_());
        CustomStatTracker.trackEvent(CustomStatDefinition.TrackingType.ENTITY_KILLED, entityId.toString(), 1L);
    }

    public static void onEntityBred(Entity entity) {
        ResourceLocation entityId = BuiltInRegistries.f_256780_.m_7981_((Object)entity.m_6095_());
        CustomStatTracker.trackEvent(CustomStatDefinition.TrackingType.ENTITY_BRED, entityId.toString(), 1L);
    }

    public static void onDamageDealt(float amount, Entity target) {
        ResourceLocation targetId = target != null ? BuiltInRegistries.f_256780_.m_7981_((Object)target.m_6095_()) : new ResourceLocation("minecraft", "unknown");
        CustomStatTracker.trackEvent(CustomStatDefinition.TrackingType.DAMAGE_DEALT, targetId.toString(), Math.round(amount * 10.0f));
    }

    public static void onDamageTaken(float amount, Entity source) {
        ResourceLocation sourceId = source != null ? BuiltInRegistries.f_256780_.m_7981_((Object)source.m_6095_()) : new ResourceLocation("minecraft", "unknown");
        CustomStatTracker.trackEvent(CustomStatDefinition.TrackingType.DAMAGE_TAKEN, sourceId.toString(), Math.round(amount * 10.0f));
    }

    public static void onDistanceTraveled(String movementType, long distanceCm) {
        CustomStatTracker.trackEvent(CustomStatDefinition.TrackingType.DISTANCE_TRAVELED, movementType, distanceCm);
    }

    public static void onTick() {
        List<CustomStatDefinition> timeStats = CustomStatManager.getMatchingStats(CustomStatDefinition.TrackingType.TIME_ELAPSED, "*");
        for (CustomStatDefinition stat : timeStats) {
            if (!CustomStatManager.checkConditions(stat)) continue;
            CustomStatManager.incrementStat(stat.getId(), 1L);
        }
    }

    public static void trackCustomEvent(String eventName, long amount) {
        CustomStatTracker.trackEvent(CustomStatDefinition.TrackingType.CUSTOM_EVENT, eventName, amount);
    }

    private static void trackEvent(CustomStatDefinition.TrackingType trackingType, String targetId, long amount) {
        if (!CustomStatManager.isInitialized()) {
            return;
        }
        List<CustomStatDefinition> matchingStats = CustomStatManager.getMatchingStats(trackingType, targetId);
        for (CustomStatDefinition stat : matchingStats) {
            if (!CustomStatManager.checkConditions(stat)) continue;
            switch (stat.getAggregationType()) {
                case SUM: 
                case INDIVIDUAL: {
                    CustomStatManager.incrementStat(stat.getId(), amount);
                    break;
                }
                case AVERAGE: {
                    CustomStatManager.incrementStat(stat.getId(), amount);
                    break;
                }
                case MAX: {
                    if (amount <= stat.getCurrentValue()) break;
                    stat.increment(amount - stat.getCurrentValue());
                    break;
                }
                case MIN: {
                    if (stat.getCurrentValue() != 0L && amount >= stat.getCurrentValue()) break;
                    stat.reset();
                    stat.increment(amount);
                }
            }
        }
    }

    public static void trackItemStack(CustomStatDefinition.TrackingType trackingType, ItemStack stack) {
        if (stack.m_41619_()) {
            return;
        }
        ResourceLocation itemId = BuiltInRegistries.f_257033_.m_7981_((Object)stack.m_41720_());
        CustomStatTracker.trackEvent(trackingType, itemId.toString(), stack.m_41613_());
    }
}

