/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.beautiful_statistics_screen.custom;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.zip.GZIPOutputStream;
import net.minecraft.client.Minecraft;
import org.texboobcat.beautiful_statistics_screen.custom.CustomStatDefinition;
import org.texboobcat.beautiful_statistics_screen.custom.CustomStatManager;

public class StatImportExport {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final String EXPORT_FOLDER = "custom_stats_export";
    private static final String FILE_EXTENSION = ".customstat";

    public static boolean exportStat(CustomStatDefinition stat, String filename) {
        try {
            Path exportDir = StatImportExport.getExportDirectory();
            Files.createDirectories(exportDir, new FileAttribute[0]);
            if (!((String)filename).endsWith(FILE_EXTENSION)) {
                filename = StatImportExport.sanitizeFilename((String)filename) + FILE_EXTENSION;
            }
            Path exportPath = exportDir.resolve((String)filename);
            StatExportPackage exportPackage = new StatExportPackage();
            exportPackage.version = "2.0";
            exportPackage.exportDate = System.currentTimeMillis();
            exportPackage.stat = stat;
            exportPackage.metadata = StatImportExport.createMetadata(stat);
            StatImportExport.writeCompressed(exportPath, GSON.toJson((Object)exportPackage));
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean exportStats(List<CustomStatDefinition> stats, String filename) {
        try {
            Path exportDir = StatImportExport.getExportDirectory();
            Files.createDirectories(exportDir, new FileAttribute[0]);
            if (!((String)filename).endsWith(FILE_EXTENSION)) {
                filename = StatImportExport.sanitizeFilename((String)filename) + FILE_EXTENSION;
            }
            Path exportPath = exportDir.resolve((String)filename);
            StatExportPackage exportPackage = new StatExportPackage();
            exportPackage.version = "2.0";
            exportPackage.exportDate = System.currentTimeMillis();
            exportPackage.stats = stats;
            exportPackage.metadata = StatImportExport.createBulkMetadata(stats);
            StatImportExport.writeCompressed(exportPath, GSON.toJson((Object)exportPackage));
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static ImportResult importStat(String filename) {
        try {
            Path exportDir = StatImportExport.getExportDirectory();
            Path importPath = exportDir.resolve(filename);
            if (!Files.exists(importPath, new LinkOption[0])) {
                return new ImportResult(false, "File not found: " + filename, null);
            }
            String json = StatImportExport.readCompressed(importPath);
            StatExportPackage exportPackage = (StatExportPackage)GSON.fromJson(json, StatExportPackage.class);
            if (exportPackage == null) {
                return new ImportResult(false, "Invalid file format", null);
            }
            ArrayList<CustomStatDefinition> imported = new ArrayList<CustomStatDefinition>();
            if (exportPackage.stat != null) {
                CustomStatDefinition stat = exportPackage.stat;
                stat.regenerateId();
                stat.reset();
                imported.add(stat);
            }
            if (exportPackage.stats != null) {
                for (CustomStatDefinition stat : exportPackage.stats) {
                    stat.regenerateId();
                    stat.reset();
                    imported.add(stat);
                }
            }
            if (imported.isEmpty()) {
                return new ImportResult(false, "No stats found in file", null);
            }
            return new ImportResult(true, "Imported " + imported.size() + " stat(s)", imported);
        }
        catch (JsonSyntaxException e) {
            return new ImportResult(false, "Invalid JSON format: " + e.getMessage(), null);
        }
        catch (IOException e) {
            return new ImportResult(false, "Error reading file: " + e.getMessage(), null);
        }
        catch (Exception e) {
            return new ImportResult(false, "Unexpected error: " + e.getMessage(), null);
        }
    }

    public static boolean exportAllStats(String filename) {
        ArrayList<CustomStatDefinition> allStats = new ArrayList<CustomStatDefinition>(CustomStatManager.getAllCustomStats());
        if (allStats.isEmpty()) {
            return false;
        }
        return StatImportExport.exportStats(allStats, filename);
    }

    public static List<String> getAvailableImports() {
        try {
            Path exportDir = StatImportExport.getExportDirectory();
            if (!Files.exists(exportDir, new LinkOption[0])) {
                return new ArrayList<String>();
            }
            ArrayList<String> files = new ArrayList<String>();
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(exportDir, "*.customstat");){
                for (Path entry : stream) {
                    files.add(entry.getFileName().toString());
                }
            }
            files.sort(Comparator.reverseOrder());
            return files;
        }
        catch (IOException e) {
            e.printStackTrace();
            return new ArrayList<String>();
        }
    }

    private static Path getExportDirectory() {
        return Minecraft.m_91087_().f_91069_.toPath().resolve("config").resolve("beautiful_statistics").resolve(EXPORT_FOLDER);
    }

    private static String sanitizeFilename(String filename) {
        return filename.replaceAll("[^a-zA-Z0-9._-]", "_");
    }

    private static ExportMetadata createMetadata(CustomStatDefinition stat) {
        ExportMetadata metadata = new ExportMetadata();
        metadata.statName = stat.getName();
        metadata.category = stat.getCategory();
        metadata.trackingType = stat.getTrackingType().getDisplayName();
        metadata.hasConditions = stat.getConditionGroup() != null || stat.getConditionalBlock() != null;
        metadata.usesScratchBlocks = stat.getConditionalBlock() != null;
        metadata.blockCount = stat.getConditionalBlock() != null ? stat.getConditionalBlock().getTotalBlockCount() : 0;
        return metadata;
    }

    private static ExportMetadata createBulkMetadata(List<CustomStatDefinition> stats) {
        ExportMetadata metadata = new ExportMetadata();
        metadata.statCount = stats.size();
        metadata.hasConditions = stats.stream().anyMatch(s -> s.getConditionGroup() != null || s.getConditionalBlock() != null);
        metadata.usesScratchBlocks = stats.stream().anyMatch(s -> s.getConditionalBlock() != null);
        return metadata;
    }

    private static void writeCompressed(Path path, String data) throws IOException {
        try (OutputStream fos = Files.newOutputStream(path, new OpenOption[0]);
             GZIPOutputStream gos = new GZIPOutputStream(fos);
             OutputStreamWriter writer = new OutputStreamWriter((OutputStream)gos, StandardCharsets.UTF_8);){
            writer.write(data);
        }
    }

    /*
     * Exception decompiling
     */
    private static String readCompressed(Path path) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static class StatExportPackage {
        public String version;
        public long exportDate;
        public CustomStatDefinition stat;
        public List<CustomStatDefinition> stats;
        public ExportMetadata metadata;
    }

    public static class ExportMetadata {
        public String statName;
        public String category;
        public String trackingType;
        public boolean hasConditions;
        public boolean usesScratchBlocks;
        public int blockCount;
        public int statCount;
    }

    public static class ImportResult {
        public final boolean success;
        public final String message;
        public final List<CustomStatDefinition> importedStats;

        public ImportResult(boolean success, String message, List<CustomStatDefinition> importedStats) {
            this.success = success;
            this.message = message;
            this.importedStats = importedStats;
        }
    }
}

