/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.beautiful_statistics_screen.custom.conditions;

import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.texboobcat.beautiful_statistics_screen.custom.conditions.ComparisonOperator;
import org.texboobcat.beautiful_statistics_screen.custom.conditions.ConditionGroup;
import org.texboobcat.beautiful_statistics_screen.custom.conditions.LogicMode;
import org.texboobcat.beautiful_statistics_screen.custom.conditions.StatCondition;

public class StatConditionEvaluator {
    public static boolean evaluate(ConditionGroup group, LocalPlayer player) {
        if (group == null || group.getConditions().isEmpty()) {
            return true;
        }
        boolean result = group.getLogicMode() == LogicMode.AND;
        for (StatCondition condition : group.getConditions()) {
            boolean conditionResult = StatConditionEvaluator.evaluateSingle(condition, player);
            if (group.getLogicMode() == LogicMode.AND) {
                if (result = result && conditionResult) continue;
                return false;
            }
            if (!(result = result || conditionResult)) continue;
            return true;
        }
        return result;
    }

    public static boolean evaluateSingle(StatCondition condition, LocalPlayer player) {
        if (player == null || player.m_9236_() == null) {
            return false;
        }
        try {
            boolean result;
            switch (condition.getType()) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case BIOME: {
                    boolean bl = StatConditionEvaluator.checkBiome(condition, player);
                    break;
                }
                case DIMENSION: {
                    boolean bl = StatConditionEvaluator.checkDimension(condition, player);
                    break;
                }
                case Y_LEVEL: {
                    boolean bl = StatConditionEvaluator.checkYLevel(condition, player);
                    break;
                }
                case LIGHT_LEVEL: {
                    boolean bl = StatConditionEvaluator.checkLightLevel(condition, player);
                    break;
                }
                case WEATHER: {
                    boolean bl = StatConditionEvaluator.checkWeather(condition, player);
                    break;
                }
                case TIME_OF_DAY: {
                    boolean bl = StatConditionEvaluator.checkTimeOfDay(condition, player);
                    break;
                }
                case GAME_MODE: {
                    boolean bl = StatConditionEvaluator.checkGameMode(condition, player);
                    break;
                }
                case EFFECT: {
                    boolean bl = StatConditionEvaluator.checkEffect(condition, player);
                    break;
                }
                case ITEM_IN_HAND: {
                    boolean bl = StatConditionEvaluator.checkItemInHand(condition, player);
                    break;
                }
                case ITEM_TAG: {
                    boolean bl = StatConditionEvaluator.checkItemTag(condition, player);
                    break;
                }
                case BLOCK_BELOW: {
                    boolean bl = StatConditionEvaluator.checkBlockBelow(condition, player);
                    break;
                }
                case ON_GROUND: {
                    boolean bl = StatConditionEvaluator.checkOnGround(condition, player);
                    break;
                }
                case IN_WATER: {
                    boolean bl = StatConditionEvaluator.checkInWater(condition, player);
                    break;
                }
                case IN_LAVA: {
                    boolean bl = StatConditionEvaluator.checkInLava(condition, player);
                    break;
                }
                case HEALTH: {
                    boolean bl = StatConditionEvaluator.checkHealth(condition, player);
                    break;
                }
                case HUNGER: {
                    boolean bl = StatConditionEvaluator.checkHunger(condition, player);
                    break;
                }
                case EXPERIENCE_LEVEL: {
                    boolean bl = StatConditionEvaluator.checkExperienceLevel(condition, player);
                    break;
                }
                case CUSTOM_TAG: {
                    boolean bl = result = StatConditionEvaluator.checkCustomTag(condition, player);
                }
            }
            return condition.isNegated() ? !result : result;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static boolean checkBiome(StatCondition condition, LocalPlayer player) {
        BlockPos pos = player.m_20183_();
        Holder biomeHolder = player.m_9236_().m_204166_(pos);
        ResourceLocation biomeId = biomeHolder.m_203543_().map(ResourceKey::m_135782_).orElse(null);
        if (biomeId != null) {
            return StatConditionEvaluator.compareString(biomeId.toString(), condition.getValue(), condition.getOperator());
        }
        return false;
    }

    private static boolean checkDimension(StatCondition condition, LocalPlayer player) {
        ResourceLocation dimensionId = player.m_9236_().m_46472_().m_135782_();
        return StatConditionEvaluator.compareString(dimensionId.toString(), condition.getValue(), condition.getOperator());
    }

    private static boolean checkYLevel(StatCondition condition, LocalPlayer player) {
        int yLevel = player.m_20183_().m_123342_();
        return StatConditionEvaluator.compareNumeric(yLevel, condition.getValue(), condition.getOperator());
    }

    private static boolean checkLightLevel(StatCondition condition, LocalPlayer player) {
        BlockPos pos = player.m_20183_();
        int lightLevel = player.m_9236_().m_46803_(pos);
        return StatConditionEvaluator.compareNumeric(lightLevel, condition.getValue(), condition.getOperator());
    }

    private static boolean checkWeather(StatCondition condition, LocalPlayer player) {
        Level level = player.m_9236_();
        String weather = level.m_46471_() ? (level.m_46470_() ? "thunder" : "rain") : "clear";
        return StatConditionEvaluator.compareString(weather, condition.getValue(), condition.getOperator());
    }

    private static boolean checkTimeOfDay(StatCondition condition, LocalPlayer player) {
        long time = player.m_9236_().m_46468_() % 24000L;
        String timeOfDay = time >= 0L && time < 6000L ? "morning" : (time >= 6000L && time < 12000L ? "day" : (time >= 12000L && time < 18000L ? "evening" : "night"));
        return StatConditionEvaluator.compareString(timeOfDay, condition.getValue(), condition.getOperator());
    }

    private static boolean checkGameMode(StatCondition condition, LocalPlayer player) {
        String gameMode = player.m_150110_().f_35937_ ? "creative" : (player.m_5833_() ? "spectator" : "survival");
        return StatConditionEvaluator.compareString(gameMode, condition.getValue(), condition.getOperator());
    }

    private static boolean checkEffect(StatCondition condition, LocalPlayer player) {
        String effectId = condition.getValue();
        ResourceLocation effectLoc = ResourceLocation.m_135820_((String)effectId);
        if (effectLoc == null) {
            return false;
        }
        return player.m_21220_().stream().anyMatch(effect -> {
            ResourceLocation id = player.m_9236_().m_9598_().m_175515_(Registries.f_256929_).m_7981_((Object)effect.m_19544_());
            return id != null && id.equals((Object)effectLoc);
        });
    }

    private static boolean checkItemInHand(StatCondition condition, LocalPlayer player) {
        ItemStack mainHand = player.m_21205_();
        ItemStack offHand = player.m_21206_();
        String itemId = condition.getValue();
        boolean mainHandMatch = StatConditionEvaluator.checkItemMatch(mainHand, itemId, condition.getOperator());
        boolean offHandMatch = StatConditionEvaluator.checkItemMatch(offHand, itemId, condition.getOperator());
        return mainHandMatch || offHandMatch;
    }

    private static boolean checkItemTag(StatCondition condition, LocalPlayer player) {
        ItemStack mainHand = player.m_21205_();
        ItemStack offHand = player.m_21206_();
        String tagId = condition.getValue();
        ResourceLocation tagLoc = ResourceLocation.m_135820_((String)tagId);
        if (tagLoc == null) {
            return false;
        }
        TagKey tag = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)tagLoc);
        return mainHand.m_204117_(tag) || offHand.m_204117_(tag);
    }

    private static boolean checkBlockBelow(StatCondition condition, LocalPlayer player) {
        BlockPos belowPos = player.m_20183_().m_7495_();
        ResourceLocation blockId = player.m_9236_().m_9598_().m_175515_(Registries.f_256747_).m_7981_((Object)player.m_9236_().m_8055_(belowPos).m_60734_());
        if (blockId == null) {
            return false;
        }
        return StatConditionEvaluator.compareString(blockId.toString(), condition.getValue(), condition.getOperator());
    }

    private static boolean checkOnGround(StatCondition condition, LocalPlayer player) {
        boolean expectedOnGround;
        boolean onGround = player.m_20096_();
        return onGround == (expectedOnGround = Boolean.parseBoolean(condition.getValue()));
    }

    private static boolean checkInWater(StatCondition condition, LocalPlayer player) {
        boolean expectedInWater;
        boolean inWater = player.m_20069_();
        return inWater == (expectedInWater = Boolean.parseBoolean(condition.getValue()));
    }

    private static boolean checkInLava(StatCondition condition, LocalPlayer player) {
        boolean expectedInLava;
        boolean inLava = player.m_20077_();
        return inLava == (expectedInLava = Boolean.parseBoolean(condition.getValue()));
    }

    private static boolean checkHealth(StatCondition condition, LocalPlayer player) {
        float health = player.m_21223_();
        return StatConditionEvaluator.compareNumeric(health, condition.getValue(), condition.getOperator());
    }

    private static boolean checkHunger(StatCondition condition, LocalPlayer player) {
        int hunger = player.m_36324_().m_38702_();
        return StatConditionEvaluator.compareNumeric(hunger, condition.getValue(), condition.getOperator());
    }

    private static boolean checkExperienceLevel(StatCondition condition, LocalPlayer player) {
        int level = player.f_36078_;
        return StatConditionEvaluator.compareNumeric(level, condition.getValue(), condition.getOperator());
    }

    private static boolean checkCustomTag(StatCondition condition, LocalPlayer player) {
        return false;
    }

    private static boolean checkItemMatch(ItemStack stack, String itemId, ComparisonOperator operator) {
        if (stack.m_41619_()) {
            return false;
        }
        ResourceLocation stackId = stack.m_41720_().m_204114_().m_205785_().m_135782_();
        return StatConditionEvaluator.compareString(stackId.toString(), itemId, operator);
    }

    private static boolean compareString(String actual, String expected, ComparisonOperator operator) {
        return switch (operator) {
            case ComparisonOperator.EQUALS -> actual.equals(expected);
            case ComparisonOperator.NOT_EQUALS -> {
                if (!actual.equals(expected)) {
                    yield true;
                }
                yield false;
            }
            case ComparisonOperator.CONTAINS -> actual.contains(expected);
            case ComparisonOperator.STARTS_WITH -> actual.startsWith(expected);
            case ComparisonOperator.ENDS_WITH -> actual.endsWith(expected);
            case ComparisonOperator.MATCHES_REGEX -> actual.matches(expected);
            default -> false;
        };
    }

    private static boolean compareNumeric(double actual, String expectedStr, ComparisonOperator operator) {
        try {
            double expected = Double.parseDouble(expectedStr);
            return switch (operator) {
                case ComparisonOperator.EQUALS -> {
                    if (Math.abs(actual - expected) < 0.001) {
                        yield true;
                    }
                    yield false;
                }
                case ComparisonOperator.NOT_EQUALS -> {
                    if (Math.abs(actual - expected) >= 0.001) {
                        yield true;
                    }
                    yield false;
                }
                case ComparisonOperator.GREATER_THAN -> {
                    if (actual > expected) {
                        yield true;
                    }
                    yield false;
                }
                case ComparisonOperator.LESS_THAN -> {
                    if (actual < expected) {
                        yield true;
                    }
                    yield false;
                }
                case ComparisonOperator.GREATER_OR_EQUAL -> {
                    if (actual >= expected) {
                        yield true;
                    }
                    yield false;
                }
                case ComparisonOperator.LESS_OR_EQUAL -> {
                    if (actual <= expected) {
                        yield true;
                    }
                    yield false;
                }
                default -> false;
            };
        }
        catch (NumberFormatException e) {
            return false;
        }
    }
}

