/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.beautiful_statistics_screen.mixin;

import net.minecraft.stats.ServerStatsCounter;
import net.minecraft.stats.Stat;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.texboobcat.beautiful_statistics_screen.Beautiful_statistics_screen;

@Mixin(value={ServerStatsCounter.class})
public abstract class ServerStatsCounterMixin {
    private long lastAutoSaveTime = 0L;
    private static final long AUTO_SAVE_INTERVAL_MS = 5000L;
    private int changesSinceLastSave = 0;
    private static final int CHANGES_THRESHOLD = 10;

    @Shadow
    public abstract void m_12818_();

    @Inject(method={"setValue"}, at={@At(value="TAIL")})
    private void onStatChanged(Player player, Stat<?> stat, int value, CallbackInfo ci) {
        boolean changeBasedSave;
        ++this.changesSinceLastSave;
        long currentTime = System.currentTimeMillis();
        boolean timeBasedSave = currentTime - this.lastAutoSaveTime >= 5000L;
        boolean bl = changeBasedSave = this.changesSinceLastSave >= 10;
        if (timeBasedSave || changeBasedSave) {
            try {
                this.m_12818_();
                this.lastAutoSaveTime = currentTime;
                this.changesSinceLastSave = 0;
            }
            catch (Exception e) {
                Beautiful_statistics_screen.LOGGER.debug("Failed to auto-save statistics", (Throwable)e);
            }
        }
    }
}

