/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.beautiful_statistics_screen.client.gui;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import org.texboobcat.beautiful_statistics_screen.api.IconRenderer;
import org.texboobcat.beautiful_statistics_screen.api.StatCategory;
import org.texboobcat.beautiful_statistics_screen.api.StatEntry;
import org.texboobcat.beautiful_statistics_screen.client.gui.StatGridWidget;
import org.texboobcat.beautiful_statistics_screen.core.StatCategoryRegistry;

public class SharedStatsScreen
extends class_437 {
    private final class_437 parent;
    private final String playerName;
    private final Map<String, Long> stats;
    private final List<StatEntry> statEntries;
    private StatGridWidget statGrid;
    private StatCategory selectedCategory;
    private final List<StatCategory> categories;

    public SharedStatsScreen(class_437 parent, String playerName, Map<String, Long> stats) {
        super((class_2561)class_2561.method_43470((String)("Statistics: " + playerName)));
        this.parent = parent;
        this.playerName = playerName;
        this.stats = stats;
        this.statEntries = new ArrayList<StatEntry>();
        this.categories = StatCategoryRegistry.getAllCategories();
        if (!this.categories.isEmpty()) {
            this.selectedCategory = this.categories.get(0);
        }
        this.convertStatsToEntries();
    }

    private void convertStatsToEntries() {
        for (Map.Entry<String, Long> entry : this.stats.entrySet()) {
            try {
                class_2960 statId = new class_2960(entry.getKey());
                StatCategory category = StatCategoryRegistry.findCategory(statId);
                class_5250 displayName = class_2561.method_43471((String)("stat." + statId.method_12836() + "." + statId.method_12832()));
                class_5250 description = class_2561.method_43473();
                StatEntry statEntry = new StatEntry(statId, category, entry.getValue(), (class_2561)displayName, (class_2561)description, IconRenderer.EMPTY);
                this.statEntries.add(statEntry);
            }
            catch (Exception exception) {}
        }
    }

    protected void method_25426() {
        super.method_25426();
        int titleY = 10;
        int buttonWidth = 80;
        int buttonSpacing = 5;
        int totalWidth = this.categories.size() * (buttonWidth + buttonSpacing);
        int startX = (this.field_22789 - totalWidth) / 2;
        int y = 35;
        for (int i = 0; i < this.categories.size(); ++i) {
            StatCategory category = this.categories.get(i);
            int x = startX + i * (buttonWidth + buttonSpacing);
            class_4185 categoryButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)category.getDisplayName().getString()), btn -> this.selectCategory(category)).method_46434(x, y, buttonWidth, 20).method_46431();
            this.method_37063((class_364)categoryButton);
        }
        int gridY = 65;
        int gridWidth = this.field_22789 - 40;
        int gridHeight = this.field_22790 - gridY - 50;
        this.statGrid = new StatGridWidget(this.field_22787, 20, gridY, gridWidth, gridHeight, this::onStatClicked, this::onStatRightClicked);
        this.method_37063((class_364)this.statGrid);
        class_4185 backButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.done"), btn -> this.method_25419()).method_46434((this.field_22789 - 200) / 2, this.field_22790 - 30, 200, 20).method_46431();
        this.method_37063((class_364)backButton);
        this.updateDisplayedStats();
    }

    private void selectCategory(StatCategory category) {
        this.selectedCategory = category;
        this.updateDisplayedStats();
        this.method_25423(this.field_22787, this.field_22789, this.field_22790);
    }

    private void updateDisplayedStats() {
        if (this.statGrid == null) {
            return;
        }
        ArrayList<StatEntry> filtered = new ArrayList<StatEntry>();
        for (StatEntry entry : this.statEntries) {
            if (this.selectedCategory != null && !entry.getCategory().equals(this.selectedCategory)) continue;
            filtered.add(entry);
        }
        filtered.sort((a, b) -> Long.compare(b.getValue(), a.getValue()));
        this.statGrid.setStats(filtered);
    }

    private void onStatClicked(StatEntry entry) {
    }

    private void onStatRightClicked(StatEntry entry) {
        if (this.field_22787 != null && this.field_22787.field_1724 != null) {
            this.field_22787.field_1724.method_43496((class_2561)class_2561.method_43470((String)"\u00a77Compare feature coming soon"));
        }
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTick) {
        this.method_25420(graphics);
        graphics.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 10, 0xFFFFFF);
        String info = "\u00a77Viewing stats for: \u00a7f" + this.playerName + " \u00a77(\u00a7e" + this.stats.size() + " stats\u00a77)";
        graphics.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)info), this.field_22789 / 2, 22, 0xFFFFFF);
        super.method_25394(graphics, mouseX, mouseY, partialTick);
        if (this.statGrid != null) {
            this.statGrid.renderTooltip(graphics, mouseX, mouseY);
        }
    }

    public void method_25419() {
        if (this.field_22787 != null) {
            this.field_22787.method_1507(this.parent);
        }
    }

    public boolean method_25421() {
        return false;
    }
}

