/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.beautiful_statistics_screen.client.gui;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import org.texboobcat.beautiful_statistics_screen.snapshot.SnapshotManager;

public class SnapshotDetailScreen
extends class_437 {
    private static final int ENTRY_HEIGHT = 20;
    private static final int PADDING = 10;
    private final class_437 parent;
    private final SnapshotManager.SnapshotInfo info;
    private final SnapshotManager.SnapshotData data;
    private final List<Map.Entry<String, Long>> statEntries;
    private int scrollOffset = 0;
    private String searchQuery = "";

    public SnapshotDetailScreen(class_437 parent, SnapshotManager.SnapshotInfo info, SnapshotManager.SnapshotData data) {
        super((class_2561)class_2561.method_43470((String)("Snapshot: " + info.filename)));
        this.parent = parent;
        this.info = info;
        this.data = data;
        this.statEntries = new ArrayList<Map.Entry<String, Long>>(data.stats.entrySet());
        this.statEntries.sort((a, b) -> Long.compare((Long)b.getValue(), (Long)a.getValue()));
    }

    protected void method_25426() {
        super.method_25426();
        class_4185 backButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.done"), btn -> this.method_25419()).method_46434((this.field_22789 - 200) / 2, this.field_22790 - 30, 200, 20).method_46431();
        this.method_37063((class_364)backButton);
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTick) {
        this.method_25420(graphics);
        graphics.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 10, 0xFFFFFF);
        this.renderInfoBar(graphics);
        this.renderStatList(graphics);
        super.method_25394(graphics, mouseX, mouseY, partialTick);
    }

    private void renderInfoBar(class_332 graphics) {
        int y = 30;
        String playerText = "Player: " + this.data.playerName;
        String timeText = "Date: " + this.info.getFormattedTimestamp();
        String countText = "Statistics: " + this.data.stats.size();
        graphics.method_25303(this.field_22793, playerText, 10, y, 0xCCCCCC);
        graphics.method_25303(this.field_22793, timeText, this.field_22789 / 2 - this.field_22793.method_1727(timeText) / 2, y, 0xCCCCCC);
        graphics.method_25303(this.field_22793, countText, this.field_22789 - 10 - this.field_22793.method_1727(countText), y, 0xCCCCCC);
    }

    private void renderStatList(class_332 graphics) {
        int listX = 10;
        int listY = 50;
        int listWidth = this.field_22789 - 20;
        int listHeight = this.field_22790 - 90;
        graphics.method_25294(listX, listY, listX + listWidth, listY + listHeight, Integer.MIN_VALUE);
        graphics.method_25303(this.field_22793, "Statistic", listX + 10, listY + 5, 0xFFFFFF);
        graphics.method_25303(this.field_22793, "Value", listX + listWidth - 10 - 60, listY + 5, 0xFFFFFF);
        graphics.method_25294(listX, listY + 18, listX + listWidth, listY + 19, -12566464);
        int entryY = listY + 22 - this.scrollOffset;
        for (Map.Entry<String, Long> entry : this.statEntries) {
            if (entryY + 20 < listY + 22 || entryY > listY + listHeight) {
                entryY += 20;
                continue;
            }
            Object statName = entry.getKey();
            if (this.field_22793.method_1727((String)statName) > listWidth - 100) {
                statName = this.field_22793.method_27523((String)statName, listWidth - 100) + "...";
            }
            graphics.method_25303(this.field_22793, (String)statName, listX + 10, entryY, 0xCCCCCC);
            String value = String.valueOf(entry.getValue());
            graphics.method_25303(this.field_22793, value, listX + listWidth - 10 - this.field_22793.method_1727(value), entryY, 0xFFFFFF);
            entryY += 20;
        }
    }

    public boolean method_25401(double mouseX, double mouseY, double delta) {
        int maxScroll = Math.max(0, this.statEntries.size() * 20 - (this.field_22790 - 112));
        this.scrollOffset = Math.max(0, Math.min(maxScroll, this.scrollOffset - (int)(delta * 20.0)));
        return true;
    }

    public void method_25419() {
        if (this.field_22787 != null) {
            this.field_22787.method_1507(this.parent);
        }
    }

    public boolean method_25421() {
        return false;
    }
}

